/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jpt.common.core.tests.internal.projects.JavaProjectTestHarness;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.core.context.java.JavaClassMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaPersistentAttributeTests
extends JaxbContextModelTestCase {
    private static String TEST_CLASS_NAME = "TestClass";

    public GenericJavaPersistentAttributeTests(String name) {
        super(name);
    }

    private void createXmlTypeWithVariousAttributes() throws CoreException {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ").append("javax.xml.bind.annotation.XmlType").append(";").append(CR);
                sb.append("import java.util.List;").append(CR);
                sb.append(CR);
                sb.append("@XmlType").append(CR);
                sb.append("public class ").append(TEST_CLASS_NAME).append("<T extends Number> ").append("{").append(CR);
                sb.append("    public String string;").append(CR);
                sb.append("    public List<String> stringList;").append(CR);
                sb.append("    public String[] stringArray;").append(CR);
                sb.append("    public String[][] stringDoubleArray;").append(CR);
                sb.append("    public T generic;").append(CR);
                sb.append("    public List<T> genericList;").append(CR);
                sb.append("    public T[] genericArray;").append(CR);
                sb.append("    public List<?> wildcardList;").append(CR);
                sb.append("    public byte[] byteArray;").append(CR);
                sb.append("    public List list;").append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", String.valueOf(TEST_CLASS_NAME) + ".java", sourceWriter);
    }

    public void testJavaResourceType() throws Exception {
        this.createXmlTypeWithVariousAttributes();
        JavaClassMapping classMapping = ((JavaClass)this.getContextRoot().getJavaType("test." + TEST_CLASS_NAME)).getMapping();
        JavaPersistentAttribute att = (JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        GenericJavaPersistentAttributeTests.assertEquals((String)"java.lang.String", (String)att.getJavaResourceAttributeBaseTypeName());
        GenericJavaPersistentAttributeTests.assertEquals((boolean)false, (boolean)att.isJavaResourceAttributeCollectionType());
        att = (JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)1);
        GenericJavaPersistentAttributeTests.assertEquals((String)"java.lang.String", (String)att.getJavaResourceAttributeBaseTypeName());
        GenericJavaPersistentAttributeTests.assertEquals((boolean)true, (boolean)att.isJavaResourceAttributeCollectionType());
        att = (JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)2);
        GenericJavaPersistentAttributeTests.assertEquals((String)"java.lang.String", (String)att.getJavaResourceAttributeBaseTypeName());
        GenericJavaPersistentAttributeTests.assertEquals((boolean)true, (boolean)att.isJavaResourceAttributeCollectionType());
        att = (JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)3);
        GenericJavaPersistentAttributeTests.assertEquals((String)"java.lang.String[][]", (String)att.getJavaResourceAttributeBaseTypeName());
        GenericJavaPersistentAttributeTests.assertEquals((boolean)false, (boolean)att.isJavaResourceAttributeCollectionType());
        att = (JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)4);
        GenericJavaPersistentAttributeTests.assertEquals((String)"java.lang.Number", (String)att.getJavaResourceAttributeBaseTypeName());
        GenericJavaPersistentAttributeTests.assertEquals((boolean)false, (boolean)att.isJavaResourceAttributeCollectionType());
        att = (JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)5);
        GenericJavaPersistentAttributeTests.assertEquals((String)"java.lang.Number", (String)att.getJavaResourceAttributeBaseTypeName());
        GenericJavaPersistentAttributeTests.assertEquals((boolean)true, (boolean)att.isJavaResourceAttributeCollectionType());
        att = (JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)6);
        GenericJavaPersistentAttributeTests.assertEquals((String)"java.lang.Number", (String)att.getJavaResourceAttributeBaseTypeName());
        GenericJavaPersistentAttributeTests.assertEquals((boolean)true, (boolean)att.isJavaResourceAttributeCollectionType());
        att = (JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)7);
        GenericJavaPersistentAttributeTests.assertEquals((String)"java.lang.Object", (String)att.getJavaResourceAttributeBaseTypeName());
        GenericJavaPersistentAttributeTests.assertEquals((boolean)true, (boolean)att.isJavaResourceAttributeCollectionType());
        att = (JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)8);
        GenericJavaPersistentAttributeTests.assertEquals((String)"byte[]", (String)att.getJavaResourceAttributeBaseTypeName());
        GenericJavaPersistentAttributeTests.assertEquals((boolean)false, (boolean)att.isJavaResourceAttributeCollectionType());
        att = (JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)9);
        GenericJavaPersistentAttributeTests.assertEquals((String)"java.lang.Object", (String)att.getJavaResourceAttributeBaseTypeName());
        GenericJavaPersistentAttributeTests.assertEquals((boolean)true, (boolean)att.isJavaResourceAttributeCollectionType());
    }
}

