/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCacheCoordinationType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCacheIsolationType2_2;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCacheType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCaching;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkExistenceType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkTimeOfDay;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkOrmEntity;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.EclipseLinkOrmFactory;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlCache;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.v2_2.CacheIsolationType;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkOrmCachingTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }
        });
    }

    public EclipseLinkOrmCachingTests(String name) {
        super(name);
    }

    public void testSetSpecifiedShared() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkCaching caching = entity.getCaching();
        EclipseLinkOrmCachingTests.assertEquals((boolean)true, (boolean)caching.isShared());
        caching.setSpecifiedShared(Boolean.FALSE);
        EclipseLinkOrmCachingTests.assertEquals((Object)Boolean.FALSE, (Object)entity.getCaching().getSpecifiedShared());
        EclipseLinkOrmCachingTests.assertEquals((boolean)false, (boolean)entity.getCaching().isShared());
    }

    public void testSetSpecifiedSharedFalseUnsetsOtherCacheSettings() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkCaching caching = entity.getCaching();
        caching.setSpecifiedType(EclipseLinkCacheType.HARD_WEAK);
        caching.setSpecifiedSize(Integer.valueOf(500));
        caching.setSpecifiedAlwaysRefresh(Boolean.FALSE);
        caching.setSpecifiedRefreshOnlyIfNewer(Boolean.FALSE);
        caching.setSpecifiedDisableHits(Boolean.FALSE);
        caching.setSpecifiedCoordinationType(EclipseLinkCacheCoordinationType.INVALIDATE_CHANGED_OBJECTS);
        caching.setSpecifiedExistenceType(EclipseLinkExistenceType.CHECK_CACHE);
        caching.setExpiry(Integer.valueOf(8000));
        caching.setSpecifiedShared(Boolean.FALSE);
        EclipseLinkOrmCachingTests.assertEquals(null, (Object)caching.getSpecifiedType());
        EclipseLinkOrmCachingTests.assertEquals(null, (Object)caching.getSpecifiedSize());
        EclipseLinkOrmCachingTests.assertEquals(null, (Object)caching.getSpecifiedAlwaysRefresh());
        EclipseLinkOrmCachingTests.assertEquals(null, (Object)caching.getSpecifiedRefreshOnlyIfNewer());
        EclipseLinkOrmCachingTests.assertEquals(null, (Object)caching.getSpecifiedDisableHits());
        EclipseLinkOrmCachingTests.assertEquals(null, (Object)caching.getSpecifiedCoordinationType());
        EclipseLinkOrmCachingTests.assertEquals(null, (Object)caching.getExpiry());
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkExistenceType.CHECK_CACHE, (Object)caching.getSpecifiedExistenceType());
        caching.setSpecifiedShared(null);
        EclipseLinkTimeOfDay timeOfDayExpiry = caching.addExpiryTimeOfDay();
        timeOfDayExpiry.setHour(Integer.valueOf(5));
        caching.setSpecifiedShared(Boolean.FALSE);
        EclipseLinkOrmCachingTests.assertNull((Object)caching.getExpiryTimeOfDay());
    }

    public void testGetDefaultShared() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkCaching caching = entity.getCaching();
        EclipseLinkOrmCachingTests.assertTrue((boolean)caching.isDefaultShared());
        this.getPersistenceUnit().setProperty("eclipselink.cache.shared.default", "false");
        EclipseLinkOrmCachingTests.assertFalse((boolean)caching.isDefaultShared());
    }

    public void testGetSpecifiedShared() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkCaching caching = entity.getCaching();
        EclipseLinkOrmCachingTests.assertEquals((boolean)true, (boolean)caching.isShared());
    }

    public void testSetSpecifiedType() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkCaching caching = entity.getCaching();
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)caching.getType());
        caching.setSpecifiedType(EclipseLinkCacheType.HARD_WEAK);
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkCacheType.HARD_WEAK, (Object)entity.getCaching().getSpecifiedType());
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkCacheType.HARD_WEAK, (Object)entity.getCaching().getType());
        caching.setSpecifiedType(EclipseLinkCacheType.SOFT_WEAK);
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)caching.getSpecifiedType());
        caching.setSpecifiedType(null);
        EclipseLinkOrmCachingTests.assertNull((Object)caching.getSpecifiedType());
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)caching.getType());
    }

    public void testGetDefaultType() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkCaching caching = entity.getCaching();
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)caching.getDefaultType());
        this.getPersistenceUnit().setProperty("eclipselink.cache.type.default", EclipseLinkCacheType.FULL.toString());
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkCacheType.FULL, (Object)caching.getDefaultType());
    }

    public void testGetSpecifiedType() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkCaching caching = entity.getCaching();
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkCacheType.SOFT_WEAK, (Object)caching.getType());
    }

    public void testSetSpecifiedAlwaysRefresh() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkCaching caching = entity.getCaching();
        EclipseLinkOrmCachingTests.assertEquals((boolean)false, (boolean)caching.isAlwaysRefresh());
        caching.setSpecifiedAlwaysRefresh(Boolean.FALSE);
        EclipseLinkOrmCachingTests.assertEquals((Object)Boolean.FALSE, (Object)entity.getCaching().getSpecifiedAlwaysRefresh());
        EclipseLinkOrmCachingTests.assertEquals((boolean)false, (boolean)entity.getCaching().isAlwaysRefresh());
    }

    public void testGetSpecifiedAlwaysRefresh() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkCaching caching = entity.getCaching();
        EclipseLinkOrmCachingTests.assertEquals((boolean)false, (boolean)caching.isAlwaysRefresh());
    }

    public void testSetSpecifiedRefreshOnlyIfNewer() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkCaching caching = entity.getCaching();
        EclipseLinkOrmCachingTests.assertEquals((boolean)false, (boolean)caching.isRefreshOnlyIfNewer());
        caching.setSpecifiedRefreshOnlyIfNewer(Boolean.TRUE);
        EclipseLinkOrmCachingTests.assertEquals((Object)Boolean.TRUE, (Object)entity.getCaching().getSpecifiedRefreshOnlyIfNewer());
        EclipseLinkOrmCachingTests.assertEquals((boolean)true, (boolean)entity.getCaching().isRefreshOnlyIfNewer());
    }

    public void testGetSpecifiedRefreshOnlyIfNewer() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkCaching caching = entity.getCaching();
        EclipseLinkOrmCachingTests.assertEquals((boolean)false, (boolean)caching.isRefreshOnlyIfNewer());
    }

    public void testSetSpecifiedDisableHits() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkCaching caching = entity.getCaching();
        EclipseLinkOrmCachingTests.assertEquals((boolean)false, (boolean)caching.isDisableHits());
        caching.setSpecifiedDisableHits(Boolean.TRUE);
        EclipseLinkOrmCachingTests.assertEquals((Object)Boolean.TRUE, (Object)entity.getCaching().getSpecifiedDisableHits());
        EclipseLinkOrmCachingTests.assertEquals((boolean)true, (boolean)entity.getCaching().isDisableHits());
    }

    public void testGetSpecifiedDisableHits() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkCaching caching = entity.getCaching();
        EclipseLinkOrmCachingTests.assertEquals((boolean)false, (boolean)caching.isDisableHits());
    }

    public void testSetSpecifiedCoordinationType() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkCaching caching = entity.getCaching();
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES, (Object)caching.getCoordinationType());
        caching.setSpecifiedCoordinationType(EclipseLinkCacheCoordinationType.INVALIDATE_CHANGED_OBJECTS);
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkCacheCoordinationType.INVALIDATE_CHANGED_OBJECTS, (Object)entity.getCaching().getSpecifiedCoordinationType());
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkCacheCoordinationType.INVALIDATE_CHANGED_OBJECTS, (Object)entity.getCaching().getCoordinationType());
        caching.setSpecifiedCoordinationType(EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES);
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES, (Object)caching.getSpecifiedCoordinationType());
        caching.setSpecifiedCoordinationType(null);
        EclipseLinkOrmCachingTests.assertNull((Object)caching.getSpecifiedCoordinationType());
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES, (Object)caching.getCoordinationType());
    }

    public void testGetSpecifiedCoordinationType() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkCaching caching = entity.getCaching();
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkCacheCoordinationType.SEND_OBJECT_CHANGES, (Object)caching.getCoordinationType());
    }

    public void testGetExpiry() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkOrmCachingTests.assertNull((Object)entity.getCaching().getExpiry());
    }

    public void testSetExpiry() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkCaching caching = entity.getCaching();
        caching.setExpiry(Integer.valueOf(58));
        EclipseLinkOrmCachingTests.assertEquals((Object)58, (Object)caching.getExpiry());
        caching.setExpiry(null);
        EclipseLinkOrmCachingTests.assertNull((Object)caching.getExpiry());
    }

    public void testSetExpiryUnsetsExpiryTimeOfDay() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkCaching caching = entity.getCaching();
        caching.addExpiryTimeOfDay();
        caching.getExpiryTimeOfDay().setHour(Integer.valueOf(5));
        EclipseLinkOrmCachingTests.assertEquals((Object)5, (Object)caching.getExpiryTimeOfDay().getHour());
        caching.setExpiry(Integer.valueOf(900));
        EclipseLinkOrmCachingTests.assertNull((Object)caching.getExpiryTimeOfDay());
        EclipseLinkOrmCachingTests.assertEquals((Object)900, (Object)caching.getExpiry());
    }

    public void testGetTimeOfDayExpiry() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkCaching caching = entity.getCaching();
        EclipseLinkOrmCachingTests.assertNull((Object)caching.getExpiryTimeOfDay());
    }

    public void testAddTimeOfDayExpiry() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkCaching caching = entity.getCaching();
        EclipseLinkOrmCachingTests.assertNull((Object)caching.getExpiryTimeOfDay());
        EclipseLinkTimeOfDay timeOfDayExpiry = caching.addExpiryTimeOfDay();
        EclipseLinkOrmCachingTests.assertNotNull((Object)caching.getExpiryTimeOfDay());
        EclipseLinkOrmCachingTests.assertEquals((Object)timeOfDayExpiry, (Object)caching.getExpiryTimeOfDay());
    }

    public void testRemoveTimeOfDayExpiry() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkCaching caching = entity.getCaching();
        EclipseLinkOrmCachingTests.assertNull((Object)caching.getExpiryTimeOfDay());
    }

    public void testAddTimeOfDayExpiryUnsetsExpiry() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkCaching caching = entity.getCaching();
        caching.setExpiry(Integer.valueOf(800));
        EclipseLinkOrmCachingTests.assertEquals((Object)800, (Object)caching.getExpiry());
        caching.addExpiryTimeOfDay();
        EclipseLinkOrmCachingTests.assertNull((Object)caching.getExpiry());
        EclipseLinkOrmCachingTests.assertNotNull((Object)caching.getExpiryTimeOfDay());
    }

    public void testSetSpecifiedSize() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkCaching caching = entity.getCaching();
        EclipseLinkOrmCachingTests.assertEquals((int)100, (int)caching.getSize());
        caching.setSpecifiedSize(new Integer(50));
        EclipseLinkOrmCachingTests.assertEquals((Object)new Integer(50), (Object)entity.getCaching().getSpecifiedSize());
        EclipseLinkOrmCachingTests.assertEquals((int)50, (int)entity.getCaching().getSize());
    }

    public void testGetDefaultSize() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkCaching caching = entity.getCaching();
        EclipseLinkOrmCachingTests.assertEquals((int)100, (int)caching.getDefaultSize());
        this.getPersistenceUnit().setProperty("eclipselink.cache.size.default", "333");
        EclipseLinkOrmCachingTests.assertEquals((int)333, (int)caching.getDefaultSize());
    }

    public void testGetSpecifiedSize() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkCaching caching = entity.getCaching();
        EclipseLinkOrmCachingTests.assertEquals((int)100, (int)caching.getSize());
        caching.setSpecifiedSize(new Integer(50));
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkOrmCachingTests.assertEquals((Object)new Integer(50), (Object)entity.getCaching().getSpecifiedSize());
        EclipseLinkOrmCachingTests.assertEquals((int)50, (int)entity.getCaching().getSize());
    }

    public void testSetSpecifiedIsolation() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkCaching caching = entity.getCaching();
        XmlCache xmlCache = entity.getXmlTypeMapping().getCache();
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkCacheIsolationType2_2.SHARED, (Object)caching.getIsolation());
        EclipseLinkOrmCachingTests.assertNull((Object)xmlCache);
        caching.setSpecifiedIsolation(EclipseLinkCacheIsolationType2_2.PROTECTED);
        xmlCache = entity.getXmlTypeMapping().getCache();
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkCacheIsolationType2_2.PROTECTED, (Object)entity.getCaching().getSpecifiedIsolation());
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkCacheIsolationType2_2.PROTECTED, (Object)entity.getCaching().getIsolation());
        EclipseLinkOrmCachingTests.assertEquals((Object)CacheIsolationType.PROTECTED, (Object)xmlCache.getIsolation());
        caching.setSpecifiedIsolation(EclipseLinkCacheIsolationType2_2.SHARED);
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkCacheIsolationType2_2.SHARED, (Object)caching.getSpecifiedIsolation());
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkCacheIsolationType2_2.SHARED, (Object)caching.getIsolation());
        EclipseLinkOrmCachingTests.assertEquals((Object)CacheIsolationType.SHARED, (Object)xmlCache.getIsolation());
        caching.setSpecifiedIsolation(null);
        xmlCache = entity.getXmlTypeMapping().getCache();
        EclipseLinkOrmCachingTests.assertNull((Object)caching.getSpecifiedIsolation());
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkCacheIsolationType2_2.SHARED, (Object)caching.getIsolation());
        EclipseLinkOrmCachingTests.assertNull((Object)xmlCache);
    }

    public void testGetSpecifiedIsolation() throws Exception {
        this.createTestEntity();
        OrmPersistentType type = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity entity = (EclipseLinkOrmEntity)type.getMapping();
        EclipseLinkCaching caching = entity.getCaching();
        XmlCache xmlCache = entity.getXmlTypeMapping().getCache();
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkCacheIsolationType2_2.SHARED, (Object)caching.getIsolation());
        EclipseLinkOrmCachingTests.assertNull((Object)xmlCache);
        entity.getXmlTypeMapping().setCache(EclipseLinkOrmFactory.eINSTANCE.createXmlCache());
        xmlCache = entity.getXmlTypeMapping().getCache();
        xmlCache.setIsolation(CacheIsolationType.ISOLATED);
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkCacheIsolationType2_2.ISOLATED, (Object)caching.getIsolation());
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkCacheIsolationType2_2.ISOLATED, (Object)caching.getSpecifiedIsolation());
        xmlCache.setIsolation(CacheIsolationType.PROTECTED);
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkCacheIsolationType2_2.PROTECTED, (Object)caching.getIsolation());
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkCacheIsolationType2_2.PROTECTED, (Object)caching.getSpecifiedIsolation());
        xmlCache.setIsolation(null);
        EclipseLinkOrmCachingTests.assertEquals((Object)EclipseLinkCacheIsolationType2_2.SHARED, (Object)caching.getIsolation());
        EclipseLinkOrmCachingTests.assertNull((Object)caching.getSpecifiedIsolation());
    }
}

