/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.common.snippets.core.ISnippetProvider;
import org.eclipse.wst.common.snippets.internal.AbstractSnippetProvider;
import org.eclipse.wst.common.snippets.internal.Logger;
import org.eclipse.wst.common.snippets.internal.editors.ISnippetEditor;
import org.eclipse.wst.common.snippets.internal.editors.VariableItemEditor;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteItem;
import org.eclipse.wst.common.snippets.internal.util.StringUtils;
import org.eclipse.wst.common.snippets.ui.DefaultSnippetInsertion;
import org.eclipse.wst.common.snippets.ui.ISnippetInsertion;

public class TextSnippetProvider
extends AbstractSnippetProvider
implements ISnippetProvider {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public SnippetPaletteItem createSnippet(PaletteEntry drawer) throws CoreException {
        SnippetPaletteItem item = super.createSnippet(drawer);
        ITextSelection selection = this.getTextSelection();
        try {
            String selectedText = this.getDocument().get(selection.getOffset(), selection.getLength());
            item.setDescription(String.valueOf(StringUtils.firstLineOf(selectedText).trim()) + "...");
            item.setContentString(selectedText);
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        return item;
    }

    protected ITextSelection getTextSelection() {
        ISelection selection;
        ITextEditor editor = this.getTextEditor();
        if (editor != null && (selection = editor.getSelectionProvider().getSelection()) instanceof ITextSelection) {
            return (ITextSelection)selection;
        }
        return null;
    }

    protected ITextEditor getTextEditor() {
        ITextEditor editor = null;
        IEditorPart activePart = this.fEditorPart;
        if (activePart instanceof ITextEditor) {
            editor = (ITextEditor)activePart;
        }
        if (editor == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            editor = (ITextEditor)activePart.getAdapter((Class)clazz);
        }
        return editor;
    }

    public boolean isActionEnabled(ISelection selection) {
        boolean enable = false;
        if (selection != null) {
            if (selection instanceof ITextSelection) {
                if (((ITextSelection)selection).getLength() > 0) {
                    enable = true;
                }
            } else {
                enable = !selection.isEmpty();
            }
        }
        return enable;
    }

    public IDocument getDocument() {
        return this.getTextEditor().getDocumentProvider().getDocument((Object)this.fEditorPart.getEditorInput());
    }

    public IStatus saveAdditionalContent(IPath path) {
        return Status.OK_STATUS;
    }

    public ISnippetInsertion getSnippetInsertion() {
        return new DefaultSnippetInsertion();
    }

    public String getId() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.common.snippets.ui.TextSnippetProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.getName();
    }

    public ISnippetEditor getSnippetEditor() {
        return new VariableItemEditor();
    }
}

