/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.MapKeyClassAnnotation2_0;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java.JavaResourceModel2_0TestCase;

public class MapKeyClass2_0AnnotationTests
extends JavaResourceModel2_0TestCase {
    private static final String MAP_KEY_CLASS_VALUE = "MyClass";

    public MapKeyClass2_0AnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestMapKeyClass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MapKeyClass"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyClass");
            }
        });
    }

    private ICompilationUnit createTestMapKeyClassWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MapKeyClass"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyClass(MyClass.class)");
            }
        });
    }

    private ICompilationUnit createTestMapKeyClassWithPrimitiveValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MapKeyClass"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@MapKeyClass(value=int.class)");
            }
        });
    }

    public void testMapKeyClass() throws Exception {
        ICompilationUnit cu = this.createTestMapKeyClass();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyClassAnnotation2_0 mapKeyClass = (MapKeyClassAnnotation2_0)resourceField.getAnnotation("javax.persistence.MapKeyClass");
        MapKeyClass2_0AnnotationTests.assertNotNull((Object)mapKeyClass);
        MapKeyClass2_0AnnotationTests.assertNull((Object)mapKeyClass.getValue());
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestMapKeyClassWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyClassAnnotation2_0 mapKeyClass = (MapKeyClassAnnotation2_0)resourceField.getAnnotation("javax.persistence.MapKeyClass");
        MapKeyClass2_0AnnotationTests.assertEquals((String)MAP_KEY_CLASS_VALUE, (String)mapKeyClass.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestMapKeyClassWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyClassAnnotation2_0 mapKeyClass = (MapKeyClassAnnotation2_0)resourceField.getAnnotation("javax.persistence.MapKeyClass");
        MapKeyClass2_0AnnotationTests.assertEquals((String)MAP_KEY_CLASS_VALUE, (String)mapKeyClass.getValue());
        mapKeyClass.setValue("foo");
        MapKeyClass2_0AnnotationTests.assertEquals((String)"foo", (String)mapKeyClass.getValue());
        this.assertSourceContains("@MapKeyClass(foo.class)", cu);
        mapKeyClass.setValue(null);
        this.assertSourceDoesNotContain("@MapKeyClass(", cu);
    }

    public void testGetFullyQualifiedClass() throws Exception {
        ICompilationUnit cu = this.createTestMapKeyClassWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyClassAnnotation2_0 mapKeyClass = (MapKeyClassAnnotation2_0)resourceField.getAnnotation("javax.persistence.MapKeyClass");
        MapKeyClass2_0AnnotationTests.assertNotNull((Object)mapKeyClass.getValue());
        MapKeyClass2_0AnnotationTests.assertEquals((String)MAP_KEY_CLASS_VALUE, (String)mapKeyClass.getFullyQualifiedClassName());
        mapKeyClass.setValue("AnnotationTestType");
        MapKeyClass2_0AnnotationTests.assertEquals((String)"test.AnnotationTestType", (String)mapKeyClass.getFullyQualifiedClassName());
        this.assertSourceContains("@MapKeyClass(AnnotationTestType.class)", cu);
    }

    public void testGetPrimitiveValue() throws Exception {
        ICompilationUnit cu = this.createTestMapKeyClassWithPrimitiveValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyClassAnnotation2_0 mapKeyClass = (MapKeyClassAnnotation2_0)resourceField.getAnnotation("javax.persistence.MapKeyClass");
        MapKeyClass2_0AnnotationTests.assertEquals((String)"int", (String)mapKeyClass.getValue());
        MapKeyClass2_0AnnotationTests.assertEquals((String)"int", (String)mapKeyClass.getFullyQualifiedClassName());
    }

    public void testSetPrimitiveValue() throws Exception {
        ICompilationUnit cu = this.createTestMapKeyClassWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        MapKeyClassAnnotation2_0 mapKeyClass = (MapKeyClassAnnotation2_0)resourceField.getAnnotation("javax.persistence.MapKeyClass");
        MapKeyClass2_0AnnotationTests.assertEquals((String)MAP_KEY_CLASS_VALUE, (String)mapKeyClass.getValue());
        mapKeyClass.setValue("int");
        MapKeyClass2_0AnnotationTests.assertEquals((String)"int", (String)mapKeyClass.getValue());
        this.assertSourceContains("@MapKeyClass(int.class)", cu);
        mapKeyClass.setValue(null);
        this.assertSourceDoesNotContain("@MapKeyClass(", cu);
    }
}

