/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.validation;

import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IType;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;
import org.eclipse.jst.ws.jaxws.dom.runtime.tests.dom.validation.ValidationTestsSetUp;

public class WmValidationTest
extends ValidationTestsSetUp {
    private IType seiType;

    public void setUp() throws Exception {
        super.setUp();
        this.seiType = this.testProject.createType(this.testPack, "Sei.java", "@javax.jws.WebService(name=\"SeiName\") public interface Sei {\n@javax.jws.WebMethod(operationName=\"test\") public void test();}");
        this.testProject.build(10);
    }

    public void testNameIsNCName() throws CoreException {
        IMarker[] markers = this.seiType.getResource().findMarkers("org.eclipse.jdt.apt.core.nonreconcile.compile.problem", false, 0);
        WmValidationTest.assertEquals((int)0, (int)markers.length);
        this.setContents(this.seiType.getCompilationUnit(), "@javax.jws.WebService(name=\"SeiName\") public interface Sei {\n@javax.jws.WebMethod(operationName=\"---\") public void test(); \n}");
        WmValidationTest.assertNotNull((String)"SEI not found", (Object)this.findSei("test.Sei"));
        HashMap<String, Object> markerAttributes = new HashMap<String, Object>();
        markerAttributes.put("charStart", 110);
        markerAttributes.put("charEnd", 115);
        markerAttributes.put("lineNumber", 3);
        markerAttributes.put("severity", 2);
        markerAttributes.put("message", MessageFormat.format(JAXWSCoreMessages.INVALID_NCNAME_ATTRIBUTE, "WebMethod", "operationName", "---"));
        ValidationTestsSetUp.MarkerData markerData = new ValidationTestsSetUp.MarkerData(this, this.seiType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem", markerAttributes);
        this.validateResourceMarkers(this.seiType.getResource(), markerData);
    }

    public void testNameIsUnique() throws CoreException {
        this.setContents(this.seiType.getCompilationUnit(), "@javax.jws.WebService(name=\"SeiName\") public interface Sei {\n@javax.jws.WebMethod(operationName=\"OpName\") public void first(); \n@javax.jws.WebMethod(operationName=\"OpName\") public void second(); \n}");
        WmValidationTest.assertNotNull((String)"SEI not found", (Object)this.findSei("test.Sei"));
        HashMap<String, Object> marker1_Attributes = new HashMap<String, Object>();
        marker1_Attributes.put("charStart", 132);
        marker1_Attributes.put("charEnd", 137);
        marker1_Attributes.put("severity", 2);
        marker1_Attributes.put("message", MessageFormat.format(JAXWSCoreMessages.OPERATION_NAMES_MUST_BE_UNIQUE_ERROR, "{http://test/}OpName"));
        HashMap<String, Object> marker2_Attributes = new HashMap<String, Object>();
        marker2_Attributes.put("charStart", 199);
        marker2_Attributes.put("charEnd", 205);
        marker2_Attributes.put("severity", 2);
        marker2_Attributes.put("message", MessageFormat.format(JAXWSCoreMessages.OPERATION_NAMES_MUST_BE_UNIQUE_ERROR, "{http://test/}OpName"));
        ValidationTestsSetUp.MarkerData marker1_Data = new ValidationTestsSetUp.MarkerData(this, this.seiType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem", marker1_Attributes);
        ValidationTestsSetUp.MarkerData marker2_Data = new ValidationTestsSetUp.MarkerData(this, this.seiType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem", marker2_Attributes);
        this.validateResourceMarkers(this.seiType.getResource(), marker1_Data, marker2_Data);
    }

    public void testNameIsUniqueExcludedMethod() throws CoreException {
        this.setContents(this.seiType.getCompilationUnit(), "@javax.jws.WebService(name=\"SeiName\") public interface Sei {\n@javax.jws.WebMethod(exclude=true) public void first(); \n@javax.jws.WebMethod(operationName=\"first\") public void second(); \n}");
        WmValidationTest.assertNotNull((String)"SEI not found", (Object)this.findSei("test.Sei"));
        HashMap<String, Object> markerAttributes_1 = new HashMap<String, Object>();
        markerAttributes_1.put("charStart", 122);
        markerAttributes_1.put("charEnd", 127);
        markerAttributes_1.put("severity", 2);
        markerAttributes_1.put("message", MessageFormat.format(JAXWSCoreMessages.OPERATION_NAMES_MUST_BE_UNIQUE_ERROR, "{http://test/}first"));
        HashMap<String, Object> markerAttributes_2 = new HashMap<String, Object>();
        markerAttributes_2.put("charStart", 104);
        markerAttributes_2.put("charEnd", 108);
        markerAttributes_2.put("severity", 2);
        markerAttributes_2.put("message", JAXWSCoreMessages.WEBMETHOD_EXCLUDE_NOT_ALLOWED_ON_SEI);
        HashMap<String, Object> markerAttributes_3 = new HashMap<String, Object>();
        markerAttributes_3.put("charStart", 188);
        markerAttributes_3.put("charEnd", 194);
        markerAttributes_3.put("severity", 2);
        markerAttributes_3.put("message", MessageFormat.format(JAXWSCoreMessages.OPERATION_NAMES_MUST_BE_UNIQUE_ERROR, "{http://test/}first"));
        ValidationTestsSetUp.MarkerData markerData_1 = new ValidationTestsSetUp.MarkerData(this, this.seiType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem", markerAttributes_1);
        ValidationTestsSetUp.MarkerData markerData_2 = new ValidationTestsSetUp.MarkerData(this, this.seiType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem", markerAttributes_2);
        ValidationTestsSetUp.MarkerData markerData_3 = new ValidationTestsSetUp.MarkerData(this, this.seiType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem", markerAttributes_3);
        this.validateResourceMarkers(this.seiType.getResource(), markerData_1, markerData_2, markerData_3);
    }

    public void testRedundantAttributesForExcludedMethod() throws CoreException {
    }

    public void testMethodCannotBeExcludedInSEI() throws CoreException {
        this.setContents(this.seiType.getCompilationUnit(), "@javax.jws.WebService(name=\"SeiName\") public interface Sei {\n@javax.jws.WebMethod(exclude=true) public void first(); \n}");
        WmValidationTest.assertNotNull((String)"SEI not found", (Object)this.findSei("test.Sei"));
        HashMap<String, Object> markerAttributes = new HashMap<String, Object>();
        markerAttributes.put("charStart", 104);
        markerAttributes.put("charEnd", 108);
        markerAttributes.put("severity", 2);
        markerAttributes.put("message", JAXWSCoreMessages.WEBMETHOD_EXCLUDE_NOT_ALLOWED_ON_SEI);
        ValidationTestsSetUp.MarkerData markerData = new ValidationTestsSetUp.MarkerData(this, this.seiType.getResource(), "org.eclipse.jdt.apt.core.nonreconcile.compile.problem", markerAttributes);
        this.validateResourceMarkers(this.seiType.getResource(), markerData);
    }
}

