/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.tests.contentassist;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.extensions.TestSetup;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.ui.StructuredTextViewerConfigurationXML;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart;
import org.eclipse.wst.xml.ui.tests.ProjectUtil;

public class TestXMLContentAssistComputers
extends TestCase {
    private static final String PROJECT_NAME = "TestXMLContentAssistComputers";
    private static final String PROJECT_FILES = "/testresources/contentassist";
    private static IProject fProject;
    private static Map fFileToEditorMap;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        fFileToEditorMap = new HashMap();
    }

    public TestXMLContentAssistComputers() {
        super("Test XML Content Assist Computers");
    }

    public TestXMLContentAssistComputers(String name) {
        super(name);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.ui.tests.contentassist.TestXMLContentAssistComputers");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite ts = new TestSuite((Class)clazz, "Test XML Content Assist Computers");
        return new TestXMLContentAssistComputersSetup((Test)ts);
    }

    public void testChildElementProposals1() throws Exception {
        int[] expectedProposalCounts = new int[]{5, 2, 3};
        TestXMLContentAssistComputers.runProposalTest("test1.xml", 11, 8, expectedProposalCounts);
    }

    public void testChildElementProposals2() throws Exception {
        int[] expectedProposalCounts = new int[]{7, 2, 5};
        TestXMLContentAssistComputers.runProposalTest("test1.xml", 24, 6, expectedProposalCounts);
    }

    public void testAttributeProposals() throws Exception {
        int[] expectedProposalCounts = new int[]{5, 4, 1};
        TestXMLContentAssistComputers.runProposalTest("test1.xml", 10, 10, expectedProposalCounts);
    }

    public void testFinishClosingTagNamePropsoals() throws Exception {
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[2] = 1;
        int[] expectedProposalCounts = nArray;
        TestXMLContentAssistComputers.runProposalTest("test2.xml", 2, 19, expectedProposalCounts);
    }

    public void testFinishClosingTagPropsoals() throws Exception {
        int[] expectedProposalCounts = new int[]{6, 4, 2};
        TestXMLContentAssistComputers.runProposalTest("test2.xml", 3, 0, expectedProposalCounts);
    }

    public void testXMLLinkedPositions() throws Exception {
        IFile file = TestXMLContentAssistComputers.getFile("test1.xml");
        StructuredTextEditor editor = TestXMLContentAssistComputers.getEditor(file);
        StructuredTextViewer viewer = editor.getTextViewer();
        int offset = viewer.getDocument().getLineOffset(13);
        ICompletionProposal[][] pages = TestXMLContentAssistComputers.getProposals(viewer, offset, 4);
        TestXMLContentAssistComputers.assertNotNull((String)"No proposals returned.", (Object)pages);
        TestXMLContentAssistComputers.assertTrue((String)"Not enough pages.", (pages.length > 0 ? 1 : 0) != 0);
        TestXMLContentAssistComputers.assertTrue((String)"Not enough proposals.", (pages[0].length > 0 ? 1 : 0) != 0);
        ICompletionProposalExtension2 proposal = null;
        int i = 0;
        while (i < pages[0].length) {
            if ("Member".equals(pages[0][i].getDisplayString())) {
                TestXMLContentAssistComputers.assertTrue((String)"Proposal not of the proper type", (boolean)(pages[0][i] instanceof ICompletionProposalExtension2));
                proposal = (ICompletionProposalExtension2)pages[0][i];
                break;
            }
            ++i;
        }
        TestXMLContentAssistComputers.assertNotNull((String)"No appropriate proposal found.", proposal);
        proposal.apply((ITextViewer)viewer, '\u0000', 0, offset);
        String[] categories = viewer.getDocument().getPositionCategories();
        String category = null;
        int i2 = 0;
        while (i2 < categories.length) {
            if (categories[i2].startsWith("org.eclipse.jface.text.link.LinkedModeModel")) {
                category = categories[i2];
            }
            ++i2;
        }
        TestXMLContentAssistComputers.assertNotNull((String)"Could not find the linked model position category.", category);
        TestXMLContentAssistComputers.assertTrue((String)"No linked positions were generated.", (viewer.getDocument().getPositions(category).length > 0 ? 1 : 0) != 0);
    }

    private static void runProposalTest(String fileName, int lineNum, int lineRelativeCharOffset, int[] expectedProposalCounts) throws Exception {
        IFile file = TestXMLContentAssistComputers.getFile(fileName);
        StructuredTextEditor editor = TestXMLContentAssistComputers.getEditor(file);
        StructuredTextViewer viewer = editor.getTextViewer();
        int offset = viewer.getDocument().getLineOffset(lineNum) + lineRelativeCharOffset;
        ICompletionProposal[][] pages = TestXMLContentAssistComputers.getProposals(viewer, offset, expectedProposalCounts.length);
        TestXMLContentAssistComputers.verifyProposalCounts(pages, expectedProposalCounts);
    }

    private static ICompletionProposal[][] getProposals(StructuredTextViewer viewer, int offset, int pageCount) throws Exception {
        StructuredTextViewerConfigurationXML configuration = new StructuredTextViewerConfigurationXML();
        ContentAssistant contentAssistant = (ContentAssistant)configuration.getContentAssistant((ISourceViewer)viewer);
        viewer.configure((SourceViewerConfiguration)configuration);
        viewer.setSelectedRange(offset, 0);
        String partitionTypeID = viewer.getDocument().getPartition(offset).getType();
        IContentAssistProcessor processor = contentAssistant.getContentAssistProcessor(partitionTypeID);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.text.contentassist.ContentAssistant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Method privateFireSessionBeginEventMethod = clazz.getDeclaredMethod("fireSessionBeginEvent", Boolean.TYPE);
        privateFireSessionBeginEventMethod.setAccessible(true);
        privateFireSessionBeginEventMethod.invoke((Object)contentAssistant, Boolean.TRUE);
        ICompletionProposal[][] pages = new ICompletionProposal[pageCount][];
        int p = 0;
        while (p < pageCount) {
            pages[p] = processor.computeCompletionProposals((ITextViewer)viewer, offset);
            ++p;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jface.text.contentassist.ContentAssistant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Method privateFireSessionEndEventMethod = clazz2.getDeclaredMethod("fireSessionEndEvent", null);
        privateFireSessionEndEventMethod.setAccessible(true);
        privateFireSessionEndEventMethod.invoke((Object)contentAssistant, null);
        return pages;
    }

    private static void verifyProposalCounts(ICompletionProposal[][] pages, int[] expectedProposalCounts) {
        StringBuffer error = new StringBuffer();
        int page = 0;
        while (page < expectedProposalCounts.length) {
            if (expectedProposalCounts[page] != pages[page].length) {
                error.append("\nProposal page " + page + " did not have the expected number of proposals: was " + pages[page].length + " expected " + expectedProposalCounts[page]);
            }
            ++page;
        }
        if (error.length() > 0) {
            Assert.fail((String)error.toString());
        }
    }

    private static IFile getFile(String name) {
        IFile file = fProject.getFile(name);
        TestXMLContentAssistComputers.assertTrue((String)("Test file " + file + " can not be found"), (boolean)file.exists());
        return file;
    }

    private static StructuredTextEditor getEditor(IFile file) {
        StructuredTextEditor editor = (StructuredTextEditor)fFileToEditorMap.get(file);
        if (editor == null) {
            try {
                IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = workbenchWindow.getActivePage();
                IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true, (boolean)true);
                if (editorPart instanceof XMLMultiPageEditorPart) {
                    XMLMultiPageEditorPart xmlEditorPart = (XMLMultiPageEditorPart)editorPart;
                    Class<?> clazz = class$2;
                    if (clazz == null) {
                        try {
                            clazz = class$2 = Class.forName("org.eclipse.wst.sse.ui.StructuredTextEditor");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    editor = (StructuredTextEditor)xmlEditorPart.getAdapter((Class)clazz);
                } else if (editorPart instanceof StructuredTextEditor) {
                    editor = (StructuredTextEditor)editorPart;
                } else {
                    TestXMLContentAssistComputers.fail((String)"Unable to open structured text editor");
                }
                if (editor != null) {
                    TestXMLContentAssistComputers.standardizeLineEndings(editor);
                    fFileToEditorMap.put(file, editor);
                } else {
                    TestXMLContentAssistComputers.fail((String)("Could not open editor for " + file));
                }
            }
            catch (Exception e) {
                TestXMLContentAssistComputers.fail((String)("Could not open editor for " + file + " exception: " + e.getMessage()));
            }
        }
        return editor;
    }

    private static void standardizeLineEndings(StructuredTextEditor editor) {
        IDocument doc = editor.getTextViewer().getDocument();
        String contents = doc.get();
        contents = StringUtils.replace((String)contents, (String)"\r\n", (String)"\n");
        contents = StringUtils.replace((String)contents, (String)"\r", (String)"\n");
        doc.set(contents);
    }

    private static class TestXMLContentAssistComputersSetup
    extends TestSetup {
        private static final String WTP_AUTOTEST_NONINTERACTIVE = "wtp.autotest.noninteractive";
        private static String previousWTPAutoTestNonInteractivePropValue = null;

        public TestXMLContentAssistComputersSetup(Test test) {
            super(test);
        }

        public void setUp() throws Exception {
            String noninteractive = System.getProperty(WTP_AUTOTEST_NONINTERACTIVE);
            previousWTPAutoTestNonInteractivePropValue = noninteractive != null ? noninteractive : "false";
            System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, "true");
            fProject = ProjectUtil.createProject(TestXMLContentAssistComputers.PROJECT_NAME, null, null);
            ProjectUtil.copyBundleEntriesIntoWorkspace(TestXMLContentAssistComputers.PROJECT_FILES, TestXMLContentAssistComputers.PROJECT_NAME);
        }

        public void tearDown() throws Exception {
            Iterator iter = fFileToEditorMap.values().iterator();
            while (iter.hasNext()) {
                StructuredTextEditor editor = (StructuredTextEditor)iter.next();
                editor.doSave(null);
                editor.close(false);
            }
            fProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
            if (previousWTPAutoTestNonInteractivePropValue != null) {
                System.setProperty(WTP_AUTOTEST_NONINTERACTIVE, previousWTPAutoTestNonInteractivePropValue);
            }
        }
    }
}

