/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.model;

import java.io.File;
import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.modelhandler.XMLModelLoader;
import org.eclipse.wst.xml.core.tests.util.FileUtil;
import org.eclipse.wst.xml.core.tests.util.ProjectUnzipUtility;

public class TestXMLModelLoader
extends TestCase {
    private boolean isSetup = false;
    private XMLModelLoader fLoader = null;
    private final String fProjectName = "DOCUMENT-LOADER";
    private final String fZipFileName = "xml-document-loader-tests.zip";

    public TestXMLModelLoader() {
        super("TestModelLoader");
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (!this.isSetup) {
            this.fLoader = new XMLModelLoader();
            this.doSetup();
            this.isSetup = true;
        }
    }

    private void doSetup() throws Exception {
        Location platformLocation = Platform.getInstanceLocation();
        ProjectUnzipUtility unzipUtil = new ProjectUnzipUtility();
        File zipFile = FileUtil.makeFileFor("projecttestfiles", "xml-document-loader-tests.zip", "projecttestfiles");
        unzipUtil.unzipAndImport(zipFile, platformLocation.getURL().getFile());
        unzipUtil.initJavaProject("DOCUMENT-LOADER");
    }

    public void testCreateEmptyModel() {
        IStructuredModel model = this.fLoader.createModel();
        TestXMLModelLoader.assertNotNull((String)"model is null", (Object)model);
    }

    public void testCreateModelWithDocument() {
        IStructuredModel emptyModel = this.fLoader.createModel();
        IStructuredDocument sDoc = emptyModel.getStructuredDocument();
        sDoc.set("<?xml version=\"1.0\"?>\n<test>\n<item attr=\"val\" /></test>\n");
        IStructuredModel modelFromDoc = this.fLoader.createModel(sDoc, "/test", null);
        TestXMLModelLoader.assertNotNull((String)"model from doc is null", (Object)modelFromDoc);
    }

    public void testCreateModelWithModel() {
        IStructuredModel emptyModel = this.fLoader.createModel();
        IStructuredDocument sDoc = emptyModel.getStructuredDocument();
        sDoc.set("<?xml version=\"1.0\"?>\n<test>\n<item attr=\"val\" /></test>\n");
    }

    public void testGetAdapterFactories() {
        List factories = this.fLoader.getAdapterFactories();
        TestXMLModelLoader.assertTrue((String)"there were no adapter factories for XML", (factories.size() > 0 ? 1 : 0) != 0);
    }

    public void testLoad() {
        IFile f = this.getFile();
        try {
            IStructuredModel model = this.fLoader.createModel();
            this.fLoader.load(f, model);
            String text = model.getStructuredDocument().get();
            TestXMLModelLoader.assertTrue((String)"failed to load", (text.length() > 0 ? 1 : 0) != 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void testLoadFromStream() {
    }

    private IFile getFile() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path("DOCUMENT-LOADER/files/simple.xml"));
    }
}

