/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence;

import org.eclipse.jpt.common.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ListValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkDdlGenerationType;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkOutputMode;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkSchemaGeneration;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence.EclipseLinkPersistenceUnitTestCase;

public class SchemaGenerationBasicAdapterTests
extends EclipseLinkPersistenceUnitTestCase {
    private EclipseLinkSchemaGeneration schemaGeneration;
    public static final String outputModeKey = "eclipselink.ddl-generation.output-mode";
    public static final String ddlGenTypeKey = "eclipselink.ddl-generation";
    public static final EclipseLinkOutputMode OUTPUT_MODE_TEST_VALUE = EclipseLinkOutputMode.sql_script;
    public static final EclipseLinkOutputMode OUTPUT_MODE_TEST_VALUE_2 = EclipseLinkOutputMode.database;
    public static final EclipseLinkDdlGenerationType DDL_GENERATION_TYPE_TEST_VALUE = EclipseLinkDdlGenerationType.drop_and_create_tables;
    public static final EclipseLinkDdlGenerationType DDL_GENERATION_TYPE_TEST_VALUE_2 = EclipseLinkDdlGenerationType.none;

    public SchemaGenerationBasicAdapterTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.schemaGeneration = this.subject.getEclipseLinkSchemaGeneration();
        PropertyChangeListener propertyChangeListener = this.buildPropertyChangeListener();
        this.schemaGeneration.addPropertyChangeListener("outputMode", propertyChangeListener);
        this.schemaGeneration.addPropertyChangeListener("ddlGenerationType", propertyChangeListener);
        this.clearEvent();
    }

    protected void populatePu() {
        this.propertiesTotal = 6;
        this.modelPropertiesSize = this.modelPropertiesSizeOriginal = 2;
        this.persistenceUnitSetProperty("property.0", "value.0");
        this.persistenceUnitSetProperty(outputModeKey, this.getPropertyStringValueOf(OUTPUT_MODE_TEST_VALUE));
        this.persistenceUnitSetProperty("property.2", "value.2");
        this.persistenceUnitSetProperty("property.3", "value.3");
        this.persistenceUnitSetProperty("property.4", "value.4");
        this.persistenceUnitSetProperty(ddlGenTypeKey, this.getPropertyStringValueOf(DDL_GENERATION_TYPE_TEST_VALUE));
    }

    public void testOutputModeUpdate() throws Exception {
        ListValueModel<PersistenceUnit.Property> propertiesAdapter = this.buildPropertiesAdapter((PropertyValueModel<EclipseLinkPersistenceUnit>)this.subjectHolder);
        new ItemPropertyListValueModelAdapter(propertiesAdapter, new String[]{"value"});
        this.verifyHasListeners((PersistenceUnitProperties)this.schemaGeneration, "outputMode");
        SchemaGenerationBasicAdapterTests.assertTrue((boolean)this.schemaGeneration.itemIsProperty(this.getPersistenceUnit().getProperty(outputModeKey)));
        SchemaGenerationBasicAdapterTests.assertEquals((Object)OUTPUT_MODE_TEST_VALUE, (Object)this.schemaGeneration.getOutputMode());
        this.persistenceUnitSetProperty(outputModeKey, OUTPUT_MODE_TEST_VALUE_2);
        this.verifyPutEvent("outputMode", OUTPUT_MODE_TEST_VALUE_2, this.schemaGeneration.getOutputMode());
        this.clearEvent();
        --this.propertiesTotal;
        --this.modelPropertiesSize;
        this.getPersistenceUnit().removeProperty(outputModeKey);
        SchemaGenerationBasicAdapterTests.assertNull((Object)this.getPersistenceUnit().getProperty(outputModeKey));
        SchemaGenerationBasicAdapterTests.assertEquals((int)this.modelPropertiesSize, (int)(this.modelPropertiesSizeOriginal - 1));
        SchemaGenerationBasicAdapterTests.assertNotNull((Object)this.propertyChangedEvent);
        SchemaGenerationBasicAdapterTests.assertNull((Object)this.propertyChangedEvent.getNewValue());
        ++this.propertiesTotal;
        ++this.modelPropertiesSize;
        this.persistenceUnitSetProperty(outputModeKey, OUTPUT_MODE_TEST_VALUE);
        this.verifyPutEvent("outputMode", OUTPUT_MODE_TEST_VALUE, this.schemaGeneration.getOutputMode());
        this.persistenceUnitSetProperty(outputModeKey, OUTPUT_MODE_TEST_VALUE_2);
        this.verifyPutEvent("outputMode", OUTPUT_MODE_TEST_VALUE_2, this.schemaGeneration.getOutputMode());
        this.clearEvent();
        this.schemaGeneration.setOutputMode(OUTPUT_MODE_TEST_VALUE);
        this.verifyPutEvent("outputMode", OUTPUT_MODE_TEST_VALUE, this.schemaGeneration.getOutputMode());
    }

    protected PersistenceUnitProperties getModel() {
        return this.schemaGeneration;
    }

    private ListValueModel<PersistenceUnit.Property> buildPropertiesAdapter(PropertyValueModel<EclipseLinkPersistenceUnit> subjectHolder) {
        return new ListAspectAdapter<EclipseLinkPersistenceUnit, PersistenceUnit.Property>(subjectHolder, new String[]{"properties"}){

            protected ListIterable<PersistenceUnit.Property> getListIterable() {
                return ((EclipseLinkPersistenceUnit)this.subject).getProperties();
            }

            protected int size_() {
                return ((EclipseLinkPersistenceUnit)this.subject).getPropertiesSize();
            }
        };
    }

    protected void setProperty(String propertyName, Object newValue) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        throw new UnsupportedOperationException();
    }
}

