/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.JavaProjectTestHarness;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.BaseEnumeratedConverter;
import org.eclipse.jpt.jpa.core.context.BaseTemporalConverter;
import org.eclipse.jpt.jpa.core.context.Entity;
import org.eclipse.jpt.jpa.core.context.FetchType;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.SpecifiedColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.orm.NullOrmConverter;
import org.eclipse.jpt.jpa.core.jpa2.context.Cascade2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.ManyToManyMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.Orderable2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.SpecifiedOrderColumn2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.java.JavaCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.orm.OrmCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.resource.orm.EnumType;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.TemporalType;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlManyToMany;
import org.eclipse.jpt.jpa.core.resource.orm.v2_0.XmlManyToMany_2_0;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericOrmManyToManyMapping2_0Tests
extends Generic2_0ContextModelTestCase {
    public GenericOrmManyToManyMapping2_0Tests(String name) {
        super(name);
    }

    private void createTestTargetEntityAddress() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private State state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private void createTestTargetEntityAddressWithElementCollection() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ElementCollection");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("Address").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    @ElementCollection").append(CR);
                sb.append("    private java.util.Collection<State> state;").append(CR);
                sb.append(CR);
                sb.append("    private int zip;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "Address.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityWithValidManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Collection<Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidMapManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Map<String, Address> addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private ICompilationUnit createTestEntityWithValidNonGenericMapManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    private java.util.Map addresses;").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
            }
        });
    }

    private void createTestEmbeddableState() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append("State").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    private String foo;").append(CR);
                sb.append(CR);
                sb.append("    private Address address;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "State.java", sourceWriter);
    }

    private ICompilationUnit createTestEntityManyToManyMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.FetchType", "javax.persistence.CascadeType", "javax.persistence.OrderBy", "javax.persistence.MapKeyEnumerated", "javax.persistence.EnumType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("    @ManyToMany(fetch=FetchType.EAGER, targetEntity=Address.class, cascade={CascadeType.ALL, CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REMOVE, CascadeType.REFRESH, CascadeType.DETACH})");
                sb.append(CR);
                sb.append("    @OrderBy(\"city\"");
                sb.append(CR);
                sb.append("    @MapKeyEnumerated(EnumType.STRING)").append(CR);
                sb.append("    private java.util.Map<String, Address> address;").append(CR);
                sb.append(CR);
                sb.append("    @Id");
            }
        });
    }

    public void testCandidateMappedByAttributeNames() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "manyToMany");
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)ormPersistentType.getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        Iterator attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity("foo");
        attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = manyToManyMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    public void testCandidateMappedByAttributeNamesElementCollection() throws Exception {
        this.createTestEntityWithValidManyToManyMapping();
        this.createTestTargetEntityAddressWithElementCollection();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "manyToMany");
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef("test.Address");
        this.addXmlClassRef("test.State");
        PersistentAttribute persistentAttribute = (PersistentAttribute)ormPersistentType.getAttributes().iterator().next();
        ManyToManyMapping manyToManyMapping = (ManyToManyMapping)persistentAttribute.getMapping();
        Iterator attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity("foo");
        attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        attributeNames = manyToManyMapping.getRelationship().getMappedByStrategy().getCandidateMappedByAttributeNames().iterator();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)attributeNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)attributeNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)attributeNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)attributeNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)attributeNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)attributeNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)attributeNames.hasNext());
        AttributeMapping stateFooMapping = manyToManyMapping.getResolvedTargetEntity().resolveAttributeMapping("state.foo");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"foo", (String)stateFooMapping.getName());
    }

    public void testUpdateMapKey() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKey());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)manyToMany.getMapKey());
        manyToMany.setMapKey(OrmFactory.eINSTANCE.createMapKey());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKey());
        GenericOrmManyToManyMapping2_0Tests.assertNotNull((Object)manyToMany.getMapKey());
        manyToMany.getMapKey().setName("myMapKey");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)ormManyToManyMapping.getSpecifiedMapKey());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)manyToMany.getMapKey().getName());
        manyToMany.getMapKey().setName(null);
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKey());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)manyToMany.getMapKey().getName());
        manyToMany.getMapKey().setName("myMapKey");
        manyToMany.setMapKey(null);
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKey());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)manyToMany.getMapKey());
    }

    public void testUpdateVirtualMapKey() throws Exception {
        this.createTestEntityWithValidMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ManyToManyMapping virtualManyToManyMapping = (ManyToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaManyToManyMapping javaManyToManyMapping = (JavaManyToManyMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)virtualManyToManyMapping.getSpecifiedMapKey());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)virtualManyToManyMapping.getMapKey());
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)virtualManyToManyMapping.isPkMapKey());
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)virtualManyToManyMapping.isCustomMapKey());
        GenericOrmManyToManyMapping2_0Tests.assertTrue((boolean)virtualManyToManyMapping.isNoMapKey());
        javaManyToManyMapping.setPkMapKey(true);
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"id", (String)virtualManyToManyMapping.getMapKey());
        GenericOrmManyToManyMapping2_0Tests.assertTrue((boolean)virtualManyToManyMapping.isPkMapKey());
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)virtualManyToManyMapping.isCustomMapKey());
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)virtualManyToManyMapping.isNoMapKey());
        javaManyToManyMapping.setCustomMapKey(true);
        javaManyToManyMapping.setSpecifiedMapKey("city");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"city", (String)virtualManyToManyMapping.getSpecifiedMapKey());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"city", (String)virtualManyToManyMapping.getMapKey());
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)virtualManyToManyMapping.isPkMapKey());
        GenericOrmManyToManyMapping2_0Tests.assertTrue((boolean)virtualManyToManyMapping.isCustomMapKey());
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)virtualManyToManyMapping.isNoMapKey());
    }

    public void testModifyMapKey() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany xmlManyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKey());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)xmlManyToMany.getMapKey());
        ormManyToManyMapping.setSpecifiedMapKey("myMapKey");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)ormManyToManyMapping.getSpecifiedMapKey());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"myMapKey", (String)xmlManyToMany.getMapKey().getName());
        ormManyToManyMapping.setSpecifiedMapKey(null);
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKey());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)xmlManyToMany.getMapKey().getName());
    }

    public void testCandidateMapKeyNames() throws Exception {
        this.createTestEntityWithValidMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ManyToManyMapping virtualManyToManyMapping = (ManyToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = virtualManyToManyMapping.getCandidateMapKeyNames().iterator();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)mapKeyNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)mapKeyNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)mapKeyNames.hasNext());
    }

    public void testCandidateMapKeyNames2() throws Exception {
        this.createTestEntityWithValidNonGenericMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ManyToManyMapping virtualManyToManyMapping = (ManyToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaManyToManyMapping javaManyToManyMapping = (JavaManyToManyMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        Iterator mapKeyNames = virtualManyToManyMapping.getCandidateMapKeyNames().iterator();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        javaManyToManyMapping.setSpecifiedTargetEntity("test.Address");
        mapKeyNames = virtualManyToManyMapping.getCandidateMapKeyNames().iterator();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)mapKeyNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)mapKeyNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)mapKeyNames.hasNext());
        ormPersistentType.getAttributeNamed("addresses").addToXml();
        virtualManyToManyMapping = (OrmManyToManyMapping)ormPersistentType.getAttributeNamed("addresses").getMapping();
        mapKeyNames = virtualManyToManyMapping.getCandidateMapKeyNames().iterator();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
        virtualManyToManyMapping.setSpecifiedTargetEntity("test.Address");
        mapKeyNames = virtualManyToManyMapping.getCandidateMapKeyNames().iterator();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"id", (String)((String)mapKeyNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"city", (String)((String)mapKeyNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"state", (String)((String)mapKeyNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"state.foo", (String)((String)mapKeyNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"state.address", (String)((String)mapKeyNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"zip", (String)((String)mapKeyNames.next()));
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)mapKeyNames.hasNext());
        virtualManyToManyMapping.setSpecifiedTargetEntity("String");
        mapKeyNames = virtualManyToManyMapping.getCandidateMapKeyNames().iterator();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)mapKeyNames.hasNext());
    }

    public void testUpdateMapKeyClass() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmCollectionMapping2_0 ormManyToManyMapping = (OrmCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)manyToMany.getMapKeyClass());
        manyToMany.setMapKeyClass(OrmFactory.eINSTANCE.createXmlClassReference());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmManyToManyMapping2_0Tests.assertNotNull((Object)manyToMany.getMapKeyClass());
        manyToMany.getMapKeyClass().setClassName("String");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"String", (String)ormManyToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"String", (String)manyToMany.getMapKeyClass().getClassName());
        manyToMany.getMapKeyClass().setClassName(null);
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)manyToMany.getMapKeyClass().getClassName());
        manyToMany.getMapKeyClass().setClassName("String");
        manyToMany.setMapKeyClass(null);
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)manyToMany.getMapKeyClass());
    }

    public void testUpdateVirtualMapKeyClass() throws Exception {
        this.createTestEntityWithValidMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        this.createTestEmbeddableState();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        this.getEntityMappings().addPersistentType("embeddable", "test.State");
        ManyToManyMapping2_0 virtualManyToManyMapping = (ManyToManyMapping2_0)ormPersistentType.getAttributeNamed("addresses").getMapping();
        JavaCollectionMapping2_0 javaManyToManyMapping = (JavaCollectionMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"java.lang.String", (String)virtualManyToManyMapping.getMapKeyClass());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)virtualManyToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"java.lang.String", (String)virtualManyToManyMapping.getDefaultMapKeyClass());
        javaManyToManyMapping.setSpecifiedMapKeyClass("Integer");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"Integer", (String)virtualManyToManyMapping.getMapKeyClass());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"Integer", (String)virtualManyToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"java.lang.String", (String)virtualManyToManyMapping.getDefaultMapKeyClass());
    }

    public void testModifyMapKeyClass() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmCollectionMapping2_0 ormManyToManyMapping = (OrmCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)manyToMany.getMapKeyClass());
        ormManyToManyMapping.setSpecifiedMapKeyClass("String");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"String", (String)ormManyToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"String", (String)manyToMany.getMapKeyClass().getClassName());
        ormManyToManyMapping.setSpecifiedMapKeyClass(null);
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormManyToManyMapping.getSpecifiedMapKeyClass());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)manyToMany.getMapKeyClass());
    }

    public void testOrderColumnDefaults() throws Exception {
        this.createTestEntityPrintQueue();
        this.createTestEntityPrintJob();
        OrmPersistentType printQueuePersistentType = this.getEntityMappings().addPersistentType("entity", "test.PrintQueue");
        OrmSpecifiedPersistentAttribute jobsPersistentAttribute = printQueuePersistentType.addAttributeToXml(printQueuePersistentType.getAttributeNamed("jobs"), "manyToMany");
        OrmManyToManyMapping jobsMapping = (OrmManyToManyMapping)jobsPersistentAttribute.getMapping();
        jobsMapping.getRelationship().setStrategyToMappedBy();
        jobsMapping.getRelationship().getMappedByStrategy().setMappedByAttribute("queues");
        OrmPersistentType printJobPersistentType = this.getEntityMappings().addPersistentType("entity", "test.PrintJob");
        OrmSpecifiedPersistentAttribute queuesPersistentAttribute = printJobPersistentType.addAttributeToXml(printJobPersistentType.getAttributeNamed("queues"), "manyToMany");
        OrmManyToManyMapping queuesMapping = (OrmManyToManyMapping)queuesPersistentAttribute.getMapping();
        Orderable2_0 jobsOrderable = (Orderable2_0)jobsMapping.getOrderable();
        SpecifiedOrderColumn2_0 jobsOrderColumn = jobsOrderable.getOrderColumn();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)jobsOrderable.isOrderColumnOrdering());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)jobsOrderable.isNoOrdering());
        Orderable2_0 queuesOrderable = (Orderable2_0)queuesMapping.getOrderable();
        SpecifiedOrderColumn2_0 queuesOrderColumn = queuesOrderable.getOrderColumn();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)queuesOrderable.isOrderColumnOrdering());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)queuesOrderable.isNoOrdering());
        jobsOrderable.setOrderColumnOrdering();
        jobsOrderColumn = jobsOrderable.getOrderColumn();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)jobsOrderable.isOrderColumnOrdering());
        GenericOrmManyToManyMapping2_0Tests.assertEquals(null, (String)jobsOrderColumn.getSpecifiedName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"jobs_ORDER", (String)jobsOrderColumn.getDefaultName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"PrintJob_PrintQueue", (String)jobsOrderColumn.getTableName());
        queuesOrderable.setOrderColumnOrdering();
        queuesOrderColumn = queuesOrderable.getOrderColumn();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)queuesOrderable.isOrderColumnOrdering());
        GenericOrmManyToManyMapping2_0Tests.assertEquals(null, (String)queuesOrderColumn.getSpecifiedName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"queues_ORDER", (String)queuesOrderColumn.getDefaultName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"PrintJob_PrintQueue", (String)queuesOrderColumn.getTableName());
        jobsOrderColumn.setSpecifiedName("FOO");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)jobsOrderColumn.getSpecifiedName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"jobs_ORDER", (String)jobsOrderColumn.getDefaultName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"PrintJob_PrintQueue", (String)jobsOrderColumn.getTableName());
        queuesOrderColumn.setSpecifiedName("BAR");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)queuesOrderColumn.getSpecifiedName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"queues_ORDER", (String)queuesOrderColumn.getDefaultName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"PrintJob_PrintQueue", (String)queuesOrderColumn.getTableName());
        ((Entity)printJobPersistentType.getMapping()).getTable().setSpecifiedName("MY_TABLE");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"MY_TABLE_PrintQueue", (String)jobsOrderColumn.getTableName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"MY_TABLE_PrintQueue", (String)queuesOrderColumn.getTableName());
        ((Entity)printQueuePersistentType.getMapping()).getTable().setSpecifiedName("OTHER_TABLE");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"MY_TABLE_OTHER_TABLE", (String)jobsOrderColumn.getTableName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"MY_TABLE_OTHER_TABLE", (String)queuesOrderColumn.getTableName());
        queuesMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("MY_JOIN_TABLE");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"MY_JOIN_TABLE", (String)jobsOrderColumn.getTableName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"MY_JOIN_TABLE", (String)queuesOrderColumn.getTableName());
    }

    public void testVirtualOrderColumn() throws Exception {
        this.createTestEntityPrintQueue();
        this.createTestEntityPrintJob();
        OrmPersistentType printQueuePersistentType = this.getEntityMappings().addPersistentType("entity", "test.PrintQueue");
        OrmSpecifiedPersistentAttribute jobsPersistentAttribute = printQueuePersistentType.addAttributeToXml(printQueuePersistentType.getAttributeNamed("jobs"), "manyToMany");
        OrmManyToManyMapping jobsMapping = (OrmManyToManyMapping)jobsPersistentAttribute.getMapping();
        OrmPersistentType printJobPersistentType = this.getEntityMappings().addPersistentType("entity", "test.PrintJob");
        OrmSpecifiedPersistentAttribute queuesPersistentAttribute = printJobPersistentType.addAttributeToXml(printJobPersistentType.getAttributeNamed("queues"), "manyToMany");
        OrmManyToManyMapping queuesMapping = (OrmManyToManyMapping)queuesPersistentAttribute.getMapping();
        Orderable2_0 jobsOrderable = (Orderable2_0)jobsMapping.getOrderable();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)jobsOrderable.isOrderColumnOrdering());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)jobsOrderable.isNoOrdering());
        Orderable2_0 queuesOrderable = (Orderable2_0)queuesMapping.getOrderable();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)queuesOrderable.isOrderColumnOrdering());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)queuesOrderable.isNoOrdering());
        JavaManyToManyMapping javaJobsManyToManyMapping = (JavaManyToManyMapping)jobsPersistentAttribute.getJavaPersistentAttribute().getMapping();
        ((Orderable2_0)javaJobsManyToManyMapping.getOrderable()).setOrderColumnOrdering();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)jobsOrderable.isOrderColumnOrdering());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)jobsOrderable.isNoOrdering());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)queuesOrderable.isOrderColumnOrdering());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)queuesOrderable.isNoOrdering());
        jobsPersistentAttribute.removeFromXml();
        OrmPersistentAttribute jobsPersistentAttribute2 = printQueuePersistentType.getAttributeNamed("jobs");
        ManyToManyMapping virtualJobsMapping = (ManyToManyMapping)jobsPersistentAttribute2.getMapping();
        jobsOrderable = (Orderable2_0)virtualJobsMapping.getOrderable();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)jobsOrderable.isOrderColumnOrdering());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)jobsOrderable.isNoOrdering());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"PrintJob_PrintQueue", (String)jobsOrderable.getOrderColumn().getTableName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"jobs_ORDER", (String)jobsOrderable.getOrderColumn().getName());
        queuesPersistentAttribute.removeFromXml();
        OrmPersistentAttribute queuesPersistentAttribute2 = printJobPersistentType.getAttributeNamed("queues");
        ManyToManyMapping virtualQueuesMapping = (ManyToManyMapping)queuesPersistentAttribute2.getMapping();
        queuesOrderable = (Orderable2_0)virtualQueuesMapping.getOrderable();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)queuesOrderable.isOrderColumnOrdering());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)queuesOrderable.isNoOrdering());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"PrintJob_PrintQueue", (String)queuesOrderable.getOrderColumn().getTableName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"queues_ORDER", (String)queuesOrderable.getOrderColumn().getName());
        ((Orderable2_0)javaJobsManyToManyMapping.getOrderable()).getOrderColumn().setSpecifiedName("FOO");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"PrintJob_PrintQueue", (String)jobsOrderable.getOrderColumn().getTableName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)jobsOrderable.getOrderColumn().getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"PrintJob_PrintQueue", (String)queuesOrderable.getOrderColumn().getTableName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"queues_ORDER", (String)queuesOrderable.getOrderColumn().getName());
        JavaManyToManyMapping javaQueuesManyToManyMapping = (JavaManyToManyMapping)queuesPersistentAttribute.getJavaPersistentAttribute().getMapping();
        javaQueuesManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("JOIN_TABLE");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"JOIN_TABLE", (String)jobsOrderable.getOrderColumn().getTableName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)jobsOrderable.getOrderColumn().getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"JOIN_TABLE", (String)queuesOrderable.getOrderColumn().getTableName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"queues_ORDER", (String)queuesOrderable.getOrderColumn().getName());
    }

    private void createTestEntityPrintQueue() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ManyToMany");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OrderColumn");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PrintQueue").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private String name;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany(mappedBy=\"queues\")").append(CR);
                sb.append("    @OrderColumn").append(CR);
                sb.append("    private java.util.List<test.PrintJob> jobs;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "PrintQueue.java", sourceWriter);
    }

    private void createTestEntityPrintJob() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ManyToMany");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.OrderColumn");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append("PrintJob").append(" ");
                sb.append("{").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int id;").append(CR);
                sb.append(CR);
                sb.append("    @ManyToMany").append(CR);
                sb.append("    @OrderColumn").append(CR);
                sb.append("    private java.util.List<test.PrintQueue> queues;").append(CR);
                sb.append(CR);
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "PrintJob.java", sourceWriter);
    }

    public void testVirtualMapKeyColumnDefaults() throws Exception {
        this.createTestEntityWithValidMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmPersistentAttribute addressesPersistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        ManyToManyMapping2_0 addressesVirtualMapping = (ManyToManyMapping2_0)addressesPersistentAttribute.getMapping();
        SpecifiedColumn ormColumn = addressesVirtualMapping.getMapKeyColumn();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)ormColumn.getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)ormColumn.getTableName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals(null, (String)ormColumn.getColumnDefinition());
        GenericOrmManyToManyMapping2_0Tests.assertTrue((boolean)ormColumn.isInsertable());
        GenericOrmManyToManyMapping2_0Tests.assertTrue((boolean)ormColumn.isUpdatable());
        GenericOrmManyToManyMapping2_0Tests.assertTrue((boolean)ormColumn.isNullable());
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)ormColumn.isUnique());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((int)255, (int)ormColumn.getLength());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((int)0, (int)ormColumn.getPrecision());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((int)0, (int)ormColumn.getScale());
        JavaCollectionMapping2_0 javaManyToManyMapping = (JavaCollectionMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedName("FOO");
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedTableName("FOO_TABLE");
        javaManyToManyMapping.getMapKeyColumn().setColumnDefinition("COLUMN_DEFINITION");
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedInsertable(Boolean.FALSE);
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedUpdatable(Boolean.FALSE);
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedNullable(Boolean.FALSE);
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedUnique(Boolean.TRUE);
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedLength(Integer.valueOf(45));
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedPrecision(Integer.valueOf(46));
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedScale(Integer.valueOf(47));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)ormColumn.getSpecifiedName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"FOO_TABLE", (String)ormColumn.getSpecifiedTableName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"COLUMN_DEFINITION", (String)ormColumn.getColumnDefinition());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedInsertable());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedUpdatable());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)Boolean.FALSE, (Object)ormColumn.getSpecifiedNullable());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)Boolean.TRUE, (Object)ormColumn.getSpecifiedUnique());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)45, (Object)ormColumn.getSpecifiedLength());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)46, (Object)ormColumn.getSpecifiedPrecision());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)47, (Object)ormColumn.getSpecifiedScale());
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        addressesPersistentAttribute = ormPersistentType.getAttributeNamed("addresses");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)addressesPersistentAttribute.getMappingKey());
    }

    public void testNullMapKeyColumnDefaults() throws Exception {
        this.createTestEntityWithValidMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmSpecifiedPersistentAttribute addressesPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "manyToMany");
        OrmCollectionMapping2_0 addressesVirtualMapping = (OrmCollectionMapping2_0)addressesPersistentAttribute.getMapping();
        SpecifiedColumn ormColumn = addressesVirtualMapping.getMapKeyColumn();
        JavaCollectionMapping2_0 javaManyToManyMapping = (JavaCollectionMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedName("FOO");
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedTableName("FOO_TABLE");
        javaManyToManyMapping.getMapKeyColumn().setColumnDefinition("COLUMN_DEFINITION");
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedInsertable(Boolean.FALSE);
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedUpdatable(Boolean.FALSE);
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedNullable(Boolean.FALSE);
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedUnique(Boolean.TRUE);
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedLength(Integer.valueOf(45));
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedPrecision(Integer.valueOf(46));
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedScale(Integer.valueOf(47));
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"addresses_KEY", (String)ormColumn.getDefaultName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)ormColumn.getDefaultTableName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultInsertable());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultUpdatable());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((boolean)true, (boolean)ormColumn.isDefaultNullable());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((boolean)false, (boolean)ormColumn.isDefaultUnique());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((int)255, (int)ormColumn.getDefaultLength());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((int)0, (int)ormColumn.getDefaultPrecision());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((int)0, (int)ormColumn.getDefaultScale());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedName());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedTableName());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormColumn.getColumnDefinition());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedInsertable());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedUpdatable());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedNullable());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedUnique());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedLength());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedPrecision());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormColumn.getSpecifiedScale());
    }

    public void testVirtualMapKeyColumnTable() throws Exception {
        this.createTestEntityWithValidMapManyToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        OrmPersistentAttribute addressesPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        ManyToManyMapping2_0 addressesVirtualMapping = (ManyToManyMapping2_0)addressesPersistentAttribute.getMapping();
        SpecifiedColumn column = addressesVirtualMapping.getMapKeyColumn();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"AnnotationTestType_Address", (String)column.getTableName());
        ((OrmEntity)ormPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TABLE");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"ORM_TABLE_Address", (String)column.getTableName());
        ManyToManyMapping2_0 javaManyToManyMapping = (ManyToManyMapping2_0)ormPersistentType.getJavaPersistentType().getAttributeNamed("addresses").getMapping();
        javaManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("JAVA_JOIN_TABLE");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"JAVA_JOIN_TABLE", (String)column.getTableName());
        javaManyToManyMapping.getMapKeyColumn().setSpecifiedTableName("JAVA_TABLE");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"JAVA_TABLE", (String)column.getTableName());
        addressesPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("addresses"), "manyToMany");
        addressesVirtualMapping = (ManyToManyMapping2_0)addressesPersistentAttribute.getMapping();
        column = addressesVirtualMapping.getMapKeyColumn();
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)column.getSpecifiedTableName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"ORM_TABLE_Address", (String)column.getDefaultTableName());
    }

    public void testVirtualMappingMetadataCompleteFalse() throws Exception {
        this.createTestEntityManyToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute virtualAttribute = (OrmPersistentAttribute)ormPersistentType.getDefaultAttributes().iterator().next();
        ManyToManyMapping2_0 virtualManyToManyMapping = (ManyToManyMapping2_0)virtualAttribute.getMapping();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"address", (String)virtualManyToManyMapping.getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)FetchType.EAGER, (Object)virtualManyToManyMapping.getSpecifiedFetch());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"Address", (String)virtualManyToManyMapping.getSpecifiedTargetEntity());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)virtualManyToManyMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.EnumType.STRING, (Object)((BaseEnumeratedConverter)virtualManyToManyMapping.getMapKeyConverter()).getEnumType());
        Cascade2_0 cascade = virtualManyToManyMapping.getCascade();
        GenericOrmManyToManyMapping2_0Tests.assertTrue((boolean)cascade.isAll());
        GenericOrmManyToManyMapping2_0Tests.assertTrue((boolean)cascade.isMerge());
        GenericOrmManyToManyMapping2_0Tests.assertTrue((boolean)cascade.isPersist());
        GenericOrmManyToManyMapping2_0Tests.assertTrue((boolean)cascade.isRemove());
        GenericOrmManyToManyMapping2_0Tests.assertTrue((boolean)cascade.isRefresh());
        GenericOrmManyToManyMapping2_0Tests.assertTrue((boolean)cascade.isDetach());
        GenericOrmManyToManyMapping2_0Tests.assertTrue((boolean)virtualManyToManyMapping.getOrderable().isOrderByOrdering());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"city", (String)virtualManyToManyMapping.getOrderable().getOrderBy().getKey());
    }

    public void testVirtualMappingMetadataCompleteTrue() throws Exception {
        this.createTestEntityManyToManyMapping();
        this.createTestTargetEntityAddress();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        this.getEntityMappings().addPersistentType("entity", "test.Address");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((int)3, (int)ormPersistentType.getDefaultAttributesSize());
        OrmPersistentAttribute virtualPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        ormPersistentType.getMapping().setSpecifiedMetadataComplete(Boolean.TRUE);
        virtualPersistentAttribute = ormPersistentType.getAttributeNamed("address");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY, (String)virtualPersistentAttribute.getMappingKey());
        GenericOrmManyToManyMapping2_0Tests.assertTrue((boolean)virtualPersistentAttribute.isVirtual());
        virtualPersistentAttribute.addToXml("manyToMany");
        OrmPersistentAttribute ormPersistentAttribute = (OrmPersistentAttribute)ormPersistentType.getSpecifiedAttributes().iterator().next();
        ManyToManyMapping2_0 ormManyToManyMapping = (ManyToManyMapping2_0)ormPersistentAttribute.getMapping();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"address", (String)ormManyToManyMapping.getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)FetchType.LAZY, (Object)ormManyToManyMapping.getFetch());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"test.Address", (String)ormManyToManyMapping.getTargetEntity());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormManyToManyMapping.getRelationship().getMappedByStrategy().getMappedByAttribute());
        GenericOrmManyToManyMapping2_0Tests.assertTrue((boolean)(ormManyToManyMapping.getMapKeyConverter() instanceof NullOrmConverter));
        Cascade2_0 cascade = ormManyToManyMapping.getCascade();
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)cascade.isAll());
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)cascade.isMerge());
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)cascade.isPersist());
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)cascade.isRemove());
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)cascade.isRefresh());
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)cascade.isDetach());
        GenericOrmManyToManyMapping2_0Tests.assertTrue((boolean)ormManyToManyMapping.getOrderable().isNoOrdering());
        GenericOrmManyToManyMapping2_0Tests.assertEquals(null, (String)ormManyToManyMapping.getOrderable().getOrderBy().getKey());
    }

    public void testUpdateSpecifiedEnumerated() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmCollectionMapping2_0 ormManyToManyMapping = (OrmCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlManyToMany_2_0 manyToManyResource = (XmlManyToMany_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormManyToManyMapping.getMapKeyConverter().getConverterType());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)manyToManyResource.getMapKeyEnumerated());
        manyToManyResource.setMapKeyEnumerated(EnumType.ORDINAL);
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.EnumType.ORDINAL, (Object)((BaseEnumeratedConverter)ormManyToManyMapping.getMapKeyConverter()).getSpecifiedEnumType());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)EnumType.ORDINAL, (Object)manyToManyResource.getMapKeyEnumerated());
        manyToManyResource.setMapKeyEnumerated(EnumType.STRING);
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.EnumType.STRING, (Object)((BaseEnumeratedConverter)ormManyToManyMapping.getMapKeyConverter()).getSpecifiedEnumType());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)EnumType.STRING, (Object)manyToManyResource.getMapKeyEnumerated());
        manyToManyResource.setMapKeyEnumerated(null);
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormManyToManyMapping.getMapKeyConverter().getConverterType());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)manyToManyResource.getMapKeyEnumerated());
    }

    public void testModifySpecifiedEnumerated() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmCollectionMapping2_0 ormManyToManyMapping = (OrmCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlManyToMany_2_0 manyToManyResource = (XmlManyToMany_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormManyToManyMapping.getMapKeyConverter().getConverterType());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)manyToManyResource.getMapKeyEnumerated());
        ormManyToManyMapping.setMapKeyConverter(BaseEnumeratedConverter.class);
        ((BaseEnumeratedConverter)ormManyToManyMapping.getMapKeyConverter()).setSpecifiedEnumType(org.eclipse.jpt.jpa.core.context.EnumType.ORDINAL);
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)EnumType.ORDINAL, (Object)manyToManyResource.getMapKeyEnumerated());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.EnumType.ORDINAL, (Object)((BaseEnumeratedConverter)ormManyToManyMapping.getMapKeyConverter()).getSpecifiedEnumType());
        ((BaseEnumeratedConverter)ormManyToManyMapping.getMapKeyConverter()).setSpecifiedEnumType(org.eclipse.jpt.jpa.core.context.EnumType.STRING);
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)EnumType.STRING, (Object)manyToManyResource.getMapKeyEnumerated());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.EnumType.STRING, (Object)((BaseEnumeratedConverter)ormManyToManyMapping.getMapKeyConverter()).getSpecifiedEnumType());
        ormManyToManyMapping.setMapKeyConverter(null);
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)manyToManyResource.getMapKeyEnumerated());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormManyToManyMapping.getMapKeyConverter().getConverterType());
    }

    public void testUpdateSpecifiedTemporal() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmCollectionMapping2_0 ormManyToManyMapping = (OrmCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlManyToMany_2_0 manyToManyResource = (XmlManyToMany_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormManyToManyMapping.getMapKeyConverter().getConverterType());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)manyToManyResource.getMapKeyTemporal());
        manyToManyResource.setMapKeyTemporal(TemporalType.DATE);
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.DATE, (Object)((BaseTemporalConverter)ormManyToManyMapping.getMapKeyConverter()).getTemporalType());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)TemporalType.DATE, (Object)manyToManyResource.getMapKeyTemporal());
        manyToManyResource.setMapKeyTemporal(TemporalType.TIME);
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIME, (Object)((BaseTemporalConverter)ormManyToManyMapping.getMapKeyConverter()).getTemporalType());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)TemporalType.TIME, (Object)manyToManyResource.getMapKeyTemporal());
        manyToManyResource.setMapKeyTemporal(TemporalType.TIMESTAMP);
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIMESTAMP, (Object)((BaseTemporalConverter)ormManyToManyMapping.getMapKeyConverter()).getTemporalType());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)TemporalType.TIMESTAMP, (Object)manyToManyResource.getMapKeyTemporal());
        manyToManyResource.setMapKeyTemporal(null);
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormManyToManyMapping.getMapKeyConverter().getConverterType());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)manyToManyResource.getMapKeyTemporal());
    }

    public void testModifySpecifiedTemporal() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmCollectionMapping2_0 ormManyToManyMapping = (OrmCollectionMapping2_0)ormPersistentAttribute.getMapping();
        XmlManyToMany_2_0 manyToManyResource = (XmlManyToMany_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormManyToManyMapping.getMapKeyConverter().getConverterType());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)manyToManyResource.getMapKeyTemporal());
        ormManyToManyMapping.setMapKeyConverter(BaseTemporalConverter.class);
        ((BaseTemporalConverter)ormManyToManyMapping.getMapKeyConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.DATE);
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)TemporalType.DATE, (Object)manyToManyResource.getMapKeyTemporal());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.DATE, (Object)((BaseTemporalConverter)ormManyToManyMapping.getMapKeyConverter()).getTemporalType());
        ((BaseTemporalConverter)ormManyToManyMapping.getMapKeyConverter()).setTemporalType(org.eclipse.jpt.jpa.core.context.TemporalType.TIME);
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)TemporalType.TIME, (Object)manyToManyResource.getMapKeyTemporal());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)org.eclipse.jpt.jpa.core.context.TemporalType.TIME, (Object)((BaseTemporalConverter)ormManyToManyMapping.getMapKeyConverter()).getTemporalType());
        ormManyToManyMapping.setMapKeyConverter(null);
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)manyToManyResource.getMapKeyTemporal());
        GenericOrmManyToManyMapping2_0Tests.assertNull((Object)ormManyToManyMapping.getMapKeyConverter().getConverterType());
    }

    public void testAddSpecifiedMapKeyJoinColumn() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        ManyToManyMapping2_0 ormManyToManyMapping = (ManyToManyMapping2_0)ormPersistentAttribute.getMapping();
        XmlManyToMany_2_0 manyToManyResource = (XmlManyToMany_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        SpecifiedJoinColumn joinColumn = ormManyToManyMapping.addSpecifiedMapKeyJoinColumn(0);
        joinColumn.setSpecifiedName("FOO");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((XmlJoinColumn)manyToManyResource.getMapKeyJoinColumns().get(0)).getName());
        SpecifiedJoinColumn joinColumn2 = ormManyToManyMapping.addSpecifiedMapKeyJoinColumn(0);
        joinColumn2.setSpecifiedName("BAR");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((XmlJoinColumn)manyToManyResource.getMapKeyJoinColumns().get(0)).getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((XmlJoinColumn)manyToManyResource.getMapKeyJoinColumns().get(1)).getName());
        SpecifiedJoinColumn joinColumn3 = ormManyToManyMapping.addSpecifiedMapKeyJoinColumn(1);
        joinColumn3.setSpecifiedName("BAZ");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((XmlJoinColumn)manyToManyResource.getMapKeyJoinColumns().get(0)).getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)manyToManyResource.getMapKeyJoinColumns().get(1)).getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((XmlJoinColumn)manyToManyResource.getMapKeyJoinColumns().get(2)).getName());
        ListIterator joinColumns = ormManyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)joinColumn2, joinColumns.next());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)joinColumn3, joinColumns.next());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((Object)joinColumn, joinColumns.next());
        joinColumns = ormManyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
    }

    public void testRemoveSpecifiedMapKeyJoinColumn() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        ManyToManyMapping2_0 ormManyToManyMapping = (ManyToManyMapping2_0)ormPersistentAttribute.getMapping();
        XmlManyToMany_2_0 manyToManyResource = (XmlManyToMany_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        ormManyToManyMapping.addSpecifiedMapKeyJoinColumn(0).setSpecifiedName("FOO");
        ormManyToManyMapping.addSpecifiedMapKeyJoinColumn(1).setSpecifiedName("BAR");
        ormManyToManyMapping.addSpecifiedMapKeyJoinColumn(2).setSpecifiedName("BAZ");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((int)3, (int)manyToManyResource.getMapKeyJoinColumns().size());
        ormManyToManyMapping.removeSpecifiedMapKeyJoinColumn(0);
        GenericOrmManyToManyMapping2_0Tests.assertEquals((int)2, (int)manyToManyResource.getMapKeyJoinColumns().size());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((XmlJoinColumn)manyToManyResource.getMapKeyJoinColumns().get(0)).getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)manyToManyResource.getMapKeyJoinColumns().get(1)).getName());
        ormManyToManyMapping.removeSpecifiedMapKeyJoinColumn(0);
        GenericOrmManyToManyMapping2_0Tests.assertEquals((int)1, (int)manyToManyResource.getMapKeyJoinColumns().size());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)manyToManyResource.getMapKeyJoinColumns().get(0)).getName());
        ormManyToManyMapping.removeSpecifiedMapKeyJoinColumn(0);
        GenericOrmManyToManyMapping2_0Tests.assertEquals((int)0, (int)manyToManyResource.getMapKeyJoinColumns().size());
    }

    public void testMoveSpecifiedMapKeyJoinColumn() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        ManyToManyMapping2_0 ormManyToManyMapping = (ManyToManyMapping2_0)ormPersistentAttribute.getMapping();
        XmlManyToMany_2_0 manyToManyResource = (XmlManyToMany_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        ormManyToManyMapping.addSpecifiedMapKeyJoinColumn(0).setSpecifiedName("FOO");
        ormManyToManyMapping.addSpecifiedMapKeyJoinColumn(1).setSpecifiedName("BAR");
        ormManyToManyMapping.addSpecifiedMapKeyJoinColumn(2).setSpecifiedName("BAZ");
        GenericOrmManyToManyMapping2_0Tests.assertEquals((int)3, (int)manyToManyResource.getMapKeyJoinColumns().size());
        ormManyToManyMapping.moveSpecifiedMapKeyJoinColumn(2, 0);
        ListIterator joinColumns = ormManyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((XmlJoinColumn)manyToManyResource.getMapKeyJoinColumns().get(0)).getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)manyToManyResource.getMapKeyJoinColumns().get(1)).getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((XmlJoinColumn)manyToManyResource.getMapKeyJoinColumns().get(2)).getName());
        ormManyToManyMapping.moveSpecifiedMapKeyJoinColumn(0, 1);
        joinColumns = ormManyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)manyToManyResource.getMapKeyJoinColumns().get(0)).getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((XmlJoinColumn)manyToManyResource.getMapKeyJoinColumns().get(1)).getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((XmlJoinColumn)manyToManyResource.getMapKeyJoinColumns().get(2)).getName());
    }

    public void testUpdateMapKeyJoinColumns() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        ManyToManyMapping2_0 ormManyToManyMapping = (ManyToManyMapping2_0)ormPersistentAttribute.getMapping();
        XmlManyToMany_2_0 manyToManyResource = (XmlManyToMany_2_0)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        manyToManyResource.getMapKeyJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        manyToManyResource.getMapKeyJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        manyToManyResource.getMapKeyJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        ((XmlJoinColumn)manyToManyResource.getMapKeyJoinColumns().get(0)).setName("FOO");
        ((XmlJoinColumn)manyToManyResource.getMapKeyJoinColumns().get(1)).setName("BAR");
        ((XmlJoinColumn)manyToManyResource.getMapKeyJoinColumns().get(2)).setName("BAZ");
        ListIterator joinColumns = ormManyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        manyToManyResource.getMapKeyJoinColumns().move(2, 0);
        joinColumns = ormManyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        manyToManyResource.getMapKeyJoinColumns().move(0, 1);
        joinColumns = ormManyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"BAR", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        manyToManyResource.getMapKeyJoinColumns().remove(1);
        joinColumns = ormManyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"FOO", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        manyToManyResource.getMapKeyJoinColumns().remove(1);
        joinColumns = ormManyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator();
        GenericOrmManyToManyMapping2_0Tests.assertEquals((String)"BAZ", (String)((SpecifiedJoinColumn)joinColumns.next()).getName());
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)joinColumns.hasNext());
        manyToManyResource.getMapKeyJoinColumns().remove(0);
        GenericOrmManyToManyMapping2_0Tests.assertFalse((boolean)ormManyToManyMapping.getSpecifiedMapKeyJoinColumns().iterator().hasNext());
    }
}

