/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPackageInfo;
import org.eclipse.jpt.jaxb.core.context.XmlSchemaType;
import org.eclipse.jpt.jaxb.core.resource.java.XmlSchemaTypeAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaXmlSchemaTypeTests
extends JaxbContextModelTestCase {
    public GenericJavaXmlSchemaTypeTests(String name) {
        super(name);
    }

    private ICompilationUnit createPackageInfoWithXmlSchemaType() throws CoreException {
        return this.createTestPackageInfo("@XmlSchemaType", new String[]{"javax.xml.bind.annotation.XmlSchemaType"});
    }

    public void testModifyName() throws Exception {
        this.createPackageInfoWithXmlSchemaType();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        XmlSchemaType contextXmlSchemaType = (XmlSchemaType)contextPackageInfo.getXmlSchemaTypes().iterator().next();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        GenericJavaXmlSchemaTypeTests.assertNull((Object)contextXmlSchemaType.getQName().getName());
        contextXmlSchemaType.getQName().setSpecifiedName("foo");
        XmlSchemaTypeAnnotation schemaTypeAnnotation = (XmlSchemaTypeAnnotation)resourcePackage.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        GenericJavaXmlSchemaTypeTests.assertEquals((String)"foo", (String)schemaTypeAnnotation.getName());
        GenericJavaXmlSchemaTypeTests.assertEquals((String)"foo", (String)contextXmlSchemaType.getQName().getName());
        contextXmlSchemaType.getQName().setSpecifiedName(null);
        schemaTypeAnnotation = (XmlSchemaTypeAnnotation)resourcePackage.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        GenericJavaXmlSchemaTypeTests.assertNull((Object)schemaTypeAnnotation.getName());
        GenericJavaXmlSchemaTypeTests.assertNull((Object)contextXmlSchemaType.getQName().getName());
    }

    public void testUpdateName() throws Exception {
        this.createPackageInfoWithXmlSchemaType();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        XmlSchemaType contextXmlSchemaType = (XmlSchemaType)contextPackageInfo.getXmlSchemaTypes().iterator().next();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        GenericJavaXmlSchemaTypeTests.assertNull((Object)contextXmlSchemaType.getQName().getName());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourcePackage);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSchemaTypeTests.this.addXmlSchemaTypeMemberValuePair(declaration, "name", "foo");
            }
        });
        GenericJavaXmlSchemaTypeTests.assertEquals((String)"foo", (String)contextXmlSchemaType.getQName().getName());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSchemaTypeTests.this.removeXmlSchemaTypeAnnotation(declaration);
            }
        });
        GenericJavaXmlSchemaTypeTests.assertFalse((boolean)contextPackageInfo.getXmlSchemaTypes().iterator().hasNext());
    }

    public void testModifyNamespace() throws Exception {
        this.createPackageInfoWithXmlSchemaType();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        XmlSchemaType contextXmlSchemaType = (XmlSchemaType)contextPackageInfo.getXmlSchemaTypes().iterator().next();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        GenericJavaXmlSchemaTypeTests.assertNull((Object)contextXmlSchemaType.getQName().getSpecifiedNamespace());
        GenericJavaXmlSchemaTypeTests.assertEquals((String)"http://www.w3.org/2001/XMLSchema", (String)contextXmlSchemaType.getQName().getDefaultNamespace());
        GenericJavaXmlSchemaTypeTests.assertEquals((String)"http://www.w3.org/2001/XMLSchema", (String)contextXmlSchemaType.getQName().getNamespace());
        contextXmlSchemaType.getQName().setSpecifiedNamespace("foo");
        XmlSchemaTypeAnnotation schemaTypeAnnotation = (XmlSchemaTypeAnnotation)resourcePackage.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        GenericJavaXmlSchemaTypeTests.assertEquals((String)"foo", (String)schemaTypeAnnotation.getNamespace());
        GenericJavaXmlSchemaTypeTests.assertEquals((String)"foo", (String)contextXmlSchemaType.getQName().getSpecifiedNamespace());
        GenericJavaXmlSchemaTypeTests.assertEquals((String)"foo", (String)contextXmlSchemaType.getQName().getNamespace());
        contextXmlSchemaType.getQName().setSpecifiedNamespace(null);
        schemaTypeAnnotation = (XmlSchemaTypeAnnotation)resourcePackage.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        GenericJavaXmlSchemaTypeTests.assertNull((Object)schemaTypeAnnotation.getNamespace());
        GenericJavaXmlSchemaTypeTests.assertNull((Object)contextXmlSchemaType.getQName().getSpecifiedNamespace());
        GenericJavaXmlSchemaTypeTests.assertEquals((String)"http://www.w3.org/2001/XMLSchema", (String)contextXmlSchemaType.getQName().getNamespace());
    }

    public void testUpdateNamespace() throws Exception {
        this.createPackageInfoWithXmlSchemaType();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        XmlSchemaType contextXmlSchemaType = (XmlSchemaType)contextPackageInfo.getXmlSchemaTypes().iterator().next();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        GenericJavaXmlSchemaTypeTests.assertNull((Object)contextXmlSchemaType.getQName().getSpecifiedNamespace());
        GenericJavaXmlSchemaTypeTests.assertEquals((String)"http://www.w3.org/2001/XMLSchema", (String)contextXmlSchemaType.getQName().getDefaultNamespace());
        GenericJavaXmlSchemaTypeTests.assertEquals((String)"http://www.w3.org/2001/XMLSchema", (String)contextXmlSchemaType.getQName().getNamespace());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourcePackage);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSchemaTypeTests.this.addXmlSchemaTypeMemberValuePair(declaration, "namespace", "foo");
            }
        });
        GenericJavaXmlSchemaTypeTests.assertEquals((String)"foo", (String)contextXmlSchemaType.getQName().getSpecifiedNamespace());
        GenericJavaXmlSchemaTypeTests.assertEquals((String)"foo", (String)contextXmlSchemaType.getQName().getNamespace());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSchemaTypeTests.this.removeXmlSchemaTypeAnnotation(declaration);
            }
        });
        GenericJavaXmlSchemaTypeTests.assertFalse((boolean)contextPackageInfo.getXmlSchemaTypes().iterator().hasNext());
    }

    public void testModifyType() throws Exception {
        this.createPackageInfoWithXmlSchemaType();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        XmlSchemaType contextXmlSchemaType = (XmlSchemaType)contextPackageInfo.getXmlSchemaTypes().iterator().next();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        GenericJavaXmlSchemaTypeTests.assertNull((Object)contextXmlSchemaType.getType());
        contextXmlSchemaType.setType("foo");
        XmlSchemaTypeAnnotation schemaTypeAnnotation = (XmlSchemaTypeAnnotation)resourcePackage.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        GenericJavaXmlSchemaTypeTests.assertEquals((String)"foo", (String)schemaTypeAnnotation.getType());
        GenericJavaXmlSchemaTypeTests.assertEquals((String)"foo", (String)contextXmlSchemaType.getType());
        contextXmlSchemaType.setType(null);
        schemaTypeAnnotation = (XmlSchemaTypeAnnotation)resourcePackage.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        GenericJavaXmlSchemaTypeTests.assertNull((Object)schemaTypeAnnotation.getType());
        GenericJavaXmlSchemaTypeTests.assertNull((Object)contextXmlSchemaType.getType());
    }

    public void testUpdateType() throws Exception {
        this.createPackageInfoWithXmlSchemaType();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        XmlSchemaType contextXmlSchemaType = (XmlSchemaType)contextPackageInfo.getXmlSchemaTypes().iterator().next();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        GenericJavaXmlSchemaTypeTests.assertNull((Object)contextXmlSchemaType.getType());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourcePackage);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSchemaTypeTests.this.addXmlSchemaTypeTypeMemberValuePair(declaration, "type", "String");
            }
        });
        GenericJavaXmlSchemaTypeTests.assertEquals((String)"String", (String)contextXmlSchemaType.getType());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSchemaTypeTests.this.removeXmlSchemaTypeAnnotation(declaration);
            }
        });
        GenericJavaXmlSchemaTypeTests.assertFalse((boolean)contextPackageInfo.getXmlSchemaTypes().iterator().hasNext());
    }

    protected void addXmlSchemaTypeTypeMemberValuePair(ModifiedDeclaration declaration, String name, String typeName) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlSchemaTypeAnnotation(declaration), name, (Expression)this.newTypeLiteral(declaration.getAst(), typeName));
    }

    protected void addXmlSchemaTypeMemberValuePair(ModifiedDeclaration declaration, String name, String value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlSchemaTypeAnnotation(declaration), name, value);
    }

    protected void removeXmlSchemaTypeAnnotation(ModifiedDeclaration declaration) {
        this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAccessorOrder");
        this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlSchemaType");
    }

    protected Annotation getXmlSchemaTypeAnnotation(ModifiedDeclaration declaration) {
        return declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlSchemaType");
    }
}

