/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAccessType;
import org.eclipse.jpt.jaxb.core.resource.java.XmlAccessorTypeAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlAccessorTypePackageAnnotationTests
extends JaxbJavaResourceModelTestCase {
    public XmlAccessorTypePackageAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createPackageInfoWithAccessorType() throws CoreException {
        return this.createTestPackageInfo("@XmlAccessorType(value = XmlAccessType.PROPERTY)", new String[]{"javax.xml.bind.annotation.XmlAccessType", "javax.xml.bind.annotation.XmlAccessorType"});
    }

    public void testValue() throws Exception {
        ICompilationUnit cu = this.createPackageInfoWithAccessorType();
        JavaResourcePackage resourcePackage = this.buildJavaResourcePackage(cu);
        XmlAccessorTypeAnnotation annotation = (XmlAccessorTypeAnnotation)resourcePackage.getAnnotation("javax.xml.bind.annotation.XmlAccessorType");
        XmlAccessorTypePackageAnnotationTests.assertTrue((annotation != null ? 1 : 0) != 0);
        XmlAccessorTypePackageAnnotationTests.assertEquals((Object)XmlAccessType.PROPERTY, (Object)annotation.getValue());
        annotation.setValue(XmlAccessType.FIELD);
        XmlAccessorTypePackageAnnotationTests.assertEquals((Object)XmlAccessType.FIELD, (Object)annotation.getValue());
        this.assertSourceContains("@XmlAccessorType(value = FIELD)", cu);
        annotation.setValue(XmlAccessType.NONE);
        XmlAccessorTypePackageAnnotationTests.assertEquals((Object)XmlAccessType.NONE, (Object)annotation.getValue());
        this.assertSourceContains("@XmlAccessorType(value = NONE)", cu);
        annotation.setValue(XmlAccessType.PUBLIC_MEMBER);
        XmlAccessorTypePackageAnnotationTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)annotation.getValue());
        this.assertSourceContains("@XmlAccessorType(value = PUBLIC_MEMBER)", cu);
        annotation.setValue(null);
        this.assertSourceDoesNotContain("@XmlAccessorType(", cu);
    }
}

