/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.core.context.java.JavaClassMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.java.ELJavaXmlValueMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.ELJaxbContextModelTestCase;

public class ELJavaXmlValueMappingTests
extends ELJaxbContextModelTestCase {
    public ELJavaXmlValueMappingTests(String name) {
        super(name);
    }

    @Override
    protected String getPlatformID() {
        return "eclipselink_2_2";
    }

    private ICompilationUnit createTypeWithXmlValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "javax.xml.bind.annotation.XmlValue"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlValue");
            }
        });
    }

    public void testModifyXmlCDATA() throws Exception {
        this.createTypeWithXmlValue();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        ELJavaXmlValueMapping mapping = (ELJavaXmlValueMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ELJavaXmlValueMappingTests.assertNull((Object)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlCDATA"));
        ELJavaXmlValueMappingTests.assertNull((Object)mapping.getXmlCDATA());
        mapping.addXmlCDATA();
        ELJavaXmlValueMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlCDATA"));
        ELJavaXmlValueMappingTests.assertNotNull((Object)mapping.getXmlCDATA());
        mapping.removeXmlCDATA();
        ELJavaXmlValueMappingTests.assertNull((Object)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlCDATA"));
        ELJavaXmlValueMappingTests.assertNull((Object)mapping.getXmlCDATA());
    }

    public void testUpdateXmlCDATA() throws Exception {
        this.createTypeWithXmlValue();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        ELJavaXmlValueMapping mapping = (ELJavaXmlValueMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ELJavaXmlValueMappingTests.assertNull((Object)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlCDATA"));
        ELJavaXmlValueMappingTests.assertNull((Object)mapping.getXmlCDATA());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlValueMappingTests.this.addMarkerAnnotation(declaration.getDeclaration(), "org.eclipse.persistence.oxm.annotations.XmlCDATA");
            }
        });
        ELJavaXmlValueMappingTests.assertNotNull((Object)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlCDATA"));
        ELJavaXmlValueMappingTests.assertNotNull((Object)mapping.getXmlCDATA());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlValueMappingTests.this.removeAnnotation(declaration, "org.eclipse.persistence.oxm.annotations.XmlCDATA");
            }
        });
        ELJavaXmlValueMappingTests.assertNull((Object)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlCDATA"));
        ELJavaXmlValueMappingTests.assertNull((Object)mapping.getXmlCDATA());
    }
}

