/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.jpa2_1.context.orm.EntityMappings2_1;
import org.eclipse.jpt.jpa.core.resource.orm.XmlConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCustomConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkOrmConverterContainer;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkOrmEntity;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.EclipseLinkOrmCustomConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.EclipseLinkOrmFactory;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLink2_5ContextModelTestCase;

public class EclipseLink2_5OrmEntityTests
extends EclipseLink2_5ContextModelTestCase {
    public EclipseLink2_5OrmEntityTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntityForConverters() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }
        });
    }

    public void testUpdateCustomConverters() throws Exception {
        this.createTestEntityForConverters();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity ormContextEntity = (EclipseLinkOrmEntity)ormPersistentType.getMapping();
        EclipseLinkOrmConverterContainer ormContextConverterHolder = ormContextEntity.getConverterContainer();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLink2_5OrmEntityTests.assertEquals((int)0, (int)ormContextConverterHolder.getCustomConvertersSize());
        EclipseLink2_5OrmEntityTests.assertEquals((int)0, (int)resourceEntity.getConverters().size());
        EclipseLink2_5OrmEntityTests.assertEquals((int)0, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConverter resourceConverter = EclipseLinkOrmFactory.eINSTANCE.createXmlConverter();
        resourceEntity.getConverters().add((Object)resourceConverter);
        resourceConverter.setClassName("Foo");
        resourceConverter.setName("myConverter");
        EclipseLink2_5OrmEntityTests.assertEquals((int)1, (int)ormContextConverterHolder.getCustomConvertersSize());
        ListIterator ormContextConverters = ormContextConverterHolder.getCustomConverters().iterator();
        EclipseLinkCustomConverter ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLink2_5OrmEntityTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLink2_5OrmEntityTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        EclipseLink2_5OrmEntityTests.assertEquals((int)1, (int)resourceEntity.getConverters().size());
        EclipseLink2_5OrmEntityTests.assertEquals((int)1, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConverter resourceConverter2 = EclipseLinkOrmFactory.eINSTANCE.createXmlConverter();
        resourceEntity.getConverters().add(0, (Object)resourceConverter2);
        resourceConverter2.setClassName("Foo2");
        resourceConverter2.setName("myConverter2");
        EclipseLink2_5OrmEntityTests.assertEquals((int)2, (int)ormContextConverterHolder.getCustomConvertersSize());
        ormContextConverters = ormContextConverterHolder.getCustomConverters().iterator();
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLink2_5OrmEntityTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLink2_5OrmEntityTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLink2_5OrmEntityTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLink2_5OrmEntityTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        EclipseLink2_5OrmEntityTests.assertEquals((int)2, (int)resourceEntity.getConverters().size());
        EclipseLink2_5OrmEntityTests.assertEquals((int)2, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        resourceEntity.getConverters().move(0, 1);
        EclipseLink2_5OrmEntityTests.assertEquals((int)2, (int)ormContextConverterHolder.getCustomConvertersSize());
        ormContextConverters = ormContextConverterHolder.getCustomConverters().iterator();
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLink2_5OrmEntityTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLink2_5OrmEntityTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLink2_5OrmEntityTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLink2_5OrmEntityTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        EclipseLink2_5OrmEntityTests.assertEquals((int)2, (int)resourceEntity.getConverters().size());
        EclipseLink2_5OrmEntityTests.assertEquals((int)2, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        resourceEntity.getConverters().remove(0);
        EclipseLink2_5OrmEntityTests.assertEquals((int)1, (int)ormContextConverterHolder.getCustomConvertersSize());
        ormContextConverters = ormContextConverterHolder.getCustomConverters().iterator();
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLink2_5OrmEntityTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLink2_5OrmEntityTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        EclipseLink2_5OrmEntityTests.assertEquals((int)1, (int)resourceEntity.getConverters().size());
        EclipseLink2_5OrmEntityTests.assertEquals((int)1, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        resourceEntity.getConverters().remove((Object)resourceConverter2);
        EclipseLink2_5OrmEntityTests.assertEquals((int)0, (int)ormContextConverterHolder.getCustomConvertersSize());
        EclipseLink2_5OrmEntityTests.assertFalse((boolean)ormContextConverterHolder.getCustomConverters().iterator().hasNext());
        EclipseLink2_5OrmEntityTests.assertEquals((int)0, (int)resourceEntity.getConverters().size());
        EclipseLink2_5OrmEntityTests.assertEquals((int)0, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
    }

    public void testModifyCustomConverters() throws Exception {
        this.createTestEntityForConverters();
        EclipseLinkPersistenceUnit persistenceUnit = this.getPersistenceUnit();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        EclipseLinkOrmEntity ormContextEntity = (EclipseLinkOrmEntity)ormPersistentType.getMapping();
        EclipseLinkOrmConverterContainer ormContextConverterHolder = ormContextEntity.getConverterContainer();
        XmlEntity resourceEntity = (XmlEntity)this.getXmlEntityMappings().getEntities().get(0);
        EclipseLink2_5OrmEntityTests.assertEquals((int)0, (int)ormContextConverterHolder.getCustomConvertersSize());
        EclipseLink2_5OrmEntityTests.assertEquals((int)0, (int)resourceEntity.getConverters().size());
        EclipseLink2_5OrmEntityTests.assertEquals((int)0, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        EclipseLinkOrmCustomConverter contextConverter = ormContextConverterHolder.addCustomConverter("myConverter", 0);
        contextConverter.setConverterClass("Foo");
        EclipseLink2_5OrmEntityTests.assertEquals((int)1, (int)resourceEntity.getConverters().size());
        EclipseLink2_5OrmEntityTests.assertEquals((String)"Foo", (String)((XmlConverter)resourceEntity.getConverters().get(0)).getClassName());
        EclipseLink2_5OrmEntityTests.assertEquals((String)"myConverter", (String)((org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConverter)resourceEntity.getConverters().get(0)).getName());
        EclipseLink2_5OrmEntityTests.assertEquals((int)1, (int)ormContextConverterHolder.getCustomConvertersSize());
        ListIterator ormContextConverters = ormContextConverterHolder.getCustomConverters().iterator();
        EclipseLinkCustomConverter ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLink2_5OrmEntityTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLink2_5OrmEntityTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        EclipseLink2_5OrmEntityTests.assertEquals((int)1, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        contextConverter.setName(null);
        ormContextConverters = ormContextConverterHolder.getCustomConverters().iterator();
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLink2_5OrmEntityTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLink2_5OrmEntityTests.assertEquals(null, (String)ormContextConverter.getName());
        EclipseLink2_5OrmEntityTests.assertEquals((int)1, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        EclipseLink2_5OrmEntityTests.assertEquals((int)0, (int)IterableTools.size((Iterable)((EntityMappings2_1)this.getEntityMappings()).getConverterTypes()));
        contextConverter.setName("myConverter");
        EclipseLinkOrmCustomConverter contextConverter2 = ormContextConverterHolder.addCustomConverter("myConverter2", 0);
        contextConverter2.setConverterClass("Foo2");
        EclipseLink2_5OrmEntityTests.assertEquals((int)2, (int)resourceEntity.getConverters().size());
        EclipseLink2_5OrmEntityTests.assertEquals((String)"Foo2", (String)((XmlConverter)resourceEntity.getConverters().get(0)).getClassName());
        EclipseLink2_5OrmEntityTests.assertEquals((String)"myConverter2", (String)((org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConverter)resourceEntity.getConverters().get(0)).getName());
        EclipseLink2_5OrmEntityTests.assertEquals((String)"Foo", (String)((XmlConverter)resourceEntity.getConverters().get(1)).getClassName());
        EclipseLink2_5OrmEntityTests.assertEquals((String)"myConverter", (String)((org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConverter)resourceEntity.getConverters().get(1)).getName());
        EclipseLink2_5OrmEntityTests.assertEquals((int)2, (int)ormContextConverterHolder.getCustomConvertersSize());
        ormContextConverters = ormContextConverterHolder.getCustomConverters().iterator();
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLink2_5OrmEntityTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLink2_5OrmEntityTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLink2_5OrmEntityTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLink2_5OrmEntityTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        EclipseLink2_5OrmEntityTests.assertEquals((int)2, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        ormContextConverterHolder.moveCustomConverter(0, 1);
        EclipseLink2_5OrmEntityTests.assertEquals((int)2, (int)resourceEntity.getConverters().size());
        EclipseLink2_5OrmEntityTests.assertEquals((String)"Foo", (String)((XmlConverter)resourceEntity.getConverters().get(0)).getClassName());
        EclipseLink2_5OrmEntityTests.assertEquals((String)"myConverter", (String)((org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConverter)resourceEntity.getConverters().get(0)).getName());
        EclipseLink2_5OrmEntityTests.assertEquals((String)"Foo2", (String)((XmlConverter)resourceEntity.getConverters().get(1)).getClassName());
        EclipseLink2_5OrmEntityTests.assertEquals((String)"myConverter2", (String)((org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConverter)resourceEntity.getConverters().get(1)).getName());
        EclipseLink2_5OrmEntityTests.assertEquals((int)2, (int)ormContextConverterHolder.getCustomConvertersSize());
        ormContextConverters = ormContextConverterHolder.getCustomConverters().iterator();
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLink2_5OrmEntityTests.assertEquals((String)"Foo", (String)ormContextConverter.getConverterClass());
        EclipseLink2_5OrmEntityTests.assertEquals((String)"myConverter", (String)ormContextConverter.getName());
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLink2_5OrmEntityTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLink2_5OrmEntityTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        EclipseLink2_5OrmEntityTests.assertEquals((int)2, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        ormContextConverterHolder.removeCustomConverter(0);
        EclipseLink2_5OrmEntityTests.assertEquals((int)1, (int)resourceEntity.getConverters().size());
        EclipseLink2_5OrmEntityTests.assertEquals((String)"Foo2", (String)((XmlConverter)resourceEntity.getConverters().get(0)).getClassName());
        EclipseLink2_5OrmEntityTests.assertEquals((String)"myConverter2", (String)((org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConverter)resourceEntity.getConverters().get(0)).getName());
        EclipseLink2_5OrmEntityTests.assertEquals((int)1, (int)ormContextConverterHolder.getCustomConvertersSize());
        ormContextConverters = ormContextConverterHolder.getCustomConverters().iterator();
        ormContextConverter = (EclipseLinkCustomConverter)ormContextConverters.next();
        EclipseLink2_5OrmEntityTests.assertEquals((String)"Foo2", (String)ormContextConverter.getConverterClass());
        EclipseLink2_5OrmEntityTests.assertEquals((String)"myConverter2", (String)ormContextConverter.getName());
        EclipseLink2_5OrmEntityTests.assertEquals((int)1, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
        ormContextConverterHolder.removeCustomConverter((EclipseLinkCustomConverter)contextConverter2);
        EclipseLink2_5OrmEntityTests.assertEquals((int)0, (int)ormContextConverterHolder.getCustomConvertersSize());
        EclipseLink2_5OrmEntityTests.assertFalse((boolean)ormContextConverterHolder.getCustomConverters().iterator().hasNext());
        EclipseLink2_5OrmEntityTests.assertEquals((int)0, (int)resourceEntity.getConverters().size());
        EclipseLink2_5OrmEntityTests.assertEquals((int)0, (int)IterableTools.size((Iterable)persistenceUnit.getAllConverters()));
    }
}

