/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.tests.contentassist;

import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceAlreadyExists;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.encoding.XMLDocumentLoader;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.StructuredTextViewerConfigurationXML;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentAssistProcessor;
import org.eclipse.wst.xml.ui.tests.ProjectUtil;

public class TestXMLContentAssist
extends TestCase {
    protected String projectName = null;
    protected String fileName = null;
    protected IFile file = null;
    protected IEditorPart textEditorPart = null;
    protected ITextEditor editor = null;
    protected XMLDocumentLoader xmlDocumentLoader = null;
    protected IStructuredDocument document = null;
    protected StructuredTextViewer sourceViewer = null;
    private IStructuredModel model;
    protected XMLContentAssistProcessor xmlContentAssistProcessor = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.projectName = "TestXMLContentAssist";
        this.fileName = "xmlContentAssist-test1.xml";
        String xmlFilePath = this.setupProject();
        this.file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(xmlFilePath));
        if (this.file != null && !this.file.exists()) {
            Assert.fail((String)("Unable to locate " + xmlFilePath + "."));
        }
        this.loadXMLFile();
        this.initializeSourceViewer();
        this.xmlContentAssistProcessor = new XMLContentAssistProcessor();
    }

    protected void initializeSourceViewer() {
        if (Display.getCurrent() != null) {
            Shell shell = null;
            Composite parent = null;
            shell = PlatformUI.isWorkbenchRunning() ? PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell() : new Shell(Display.getCurrent());
            parent = new Composite((Composite)shell, 0);
            this.sourceViewer = new StructuredTextViewer(parent, null, null, false, 0);
        } else {
            Assert.fail((String)"Unable to run the test as a display must be available.");
        }
        this.configureSourceViewer();
    }

    protected void configureSourceViewer() {
        this.sourceViewer.configure((SourceViewerConfiguration)new StructuredTextViewerConfigurationXML());
        this.sourceViewer.setDocument((IDocument)this.document);
    }

    protected void loadXMLFile() throws ResourceAlreadyExists, ResourceInUse, IOException, CoreException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        this.model = modelManager.getModelForEdit(this.file);
        this.document = this.model.getStructuredDocument();
    }

    protected String setupProject() {
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(this.projectName);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
        try {
            project.create(description, (IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException coreException) {}
        String xmlFilePath = project.getFullPath().addTrailingSeparator().append(this.fileName).toString();
        ProjectUtil.copyBundleEntriesIntoWorkspace("/testresources", project.getFullPath().toString());
        return xmlFilePath;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.xmlContentAssistProcessor.release();
    }

    private ICompletionProposal[] getProposals(int offset) throws Exception {
        return this.xmlContentAssistProcessor.computeCompletionProposals((ITextViewer)this.sourceViewer, offset);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testAttributeProposal() throws Exception {
        try {
            int offset = this.sourceViewer.getDocument().getLineOffset(10) + 10;
            IDOMNode node = (IDOMNode)ContentAssistUtils.getNodeAt((ITextViewer)this.sourceViewer, (int)offset);
            TestXMLContentAssist.assertEquals((String)"Wrong node name returned:", (String)"Member", (String)node.getNodeName());
            ICompletionProposal[] proposals = this.getProposals(offset);
            TestXMLContentAssist.assertTrue((String)"Length less than 1", (proposals.length > 1 ? 1 : 0) != 0);
            ICompletionProposal proposal = proposals[0];
            TestXMLContentAssist.assertEquals((String)("Wrong attribute proposal returned at [" + this.sourceViewer.getDocument().get(offset - 9, 9) + "|" + this.sourceViewer.getDocument().get(offset, 9) + "]"), (String)"handicap", (String)proposal.getDisplayString());
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.model.releaseFromEdit();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        this.model.releaseFromEdit();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testChildElementProposal() throws Exception {
        try {
            int offset = this.sourceViewer.getDocument().getLineOffset(11) + 8;
            ICompletionProposal[] proposals = this.getProposals(offset);
            TestXMLContentAssist.assertEquals((String)"Unexpected number of proposals", (int)5, (int)proposals.length);
            ICompletionProposal proposal = proposals[0];
            TestXMLContentAssist.assertEquals((String)"Wrong element proposal returned.", (String)"ExclusiveMember", (String)proposal.getDisplayString());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.model.releaseFromEdit();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.model.releaseFromEdit();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testShaftElementProposal() throws Exception {
        try {
            int offset = this.sourceViewer.getDocument().getLineOffset(24) + 6;
            ICompletionProposal[] proposals = this.getProposals(offset);
            TestXMLContentAssist.assertEquals((String)"Unexpected number of proposals", (int)7, (int)proposals.length);
            ICompletionProposal proposal = proposals[0];
            TestXMLContentAssist.assertEquals((String)"Wrong element proposal returned.", (String)"Shaft", (String)proposal.getDisplayString());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.model.releaseFromEdit();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.model.releaseFromEdit();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testXMLTemplatePositionalProposal() throws Exception {
        try {
            int offset = this.sourceViewer.getDocument().getLineOffset(24) + 6;
            ICompletionProposal[] proposals = this.getProposals(offset);
            TestXMLContentAssist.assertEquals((String)"Unexpected number of proposals", (int)7, (int)proposals.length);
            ICompletionProposal proposal = proposals[5];
            TestXMLContentAssist.assertEquals((String)"Wrong template proposal returned.", (String)"comment - xml comment", (String)proposal.getDisplayString());
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.model.releaseFromEdit();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        this.model.releaseFromEdit();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testXMLCommentTemplateProposalExists() throws Exception {
        try {
            int offset = this.sourceViewer.getDocument().getLineOffset(24) + 6;
            ICompletionProposal[] proposals = this.getProposals(offset);
            TestXMLContentAssist.assertNotNull((String)"No proposals returned.", (Object)proposals);
            boolean foundsw = false;
            int cnt = 0;
            while (true) {
                block6: {
                    if (cnt < proposals.length) break block6;
                    if (!foundsw) {
                        TestXMLContentAssist.fail((String)"XML Template 'xml comment' was not found in the proposal list");
                    }
                    break;
                }
                ICompletionProposal proposal = proposals[cnt];
                if (proposal.getDisplayString().equals("comment - xml comment")) {
                    foundsw = true;
                }
                ++cnt;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.model.releaseFromEdit();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        this.model.releaseFromEdit();
    }
}

