/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.v8native;

import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import org.eclipse.wst.jsdt.chromium.JavascriptVm;
import org.eclipse.wst.jsdt.chromium.Script;
import org.eclipse.wst.jsdt.chromium.internal.browserfixture.AbstractAttachedTest;
import org.eclipse.wst.jsdt.chromium.internal.browserfixture.FixtureChromeStub;
import org.eclipse.wst.jsdt.chromium.internal.transport.FakeConnection;
import org.eclipse.wst.jsdt.chromium.util.MethodIsBlockingException;
import org.junit.Assert;
import org.junit.Test;

public class ScriptsTest
extends AbstractAttachedTest<FakeConnection> {
    @Test
    public void checkAfterCompileScriptIsKnown() throws Exception {
        Collection<Script> scripts = this.getScripts();
        Assert.assertEquals((long)1L, (long)scripts.size());
        final CountDownLatch latch = new CountDownLatch(1);
        this.scriptLoadedCallback = new Runnable(){

            @Override
            public void run() {
                latch.countDown();
            }
        };
        this.messageResponder.sendAfterCompile();
        latch.await();
        Assert.assertNotNull((Object)this.loadedScript);
        Collection<Script> newScripts = this.getScripts();
        Assert.assertEquals((long)2L, (long)newScripts.size());
        newScripts.removeAll(scripts);
        Script compiledScript = newScripts.iterator().next();
        Assert.assertEquals((Object)FixtureChromeStub.getCompiledScriptId(), (Object)compiledScript.getId());
        Assert.assertEquals((Object)this.loadedScript.getId(), (Object)compiledScript.getId());
        String source = compiledScript.getSource();
        Assert.assertTrue((source != null && source.contains("compiled()") ? 1 : 0) != 0);
    }

    private Collection<Script> getScripts() throws MethodIsBlockingException {
        final Collection[] loadedScripts = new Collection[1];
        this.javascriptVm.getScripts(new JavascriptVm.ScriptsCallback(){

            public void success(Collection<Script> scripts) {
                loadedScripts[0] = scripts;
            }

            public void failure(String errorMessage) {
            }
        });
        return loadedScripts[0];
    }

    @Override
    protected FakeConnection createConnection() {
        return new FakeConnection(this.messageResponder);
    }
}

