/*******************************************************************************
 * Copyright (c) 2007, 2013 Oracle. All rights reserved.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0, which accompanies this distribution
 * and is available at http://www.eclipse.org/legal/epl-v10.html.
 * 
 * Contributors:
 *     Oracle - initial API and implementation
 ******************************************************************************/
package org.eclipse.jpt.jpa.core.context.orm;

import org.eclipse.jpt.jpa.core.context.SpecifiedColumn;
import org.eclipse.jpt.jpa.core.context.TableColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlColumn;

/**
 * <code>orm.xml</code> specified column
 * <p>
 * Provisional API: This interface is part of an interim API that is still
 * under development and expected to change significantly before reaching
 * stability. It is available at this early stage to solicit feedback from
 * pioneering adopters on the understanding that any code that uses this API
 * will almost certainly be broken (repeatedly) as the API evolves.
 * 
 * @version 2.3
 * @since 2.0
 */
public interface OrmSpecifiedColumn
	extends SpecifiedColumn, OrmSpecifiedBaseColumn
{
	/**
	 * @see OrmAttributeMapping#initializeOn(OrmAttributeMapping)
	 * @see OrmSpecifiedAttributeOverride#initializeFrom(OrmSpecifiedAttributeOverride)
	 */
	void initializeFrom(OrmSpecifiedColumn oldColumn);

	XmlColumn getXmlColumn();


	// ********** parent adapter **********

	/**
	 * interface allowing columns to be used in multiple places
	 * (e.g. basic mappings and attribute overrides)
	 */
	interface ParentAdapter
		extends TableColumn.ParentAdapter
	{
		XmlColumn getXmlColumn();
		XmlColumn buildXmlColumn();
		void removeXmlColumn();
	}
}
