/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context;

import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.jpa.core.tests.internal.projects.JpaProjectTestHarness;
import org.eclipse.jpt.jpa.eclipselink.core.EclipseLinkJpaProject;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaEmbeddable;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaEntity;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaMappedSuperclass;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkEntityMappings;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.core.internal.operations.EclipseLinkOrmFileCreationDataModelProvider;
import org.eclipse.jpt.jpa.eclipselink.core.internal.operations.EclipseLinkOrmFileCreationOperation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlEntityMappings;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public abstract class EclipseLinkContextModelTestCase
extends ContextModelTestCase {
    protected JptXmlResource eclipseLinkOrmXmlResource;

    protected EclipseLinkContextModelTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.eclipseLinkOrmXmlResource = this.getJpaProject().getDefaultEclipseLinkOrmXmlResource();
    }

    protected void tearDown() throws Exception {
        this.eclipseLinkOrmXmlResource = null;
        super.tearDown();
    }

    protected JpaProjectTestHarness buildJpaProjectTestHarness(String projectName, boolean autoBuild, IDataModel jpaConfig) throws Exception {
        JpaProjectTestHarness harness = super.buildJpaProjectTestHarness(projectName, autoBuild, jpaConfig);
        if (this.createEclipseLinkOrmXml()) {
            EclipseLinkOrmFileCreationOperation operation = new EclipseLinkOrmFileCreationOperation(this.buildEclipseLinkOrmConfig(harness));
            operation.execute(null, null);
        }
        return harness;
    }

    protected boolean createOrmXml() {
        return false;
    }

    protected boolean createEclipseLinkOrmXml() {
        return true;
    }

    protected IDataModel buildEclipseLinkOrmConfig(JpaProjectTestHarness harness) {
        IDataModel dataModel = DataModelFactory.createDataModel((IDataModelProvider)new EclipseLinkOrmFileCreationDataModelProvider());
        dataModel.setProperty("JptFileCreationDataModelProperties.CONTAINER_PATH", (Object)harness.getProject().getFolder("src/META-INF").getFullPath());
        dataModel.setProperty("JpaFileCreationDataModelProperties.VERSION", (Object)this.getEclipseLinkSchemaVersion());
        dataModel.setProperty("OrmFileCreationDataModelProperties.ADD_TO_PERSISTENCE_UNIT", (Object)Boolean.TRUE);
        return dataModel;
    }

    protected String getEclipseLinkSchemaVersion() {
        return "1.0";
    }

    protected String getJpaPlatformID() {
        return "org.eclipse.eclipselink.platform";
    }

    protected EclipseLinkJpaProject getJpaProject() {
        return (EclipseLinkJpaProject)super.getJpaProject();
    }

    protected EclipseLinkPersistenceUnit getPersistenceUnit() {
        return (EclipseLinkPersistenceUnit)super.getPersistenceUnit();
    }

    protected EclipseLinkJavaEntity getJavaEntity() {
        return (EclipseLinkJavaEntity)this.getJavaPersistentType().getMapping();
    }

    protected EclipseLinkJavaEmbeddable getJavaEmbeddable() {
        return (EclipseLinkJavaEmbeddable)this.getJavaPersistentType().getMapping();
    }

    protected EclipseLinkJavaMappedSuperclass getJavaMappedSuperclass() {
        return (EclipseLinkJavaMappedSuperclass)this.getJavaPersistentType().getMapping();
    }

    protected JptXmlResource getOrmXmlResource() {
        return this.eclipseLinkOrmXmlResource;
    }

    protected XmlEntityMappings getXmlEntityMappings() {
        return (XmlEntityMappings)super.getXmlEntityMappings();
    }

    protected EclipseLinkEntityMappings getEntityMappings() {
        return (EclipseLinkEntityMappings)((MappingFileRef)this.getPersistenceUnit().getSpecifiedMappingFileRefs().iterator().next()).getMappingFile().getRoot();
    }
}

