/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.JavaProjectTestHarness;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.BasicMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedIdMapping;
import org.eclipse.jpt.jpa.core.context.EmbeddedMapping;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.ManyToOneMapping;
import org.eclipse.jpt.jpa.core.context.OneToManyMapping;
import org.eclipse.jpt.jpa.core.context.OneToOneMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.TransientMapping;
import org.eclipse.jpt.jpa.core.context.VersionMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaEmbeddedMapping;
import org.eclipse.jpt.jpa.core.internal.jpa1.context.java.GenericJavaNullAttributeMapping;
import org.eclipse.jpt.jpa.core.jpa2.context.ElementCollectionMapping2_0;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.context.Generic2_0ContextModelTestCase;

public class GenericJavaEmbeddedIdMapping2_0Tests
extends Generic2_0ContextModelTestCase {
    public static final String EMBEDDABLE_TYPE_NAME = "MyEmbeddable";
    public static final String FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME = "test.MyEmbeddable";

    private ICompilationUnit createTestEntityWithEmbeddedIdMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.EmbeddedId"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@EmbeddedId").append(CR);
                sb.append(CR);
                sb.append("    private MyEmbeddable myEmbeddedId;").append(CR);
                sb.append(CR);
            }
        });
    }

    private void createEmbeddableType() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Embeddable");
                sb.append(";");
                sb.append(CR);
                sb.append("@Embeddable");
                sb.append(CR);
                sb.append("public class ").append(GenericJavaEmbeddedIdMapping2_0Tests.EMBEDDABLE_TYPE_NAME).append(" {");
                sb.append(CR);
                sb.append("    private String city;").append(CR);
                sb.append(CR);
                sb.append("    private String state;").append(CR);
                sb.append(CR);
                sb.append("    ");
                sb.append("}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "MyEmbeddable.java", sourceWriter);
    }

    public GenericJavaEmbeddedIdMapping2_0Tests(String name) {
        super(name);
    }

    public void testMorphToBasicMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaEmbeddedIdMapping2_0Tests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setMappingKey("basic");
        GenericJavaEmbeddedIdMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof BasicMapping));
        GenericJavaEmbeddedIdMapping2_0Tests.assertFalse((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaEmbeddedIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.EmbeddedId"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Basic"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
    }

    public void testMorphToDefault() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaEmbeddedIdMapping2_0Tests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        GenericJavaEmbeddedIdMapping2_0Tests.assertTrue((boolean)((JavaEmbeddedMapping)persistentAttribute.getMapping()).getAttributeOverrideContainer().getOverrides().iterator().hasNext());
        GenericJavaEmbeddedIdMapping2_0Tests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        GenericJavaEmbeddedIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.EmbeddedId"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
    }

    public void testDefaultEmbeddedIdMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        GenericJavaEmbeddedIdMapping2_0Tests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        GenericJavaEmbeddedIdMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof GenericJavaNullAttributeMapping));
        GenericJavaEmbeddedIdMapping2_0Tests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
        this.createEmbeddableType();
        this.addXmlClassRef(FULLY_QUALIFIED_EMBEDDABLE_TYPE_NAME);
        GenericJavaEmbeddedIdMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        GenericJavaEmbeddedIdMapping2_0Tests.assertTrue((boolean)persistentAttribute.getMapping().isDefault());
    }

    public void testMorphToVersionMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaEmbeddedIdMapping2_0Tests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setMappingKey("version");
        GenericJavaEmbeddedIdMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof VersionMapping));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.EmbeddedId"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Version"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
    }

    public void testMorphToTransientMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaEmbeddedIdMapping2_0Tests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setMappingKey("transient");
        GenericJavaEmbeddedIdMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof TransientMapping));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.EmbeddedId"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Transient"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
    }

    public void testMorphToIdMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaEmbeddedIdMapping2_0Tests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setMappingKey("id");
        GenericJavaEmbeddedIdMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof IdMapping));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.EmbeddedId"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Id"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
    }

    public void testMorphToEmbeddedMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaEmbeddedIdMapping2_0Tests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setMappingKey("embedded");
        GenericJavaEmbeddedIdMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof EmbeddedMapping));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.EmbeddedId"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Embedded"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
    }

    public void testMorphToOneToOneMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaEmbeddedIdMapping2_0Tests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setMappingKey("oneToOne");
        GenericJavaEmbeddedIdMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToOneMapping));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.EmbeddedId"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToOne"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
    }

    public void testMorphToOneToManyMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaEmbeddedIdMapping2_0Tests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setMappingKey("oneToMany");
        GenericJavaEmbeddedIdMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof OneToManyMapping));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.EmbeddedId"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.OneToMany"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
    }

    public void testMorphToManyToOneMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        resourceField.addAnnotation("javax.persistence.Access");
        GenericJavaEmbeddedIdMapping2_0Tests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setMappingKey("manyToOne");
        GenericJavaEmbeddedIdMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToOneMapping));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.EmbeddedId"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToOne"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertEquals((int)0, (int)resourceField.getAnnotationsSize("javax.persistence.AttributeOverride"));
    }

    public void testMorphToManyToManyMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation("javax.persistence.Access");
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        GenericJavaEmbeddedIdMapping2_0Tests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setMappingKey("manyToMany");
        GenericJavaEmbeddedIdMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ManyToManyMapping));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.EmbeddedId"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ManyToMany"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
    }

    public void testMorphToElementCollectionMapping() throws Exception {
        this.createTestEntityWithEmbeddedIdMapping();
        this.createEmbeddableType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EmbeddedIdMapping embeddedIdMapping = (EmbeddedIdMapping)persistentAttribute.getMapping();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        resourceField.addAnnotation("javax.persistence.Access");
        resourceField.addAnnotation(0, "javax.persistence.AttributeOverride");
        GenericJavaEmbeddedIdMapping2_0Tests.assertFalse((boolean)embeddedIdMapping.isDefault());
        persistentAttribute.setMappingKey("elementCollection");
        GenericJavaEmbeddedIdMapping2_0Tests.assertTrue((boolean)(persistentAttribute.getMapping() instanceof ElementCollectionMapping2_0));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNull((Object)resourceField.getAnnotation("javax.persistence.EmbeddedId"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.ElementCollection"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation("javax.persistence.Access"));
        GenericJavaEmbeddedIdMapping2_0Tests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.AttributeOverride"));
    }
}

