/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.resource.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceMember;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.resource.java.JpaJavaResourceModelTestCase;

public class JoinColumnsTests
extends JpaJavaResourceModelTestCase {
    private static final String COLUMN_NAME = "MY_COLUMN";
    private static final String COLUMN_TABLE = "MY_TABLE";
    private static final String COLUMN_COLUMN_DEFINITION = "COLUMN_DEFINITION";
    private static final String COLUMN_REFERENCED_COLUMN_NAME = "MY_REF_COLUMN_NAME";

    public JoinColumnsTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestJoinColumns() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.JoinColumn", "javax.persistence.JoinColumns"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinColumns(@JoinColumn)");
            }
        });
    }

    private ICompilationUnit createTestJoinColumnWithName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.JoinColumn", "javax.persistence.JoinColumns"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinColumns(@JoinColumn(name = \"MY_COLUMN\"))");
            }
        });
    }

    private ICompilationUnit createTestJoinColumnWithTable() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.JoinColumn", "javax.persistence.JoinColumns"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinColumns(@JoinColumn(table = \"MY_TABLE\"))");
            }
        });
    }

    private ICompilationUnit createTestJoinColumnWithReferencedColumnName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.JoinColumn", "javax.persistence.JoinColumns"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinColumns(@JoinColumn(referencedColumnName = \"MY_REF_COLUMN_NAME\"))");
            }
        });
    }

    private ICompilationUnit createTestJoinColumnWithColumnDefinition() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.JoinColumn", "javax.persistence.JoinColumns"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinColumns(@JoinColumn(columnDefinition = \"COLUMN_DEFINITION\"))");
            }
        });
    }

    private ICompilationUnit createTestJoinColumnWithBooleanElement(final String booleanElement) throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.JoinColumn", "javax.persistence.JoinColumns"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinColumns(@JoinColumn(" + booleanElement + " = true))");
            }
        });
    }

    private ICompilationUnit createTestJoinColumn() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.JoinColumn", "javax.persistence.JoinColumns"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\")");
            }
        });
    }

    private JoinColumnAnnotation joinColumnAt(JavaResourceMember resourceMember, int index) {
        return (JoinColumnAnnotation)IterableTools.get((Iterable)resourceMember.getAnnotations("javax.persistence.JoinColumn"), (int)index);
    }

    public void testGetName() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinColumnAnnotation column = this.joinColumnAt((JavaResourceMember)resourceField, 0);
        JoinColumnsTests.assertNotNull((Object)column);
        JoinColumnsTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
    }

    public void testGetNull() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinColumnAnnotation column = this.joinColumnAt((JavaResourceMember)resourceField, 0);
        JoinColumnsTests.assertNotNull((Object)column);
        JoinColumnsTests.assertNull((Object)column.getName());
        JoinColumnsTests.assertNull((Object)column.getNullable());
        JoinColumnsTests.assertNull((Object)column.getInsertable());
        JoinColumnsTests.assertNull((Object)column.getUnique());
        JoinColumnsTests.assertNull((Object)column.getUpdatable());
        JoinColumnsTests.assertNull((Object)column.getTable());
        JoinColumnsTests.assertNull((Object)column.getColumnDefinition());
    }

    public void testSetName() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinColumnAnnotation column = this.joinColumnAt((JavaResourceMember)resourceField, 0);
        JoinColumnsTests.assertNotNull((Object)column);
        JoinColumnsTests.assertNull((Object)column.getName());
        column.setName("Foo");
        JoinColumnsTests.assertEquals((String)"Foo", (String)column.getName());
        this.assertSourceContains("@JoinColumns(@JoinColumn(name = \"Foo\"))", cu);
    }

    public void testSetNameNull() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinColumnAnnotation column = this.joinColumnAt((JavaResourceMember)resourceField, 0);
        JoinColumnsTests.assertEquals((String)COLUMN_NAME, (String)column.getName());
        column.setName(null);
        JoinColumnsTests.assertNull((Object)column.getName());
        this.assertSourceDoesNotContain("@JoinColumn(", cu);
    }

    public void testGetTable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithTable();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinColumnAnnotation column = this.joinColumnAt((JavaResourceMember)resourceField, 0);
        JoinColumnsTests.assertEquals((String)COLUMN_TABLE, (String)column.getTable());
    }

    public void testSetTable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinColumnAnnotation column = this.joinColumnAt((JavaResourceMember)resourceField, 0);
        JoinColumnsTests.assertNotNull((Object)column);
        JoinColumnsTests.assertNull((Object)column.getTable());
        column.setTable("Foo");
        JoinColumnsTests.assertEquals((String)"Foo", (String)column.getTable());
        this.assertSourceContains("@JoinColumns(@JoinColumn(table = \"Foo\"))", cu);
        column.setTable(null);
        this.assertSourceDoesNotContain("@JoinColumn(", cu);
    }

    public void testGetReferencedColumnName() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithReferencedColumnName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinColumnAnnotation column = this.joinColumnAt((JavaResourceMember)resourceField, 0);
        JoinColumnsTests.assertEquals((String)COLUMN_REFERENCED_COLUMN_NAME, (String)column.getReferencedColumnName());
    }

    public void testSetReferencedColumnName() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinColumnAnnotation column = this.joinColumnAt((JavaResourceMember)resourceField, 0);
        JoinColumnsTests.assertNotNull((Object)column);
        JoinColumnsTests.assertNull((Object)column.getReferencedColumnName());
        column.setReferencedColumnName("Foo");
        JoinColumnsTests.assertEquals((String)"Foo", (String)column.getReferencedColumnName());
        this.assertSourceContains("@JoinColumns(@JoinColumn(referencedColumnName = \"Foo\"))", cu);
        column.setReferencedColumnName(null);
        this.assertSourceDoesNotContain("@JoinColumn(", cu);
    }

    public void testGetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithColumnDefinition();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinColumnAnnotation column = this.joinColumnAt((JavaResourceMember)resourceField, 0);
        JoinColumnsTests.assertEquals((String)COLUMN_COLUMN_DEFINITION, (String)column.getColumnDefinition());
    }

    public void testSetColumnDefinition() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinColumnAnnotation column = this.joinColumnAt((JavaResourceMember)resourceField, 0);
        JoinColumnsTests.assertNotNull((Object)column);
        JoinColumnsTests.assertNull((Object)column.getColumnDefinition());
        column.setColumnDefinition("Foo");
        JoinColumnsTests.assertEquals((String)"Foo", (String)column.getColumnDefinition());
        this.assertSourceContains("@JoinColumns(@JoinColumn(columnDefinition = \"Foo\"))", cu);
        column.setColumnDefinition(null);
        this.assertSourceDoesNotContain("@JoinColumn(", cu);
    }

    public void testGetUnique() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithBooleanElement("unique");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinColumnAnnotation column = this.joinColumnAt((JavaResourceMember)resourceField, 0);
        JoinColumnsTests.assertTrue((boolean)column.getUnique());
    }

    public void testSetUnique() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinColumnAnnotation column = this.joinColumnAt((JavaResourceMember)resourceField, 0);
        JoinColumnsTests.assertNotNull((Object)column);
        JoinColumnsTests.assertNull((Object)column.getUnique());
        column.setUnique(Boolean.FALSE);
        JoinColumnsTests.assertFalse((boolean)column.getUnique());
        this.assertSourceContains("@JoinColumns(@JoinColumn(unique = false))", cu);
        column.setUnique(null);
        this.assertSourceDoesNotContain("@JoinColumn(", cu);
    }

    public void testGetNullable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithBooleanElement("nullable");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinColumnAnnotation column = this.joinColumnAt((JavaResourceMember)resourceField, 0);
        JoinColumnsTests.assertTrue((boolean)column.getNullable());
    }

    public void testSetNullable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinColumnAnnotation column = this.joinColumnAt((JavaResourceMember)resourceField, 0);
        JoinColumnsTests.assertNotNull((Object)column);
        JoinColumnsTests.assertNull((Object)column.getNullable());
        column.setNullable(Boolean.FALSE);
        JoinColumnsTests.assertFalse((boolean)column.getNullable());
        this.assertSourceContains("@JoinColumns(@JoinColumn(nullable = false))", cu);
        column.setNullable(null);
        this.assertSourceDoesNotContain("@JoinColumn(", cu);
    }

    public void testGetInsertable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithBooleanElement("insertable");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinColumnAnnotation column = this.joinColumnAt((JavaResourceMember)resourceField, 0);
        JoinColumnsTests.assertTrue((boolean)column.getInsertable());
    }

    public void testSetInsertable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinColumnAnnotation column = this.joinColumnAt((JavaResourceMember)resourceField, 0);
        JoinColumnsTests.assertNotNull((Object)column);
        JoinColumnsTests.assertNull((Object)column.getInsertable());
        column.setInsertable(Boolean.FALSE);
        JoinColumnsTests.assertFalse((boolean)column.getInsertable());
        this.assertSourceContains("@JoinColumns(@JoinColumn(insertable = false))", cu);
        column.setInsertable(null);
        this.assertSourceDoesNotContain("@JoinColumn(", cu);
    }

    public void testGetUpdatable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumnWithBooleanElement("updatable");
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinColumnAnnotation column = this.joinColumnAt((JavaResourceMember)resourceField, 0);
        JoinColumnsTests.assertTrue((boolean)column.getUpdatable());
    }

    public void testSetUpdatable() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumns();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        JoinColumnAnnotation column = this.joinColumnAt((JavaResourceMember)resourceField, 0);
        JoinColumnsTests.assertNotNull((Object)column);
        JoinColumnsTests.assertNull((Object)column.getUpdatable());
        column.setUpdatable(Boolean.FALSE);
        JoinColumnsTests.assertFalse((boolean)column.getUpdatable());
        this.assertSourceContains("@JoinColumns(@JoinColumn(updatable = false))", cu);
        column.setUpdatable(null);
        this.assertSourceDoesNotContain("@JoinColumn(", cu);
    }

    public void testAddJoinColumnCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        String expected1 = "@JoinColumns({";
        String expected2 = "@JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"),";
        String expected3 = "@JoinColumn(name = \"FOO\") })";
        JoinColumnAnnotation joinColumn = (JoinColumnAnnotation)resourceField.addAnnotation(1, "javax.persistence.JoinColumn");
        joinColumn.setName("FOO");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        JoinColumnsTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        JoinColumnsTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        JoinColumnsTests.assertEquals((int)2, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
    }

    public void testAddJoinColumnToBeginningOfList() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        String expected1 = "@JoinColumns({";
        String expected2 = "@JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"),";
        String expected3 = "@JoinColumn(name = \"FOO\") })";
        JoinColumnAnnotation joinColumn = (JoinColumnAnnotation)resourceField.addAnnotation(1, "javax.persistence.JoinColumn");
        joinColumn.setName("FOO");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        expected2 = "@JoinColumn(name = \"BAZ\"),";
        expected3 = "@JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"), @JoinColumn(name = \"FOO\") })";
        joinColumn = (JoinColumnAnnotation)resourceField.addAnnotation(0, "javax.persistence.JoinColumn");
        joinColumn.setName("BAZ");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        ListIterator joinColumns = resourceField.getAnnotations("javax.persistence.JoinColumn").iterator();
        JoinColumnsTests.assertEquals((String)"BAZ", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        JoinColumnsTests.assertEquals((String)"BAR", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        JoinColumnsTests.assertEquals((String)"FOO", (String)((JoinColumnAnnotation)joinColumns.next()).getName());
        JoinColumnsTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        JoinColumnsTests.assertNotNull((Object)resourceField.getAnnotation(0, "javax.persistence.JoinColumn"));
        JoinColumnsTests.assertEquals((int)3, (int)resourceField.getAnnotationsSize("javax.persistence.JoinColumn"));
    }

    public void testRemoveJoinColumnCopyExisting() throws Exception {
        ICompilationUnit cu = this.createTestJoinColumn();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        String expected1 = "@JoinColumns({";
        String expected2 = "@JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\"),";
        String expected3 = "@JoinColumn(name = \"FOO\") })";
        JoinColumnAnnotation joinColumn = (JoinColumnAnnotation)resourceField.addAnnotation(1, "javax.persistence.JoinColumn");
        joinColumn.setName("FOO");
        this.assertSourceContains(expected1, cu);
        this.assertSourceContains(expected2, cu);
        this.assertSourceContains(expected3, cu);
        expected1 = "@JoinColumn(name = \"BAR\", referencedColumnName = \"REF_NAME\", unique = false, nullable = false, insertable = false, updatable = false, columnDefinition = \"COLUMN_DEF\", table = \"TABLE\")";
        resourceField.removeAnnotation(1, "javax.persistence.JoinColumn");
        this.assertSourceContains(expected1, cu);
        this.assertSourceDoesNotContain("@JoinColumns", cu);
    }
}

