/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jpt.jaxb.core.tests.internal.JaxbTestCase;
import org.eclipse.jpt.jaxb.core.xsd.XsdSchema;
import org.eclipse.xsd.XSDSchema;

public class SchemaLibraryTests
extends JaxbTestCase {
    public SchemaLibraryTests(String name) {
        super(name);
    }

    public void testUnsetNamespace() {
        String namespace = "http://www.w3.org/2001/XInclude";
        XsdSchema schema = this.getJaxbProject().getSchemaLibrary().getSchema(namespace);
        SchemaLibraryTests.assertNotNull((Object)schema);
        schema = this.getJaxbProject().getSchemaLibrary().getSchema(namespace);
        SchemaLibraryTests.assertNotNull((Object)schema);
        ((XSDSchema)schema.getXSDComponent()).eResource().unload();
        schema = this.getJaxbProject().getSchemaLibrary().getSchema(namespace);
        SchemaLibraryTests.assertNotNull((Object)schema);
    }

    public void testSetRegisteredUriUnregisteredNamespace() {
        String namespace = "http://java.sun.com/xml/ns/persistence/orm";
        Vector<String> schemaLocations = new Vector<String>();
        schemaLocations.add("http://java.sun.com/xml/ns/persistence/orm_2_0.xsd");
        this.getJaxbProject().getSchemaLibrary().setSchemaLocations(schemaLocations);
        XsdSchema schema = this.getJaxbProject().getSchemaLibrary().getSchema(namespace);
        SchemaLibraryTests.assertNotNull((Object)schema);
        schema = this.getJaxbProject().getSchemaLibrary().getSchema(namespace);
        SchemaLibraryTests.assertNotNull((Object)schema);
        ((XSDSchema)schema.getXSDComponent()).eResource().unload();
        schema = this.getJaxbProject().getSchemaLibrary().getSchema(namespace);
        SchemaLibraryTests.assertNotNull((Object)schema);
    }

    public void testSetRegisteredUriRegisteredNamespace() {
        String namespace = "http://www.eclipse.org/eclipselink/xsds/persistence/orm";
        Vector<String> schemaLocations = new Vector<String>();
        schemaLocations.add("http://www.eclipse.org/eclipselink/xsds/eclipselink_orm_1_0.xsd");
        this.getJaxbProject().getSchemaLibrary().setSchemaLocations(schemaLocations);
        XsdSchema schema = this.getJaxbProject().getSchemaLibrary().getSchema(namespace);
        SchemaLibraryTests.assertNotNull((Object)schema);
        schema = this.getJaxbProject().getSchemaLibrary().getSchema(namespace);
        SchemaLibraryTests.assertNotNull((Object)schema);
        ((XSDSchema)schema.getXSDComponent()).eResource().unload();
        schema = this.getJaxbProject().getSchemaLibrary().getSchema(namespace);
        SchemaLibraryTests.assertNotNull((Object)schema);
    }

    public void testSetUnregisterdUri() throws Exception {
        IFile schemaFile = this.getJaxbProject().getProject().getFile((IPath)new Path("customer.xsd"));
        String contents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\" targetNamespace=\"http://www.example.org/customer-example\"></xs:schema>";
        schemaFile.create((InputStream)new ByteArrayInputStream(contents.getBytes()), true, null);
        String namespace = "http://www.example.org/customer-example";
        Vector<String> schemaLocations = new Vector<String>();
        schemaLocations.add("platform:/resource/JaxbTestProject/customer.xsd");
        this.getJaxbProject().getSchemaLibrary().setSchemaLocations(schemaLocations);
        XsdSchema schema = this.getJaxbProject().getSchemaLibrary().getSchema(namespace);
        SchemaLibraryTests.assertNotNull((Object)schema);
        schema = this.getJaxbProject().getSchemaLibrary().getSchema(namespace);
        SchemaLibraryTests.assertNotNull((Object)schema);
        ((XSDSchema)schema.getXSDComponent()).eResource().unload();
        schema = this.getJaxbProject().getSchemaLibrary().getSchema(namespace);
        SchemaLibraryTests.assertNotNull((Object)schema);
    }
}

