/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.resource.java;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jaxb.core.resource.java.XmlSchemaTypeAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.java.JaxbJavaResourceModelTestCase;

public class XmlSchemaTypeAttributeAnnotationTests
extends JaxbJavaResourceModelTestCase {
    private static final String TEST_NAME = "foo";
    private static final String TEST_NAME_2 = "bar";
    private static final String TEST_NAMESPACE = "http://www.eclipse.org/test/schema";
    private static final String TEST_NAMESPACE_2 = "http://www.eclipse.org/test/schema2";
    private static final String TEST_CLASS = GregorianCalendar.class.getSimpleName();
    private static final String TEST_CLASS_2 = Date.class.getSimpleName();
    private static final String FQ_TEST_CLASS = GregorianCalendar.class.getName();
    private static final String FQ_TEST_CLASS_2 = Date.class.getName();

    public XmlSchemaTypeAttributeAnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestXmlAttributeWithSchemaTypeAndName() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlSchemaType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlSchemaType(name = \"foo\")");
            }
        });
    }

    private ICompilationUnit createTestXmlAttributeWithSchemaTypeAndNamespace() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlSchemaType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlSchemaType(namespace = \"http://www.eclipse.org/test/schema\")");
            }
        });
    }

    private ICompilationUnit createTestXmlAttributeWithSchemaTypeAndType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlSchemaType", FQ_TEST_CLASS, FQ_TEST_CLASS_2});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlSchemaType(type = " + TEST_CLASS + ".class)");
            }
        });
    }

    public void testName() throws Exception {
        ICompilationUnit cu = this.createTestXmlAttributeWithSchemaTypeAndName();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlSchemaTypeAnnotation annotation = (XmlSchemaTypeAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        XmlSchemaTypeAttributeAnnotationTests.assertTrue((annotation != null ? 1 : 0) != 0);
        XmlSchemaTypeAttributeAnnotationTests.assertEquals((String)TEST_NAME, (String)annotation.getName());
        this.assertSourceContains("@XmlSchemaType(name = \"foo\")", cu);
        annotation.setName(TEST_NAME_2);
        XmlSchemaTypeAttributeAnnotationTests.assertEquals((String)TEST_NAME_2, (String)annotation.getName());
        this.assertSourceContains("@XmlSchemaType(name = \"bar\")", cu);
        annotation.setName(null);
        XmlSchemaTypeAttributeAnnotationTests.assertEquals(null, (String)annotation.getName());
        this.assertSourceContains("@XmlSchemaType", cu);
        annotation.setName(TEST_NAME);
        XmlSchemaTypeAttributeAnnotationTests.assertEquals((String)TEST_NAME, (String)annotation.getName());
        this.assertSourceContains("@XmlSchemaType(name = \"foo\")", cu);
    }

    public void testNamespace() throws Exception {
        ICompilationUnit cu = this.createTestXmlAttributeWithSchemaTypeAndNamespace();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlSchemaTypeAnnotation annotation = (XmlSchemaTypeAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        XmlSchemaTypeAttributeAnnotationTests.assertTrue((annotation != null ? 1 : 0) != 0);
        XmlSchemaTypeAttributeAnnotationTests.assertEquals((String)TEST_NAMESPACE, (String)annotation.getNamespace());
        this.assertSourceContains("@XmlSchemaType(namespace = \"http://www.eclipse.org/test/schema\")", cu);
        annotation.setNamespace(TEST_NAMESPACE_2);
        XmlSchemaTypeAttributeAnnotationTests.assertEquals((String)TEST_NAMESPACE_2, (String)annotation.getNamespace());
        this.assertSourceContains("@XmlSchemaType(namespace = \"http://www.eclipse.org/test/schema2\")", cu);
        annotation.setNamespace(null);
        XmlSchemaTypeAttributeAnnotationTests.assertEquals(null, (String)annotation.getNamespace());
        this.assertSourceContains("@XmlSchemaType", cu);
        annotation.setNamespace(TEST_NAMESPACE);
        XmlSchemaTypeAttributeAnnotationTests.assertEquals((String)TEST_NAMESPACE, (String)annotation.getNamespace());
        this.assertSourceContains("@XmlSchemaType(namespace = \"http://www.eclipse.org/test/schema\")", cu);
    }

    public void testType() throws Exception {
        ICompilationUnit cu = this.createTestXmlAttributeWithSchemaTypeAndType();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceAttribute = this.getField(resourceType, 0);
        XmlSchemaTypeAnnotation annotation = (XmlSchemaTypeAnnotation)resourceAttribute.getAnnotation(0, "javax.xml.bind.annotation.XmlSchemaType");
        XmlSchemaTypeAttributeAnnotationTests.assertTrue((annotation != null ? 1 : 0) != 0);
        XmlSchemaTypeAttributeAnnotationTests.assertEquals((String)TEST_CLASS, (String)annotation.getType());
        XmlSchemaTypeAttributeAnnotationTests.assertEquals((String)FQ_TEST_CLASS, (String)annotation.getFullyQualifiedType());
        this.assertSourceContains("@XmlSchemaType(type = " + TEST_CLASS + ".class)", cu);
        annotation.setType(TEST_CLASS_2);
        XmlSchemaTypeAttributeAnnotationTests.assertEquals((String)TEST_CLASS_2, (String)annotation.getType());
        XmlSchemaTypeAttributeAnnotationTests.assertEquals((String)FQ_TEST_CLASS_2, (String)annotation.getFullyQualifiedType());
        this.assertSourceContains("@XmlSchemaType(type = " + TEST_CLASS_2 + ".class)", cu);
        annotation.setType(null);
        XmlSchemaTypeAttributeAnnotationTests.assertEquals(null, (String)annotation.getType());
        XmlSchemaTypeAttributeAnnotationTests.assertEquals(null, (String)annotation.getFullyQualifiedType());
        this.assertSourceContains("@XmlSchemaType", cu);
        annotation.setType(TEST_CLASS);
        XmlSchemaTypeAttributeAnnotationTests.assertEquals((String)TEST_CLASS, (String)annotation.getType());
        XmlSchemaTypeAttributeAnnotationTests.assertEquals((String)FQ_TEST_CLASS, (String)annotation.getFullyQualifiedType());
        this.assertSourceContains("@XmlSchemaType(type = " + TEST_CLASS + ".class)", cu);
    }
}

