/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.jpa.core.internal.operations.OrmFileCreationDataModelProvider;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;
import org.eclipse.jpt.jpa.eclipselink.core.EclipseLinkJpaProject;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.EclipseLinkOrmXmlDefinition1_2;
import org.eclipse.jpt.jpa.eclipselink.core.internal.operations.EclipseLinkOrmFileCreationDataModelProvider;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlEntityMappings;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;

public class EclipseLink1_2JpaProjectTests
extends ContextModelTestCase {
    public EclipseLink1_2JpaProjectTests(String name) {
        super(name);
    }

    protected String getJpaPlatformID() {
        return "eclipselink1_2";
    }

    protected EclipseLinkJpaProject getJpaProject() {
        return (EclipseLinkJpaProject)super.getJpaProject();
    }

    public void testGetDefaultOrmXmlResource() throws Exception {
        JptXmlResource resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLink1_2JpaProjectTests.assertNotNull((Object)resource);
        EclipseLink1_2JpaProjectTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.XmlEntityMappings.CONTENT_TYPE, (Object)resource.getContentType());
        EclipseLink1_2JpaProjectTests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLink1_2JpaProjectTests.assertNull((Object)resource);
        this.createDefaultOrmXmlFileWithEclipseLink1_2ContentType();
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLink1_2JpaProjectTests.assertNotNull((Object)resource);
        EclipseLink1_2JpaProjectTests.assertEquals((Object)EclipseLinkOrmXmlDefinition1_2.instance().getResourceType(), (Object)resource.getResourceType());
        EclipseLink1_2JpaProjectTests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLink1_2JpaProjectTests.assertNull((Object)resource);
        this.createDefaultOrmXmlFileWithEclipseLinkContentType();
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLink1_2JpaProjectTests.assertNotNull((Object)resource);
        EclipseLink1_2JpaProjectTests.assertEquals((Object)XmlEntityMappings.CONTENT_TYPE, (Object)resource.getContentType());
        EclipseLink1_2JpaProjectTests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLink1_2JpaProjectTests.assertNull((Object)resource);
        this.createDefaultOrmXmlFile();
        resource = this.getJpaProject().getDefaultOrmXmlResource();
        EclipseLink1_2JpaProjectTests.assertNotNull((Object)resource);
        EclipseLink1_2JpaProjectTests.assertEquals((Object)org.eclipse.jpt.jpa.core.resource.orm.XmlEntityMappings.CONTENT_TYPE, (Object)resource.getContentType());
        EclipseLink1_2JpaProjectTests.assertEquals((String)"src/META-INF/orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
    }

    public void testGetDefaultEclipseLinkOrmXmlResource() throws Exception {
        JptXmlResource resource = this.getJpaProject().getDefaultEclipseLinkOrmXmlResource();
        EclipseLink1_2JpaProjectTests.assertNull((Object)resource);
        this.createDefaultEclipseLink1_2OrmXmlFile();
        resource = this.getJpaProject().getDefaultEclipseLinkOrmXmlResource();
        EclipseLink1_2JpaProjectTests.assertNotNull((Object)resource);
        EclipseLink1_2JpaProjectTests.assertEquals((Object)EclipseLinkOrmXmlDefinition1_2.instance().getResourceType(), (Object)resource.getResourceType());
        EclipseLink1_2JpaProjectTests.assertEquals((String)"src/META-INF/eclipselink-orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getDefaultEclipseLinkOrmXmlResource();
        EclipseLink1_2JpaProjectTests.assertNull((Object)resource);
    }

    private void createDefaultOrmXmlFile() throws Exception {
        IDataModel config = DataModelFactory.createDataModel((IDataModelProvider)new OrmFileCreationDataModelProvider());
        config.setProperty("JptFileCreationDataModelProperties.CONTAINER_PATH", (Object)this.getJpaProject().getProject().getFolder("src/META-INF").getFullPath());
        config.getDefaultOperation().execute(null, null);
    }

    private void createDefaultOrmXmlFileWithEclipseLinkContentType() throws Exception {
        IDataModel config = DataModelFactory.createDataModel((IDataModelProvider)new EclipseLinkOrmFileCreationDataModelProvider());
        config.setProperty("JptFileCreationDataModelProperties.CONTAINER_PATH", (Object)this.getJpaProject().getProject().getFolder("src/META-INF").getFullPath());
        config.setProperty("JptFileCreationDataModelProperties.FILE_NAME", (Object)org.eclipse.jpt.jpa.core.resource.orm.XmlEntityMappings.DEFAULT_RUNTIME_PATH.lastSegment());
        config.getDefaultOperation().execute(null, null);
    }

    private void createDefaultOrmXmlFileWithEclipseLink1_2ContentType() throws Exception {
        this.createEclipseLink1_2OrmXmlFile(org.eclipse.jpt.jpa.core.resource.orm.XmlEntityMappings.DEFAULT_RUNTIME_PATH.lastSegment());
    }

    private void createDefaultEclipseLink1_2OrmXmlFile() throws Exception {
        this.createEclipseLink1_2OrmXmlFile(XmlEntityMappings.DEFAULT_RUNTIME_PATH.lastSegment());
    }

    private void createEclipseLink1_2OrmXmlFile(String fileName) throws Exception {
        IDataModel config = DataModelFactory.createDataModel((IDataModelProvider)new EclipseLinkOrmFileCreationDataModelProvider());
        config.setProperty("JptFileCreationDataModelProperties.CONTAINER_PATH", (Object)this.getJpaProject().getProject().getFolder("src/META-INF").getFullPath());
        config.setProperty("JptFileCreationDataModelProperties.FILE_NAME", (Object)fileName);
        config.setProperty("JpaFileCreationDataModelProperties.VERSION", (Object)"1.2");
        config.getDefaultOperation().execute(null, null);
    }

    public void testGetMappingFileResource() throws Exception {
        JptXmlResource resource = this.getJpaProject().getMappingFileXmlResource(XmlEntityMappings.DEFAULT_RUNTIME_PATH);
        EclipseLink1_2JpaProjectTests.assertNull((Object)resource);
        this.createDefaultEclipseLink1_2OrmXmlFile();
        resource = this.getJpaProject().getMappingFileXmlResource(XmlEntityMappings.DEFAULT_RUNTIME_PATH);
        EclipseLink1_2JpaProjectTests.assertNotNull((Object)resource);
        EclipseLink1_2JpaProjectTests.assertEquals((Object)EclipseLinkOrmXmlDefinition1_2.instance().getResourceType(), (Object)resource.getResourceType());
        EclipseLink1_2JpaProjectTests.assertEquals((String)"src/META-INF/eclipselink-orm.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getMappingFileXmlResource(XmlEntityMappings.DEFAULT_RUNTIME_PATH);
        EclipseLink1_2JpaProjectTests.assertNull((Object)resource);
    }

    public void testGetDifferentlyNamedMappingFileResource() throws Exception {
        JptXmlResource resource = this.getJpaProject().getMappingFileXmlResource((IPath)new Path("META-INF/orm2.xml"));
        EclipseLink1_2JpaProjectTests.assertNull((Object)resource);
        this.createEclipseLink1_2OrmXmlFile("orm2.xml");
        resource = this.getJpaProject().getMappingFileXmlResource((IPath)new Path("META-INF/orm2.xml"));
        EclipseLink1_2JpaProjectTests.assertNotNull((Object)resource);
        EclipseLink1_2JpaProjectTests.assertEquals((Object)EclipseLinkOrmXmlDefinition1_2.instance().getResourceType(), (Object)resource.getResourceType());
        EclipseLink1_2JpaProjectTests.assertEquals((String)"src/META-INF/orm2.xml", (String)resource.getFile().getProjectRelativePath().toString());
        resource.delete(null);
        resource = this.getJpaProject().getMappingFileXmlResource((IPath)new Path("META-INF/orm2.xml"));
        EclipseLink1_2JpaProjectTests.assertNull((Object)resource);
        this.createEclipseLink1_2OrmXmlFile("orm2.xml");
        resource = this.getJpaProject().getMappingFileXmlResource((IPath)new Path("META-INF/orm2.xml"));
        EclipseLink1_2JpaProjectTests.assertNotNull((Object)resource);
        EclipseLink1_2JpaProjectTests.assertEquals((Object)EclipseLinkOrmXmlDefinition1_2.instance().getResourceType(), (Object)resource.getResourceType());
        EclipseLink1_2JpaProjectTests.assertEquals((String)"src/META-INF/orm2.xml", (String)resource.getFile().getProjectRelativePath().toString());
    }
}

