/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkChangeTracking;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkChangeTrackingType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkCustomizer;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkEmbeddable;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ChangeTrackingAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ChangeTrackingType;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.CustomizerAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkJavaEmbeddableTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEmbeddableWithConvertAndCustomizerClass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Embeddable", "org.eclipse.persistence.annotations.Customizer"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Embeddable").append(CR);
                sb.append("    @Customizer(Foo.class");
            }
        });
    }

    private ICompilationUnit createTestEmbeddableWithChangeTracking() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Embeddable", "org.eclipse.persistence.annotations.ChangeTracking"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Embeddable").append(CR);
                sb.append("    @ChangeTracking").append(CR);
            }
        });
    }

    public EclipseLinkJavaEmbeddableTests(String name) {
        super(name);
    }

    public void testGetCustomizerClass() throws Exception {
        this.createTestEmbeddableWithConvertAndCustomizerClass();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkCustomizer customizer = ((EclipseLinkEmbeddable)this.getJavaPersistentType().getMapping()).getCustomizer();
        EclipseLinkJavaEmbeddableTests.assertEquals((String)"Foo", (String)customizer.getSpecifiedCustomizerClass());
    }

    public void testSetCustomizerClass() throws Exception {
        this.createTestEmbeddableWithConvertAndCustomizerClass();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkCustomizer customizer = ((EclipseLinkEmbeddable)this.getJavaPersistentType().getMapping()).getCustomizer();
        EclipseLinkJavaEmbeddableTests.assertEquals((String)"Foo", (String)customizer.getSpecifiedCustomizerClass());
        customizer.setSpecifiedCustomizerClass("Bar");
        EclipseLinkJavaEmbeddableTests.assertEquals((String)"Bar", (String)customizer.getSpecifiedCustomizerClass());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        CustomizerAnnotation customizerAnnotation = (CustomizerAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLinkJavaEmbeddableTests.assertEquals((String)"Bar", (String)customizerAnnotation.getValue());
        customizer.setSpecifiedCustomizerClass(null);
        EclipseLinkJavaEmbeddableTests.assertEquals(null, (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation = (CustomizerAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLinkJavaEmbeddableTests.assertEquals(null, (Object)customizerAnnotation);
        customizer.setSpecifiedCustomizerClass("Bar");
        EclipseLinkJavaEmbeddableTests.assertEquals((String)"Bar", (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation = (CustomizerAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Customizer");
        EclipseLinkJavaEmbeddableTests.assertEquals((String)"Bar", (String)customizerAnnotation.getValue());
    }

    public void testGetCustomizerClassUpdatesFromResourceModelChange() throws Exception {
        this.createTestEmbeddableWithConvertAndCustomizerClass();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkEmbeddable embeddable = (EclipseLinkEmbeddable)this.getJavaPersistentType().getMapping();
        EclipseLinkCustomizer customizer = embeddable.getCustomizer();
        EclipseLinkJavaEmbeddableTests.assertEquals((String)"Foo", (String)customizer.getSpecifiedCustomizerClass());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        CustomizerAnnotation customizerAnnotation = (CustomizerAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.Customizer");
        customizerAnnotation.setValue("Bar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaEmbeddableTests.assertEquals((String)"Bar", (String)customizer.getSpecifiedCustomizerClass());
        resourceType.removeAnnotation("org.eclipse.persistence.annotations.Customizer");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaEmbeddableTests.assertEquals(null, (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation = (CustomizerAnnotation)resourceType.addAnnotation("org.eclipse.persistence.annotations.Customizer");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaEmbeddableTests.assertEquals(null, (String)customizer.getSpecifiedCustomizerClass());
        customizerAnnotation.setValue("FooBar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaEmbeddableTests.assertEquals((String)"FooBar", (String)customizer.getSpecifiedCustomizerClass());
    }

    public void testGetChangeTracking() throws Exception {
        this.createTestEmbeddableWithChangeTracking();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkEmbeddable embeddable = (EclipseLinkEmbeddable)this.getJavaPersistentType().getMapping();
        EclipseLinkChangeTracking contextChangeTracking = embeddable.getChangeTracking();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ChangeTrackingAnnotation resourceChangeTracking = (ChangeTrackingAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        EclipseLinkJavaEmbeddableTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.ATTRIBUTE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)ChangeTrackingType.ATTRIBUTE, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.OBJECT);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)ChangeTrackingType.OBJECT, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.OBJECT, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.OBJECT, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.DEFERRED);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)ChangeTrackingType.DEFERRED, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.DEFERRED, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.DEFERRED, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(ChangeTrackingType.AUTO);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        resourceChangeTracking.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaEmbeddableTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        resourceType.removeAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaEmbeddableTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getType());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getDefaultType());
        EclipseLinkJavaEmbeddableTests.assertNull((Object)contextChangeTracking.getSpecifiedType());
    }

    public void testSetChangeTracking() throws Exception {
        this.createTestEmbeddableWithChangeTracking();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkEmbeddable embeddable = (EclipseLinkEmbeddable)this.getJavaPersistentType().getMapping();
        EclipseLinkChangeTracking contextChangeTracking = embeddable.getChangeTracking();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ChangeTrackingAnnotation resourceChangeTracking = (ChangeTrackingAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        EclipseLinkJavaEmbeddableTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(EclipseLinkChangeTrackingType.AUTO);
        EclipseLinkJavaEmbeddableTests.assertNull((Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(EclipseLinkChangeTrackingType.ATTRIBUTE);
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)ChangeTrackingType.ATTRIBUTE, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.ATTRIBUTE, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(EclipseLinkChangeTrackingType.OBJECT);
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)ChangeTrackingType.OBJECT, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.OBJECT, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(EclipseLinkChangeTrackingType.DEFERRED);
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)ChangeTrackingType.DEFERRED, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.DEFERRED, (Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(null);
        EclipseLinkJavaEmbeddableTests.assertNull((Object)resourceType.getAnnotation("org.eclipse.persistence.annotations.ChangeTracking"));
        EclipseLinkJavaEmbeddableTests.assertNull((Object)contextChangeTracking.getSpecifiedType());
        contextChangeTracking.setSpecifiedType(EclipseLinkChangeTrackingType.AUTO);
        resourceChangeTracking = (ChangeTrackingAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)ChangeTrackingType.AUTO, (Object)resourceChangeTracking.getValue());
        EclipseLinkJavaEmbeddableTests.assertEquals((Object)EclipseLinkChangeTrackingType.AUTO, (Object)contextChangeTracking.getSpecifiedType());
    }
}

