/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.EclipseLinkOrmBasicMapping;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.EclipseLinkOrmTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlBasic;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkOrmTypeConverterTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithBasicMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.TypeConverter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
                sb.append("    @Convert(name=\"foo\")").append(CR);
                sb.append("    @TypeConverter");
            }
        });
    }

    public EclipseLinkOrmTypeConverterTests(String name) {
        super(name);
    }

    public void testUpdateDataType() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        EclipseLinkOrmBasicMapping ormBasicMapping = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmTypeConverter ormConverter = ormBasicMapping.getConverterContainer().addTypeConverter("typeConverter", 0);
        XmlTypeConverter converterResource = (XmlTypeConverter)((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getTypeConverters().get(0);
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getDataType());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getDataType());
        converterResource.setDataType("myConvert");
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getDataType());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"myConvert", (String)converterResource.getDataType());
        converterResource.setDataType(null);
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getDataType());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getDataType());
    }

    public void testModifyDataType() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        EclipseLinkOrmBasicMapping ormBasicMapping = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmTypeConverter ormConverter = ormBasicMapping.getConverterContainer().addTypeConverter("typeConverter", 0);
        XmlTypeConverter converterResource = (XmlTypeConverter)((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getTypeConverters().get(0);
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getDataType());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getDataType());
        ormConverter.setDataType("foo");
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"foo", (String)ormConverter.getDataType());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"foo", (String)converterResource.getDataType());
        ormConverter.setDataType(null);
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getDataType());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getDataType());
    }

    public void testUpdateObjectType() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        EclipseLinkOrmBasicMapping ormBasicMapping = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmTypeConverter ormConverter = ormBasicMapping.getConverterContainer().addTypeConverter("typeConverter", 0);
        XmlTypeConverter converterResource = (XmlTypeConverter)((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getTypeConverters().get(0);
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getObjectType());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getObjectType());
        converterResource.setObjectType("myConvert");
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getObjectType());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"myConvert", (String)converterResource.getObjectType());
        converterResource.setObjectType(null);
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getObjectType());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getObjectType());
    }

    public void testModifyObjectType() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        EclipseLinkOrmBasicMapping ormBasicMapping = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmTypeConverter ormConverter = ormBasicMapping.getConverterContainer().addTypeConverter("typeConverter", 0);
        XmlTypeConverter converterResource = (XmlTypeConverter)((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getTypeConverters().get(0);
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getObjectType());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getObjectType());
        ormConverter.setObjectType("foo");
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"foo", (String)ormConverter.getObjectType());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"foo", (String)converterResource.getObjectType());
        ormConverter.setObjectType(null);
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getObjectType());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getObjectType());
    }

    public void testUpdateName() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        EclipseLinkOrmBasicMapping ormBasicMapping = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmTypeConverter ormConverter = ormBasicMapping.getConverterContainer().addTypeConverter("typeConverter", 0);
        XmlTypeConverter converterResource = (XmlTypeConverter)((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getTypeConverters().get(0);
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"typeConverter", (String)ormConverter.getName());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"typeConverter", (String)converterResource.getName());
        converterResource.setName("myConvert");
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getName());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"myConvert", (String)converterResource.getName());
        converterResource.setName(null);
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getName());
    }

    public void testModifyName() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        EclipseLinkOrmBasicMapping ormBasicMapping = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmTypeConverter ormConverter = ormBasicMapping.getConverterContainer().addTypeConverter("typeConverter", 0);
        XmlTypeConverter converterResource = (XmlTypeConverter)((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getTypeConverters().get(0);
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"typeConverter", (String)ormConverter.getName());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"typeConverter", (String)converterResource.getName());
        ormConverter.setName("foo");
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"foo", (String)ormConverter.getName());
        EclipseLinkOrmTypeConverterTests.assertEquals((String)"foo", (String)converterResource.getName());
        ormConverter.setName(null);
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmTypeConverterTests.assertEquals(null, (String)converterResource.getName());
    }
}

