/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence;

import org.eclipse.jpt.common.utility.model.event.ListAddEvent;
import org.eclipse.jpt.common.utility.model.event.ListChangeEvent;
import org.eclipse.jpt.common.utility.model.event.ListClearEvent;
import org.eclipse.jpt.common.utility.model.event.ListEvent;
import org.eclipse.jpt.common.utility.model.event.ListMoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListRemoveEvent;
import org.eclipse.jpt.common.utility.model.event.ListReplaceEvent;
import org.eclipse.jpt.common.utility.model.listener.ListChangeListener;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkCacheType;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkCaching;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkCachingEntity;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkFlushClearCache;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence.EclipseLinkPersistenceUnitTestCase;

public class CachingAdapterTests
extends EclipseLinkPersistenceUnitTestCase {
    private EclipseLinkCaching caching;
    private ListEvent entitiesEvent;
    public static final String ENTITY_TEST = "Employee";
    public static final String ENTITY_TEST_2 = "Address";
    public static final String CACHE_TYPE_DEFAULT_KEY = "eclipselink.cache.type.default";
    public static final EclipseLinkCacheType CACHE_TYPE_DEFAULT_TEST_VALUE = EclipseLinkCacheType.soft_weak;
    public static final EclipseLinkCacheType CACHE_TYPE_DEFAULT_TEST_VALUE_2 = EclipseLinkCacheType.full;
    public static final String CACHE_SIZE_DEFAULT_KEY = "eclipselink.cache.size.default";
    public static final Integer CACHE_SIZE_DEFAULT_TEST_VALUE = 12345;
    public static final Integer CACHE_SIZE_DEFAULT_TEST_VALUE_2 = 67890;
    public static final String SHARED_CACHE_DEFAULT_KEY = "eclipselink.cache.shared.default";
    public static final Boolean SHARED_CACHE_DEFAULT_TEST_VALUE = false;
    public static final Boolean SHARED_CACHE_DEFAULT_TEST_VALUE_2 = true;
    public static final String CACHE_TYPE_KEY = "eclipselink.cache.type.Employee";
    public static final EclipseLinkCacheType CACHE_TYPE_TEST_VALUE = EclipseLinkCacheType.soft_weak;
    public static final EclipseLinkCacheType CACHE_TYPE_TEST_VALUE_2 = EclipseLinkCacheType.full;
    public static final String SHARED_CACHE_KEY = "eclipselink.cache.shared.Employee";
    public static final Boolean SHARED_CACHE_TEST_VALUE = false;
    public static final Boolean SHARED_CACHE_TEST_VALUE_2 = true;
    public static final String CACHE_SIZE_KEY = "eclipselink.cache.size.Employee";
    public static final Integer CACHE_SIZE_TEST_VALUE = 12345;
    public static final Integer CACHE_SIZE_TEST_VALUE_2 = 67890;
    public static final String FLUSH_CLEAR_CACHE_KEY = "eclipselink.flush-clear.cache";
    public static final EclipseLinkFlushClearCache FLUSH_CLEAR_CACHE_TEST_VALUE = EclipseLinkFlushClearCache.drop;
    public static final EclipseLinkFlushClearCache FLUSH_CLEAR_CACHE_TEST_VALUE_2 = EclipseLinkFlushClearCache.merge;

    public CachingAdapterTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.caching = this.getPersistenceUnit().getCaching();
        PropertyChangeListener propertyChangeListener = this.buildPropertyChangeListener();
        this.caching.addPropertyChangeListener("cacheTypeDefault", propertyChangeListener);
        this.caching.addPropertyChangeListener("cacheSizeDefault", propertyChangeListener);
        this.caching.addPropertyChangeListener("sharedCacheDefault", propertyChangeListener);
        this.caching.addPropertyChangeListener("cacheType", propertyChangeListener);
        this.caching.addPropertyChangeListener("cacheSize", propertyChangeListener);
        this.caching.addPropertyChangeListener("sharedCache", propertyChangeListener);
        this.caching.addPropertyChangeListener("flushClearCache", propertyChangeListener);
        ListChangeListener entitiesChangeListener = this.buildEntitiesChangeListener();
        this.caching.addListChangeListener("entities", entitiesChangeListener);
        this.clearEvent();
    }

    protected void populatePu() {
        this.modelPropertiesSizeOriginal = 7;
        this.propertiesTotal = this.modelPropertiesSizeOriginal + 4;
        this.modelPropertiesSize = this.modelPropertiesSizeOriginal;
        this.persistenceUnitSetProperty("misc.property.1", "value.1");
        this.persistenceUnitSetProperty(CACHE_TYPE_DEFAULT_KEY, CACHE_TYPE_DEFAULT_TEST_VALUE);
        this.persistenceUnitSetProperty("misc.property.2", "value.2");
        this.persistenceUnitSetProperty(CACHE_SIZE_DEFAULT_KEY, CACHE_SIZE_DEFAULT_TEST_VALUE);
        this.persistenceUnitSetProperty(SHARED_CACHE_DEFAULT_KEY, SHARED_CACHE_DEFAULT_TEST_VALUE);
        this.persistenceUnitSetProperty("misc.property.3", "value.3");
        this.persistenceUnitSetProperty("misc.property.4", "value.4");
        this.persistenceUnitSetProperty(CACHE_SIZE_KEY, CACHE_SIZE_TEST_VALUE);
        this.persistenceUnitSetProperty(CACHE_TYPE_KEY, CACHE_TYPE_TEST_VALUE);
        this.persistenceUnitSetProperty(SHARED_CACHE_KEY, SHARED_CACHE_TEST_VALUE);
        this.persistenceUnitSetProperty(FLUSH_CLEAR_CACHE_KEY, FLUSH_CLEAR_CACHE_TEST_VALUE);
    }

    private ListChangeListener buildEntitiesChangeListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListAddEvent e) {
                CachingAdapterTests.this.entityAdded(e);
            }

            public void itemsRemoved(ListRemoveEvent e) {
                CachingAdapterTests.this.entityRemoved(e);
            }

            public void itemsReplaced(ListReplaceEvent e) {
                CachingAdapterTests.this.throwUnsupportedOperationException((ListEvent)e);
            }

            public void itemsMoved(ListMoveEvent e) {
                CachingAdapterTests.this.throwUnsupportedOperationException((ListEvent)e);
            }

            public void listCleared(ListClearEvent e) {
                CachingAdapterTests.this.throwUnsupportedOperationException((ListEvent)e);
            }

            public void listChanged(ListChangeEvent e) {
                CachingAdapterTests.this.throwUnsupportedOperationException((ListEvent)e);
            }
        };
    }

    protected void clearEvent() {
        super.clearEvent();
        this.entitiesEvent = null;
    }

    void entityAdded(ListAddEvent e) {
        this.entitiesEvent = e;
    }

    void entityRemoved(ListRemoveEvent e) {
        this.entitiesEvent = e;
    }

    public void testEntitiesList() throws Exception {
        this.clearEvent();
        int originalNumberOfEntities = this.caching.getEntitiesSize();
        this.caching.addEntity(ENTITY_TEST_2);
        CachingAdapterTests.assertEquals((String)"Entity not added", (int)this.caching.getEntitiesSize(), (int)(originalNumberOfEntities + 1));
        CachingAdapterTests.assertNotNull((String)"No Event Fired.", (Object)this.entitiesEvent);
        CachingAdapterTests.assertEquals((String)"Wrong Event.", (String)this.entitiesEvent.getListName(), (String)"entities");
        this.clearEvent();
        this.caching.removeEntity(ENTITY_TEST_2);
        CachingAdapterTests.assertEquals((String)"Entity not removed", (int)this.caching.getEntitiesSize(), (int)originalNumberOfEntities);
        CachingAdapterTests.assertNotNull((String)"No Event Fired.", (Object)this.entitiesEvent);
        CachingAdapterTests.assertEquals((String)"Wrong Event.", (String)this.entitiesEvent.getListName(), (String)"entities");
    }

    public void testSetCacheTypeDefault() throws Exception {
        this.verifyModelInitialized(CACHE_TYPE_DEFAULT_KEY, CACHE_TYPE_DEFAULT_TEST_VALUE);
        this.verifySetProperty(CACHE_TYPE_DEFAULT_KEY, CACHE_TYPE_DEFAULT_TEST_VALUE, CACHE_TYPE_DEFAULT_TEST_VALUE_2);
    }

    public void testAddRemoveCacheTypeDefault() throws Exception {
        this.verifyAddRemoveProperty(CACHE_TYPE_DEFAULT_KEY, CACHE_TYPE_DEFAULT_TEST_VALUE, CACHE_TYPE_DEFAULT_TEST_VALUE_2);
    }

    public void testSetCacheSizeDefault() throws Exception {
        this.verifyModelInitialized(CACHE_SIZE_DEFAULT_KEY, CACHE_SIZE_DEFAULT_TEST_VALUE);
        this.verifySetProperty(CACHE_SIZE_DEFAULT_KEY, CACHE_SIZE_DEFAULT_TEST_VALUE, CACHE_SIZE_DEFAULT_TEST_VALUE_2);
    }

    public void testAddRemoveCacheSizeDefault() throws Exception {
        this.verifyAddRemoveProperty(CACHE_SIZE_DEFAULT_KEY, CACHE_SIZE_DEFAULT_TEST_VALUE, CACHE_SIZE_DEFAULT_TEST_VALUE_2);
    }

    public void testSetSharedCacheDefault() throws Exception {
        this.verifyModelInitialized(SHARED_CACHE_DEFAULT_KEY, SHARED_CACHE_DEFAULT_TEST_VALUE);
        this.verifySetProperty(SHARED_CACHE_DEFAULT_KEY, SHARED_CACHE_DEFAULT_TEST_VALUE, SHARED_CACHE_DEFAULT_TEST_VALUE_2);
    }

    public void testAddRemoveSharedCacheDefault() throws Exception {
        this.verifyAddRemoveProperty(SHARED_CACHE_DEFAULT_KEY, SHARED_CACHE_DEFAULT_TEST_VALUE, SHARED_CACHE_DEFAULT_TEST_VALUE_2);
    }

    public void testSetCacheType() throws Exception {
        this.verifyModelInitialized(CACHE_TYPE_KEY, CACHE_TYPE_TEST_VALUE);
        this.verifySetCachingProperty("cacheType", CACHE_TYPE_KEY, CACHE_TYPE_TEST_VALUE, CACHE_TYPE_TEST_VALUE_2);
    }

    public void testAddRemoveCacheType() throws Exception {
        this.verifyAddRemoveCachingProperty("cacheType", CACHE_TYPE_KEY, CACHE_TYPE_TEST_VALUE, CACHE_TYPE_TEST_VALUE_2);
    }

    public void testSetCacheSize() throws Exception {
        this.verifyModelInitialized(CACHE_SIZE_KEY, CACHE_SIZE_TEST_VALUE);
        this.verifySetCachingProperty("cacheSize", CACHE_SIZE_KEY, CACHE_SIZE_TEST_VALUE, CACHE_SIZE_TEST_VALUE_2);
    }

    public void testAddRemoveCacheSize() throws Exception {
        this.verifyAddRemoveCachingProperty("cacheSize", CACHE_SIZE_KEY, CACHE_SIZE_TEST_VALUE, CACHE_SIZE_TEST_VALUE_2);
    }

    public void testSetSharedCache() throws Exception {
        this.verifyModelInitialized(SHARED_CACHE_KEY, SHARED_CACHE_TEST_VALUE);
        this.verifySetCachingProperty("sharedCache", SHARED_CACHE_KEY, SHARED_CACHE_TEST_VALUE, SHARED_CACHE_TEST_VALUE_2);
    }

    public void testAddRemoveSharedCache() throws Exception {
        this.verifyAddRemoveCachingProperty("sharedCache", SHARED_CACHE_KEY, SHARED_CACHE_TEST_VALUE, SHARED_CACHE_TEST_VALUE_2);
    }

    public void testSetFlushClearCache() throws Exception {
        this.verifyModelInitialized(FLUSH_CLEAR_CACHE_KEY, FLUSH_CLEAR_CACHE_TEST_VALUE);
        this.verifySetProperty(FLUSH_CLEAR_CACHE_KEY, FLUSH_CLEAR_CACHE_TEST_VALUE, FLUSH_CLEAR_CACHE_TEST_VALUE_2);
    }

    public void testAddRemoveFlushClearCache() throws Exception {
        this.verifyAddRemoveProperty(FLUSH_CLEAR_CACHE_KEY, FLUSH_CLEAR_CACHE_TEST_VALUE, FLUSH_CLEAR_CACHE_TEST_VALUE_2);
    }

    protected PersistenceUnitProperties getModel() {
        return this.caching;
    }

    protected void verifySetCachingProperty(String propertyName, String key, Object testValue1, Object testValue2) throws Exception {
        this.persistenceUnitSetProperty(key, testValue2);
        this.verifyPutCachingProperty(propertyName, ENTITY_TEST, testValue2);
        this.clearEvent();
        this.setCachingProperty(propertyName, ENTITY_TEST, testValue1);
        this.verifyPutCachingProperty(propertyName, ENTITY_TEST, testValue1);
    }

    protected void verifyAddRemoveCachingProperty(String propertyName, String key, Object testValue1, Object testValue2) throws Exception {
        this.clearEvent();
        --this.propertiesTotal;
        --this.modelPropertiesSize;
        this.getPersistenceUnit().removeProperty(key);
        CachingAdapterTests.assertNull((Object)this.getPersistenceUnit().getProperty(key));
        CachingAdapterTests.assertEquals((int)this.modelPropertiesSize, (int)(this.modelPropertiesSizeOriginal - 1));
        this.verifyPutCachingProperty(propertyName, ENTITY_TEST, null);
        ++this.propertiesTotal;
        ++this.modelPropertiesSize;
        this.persistenceUnitSetProperty(key, testValue1);
        this.verifyPutCachingProperty(propertyName, ENTITY_TEST, testValue1);
        this.persistenceUnitSetProperty(key, null);
        this.verifyPutCachingProperty(propertyName, ENTITY_TEST, null);
        this.persistenceUnitSetProperty(key, testValue2);
        this.verifyPutCachingProperty(propertyName, ENTITY_TEST, testValue2);
    }

    protected void verifyPutCachingProperty(String propertyName, String entityName, Object expectedValue) throws Exception {
        this.verifyEvent(propertyName);
        this.verifyCachingEvent(propertyName, entityName, expectedValue);
    }

    protected void verifyCachingEvent(String propertyName, String entityName, Object expectedValue) throws Exception {
        EclipseLinkCachingEntity entity = (EclipseLinkCachingEntity)this.propertyChangedEvent.getNewValue();
        if (propertyName.equals("cacheType")) {
            CachingAdapterTests.assertEquals((Object)expectedValue, (Object)entity.getParent().getCacheTypeOf(entityName));
            CachingAdapterTests.assertEquals((Object)expectedValue, (Object)this.caching.getCacheTypeOf(entityName));
        } else if (propertyName.equals("cacheSize")) {
            CachingAdapterTests.assertEquals((Object)expectedValue, (Object)entity.getParent().getCacheSizeOf(entityName));
            CachingAdapterTests.assertEquals((Object)expectedValue, (Object)this.caching.getCacheSizeOf(entityName));
        } else if (propertyName.equals("sharedCache")) {
            CachingAdapterTests.assertEquals((Object)expectedValue, (Object)entity.getParent().getSharedCacheOf(entityName));
            CachingAdapterTests.assertEquals((Object)expectedValue, (Object)this.caching.getSharedCacheOf(entityName));
        } else {
            this.throwMissingDefinition("verifyCachingEvent", propertyName);
        }
    }

    protected void setProperty(String propertyName, Object newValue) throws Exception {
        if (propertyName.equals("cacheTypeDefault")) {
            this.caching.setCacheTypeDefault((EclipseLinkCacheType)newValue);
        } else if (propertyName.equals("cacheSizeDefault")) {
            this.caching.setCacheSizeDefault((Integer)newValue);
        } else if (propertyName.equals("sharedCacheDefault")) {
            this.caching.setSharedCacheDefault((Boolean)newValue);
        } else if (propertyName.equals("flushClearCache")) {
            this.caching.setFlushClearCache((EclipseLinkFlushClearCache)newValue);
        } else {
            this.throwMissingDefinition("setProperty", propertyName);
        }
    }

    protected void setCachingProperty(String propertyName, String entityName, Object newValue) throws NoSuchFieldException {
        if (propertyName.equals("cacheType")) {
            this.caching.setCacheTypeOf(entityName, (EclipseLinkCacheType)newValue);
        } else if (propertyName.equals("cacheSize")) {
            this.caching.setCacheSizeOf(entityName, (Integer)newValue);
        } else if (propertyName.equals("sharedCache")) {
            this.caching.setSharedCacheOf(entityName, (Boolean)newValue);
        } else {
            this.throwMissingDefinition("setCachingProperty", propertyName);
        }
    }

    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        Object modelValue = null;
        if (propertyName.equals("cacheTypeDefault")) {
            modelValue = this.caching.getCacheTypeDefault();
        } else if (propertyName.equals("cacheSizeDefault")) {
            modelValue = this.caching.getCacheSizeDefault();
        } else if (propertyName.equals("sharedCacheDefault")) {
            modelValue = this.caching.getSharedCacheDefault();
        } else if (propertyName.equals("cacheSize")) {
            modelValue = this.caching.getCacheSizeOf(ENTITY_TEST);
        } else if (propertyName.equals("cacheType")) {
            modelValue = this.caching.getCacheTypeOf(ENTITY_TEST);
        } else if (propertyName.equals("sharedCache")) {
            modelValue = this.caching.getSharedCacheOf(ENTITY_TEST);
        } else if (propertyName.equals("flushClearCache")) {
            modelValue = this.caching.getFlushClearCache();
        } else {
            this.throwMissingDefinition("getProperty", propertyName);
        }
        return modelValue;
    }
}

