/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence;

import org.eclipse.jpt.common.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.common.utility.model.event.PropertyChangeEvent;
import org.eclipse.jpt.common.utility.model.listener.PropertyChangeListener;
import org.eclipse.jpt.common.utility.model.value.ModifiablePropertyValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnitProperties;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkDdlGenerationType;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkOutputMode;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkSchemaGeneration;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.persistence.EclipseLinkPersistenceUnitTestCase;

public class SchemaGenerationValueModelTests
extends EclipseLinkPersistenceUnitTestCase {
    private EclipseLinkSchemaGeneration schemaGen;
    private PropertyValueModel<EclipseLinkSchemaGeneration> schemaGenHolder;
    private ModifiablePropertyValueModel<EclipseLinkDdlGenerationType> ddlGenerationTypeHolder;
    private PropertyChangeEvent ddlGenerationTypeEvent;
    private ModifiablePropertyValueModel<EclipseLinkOutputMode> outputModeHolder;
    private PropertyChangeEvent outputModeEvent;
    public static final EclipseLinkDdlGenerationType DDL_GENERATION_TYPE_TEST_VALUE = EclipseLinkDdlGenerationType.drop_and_create_tables;
    public static final EclipseLinkOutputMode OUTPUT_MODE_TEST_VALUE = EclipseLinkOutputMode.sql_script;

    public SchemaGenerationValueModelTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.schemaGen = this.subject.getEclipseLinkSchemaGeneration();
        this.schemaGenHolder = new SimplePropertyValueModel((Object)this.schemaGen);
        this.ddlGenerationTypeHolder = this.buildDdlGenerationTypeAA(this.schemaGenHolder);
        PropertyChangeListener ddlGenerationTypeListener = this.buildDdlGenerationTypeChangeListener();
        this.ddlGenerationTypeHolder.addPropertyChangeListener("value", ddlGenerationTypeListener);
        this.ddlGenerationTypeEvent = null;
        this.outputModeHolder = this.buildOutputModeAA(this.schemaGenHolder);
        PropertyChangeListener outputModeListener = this.buildOutputModeChangeListener();
        this.outputModeHolder.addPropertyChangeListener("value", outputModeListener);
        this.outputModeEvent = null;
    }

    protected void populatePu() {
        this.persistenceUnitSetProperty("eclipselink.ddl-generation", DDL_GENERATION_TYPE_TEST_VALUE);
        this.persistenceUnitSetProperty("eclipselink.ddl-generation.output-mode", OUTPUT_MODE_TEST_VALUE);
    }

    protected PersistenceUnitProperties getModel() {
        return this.schemaGen;
    }

    private ModifiablePropertyValueModel<EclipseLinkDdlGenerationType> buildDdlGenerationTypeAA(PropertyValueModel<EclipseLinkSchemaGeneration> subjectHolder) {
        return new PropertyAspectAdapter<EclipseLinkSchemaGeneration, EclipseLinkDdlGenerationType>(subjectHolder, new String[]{"ddlGenerationType"}){

            protected EclipseLinkDdlGenerationType buildValue_() {
                return ((EclipseLinkSchemaGeneration)this.subject).getDdlGenerationType();
            }

            protected void setValue_(EclipseLinkDdlGenerationType enumValue) {
                ((EclipseLinkSchemaGeneration)this.subject).setDdlGenerationType(enumValue);
            }
        };
    }

    private PropertyChangeListener buildDdlGenerationTypeChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                SchemaGenerationValueModelTests.this.ddlGenerationTypeEvent = e;
            }
        };
    }

    private ModifiablePropertyValueModel<EclipseLinkOutputMode> buildOutputModeAA(PropertyValueModel<EclipseLinkSchemaGeneration> subjectHolder) {
        return new PropertyAspectAdapter<EclipseLinkSchemaGeneration, EclipseLinkOutputMode>(subjectHolder, new String[]{"outputMode"}){

            protected EclipseLinkOutputMode buildValue_() {
                return ((EclipseLinkSchemaGeneration)this.subject).getOutputMode();
            }

            protected void setValue_(EclipseLinkOutputMode enumValue) {
                ((EclipseLinkSchemaGeneration)this.subject).setOutputMode(enumValue);
            }
        };
    }

    private PropertyChangeListener buildOutputModeChangeListener() {
        return new PropertyChangeListener(){

            public void propertyChanged(PropertyChangeEvent e) {
                SchemaGenerationValueModelTests.this.outputModeEvent = e;
            }
        };
    }

    public void testValue() {
        this.verifyDdlGenerationTypeAAValue(DDL_GENERATION_TYPE_TEST_VALUE);
        SchemaGenerationValueModelTests.assertEquals((Object)EclipseLinkSchemaGeneration.DEFAULT_SCHEMA_GENERATION_DDL_GENERATION_TYPE, (Object)this.schemaGen.getDefaultDdlGenerationType());
        this.verifyOutputModeAAValue(OUTPUT_MODE_TEST_VALUE);
        SchemaGenerationValueModelTests.assertEquals((Object)EclipseLinkSchemaGeneration.DEFAULT_SCHEMA_GENERATION_OUTPUT_MODE, (Object)this.schemaGen.getDefaultOutputMode());
    }

    public void testSetValue() throws Exception {
        this.ddlGenerationTypeEvent = null;
        this.verifyHasListeners((PropertyValueModel)this.ddlGenerationTypeHolder, "value");
        EclipseLinkDdlGenerationType newDdlGenerationType = EclipseLinkDdlGenerationType.create_tables;
        this.subject.setProperty("eclipselink.ddl-generation", this.getPropertyStringValueOf(newDdlGenerationType), false);
        this.verifyDdlGenerationTypeAAValue(newDdlGenerationType);
        SchemaGenerationValueModelTests.assertNotNull((Object)this.ddlGenerationTypeEvent);
        this.outputModeEvent = null;
        this.verifyHasListeners((PropertyValueModel)this.outputModeHolder, "value");
        EclipseLinkOutputMode newOutputMode = EclipseLinkOutputMode.database;
        this.outputModeHolder.setValue((Object)newOutputMode);
        this.verifyOutputModeAAValue(newOutputMode);
        SchemaGenerationValueModelTests.assertNotNull((Object)this.outputModeEvent);
    }

    public void testSetNullValue() {
        this.ddlGenerationTypeEvent = null;
        this.subject.setProperty("eclipselink.ddl-generation", null, false);
        this.ddlGenerationTypeHolder.setValue(null);
        this.verifyDdlGenerationTypeAAValue(null);
        SchemaGenerationValueModelTests.assertNotNull((Object)this.ddlGenerationTypeEvent);
        PersistenceUnit.Property property = this.getPersistenceUnit().getProperty("eclipselink.ddl-generation");
        SchemaGenerationValueModelTests.assertNull((Object)property);
        this.outputModeEvent = null;
        this.outputModeHolder.setValue(null);
        this.verifyOutputModeAAValue(null);
        SchemaGenerationValueModelTests.assertNotNull((Object)this.outputModeEvent);
        property = this.getPersistenceUnit().getProperty("eclipselink.ddl-generation.output-mode");
        SchemaGenerationValueModelTests.assertNull((Object)property);
    }

    protected void verifyDdlGenerationTypeAAValue(EclipseLinkDdlGenerationType testValue) {
        this.verifyAAValue((Enum)testValue, (Enum)this.schemaGen.getDdlGenerationType(), (PropertyValueModel)this.ddlGenerationTypeHolder, "eclipselink.ddl-generation");
    }

    protected void verifyOutputModeAAValue(EclipseLinkOutputMode testValue) {
        this.verifyAAValue((Enum)testValue, (Enum)this.schemaGen.getOutputMode(), (PropertyValueModel)this.outputModeHolder, "eclipselink.ddl-generation.output-mode");
    }

    protected void setProperty(String propertyName, Object newValue) throws Exception {
        throw new UnsupportedOperationException();
    }

    protected Object getProperty(String propertyName) throws NoSuchFieldException {
        throw new UnsupportedOperationException();
    }
}

