/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.MappingKeys;
import org.eclipse.jpt.jpa.core.context.SpecifiedPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPrimaryKeyJoinColumn;
import org.eclipse.jpt.jpa.core.resource.java.PrimaryKeyJoinColumnAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class JavaPrimaryKeyJoinColumnTests
extends ContextModelTestCase {
    private static final String PRIMARY_KEY_JOIN_COLUMN_NAME = "MY_PRIMARY_KEY_JOIN_COLUMN";
    private static final String COLUMN_DEFINITION = "MY_COLUMN_DEFINITION";

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestSubEntity() throws Exception {
        return this.createTestType("test", "AnnotationTestTypeChild.java", "AnnotationTestTypeChild", (AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendExtendsImplementsTo(StringBuilder sb) {
                sb.append("extends AnnotationTestType ");
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    private ICompilationUnit createTestEntityWithPrimaryKeyJoinColumn() throws Exception {
        return this.createTestType("test", "AnnotationTestTypeChild.java", "AnnotationTestTypeChild", (AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id", "javax.persistence.PrimaryKeyJoinColumn"});
            }

            public void appendExtendsImplementsTo(StringBuilder sb) {
                sb.append("extends AnnotationTestType ");
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@PrimaryKeyJoinColumn(name=\"MY_PRIMARY_KEY_JOIN_COLUMN\")");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Id");
            }
        });
    }

    public JavaPrimaryKeyJoinColumnTests(String name) {
        super(name);
    }

    public void testGetSpecifiedName() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        SpecifiedPrimaryKeyJoinColumn specifiedPkJoinColumn = (SpecifiedPrimaryKeyJoinColumn)this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator().next();
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)PRIMARY_KEY_JOIN_COLUMN_NAME, (String)specifiedPkJoinColumn.getSpecifiedName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestTypeChild", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        PrimaryKeyJoinColumnAnnotation pkJoinColumnResource = (PrimaryKeyJoinColumnAnnotation)resourceType.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        pkJoinColumnResource.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedPkJoinColumn = (SpecifiedPrimaryKeyJoinColumn)this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator().next();
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)specifiedPkJoinColumn.getName());
    }

    public void testGetDefaultNameNoSpecifiedPrimaryKeyJoinColumns() throws Exception {
        this.createTestEntity();
        this.createTestSubEntity();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedPrimaryKeyJoinColumn pkJoinColumn = this.getJavaEntity().getDefaultPrimaryKeyJoinColumn();
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)"id", (String)pkJoinColumn.getDefaultName());
    }

    public void testGetDefaultName() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)this.getJavaEntity().getDefaultPrimaryKeyJoinColumn());
        SpecifiedPrimaryKeyJoinColumn specifiedPkJoinColumn = (SpecifiedPrimaryKeyJoinColumn)this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator().next();
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)"id", (String)specifiedPkJoinColumn.getDefaultName());
        JavaSpecifiedPersistentAttribute idAttribute = this.getJavaPersistentType().getAttributeNamed("id");
        idAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)specifiedPkJoinColumn.getDefaultName());
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        SpecifiedPrimaryKeyJoinColumn specifiedPkJoinColumn = (SpecifiedPrimaryKeyJoinColumn)this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator().next();
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)PRIMARY_KEY_JOIN_COLUMN_NAME, (String)specifiedPkJoinColumn.getName());
    }

    public void testSetSpecifiedName() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        SpecifiedPrimaryKeyJoinColumn specifiedPkJoinColumn = (SpecifiedPrimaryKeyJoinColumn)this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator().next();
        specifiedPkJoinColumn.setSpecifiedName("foo");
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)"foo", (String)specifiedPkJoinColumn.getSpecifiedName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestTypeChild", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        PrimaryKeyJoinColumnAnnotation columnAnnotation = (PrimaryKeyJoinColumnAnnotation)resourceType.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)"foo", (String)columnAnnotation.getName());
        specifiedPkJoinColumn.setSpecifiedName(null);
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)specifiedPkJoinColumn.getSpecifiedName());
        columnAnnotation = (PrimaryKeyJoinColumnAnnotation)resourceType.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)columnAnnotation.getName());
    }

    public void testGetColumnDefinition() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        SpecifiedPrimaryKeyJoinColumn specifiedPkJoinColumn = (SpecifiedPrimaryKeyJoinColumn)this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator().next();
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)specifiedPkJoinColumn.getColumnDefinition());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestTypeChild", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)resourceType.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        column.setColumnDefinition(COLUMN_DEFINITION);
        this.getJpaProject().synchronizeContextModel();
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)COLUMN_DEFINITION, (String)specifiedPkJoinColumn.getColumnDefinition());
        column.setColumnDefinition(null);
        this.getJpaProject().synchronizeContextModel();
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)specifiedPkJoinColumn.getColumnDefinition());
        resourceType.removeAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        this.getJpaProject().synchronizeContextModel();
        JavaPrimaryKeyJoinColumnTests.assertEquals((int)0, (int)this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumnsSize());
    }

    public void testSetColumnDefinition() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        SpecifiedPrimaryKeyJoinColumn specifiedPkJoinColumn = (SpecifiedPrimaryKeyJoinColumn)this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator().next();
        specifiedPkJoinColumn.setColumnDefinition("foo");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestTypeChild", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        PrimaryKeyJoinColumnAnnotation column = (PrimaryKeyJoinColumnAnnotation)resourceType.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)"foo", (String)column.getColumnDefinition());
        specifiedPkJoinColumn.setColumnDefinition(null);
        column = (PrimaryKeyJoinColumnAnnotation)resourceType.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)column.getColumnDefinition());
    }

    public void testGetSpecifiedReferencedColumnName() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        SpecifiedPrimaryKeyJoinColumn specifiedPkJoinColumn = (SpecifiedPrimaryKeyJoinColumn)this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator().next();
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)specifiedPkJoinColumn.getSpecifiedReferencedColumnName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestTypeChild", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        PrimaryKeyJoinColumnAnnotation pkJoinColumnResource = (PrimaryKeyJoinColumnAnnotation)resourceType.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        pkJoinColumnResource.setReferencedColumnName("FOO");
        this.getJpaProject().synchronizeContextModel();
        specifiedPkJoinColumn = (SpecifiedPrimaryKeyJoinColumn)this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator().next();
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)specifiedPkJoinColumn.getSpecifiedReferencedColumnName());
    }

    public void testGetDefaultReferencedColumnNameNoSpecifiedPrimaryKeyJoinColumns() throws Exception {
        this.createTestEntity();
        this.createTestSubEntity();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedPrimaryKeyJoinColumn pkJoinColumn = this.getJavaEntity().getDefaultPrimaryKeyJoinColumn();
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)"id", (String)pkJoinColumn.getDefaultReferencedColumnName());
    }

    public void testGetDefaultReferencedColumnName() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)this.getJavaEntity().getDefaultPrimaryKeyJoinColumn());
        SpecifiedPrimaryKeyJoinColumn specifiedPkJoinColumn = (SpecifiedPrimaryKeyJoinColumn)this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator().next();
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)"id", (String)specifiedPkJoinColumn.getDefaultReferencedColumnName());
        JavaSpecifiedPersistentAttribute idAttribute = this.getJavaPersistentType().getAttributeNamed("id");
        idAttribute.setMappingKey(MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY);
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)specifiedPkJoinColumn.getDefaultReferencedColumnName());
    }

    public void testGetReferencedColumnName() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestTypeChild", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        PrimaryKeyJoinColumnAnnotation pkJoinColumnResource = (PrimaryKeyJoinColumnAnnotation)resourceType.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        pkJoinColumnResource.setReferencedColumnName("FOO");
        this.getJpaProject().synchronizeContextModel();
        SpecifiedPrimaryKeyJoinColumn specifiedPkJoinColumn = (SpecifiedPrimaryKeyJoinColumn)this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator().next();
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)"FOO", (String)specifiedPkJoinColumn.getReferencedColumnName());
    }

    public void testSetSpecifiedReferencedColumnName() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        SpecifiedPrimaryKeyJoinColumn specifiedPkJoinColumn = (SpecifiedPrimaryKeyJoinColumn)this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator().next();
        specifiedPkJoinColumn.setSpecifiedReferencedColumnName("foo");
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)"foo", (String)specifiedPkJoinColumn.getSpecifiedReferencedColumnName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestTypeChild", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        PrimaryKeyJoinColumnAnnotation columnAnnotation = (PrimaryKeyJoinColumnAnnotation)resourceType.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        JavaPrimaryKeyJoinColumnTests.assertEquals((String)"foo", (String)columnAnnotation.getReferencedColumnName());
        specifiedPkJoinColumn.setSpecifiedName(null);
        specifiedPkJoinColumn.setSpecifiedReferencedColumnName(null);
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)specifiedPkJoinColumn.getSpecifiedReferencedColumnName());
        columnAnnotation = (PrimaryKeyJoinColumnAnnotation)resourceType.getAnnotation(0, "javax.persistence.PrimaryKeyJoinColumn");
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)columnAnnotation.getReferencedColumnName());
    }

    public void testIsVirtual() throws Exception {
        this.createTestEntity();
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPrimaryKeyJoinColumn specifiedPkJoinColumn = (SpecifiedPrimaryKeyJoinColumn)this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator().next();
        JavaPrimaryKeyJoinColumnTests.assertFalse((boolean)specifiedPkJoinColumn.isVirtual());
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)this.getJavaEntity().getDefaultPrimaryKeyJoinColumn());
        this.getJavaEntity().removeSpecifiedPrimaryKeyJoinColumn(0);
        JavaPrimaryKeyJoinColumnTests.assertTrue((boolean)this.getJavaEntity().getDefaultPrimaryKeyJoinColumn().isVirtual());
    }

    public void testIsReferencedColumnResolved() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        SpecifiedPrimaryKeyJoinColumn specifiedPkJoinColumn = (SpecifiedPrimaryKeyJoinColumn)this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator().next();
        JavaPrimaryKeyJoinColumnTests.assertFalse((boolean)((Boolean)ObjectTools.execute((Object)specifiedPkJoinColumn, (String)"referencedColumnIsResolved")));
    }

    public void testDbColumn() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        SpecifiedPrimaryKeyJoinColumn specifiedPkJoinColumn = (SpecifiedPrimaryKeyJoinColumn)this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator().next();
        JavaPrimaryKeyJoinColumnTests.assertFalse((boolean)specifiedPkJoinColumn.isResolved());
    }

    public void testDbReferencedColumn() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        SpecifiedPrimaryKeyJoinColumn specifiedPkJoinColumn = (SpecifiedPrimaryKeyJoinColumn)this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator().next();
        JavaPrimaryKeyJoinColumnTests.assertFalse((boolean)((Boolean)ObjectTools.execute((Object)specifiedPkJoinColumn, (String)"referencedColumnIsResolved")));
    }

    public void testDbTable() throws Exception {
        this.createTestEntityWithPrimaryKeyJoinColumn();
        this.addXmlClassRef("test.AnnotationTestTypeChild");
        SpecifiedPrimaryKeyJoinColumn specifiedPkJoinColumn = (SpecifiedPrimaryKeyJoinColumn)this.getJavaEntity().getSpecifiedPrimaryKeyJoinColumns().iterator().next();
        JavaPrimaryKeyJoinColumnTests.assertNull((Object)specifiedPkJoinColumn.getDbTable());
    }
}

