/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.projects.JavaProjectTestHarness;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.IdMapping;
import org.eclipse.jpt.jpa.core.context.ManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedJoinTable;
import org.eclipse.jpt.jpa.core.context.SpecifiedUniqueConstraint;
import org.eclipse.jpt.jpa.core.context.java.JavaEntity;
import org.eclipse.jpt.jpa.core.context.java.JavaManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedJoinTable;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmEntity;
import org.eclipse.jpt.jpa.core.context.orm.OrmManyToManyMapping;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedJoinColumn;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedJoinTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedUniqueConstraint;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinColumn;
import org.eclipse.jpt.jpa.core.resource.orm.XmlJoinTable;
import org.eclipse.jpt.jpa.core.resource.orm.XmlManyToMany;
import org.eclipse.jpt.jpa.core.resource.orm.XmlUniqueConstraint;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlMappingFileRef;
import org.eclipse.jpt.jpa.core.tests.internal.context.ContextModelTestCase;

public class OrmJoinTableTests
extends ContextModelTestCase {
    public OrmJoinTableTests(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        XmlMappingFileRef mappingFileRef = PersistenceFactory.eINSTANCE.createXmlMappingFileRef();
        mappingFileRef.setFileName("META-INF/orm.xml");
        this.getXmlPersistenceUnit().getMappingFiles().add((Object)mappingFileRef);
        this.getPersistenceXmlResource().save(null);
    }

    private ICompilationUnit createTestEntityWithValidManyToMany() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.ManyToMany", "javax.persistence.Id", "java.util.Collection"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@ManyToMany").append(CR);
                sb.append("    private Collection<Project> projects;").append(CR);
            }
        });
    }

    private void createTargetEntity() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class Project {").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int proj_id;").append(CR);
                sb.append(CR);
                sb.append("}");
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "Project.java", sourceWriter);
    }

    private void createTargetEntityWithBackPointer() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Id");
                sb.append(";");
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.ManyToMany");
                sb.append(";");
                sb.append(CR);
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class Project {").append(CR);
                sb.append(CR);
                sb.append("    @Id").append(CR);
                sb.append("    private int proj_id;").append(CR);
                sb.append("    @ManyToMany(mappedBy=\"projects\"").append(CR);
                sb.append("    private java.util.Collection<AnnotationTestType> employees;").append(CR);
                sb.append(CR);
                sb.append("}");
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "Project.java", sourceWriter);
    }

    public void testUpdateSpecifiedName() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmSpecifiedJoinTable ormJoinTable = ormManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedName());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
        manyToMany.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        manyToMany.getJoinTable().setName("FOO");
        OrmJoinTableTests.assertEquals((String)"FOO", (String)ormJoinTable.getSpecifiedName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)manyToMany.getJoinTable().getName());
        manyToMany.getJoinTable().setName(null);
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedName());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable().getName());
        manyToMany.getJoinTable().setName("FOO");
        OrmJoinTableTests.assertEquals((String)"FOO", (String)ormJoinTable.getSpecifiedName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)manyToMany.getJoinTable().getName());
        manyToMany.setJoinTable(null);
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedName());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
    }

    public void testModifySpecifiedName() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmSpecifiedJoinTable ormJoinTable = ormManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedName());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
        ormJoinTable.setSpecifiedName("foo");
        OrmJoinTableTests.assertEquals((String)"foo", (String)ormJoinTable.getSpecifiedName());
        OrmJoinTableTests.assertEquals((String)"foo", (String)manyToMany.getJoinTable().getName());
        ormJoinTable.setSpecifiedName(null);
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedName());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
    }

    public void testVirtualJoinTable() throws Exception {
        this.createTestEntityWithValidManyToMany();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmPersistentAttribute ormPersistentAttribute = ormPersistentType.getAttributeNamed("projects");
        ManyToManyMapping virtualManyToManyMapping = (ManyToManyMapping)ormPersistentAttribute.getMapping();
        SpecifiedJoinTable virtualJoinTable = virtualManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        OrmJoinTableTests.assertTrue((boolean)ormPersistentAttribute.isVirtual());
        OrmJoinTableTests.assertEquals(null, (String)virtualJoinTable.getSpecifiedName());
        this.createTargetEntity();
        this.getEntityMappings().addPersistentType("entity", "test.Project");
        OrmJoinTableTests.assertEquals((String)"AnnotationTestType_Project", (String)virtualJoinTable.getName());
        OrmJoinTableTests.assertNull((Object)virtualJoinTable.getSpecifiedCatalog());
        OrmJoinTableTests.assertNull((Object)virtualJoinTable.getSpecifiedSchema());
        OrmJoinTableTests.assertEquals((int)0, (int)virtualJoinTable.getSpecifiedJoinColumnsSize());
        OrmJoinTableTests.assertEquals((int)0, (int)virtualJoinTable.getSpecifiedInverseJoinColumnsSize());
        SpecifiedJoinColumn ormJoinColumn = virtualJoinTable.getDefaultJoinColumn();
        SpecifiedJoinColumn inverseOrmJoinColumn = virtualJoinTable.getDefaultInverseJoinColumn();
        JavaSpecifiedPersistentAttribute javaPersistentAttribute = ormPersistentAttribute.getJavaPersistentAttribute();
        JavaManyToManyMapping javaManyToManyMapping = (JavaManyToManyMapping)javaPersistentAttribute.getMapping();
        JavaSpecifiedJoinTable javaJoinTable = javaManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        javaJoinTable.setSpecifiedName("FOO");
        javaJoinTable.setSpecifiedCatalog("CATALOG");
        javaJoinTable.setSpecifiedSchema("SCHEMA");
        JavaSpecifiedJoinColumn javaJoinColumn = javaJoinTable.addSpecifiedJoinColumn(0);
        javaJoinColumn.setSpecifiedName("NAME");
        javaJoinColumn.setSpecifiedReferencedColumnName("REFERENCED_NAME");
        JavaSpecifiedJoinColumn inverseJavaJoinColumn = javaJoinTable.addSpecifiedInverseJoinColumn(0);
        inverseJavaJoinColumn.setSpecifiedName("INVERSE_NAME");
        inverseJavaJoinColumn.setSpecifiedReferencedColumnName("INVERSE_REFERENCED_NAME");
        OrmJoinTableTests.assertEquals((String)"FOO", (String)virtualJoinTable.getSpecifiedName());
        OrmJoinTableTests.assertEquals((String)"CATALOG", (String)virtualJoinTable.getSpecifiedCatalog());
        OrmJoinTableTests.assertEquals((String)"SCHEMA", (String)virtualJoinTable.getSpecifiedSchema());
        OrmJoinTableTests.assertEquals((int)1, (int)virtualJoinTable.getSpecifiedJoinColumnsSize());
        OrmJoinTableTests.assertEquals((int)1, (int)virtualJoinTable.getSpecifiedInverseJoinColumnsSize());
        ormJoinColumn = (SpecifiedJoinColumn)virtualJoinTable.getSpecifiedJoinColumns().iterator().next();
        OrmJoinTableTests.assertEquals((String)"NAME", (String)ormJoinColumn.getSpecifiedName());
        OrmJoinTableTests.assertEquals((String)"REFERENCED_NAME", (String)ormJoinColumn.getSpecifiedReferencedColumnName());
        inverseOrmJoinColumn = (SpecifiedJoinColumn)virtualJoinTable.getSpecifiedInverseJoinColumns().iterator().next();
        OrmJoinTableTests.assertEquals((String)"INVERSE_NAME", (String)inverseOrmJoinColumn.getSpecifiedName());
        OrmJoinTableTests.assertEquals((String)"INVERSE_REFERENCED_NAME", (String)inverseOrmJoinColumn.getSpecifiedReferencedColumnName());
    }

    public void testUpdateDefaultNameFromJavaTable() throws Exception {
        this.createTestEntityWithValidManyToMany();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("projects"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        OrmSpecifiedJoinTable ormJoinTable = ormManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        OrmJoinTableTests.assertEquals(null, (String)ormJoinTable.getDefaultName());
        this.createTargetEntity();
        OrmPersistentType targetPersistentType = this.getEntityMappings().addPersistentType("entity", "test.Project");
        OrmJoinTableTests.assertEquals((String)"AnnotationTestType_Project", (String)ormJoinTable.getDefaultName());
        ((JavaEntity)targetPersistentType.getJavaPersistentType().getMapping()).getTable().setSpecifiedName("FOO");
        OrmJoinTableTests.assertEquals((String)"AnnotationTestType_FOO", (String)ormJoinTable.getDefaultName());
        ((JavaEntity)ormPersistentType.getJavaPersistentType().getMapping()).getTable().setSpecifiedName("BAR");
        OrmJoinTableTests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getDefaultName());
        ormPersistentType.getJavaPersistentType().getAttributeNamed("projects").setMappingKey("manyToMany");
        JavaManyToManyMapping javaManyMapping = (JavaManyToManyMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("projects").getMapping();
        javaManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName("JAVA_JOIN_TABLE");
        OrmJoinTableTests.assertEquals((String)"BAR_FOO", (String)ormJoinTable.getDefaultName());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(true);
        OrmJoinTableTests.assertEquals((String)"AnnotationTestType_Project", (String)ormJoinTable.getDefaultName());
        this.getEntityMappings().getPersistenceUnitMetadata().setXmlMappingMetadataComplete(false);
        ormPersistentAttribute.removeFromXml();
        OrmPersistentAttribute ormPersistentAttribute2 = ormPersistentType.getAttributeNamed("projects");
        ManyToManyMapping virtualManyToManyMapping = (ManyToManyMapping)ormPersistentAttribute2.getMapping();
        SpecifiedJoinTable virtualJoinTable = virtualManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        OrmJoinTableTests.assertTrue((boolean)ormPersistentAttribute2.isVirtual());
        OrmJoinTableTests.assertEquals((String)"JAVA_JOIN_TABLE", (String)virtualJoinTable.getSpecifiedName());
        javaManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().setSpecifiedName(null);
        javaManyMapping.getRelationship().setStrategyToJoinTable();
        OrmJoinTableTests.assertNull((Object)virtualJoinTable.getSpecifiedName());
        OrmJoinTableTests.assertEquals((String)"BAR_FOO", (String)virtualJoinTable.getDefaultName());
        ((OrmEntity)ormPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TABLE_NAME");
        OrmJoinTableTests.assertEquals((String)"ORM_TABLE_NAME_FOO", (String)virtualJoinTable.getDefaultName());
        ((OrmEntity)targetPersistentType.getMapping()).getTable().setSpecifiedName("ORM_TARGET");
        OrmJoinTableTests.assertEquals((String)"ORM_TABLE_NAME_ORM_TARGET", (String)virtualJoinTable.getDefaultName());
    }

    public void testUpdateSpecifiedSchema() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmSpecifiedJoinTable ormJoinTable = ormManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedSchema());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
        manyToMany.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        manyToMany.getJoinTable().setSchema("FOO");
        OrmJoinTableTests.assertEquals((String)"FOO", (String)ormJoinTable.getSpecifiedSchema());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)manyToMany.getJoinTable().getSchema());
        manyToMany.getJoinTable().setSchema(null);
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedSchema());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable().getSchema());
        manyToMany.getJoinTable().setSchema("FOO");
        OrmJoinTableTests.assertEquals((String)"FOO", (String)ormJoinTable.getSpecifiedSchema());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)manyToMany.getJoinTable().getSchema());
        manyToMany.setJoinTable(null);
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedSchema());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
    }

    public void testModifySpecifiedSchema() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmSpecifiedJoinTable ormJoinTable = ormManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedSchema());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
        ormJoinTable.setSpecifiedSchema("foo");
        OrmJoinTableTests.assertEquals((String)"foo", (String)ormJoinTable.getSpecifiedSchema());
        OrmJoinTableTests.assertEquals((String)"foo", (String)manyToMany.getJoinTable().getSchema());
        ormJoinTable.setSpecifiedSchema(null);
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedSchema());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
    }

    public void testUpdateSpecifiedCatalog() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmSpecifiedJoinTable ormJoinTable = ormManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedCatalog());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
        manyToMany.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        manyToMany.getJoinTable().setCatalog("FOO");
        OrmJoinTableTests.assertEquals((String)"FOO", (String)ormJoinTable.getSpecifiedCatalog());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)manyToMany.getJoinTable().getCatalog());
        manyToMany.getJoinTable().setCatalog(null);
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedCatalog());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable().getCatalog());
        manyToMany.getJoinTable().setCatalog("FOO");
        OrmJoinTableTests.assertEquals((String)"FOO", (String)ormJoinTable.getSpecifiedCatalog());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)manyToMany.getJoinTable().getCatalog());
        manyToMany.setJoinTable(null);
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedCatalog());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
    }

    public void testModifySpecifiedCatalog() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmSpecifiedJoinTable ormJoinTable = ormManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedCatalog());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
        ormJoinTable.setSpecifiedCatalog("foo");
        OrmJoinTableTests.assertEquals((String)"foo", (String)ormJoinTable.getSpecifiedCatalog());
        OrmJoinTableTests.assertEquals((String)"foo", (String)manyToMany.getJoinTable().getCatalog());
        ormJoinTable.setSpecifiedCatalog(null);
        OrmJoinTableTests.assertNull((Object)ormJoinTable.getSpecifiedCatalog());
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
    }

    public void testAddSpecifiedJoinColumn() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmSpecifiedJoinTable ormJoinTable = ormManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        OrmSpecifiedJoinColumn joinColumn = ormJoinTable.addSpecifiedJoinColumn(0);
        joinColumn.setSpecifiedName("FOO");
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(0)).getName());
        OrmSpecifiedJoinColumn joinColumn2 = ormJoinTable.addSpecifiedJoinColumn(0);
        joinColumn2.setSpecifiedName("BAR");
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(0)).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(1)).getName());
        OrmSpecifiedJoinColumn joinColumn3 = ormJoinTable.addSpecifiedJoinColumn(1);
        joinColumn3.setSpecifiedName("BAZ");
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(0)).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(1)).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(2)).getName());
        ListIterator joinColumns = ormJoinTable.getSpecifiedJoinColumns().iterator();
        OrmJoinTableTests.assertEquals((Object)joinColumn2, joinColumns.next());
        OrmJoinTableTests.assertEquals((Object)joinColumn3, joinColumns.next());
        OrmJoinTableTests.assertEquals((Object)joinColumn, joinColumns.next());
        joinColumns = ormJoinTable.getSpecifiedJoinColumns().iterator();
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
    }

    public void testRemoveSpecifiedJoinColumn() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmSpecifiedJoinTable ormJoinTable = ormManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        ormJoinTable.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        ormJoinTable.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        ormJoinTable.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        OrmJoinTableTests.assertEquals((int)3, (int)joinTableResource.getJoinColumns().size());
        ormJoinTable.removeSpecifiedJoinColumn(0);
        OrmJoinTableTests.assertEquals((int)2, (int)joinTableResource.getJoinColumns().size());
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(0)).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(1)).getName());
        ormJoinTable.removeSpecifiedJoinColumn(0);
        OrmJoinTableTests.assertEquals((int)1, (int)joinTableResource.getJoinColumns().size());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(0)).getName());
        ormJoinTable.removeSpecifiedJoinColumn(0);
        OrmJoinTableTests.assertEquals((int)0, (int)joinTableResource.getJoinColumns().size());
    }

    public void testMoveSpecifiedJoinColumn() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmSpecifiedJoinTable ormJoinTable = ormManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        ormJoinTable.addSpecifiedJoinColumn(0).setSpecifiedName("FOO");
        ormJoinTable.addSpecifiedJoinColumn(1).setSpecifiedName("BAR");
        ormJoinTable.addSpecifiedJoinColumn(2).setSpecifiedName("BAZ");
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        OrmJoinTableTests.assertEquals((int)3, (int)joinTableResource.getJoinColumns().size());
        ormJoinTable.moveSpecifiedJoinColumn(2, 0);
        ListIterator joinColumns = ormJoinTable.getSpecifiedJoinColumns().iterator();
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(0)).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(1)).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(2)).getName());
        ormJoinTable.moveSpecifiedJoinColumn(0, 1);
        joinColumns = ormJoinTable.getSpecifiedJoinColumns().iterator();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(0)).getName());
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(1)).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)joinTableResource.getJoinColumns().get(2)).getName());
    }

    public void testUpdateInverseJoinColumns() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmSpecifiedJoinTable ormJoinTable = ormManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        manyToMany.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        joinTableResource.getInverseJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        joinTableResource.getInverseJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        joinTableResource.getInverseJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        ((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(0)).setName("FOO");
        ((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(1)).setName("BAR");
        ((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(2)).setName("BAZ");
        ListIterator joinColumns = ormJoinTable.getSpecifiedInverseJoinColumns().iterator();
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.getInverseJoinColumns().move(2, 0);
        joinColumns = ormJoinTable.getSpecifiedInverseJoinColumns().iterator();
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.getInverseJoinColumns().move(0, 1);
        joinColumns = ormJoinTable.getSpecifiedInverseJoinColumns().iterator();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.getInverseJoinColumns().remove(1);
        joinColumns = ormJoinTable.getSpecifiedInverseJoinColumns().iterator();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.getInverseJoinColumns().remove(1);
        joinColumns = ormJoinTable.getSpecifiedInverseJoinColumns().iterator();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.getInverseJoinColumns().remove(0);
        OrmJoinTableTests.assertFalse((boolean)ormJoinTable.getSpecifiedInverseJoinColumns().iterator().hasNext());
    }

    public void testAddSpecifiedInverseJoinColumn() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmSpecifiedJoinTable ormJoinTable = ormManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        OrmSpecifiedJoinColumn joinColumn = ormJoinTable.addSpecifiedInverseJoinColumn(0);
        joinColumn.setSpecifiedName("FOO");
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(0)).getName());
        OrmSpecifiedJoinColumn joinColumn2 = ormJoinTable.addSpecifiedInverseJoinColumn(0);
        joinColumn2.setSpecifiedName("BAR");
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(0)).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(1)).getName());
        OrmSpecifiedJoinColumn joinColumn3 = ormJoinTable.addSpecifiedInverseJoinColumn(1);
        joinColumn3.setSpecifiedName("BAZ");
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(0)).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(1)).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(2)).getName());
        ListIterator joinColumns = ormJoinTable.getSpecifiedInverseJoinColumns().iterator();
        OrmJoinTableTests.assertEquals((Object)joinColumn2, joinColumns.next());
        OrmJoinTableTests.assertEquals((Object)joinColumn3, joinColumns.next());
        OrmJoinTableTests.assertEquals((Object)joinColumn, joinColumns.next());
        joinColumns = ormJoinTable.getSpecifiedInverseJoinColumns().iterator();
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
    }

    public void testRemoveSpecifiedInverseJoinColumn() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmSpecifiedJoinTable ormJoinTable = ormManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        ormJoinTable.addSpecifiedInverseJoinColumn(0).setSpecifiedName("FOO");
        ormJoinTable.addSpecifiedInverseJoinColumn(1).setSpecifiedName("BAR");
        ormJoinTable.addSpecifiedInverseJoinColumn(2).setSpecifiedName("BAZ");
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        OrmJoinTableTests.assertEquals((int)3, (int)joinTableResource.getInverseJoinColumns().size());
        ormJoinTable.removeSpecifiedInverseJoinColumn(0);
        OrmJoinTableTests.assertEquals((int)2, (int)joinTableResource.getInverseJoinColumns().size());
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(0)).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(1)).getName());
        ormJoinTable.removeSpecifiedInverseJoinColumn(0);
        OrmJoinTableTests.assertEquals((int)1, (int)joinTableResource.getInverseJoinColumns().size());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(0)).getName());
        ormJoinTable.removeSpecifiedInverseJoinColumn(0);
        OrmJoinTableTests.assertEquals((int)0, (int)joinTableResource.getInverseJoinColumns().size());
    }

    public void testMoveSpecifiedInverseJoinColumn() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmSpecifiedJoinTable ormJoinTable = ormManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        ormJoinTable.addSpecifiedInverseJoinColumn(0).setSpecifiedName("FOO");
        ormJoinTable.addSpecifiedInverseJoinColumn(1).setSpecifiedName("BAR");
        ormJoinTable.addSpecifiedInverseJoinColumn(2).setSpecifiedName("BAZ");
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        OrmJoinTableTests.assertEquals((int)3, (int)joinTableResource.getInverseJoinColumns().size());
        ormJoinTable.moveSpecifiedInverseJoinColumn(2, 0);
        ListIterator joinColumns = ormJoinTable.getSpecifiedInverseJoinColumns().iterator();
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(0)).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(1)).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(2)).getName());
        ormJoinTable.moveSpecifiedInverseJoinColumn(0, 1);
        joinColumns = ormJoinTable.getSpecifiedInverseJoinColumns().iterator();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(0)).getName());
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(1)).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((XmlJoinColumn)joinTableResource.getInverseJoinColumns().get(2)).getName());
    }

    public void testUpdateJoinColumns() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmSpecifiedJoinTable ormJoinTable = ormManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        manyToMany.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        joinTableResource.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        joinTableResource.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        joinTableResource.getJoinColumns().add((Object)OrmFactory.eINSTANCE.createXmlJoinColumn());
        ((XmlJoinColumn)joinTableResource.getJoinColumns().get(0)).setName("FOO");
        ((XmlJoinColumn)joinTableResource.getJoinColumns().get(1)).setName("BAR");
        ((XmlJoinColumn)joinTableResource.getJoinColumns().get(2)).setName("BAZ");
        ListIterator joinColumns = ormJoinTable.getSpecifiedJoinColumns().iterator();
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.getJoinColumns().move(2, 0);
        joinColumns = ormJoinTable.getSpecifiedJoinColumns().iterator();
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.getJoinColumns().move(0, 1);
        joinColumns = ormJoinTable.getSpecifiedJoinColumns().iterator();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.getJoinColumns().remove(1);
        joinColumns = ormJoinTable.getSpecifiedJoinColumns().iterator();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.getJoinColumns().remove(1);
        joinColumns = ormJoinTable.getSpecifiedJoinColumns().iterator();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((OrmSpecifiedJoinColumn)joinColumns.next()).getName());
        OrmJoinTableTests.assertFalse((boolean)joinColumns.hasNext());
        joinTableResource.getJoinColumns().remove(0);
        OrmJoinTableTests.assertFalse((boolean)ormJoinTable.getSpecifiedJoinColumns().iterator().hasNext());
    }

    public void testUniqueConstraints() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmSpecifiedJoinTable ormJoinTable = ormManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        manyToMany.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        ListIterator uniqueConstraints = ormJoinTable.getUniqueConstraints().iterator();
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        XmlUniqueConstraint uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        joinTableResource.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"foo");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        joinTableResource.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"bar");
        uniqueConstraints = ormJoinTable.getUniqueConstraints().iterator();
        OrmJoinTableTests.assertTrue((boolean)uniqueConstraints.hasNext());
        OrmJoinTableTests.assertEquals((String)"bar", (String)((String)((OrmSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmJoinTableTests.assertEquals((String)"foo", (String)((String)((OrmSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testUniqueConstraintsSize() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmSpecifiedJoinTable ormJoinTable = ormManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        manyToMany.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        OrmJoinTableTests.assertEquals((int)0, (int)ormJoinTable.getUniqueConstraintsSize());
        XmlUniqueConstraint uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        joinTableResource.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"foo");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        joinTableResource.getUniqueConstraints().add(1, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"bar");
        OrmJoinTableTests.assertEquals((int)2, (int)ormJoinTable.getUniqueConstraintsSize());
    }

    public void testAddUniqueConstraint() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmSpecifiedJoinTable ormJoinTable = ormManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        manyToMany.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        ormJoinTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        ormJoinTable.addUniqueConstraint(0).addColumnName(0, "BAR");
        ormJoinTable.addUniqueConstraint(0).addColumnName(0, "BAZ");
        ListIterator uniqueConstraints = joinTableResource.getUniqueConstraints().listIterator();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testAddUniqueConstraint2() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmSpecifiedJoinTable ormJoinTable = ormManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        manyToMany.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        ormJoinTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        ormJoinTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        ormJoinTable.addUniqueConstraint(0).addColumnName(0, "BAZ");
        ListIterator uniqueConstraints = joinTableResource.getUniqueConstraints().listIterator();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraints.next()).getColumnNames().get(0)));
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testRemoveUniqueConstraint() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmSpecifiedJoinTable ormJoinTable = ormManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        manyToMany.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        ormJoinTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        ormJoinTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        ormJoinTable.addUniqueConstraint(2).addColumnName(0, "BAZ");
        OrmJoinTableTests.assertEquals((int)3, (int)joinTableResource.getUniqueConstraints().size());
        ormJoinTable.removeUniqueConstraint(1);
        ListIterator uniqueConstraintResources = joinTableResource.getUniqueConstraints().listIterator();
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraintResources.hasNext());
        ListIterator uniqueConstraints = ormJoinTable.getUniqueConstraints().iterator();
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((OrmSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((OrmSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        ormJoinTable.removeUniqueConstraint(1);
        uniqueConstraintResources = joinTableResource.getUniqueConstraints().listIterator();
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraintResources.hasNext());
        uniqueConstraints = ormJoinTable.getUniqueConstraints().iterator();
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((OrmSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        ormJoinTable.removeUniqueConstraint(0);
        uniqueConstraintResources = joinTableResource.getUniqueConstraints().listIterator();
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraintResources.hasNext());
        uniqueConstraints = ormJoinTable.getUniqueConstraints().iterator();
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testMoveUniqueConstraint() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmSpecifiedJoinTable ormJoinTable = ormManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        manyToMany.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        ormJoinTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        ormJoinTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        ormJoinTable.addUniqueConstraint(2).addColumnName(0, "BAZ");
        OrmJoinTableTests.assertEquals((int)3, (int)joinTableResource.getUniqueConstraints().size());
        ormJoinTable.moveUniqueConstraint(2, 0);
        ListIterator uniqueConstraints = ormJoinTable.getUniqueConstraints().iterator();
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((String)((OrmSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((OrmSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((OrmSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        ListIterator uniqueConstraintResources = joinTableResource.getUniqueConstraints().listIterator();
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        ormJoinTable.moveUniqueConstraint(0, 1);
        uniqueConstraints = ormJoinTable.getUniqueConstraints().iterator();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((OrmSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((String)((OrmSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((OrmSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        uniqueConstraintResources = joinTableResource.getUniqueConstraints().listIterator();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((XmlUniqueConstraint)uniqueConstraintResources.next()).getColumnNames().get(0)));
    }

    public void testUpdateUniqueConstraints() throws Exception {
        this.createTestType();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "manyToMany");
        OrmManyToManyMapping ormManyToManyMapping = (OrmManyToManyMapping)ormPersistentAttribute.getMapping();
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmSpecifiedJoinTable ormJoinTable = ormManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        manyToMany.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        XmlJoinTable joinTableResource = manyToMany.getJoinTable();
        XmlUniqueConstraint uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        joinTableResource.getUniqueConstraints().add(0, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"FOO");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        joinTableResource.getUniqueConstraints().add(1, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"BAR");
        uniqueConstraintResource = OrmFactory.eINSTANCE.createXmlUniqueConstraint();
        joinTableResource.getUniqueConstraints().add(2, (Object)uniqueConstraintResource);
        uniqueConstraintResource.getColumnNames().add(0, (Object)"BAZ");
        ListIterator uniqueConstraints = ormJoinTable.getUniqueConstraints().iterator();
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((OrmSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((String)((OrmSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((OrmSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableResource.getUniqueConstraints().move(2, 0);
        uniqueConstraints = ormJoinTable.getUniqueConstraints().iterator();
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((String)((OrmSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((OrmSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((OrmSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableResource.getUniqueConstraints().move(0, 1);
        uniqueConstraints = ormJoinTable.getUniqueConstraints().iterator();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((OrmSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((String)((OrmSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((OrmSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableResource.getUniqueConstraints().remove(1);
        uniqueConstraints = ormJoinTable.getUniqueConstraints().iterator();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((OrmSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((OrmSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableResource.getUniqueConstraints().remove(1);
        uniqueConstraints = ormJoinTable.getUniqueConstraints().iterator();
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((OrmSpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        joinTableResource.getUniqueConstraints().remove(0);
        uniqueConstraints = ormJoinTable.getUniqueConstraints().iterator();
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
    }

    public void testUniqueConstraintsFromJava() throws Exception {
        this.createTestEntityWithValidManyToMany();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        PersistentAttribute virtualAttribute = (PersistentAttribute)ormPersistentType.getAttributes().iterator().next();
        ManyToManyMapping virtualManyToManyMapping = (ManyToManyMapping)virtualAttribute.getMapping();
        SpecifiedJoinTable virtualJoinTable = virtualManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        OrmJoinTableTests.assertTrue((boolean)virtualAttribute.isVirtual());
        ListIterator uniqueConstraints = virtualJoinTable.getUniqueConstraints().iterator();
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        JavaManyToManyMapping javaManyToManyMapping = (JavaManyToManyMapping)((JavaSpecifiedPersistentAttribute)ormPersistentType.getJavaPersistentType().getAttributes().iterator().next()).getMapping();
        JavaSpecifiedJoinTable javaJoinTable = javaManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        javaJoinTable.addUniqueConstraint(0).addColumnName(0, "FOO");
        javaJoinTable.addUniqueConstraint(1).addColumnName(0, "BAR");
        javaJoinTable.addUniqueConstraint(2).addColumnName(0, "BAZ");
        uniqueConstraints = virtualJoinTable.getUniqueConstraints().iterator();
        OrmJoinTableTests.assertTrue((boolean)uniqueConstraints.hasNext());
        OrmJoinTableTests.assertEquals((String)"FOO", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmJoinTableTests.assertEquals((String)"BAR", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmJoinTableTests.assertEquals((String)"BAZ", (String)((String)((SpecifiedUniqueConstraint)uniqueConstraints.next()).getColumnNames().iterator().next()));
        OrmJoinTableTests.assertFalse((boolean)uniqueConstraints.hasNext());
        OrmManyToManyMapping specifiedManyToManyMapping = (OrmManyToManyMapping)((OrmPersistentAttribute)virtualAttribute).addToXml().getMapping();
        OrmJoinTableTests.assertEquals((int)0, (int)specifiedManyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable().getUniqueConstraintsSize());
    }

    public void testDefaultName() throws Exception {
        this.createTestEntityWithValidManyToMany();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.getAttributeNamed("projects").addToXml();
        OrmManyToManyMapping manyToManyMapping = (OrmManyToManyMapping)ormPersistentType.getAttributeNamed("projects").getMapping();
        OrmSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        OrmJoinTableTests.assertNull((Object)joinTable.getDefaultName());
        this.createTargetEntity();
        this.getEntityMappings().addPersistentType("entity", "test.Project");
        OrmJoinTableTests.assertEquals((String)"AnnotationTestType_Project", (String)joinTable.getDefaultName());
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
        manyToManyMapping.setSpecifiedTargetEntity("Foo");
        OrmJoinTableTests.assertNull((Object)joinTable.getDefaultName());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        OrmJoinTableTests.assertEquals((String)"AnnotationTestType_Project", (String)joinTable.getDefaultName());
        manyToMany.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        OrmJoinTableTests.assertEquals((String)"AnnotationTestType_Project", (String)joinTable.getDefaultName());
        OrmJoinTableTests.assertNotNull((Object)manyToMany.getJoinTable());
        manyToManyMapping.getResolvedTargetEntity().getTable().setSpecifiedName("FOO");
        OrmJoinTableTests.assertEquals((String)"AnnotationTestType_FOO", (String)joinTable.getDefaultName());
        ((OrmEntity)ormPersistentType.getMapping()).getTable().setSpecifiedName("BAR");
        OrmJoinTableTests.assertEquals((String)"BAR_FOO", (String)joinTable.getDefaultName());
    }

    public void testDefaultJoinColumns() throws Exception {
        this.createTestEntityWithValidManyToMany();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.getAttributeNamed("projects").addToXml();
        OrmManyToManyMapping manyToManyMapping = (OrmManyToManyMapping)ormPersistentType.getAttributeNamed("projects").getMapping();
        OrmSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        SpecifiedJoinColumn joinColumn = (SpecifiedJoinColumn)joinTable.getJoinColumns().iterator().next();
        SpecifiedJoinColumn inverseJoinColumn = (SpecifiedJoinColumn)joinTable.getInverseJoinColumns().iterator().next();
        OrmJoinTableTests.assertNull((Object)joinColumn.getDefaultName());
        OrmJoinTableTests.assertNull((Object)joinColumn.getDefaultReferencedColumnName());
        OrmJoinTableTests.assertNull((Object)inverseJoinColumn.getDefaultName());
        OrmJoinTableTests.assertNull((Object)inverseJoinColumn.getDefaultReferencedColumnName());
        this.createTargetEntity();
        this.getEntityMappings().addPersistentType("entity", "test.Project");
        OrmJoinTableTests.assertNull((Object)joinColumn.getDefaultName());
        OrmJoinTableTests.assertNull((Object)joinColumn.getDefaultReferencedColumnName());
        OrmJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        OrmJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        ormPersistentType.getJavaPersistentType().getAttributeNamed("id").setMappingKey("id");
        OrmJoinTableTests.assertEquals((String)"AnnotationTestType_id", (String)joinColumn.getDefaultName());
        OrmJoinTableTests.assertEquals((String)"id", (String)joinColumn.getDefaultReferencedColumnName());
        OrmJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        OrmJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        ((IdMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping()).getColumn().setSpecifiedName("MY_ID");
        OrmJoinTableTests.assertEquals((String)"AnnotationTestType_MY_ID", (String)joinColumn.getDefaultName());
        OrmJoinTableTests.assertEquals((String)"MY_ID", (String)joinColumn.getDefaultReferencedColumnName());
        OrmJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        OrmJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
        manyToManyMapping.setSpecifiedTargetEntity("Foo");
        OrmJoinTableTests.assertEquals((String)"AnnotationTestType_MY_ID", (String)joinColumn.getDefaultName());
        OrmJoinTableTests.assertEquals((String)"MY_ID", (String)joinColumn.getDefaultReferencedColumnName());
        OrmJoinTableTests.assertNull((Object)inverseJoinColumn.getDefaultName());
        OrmJoinTableTests.assertNull((Object)inverseJoinColumn.getDefaultReferencedColumnName());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        OrmJoinTableTests.assertEquals((String)"AnnotationTestType_MY_ID", (String)joinColumn.getDefaultName());
        OrmJoinTableTests.assertEquals((String)"MY_ID", (String)joinColumn.getDefaultReferencedColumnName());
        OrmJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        OrmJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        manyToMany.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        OrmJoinTableTests.assertEquals((String)"AnnotationTestType_MY_ID", (String)joinColumn.getDefaultName());
        OrmJoinTableTests.assertEquals((String)"MY_ID", (String)joinColumn.getDefaultReferencedColumnName());
        OrmJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        OrmJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        OrmJoinTableTests.assertNotNull((Object)manyToMany.getJoinTable());
    }

    public void testDefaultJoinColumnsBidirectionalRelationship() throws Exception {
        this.createTestEntityWithValidManyToMany();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        ormPersistentType.getAttributeNamed("projects").addToXml();
        OrmManyToManyMapping manyToManyMapping = (OrmManyToManyMapping)ormPersistentType.getAttributeNamed("projects").getMapping();
        OrmSpecifiedJoinTable joinTable = manyToManyMapping.getRelationship().getJoinTableStrategy().getJoinTable();
        SpecifiedJoinColumn joinColumn = (SpecifiedJoinColumn)joinTable.getJoinColumns().iterator().next();
        SpecifiedJoinColumn inverseJoinColumn = (SpecifiedJoinColumn)joinTable.getInverseJoinColumns().iterator().next();
        OrmJoinTableTests.assertNull((Object)joinColumn.getDefaultName());
        OrmJoinTableTests.assertNull((Object)joinColumn.getDefaultReferencedColumnName());
        OrmJoinTableTests.assertNull((Object)inverseJoinColumn.getDefaultName());
        OrmJoinTableTests.assertNull((Object)inverseJoinColumn.getDefaultReferencedColumnName());
        this.createTargetEntityWithBackPointer();
        this.getEntityMappings().addPersistentType("entity", "test.Project");
        OrmJoinTableTests.assertNull((Object)joinColumn.getDefaultName());
        OrmJoinTableTests.assertNull((Object)joinColumn.getDefaultReferencedColumnName());
        OrmJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        OrmJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        ormPersistentType.getJavaPersistentType().getAttributeNamed("id").setMappingKey("id");
        OrmJoinTableTests.assertEquals((String)"employees_id", (String)joinColumn.getDefaultName());
        OrmJoinTableTests.assertEquals((String)"id", (String)joinColumn.getDefaultReferencedColumnName());
        OrmJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        OrmJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        ((IdMapping)ormPersistentType.getJavaPersistentType().getAttributeNamed("id").getMapping()).getColumn().setSpecifiedName("MY_ID");
        OrmJoinTableTests.assertEquals((String)"employees_MY_ID", (String)joinColumn.getDefaultName());
        OrmJoinTableTests.assertEquals((String)"MY_ID", (String)joinColumn.getDefaultReferencedColumnName());
        OrmJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        OrmJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        XmlManyToMany manyToMany = (XmlManyToMany)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getManyToManys().get(0);
        OrmJoinTableTests.assertNull((Object)manyToMany.getJoinTable());
        manyToManyMapping.setSpecifiedTargetEntity("Foo");
        OrmJoinTableTests.assertEquals((String)"AnnotationTestType_MY_ID", (String)joinColumn.getDefaultName());
        OrmJoinTableTests.assertEquals((String)"MY_ID", (String)joinColumn.getDefaultReferencedColumnName());
        OrmJoinTableTests.assertNull((Object)inverseJoinColumn.getDefaultName());
        OrmJoinTableTests.assertNull((Object)inverseJoinColumn.getDefaultReferencedColumnName());
        manyToManyMapping.setSpecifiedTargetEntity(null);
        OrmJoinTableTests.assertEquals((String)"employees_MY_ID", (String)joinColumn.getDefaultName());
        OrmJoinTableTests.assertEquals((String)"MY_ID", (String)joinColumn.getDefaultReferencedColumnName());
        OrmJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        OrmJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        manyToMany.setJoinTable(OrmFactory.eINSTANCE.createXmlJoinTable());
        OrmJoinTableTests.assertEquals((String)"employees_MY_ID", (String)joinColumn.getDefaultName());
        OrmJoinTableTests.assertEquals((String)"MY_ID", (String)joinColumn.getDefaultReferencedColumnName());
        OrmJoinTableTests.assertEquals((String)"projects_proj_id", (String)inverseJoinColumn.getDefaultName());
        OrmJoinTableTests.assertEquals((String)"proj_id", (String)inverseJoinColumn.getDefaultReferencedColumnName());
        OrmJoinTableTests.assertNotNull((Object)manyToMany.getJoinTable());
    }
}

