/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2_1.context.persistence;

import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.persistence.ClassRef;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.jpa2_1.context.ConverterType2_1;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlJavaClassRef;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2_1.context.Generic2_1ContextModelTestCase;

public class ClassRef2_1Tests
extends Generic2_1ContextModelTestCase {
    public ClassRef2_1Tests(String name) {
        super(name);
    }

    public void testUpdateClassName() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        XmlJavaClassRef xmlClassRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        xmlClassRef.setJavaClass("com.foo.Bar");
        xmlPersistenceUnit.getClasses().add((Object)xmlClassRef);
        ClassRef classRef = (ClassRef)persistenceUnit.getSpecifiedClassRefs().iterator().next();
        ClassRef2_1Tests.assertEquals((String)classRef.getClassName(), (String)xmlClassRef.getJavaClass());
        xmlClassRef.setJavaClass("com.bar.Foo");
        classRef = (ClassRef)persistenceUnit.getSpecifiedClassRefs().iterator().next();
        ClassRef2_1Tests.assertEquals((String)classRef.getClassName(), (String)xmlClassRef.getJavaClass());
        xmlClassRef.setJavaClass("");
        classRef = (ClassRef)persistenceUnit.getSpecifiedClassRefs().iterator().next();
        ClassRef2_1Tests.assertEquals((String)classRef.getClassName(), (String)xmlClassRef.getJavaClass());
        xmlClassRef.setJavaClass("com.foo.Bar");
        classRef = (ClassRef)persistenceUnit.getSpecifiedClassRefs().iterator().next();
        ClassRef2_1Tests.assertEquals((String)classRef.getClassName(), (String)xmlClassRef.getJavaClass());
    }

    public void testModifyClassName() {
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        PersistenceUnit persistenceUnit = this.getPersistenceUnit();
        XmlJavaClassRef xmlClassRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        xmlClassRef.setJavaClass("com.foo.Bar");
        xmlPersistenceUnit.getClasses().add((Object)xmlClassRef);
        ClassRef classRef = (ClassRef)persistenceUnit.getSpecifiedClassRefs().iterator().next();
        ClassRef2_1Tests.assertEquals((String)classRef.getClassName(), (String)xmlClassRef.getJavaClass());
        classRef.setClassName("com.bar.Foo");
        ClassRef2_1Tests.assertEquals((String)classRef.getClassName(), (String)xmlClassRef.getJavaClass());
        classRef.setClassName("");
        ClassRef2_1Tests.assertEquals((String)classRef.getClassName(), (String)xmlClassRef.getJavaClass());
        classRef.setClassName(null);
        ClassRef2_1Tests.assertEquals((String)classRef.getClassName(), (String)xmlClassRef.getJavaClass());
        classRef.setClassName("com.foo.Bar");
        ClassRef2_1Tests.assertEquals((String)classRef.getClassName(), (String)xmlClassRef.getJavaClass());
    }

    public void testGetJavaManagedType() throws Exception {
        this.createTestType();
        XmlPersistenceUnit xmlPersistenceUnit = this.getXmlPersistenceUnit();
        XmlJavaClassRef xmlClassRef = PersistenceFactory.eINSTANCE.createXmlJavaClassRef();
        xmlClassRef.setJavaClass("test.AnnotationTestType");
        xmlPersistenceUnit.getClasses().add((Object)xmlClassRef);
        ClassRef classRef = this.getSpecifiedClassRef();
        ClassRef2_1Tests.assertEquals((String)"test.AnnotationTestType", (String)classRef.getJavaManagedType().getName());
        xmlClassRef.setJavaClass("com.foo.Bar");
        classRef = this.getSpecifiedClassRef();
        ClassRef2_1Tests.assertNull((Object)classRef.getJavaManagedType());
        xmlClassRef.setJavaClass("test.AnnotationTestType");
        ClassRef2_1Tests.assertEquals((String)"test.AnnotationTestType", (String)classRef.getJavaManagedType().getName());
        ClassRef2_1Tests.assertEquals(PersistentType.class, (Object)classRef.getJavaManagedType().getManagedTypeType());
        classRef.getJavaResourceType().addAnnotation("javax.persistence.Converter");
        this.getJpaProject().synchronizeContextModel();
        ClassRef2_1Tests.assertEquals((String)"test.AnnotationTestType", (String)classRef.getJavaManagedType().getName());
        ClassRef2_1Tests.assertEquals(ConverterType2_1.class, (Object)classRef.getJavaManagedType().getManagedTypeType());
        classRef.getJavaResourceType().addAnnotation("javax.persistence.Entity");
        this.getJpaProject().synchronizeContextModel();
        ClassRef2_1Tests.assertEquals((String)"test.AnnotationTestType", (String)classRef.getJavaManagedType().getName());
        ClassRef2_1Tests.assertEquals(PersistentType.class, (Object)classRef.getJavaManagedType().getManagedTypeType());
        classRef.getJavaResourceType().removeAnnotation("javax.persistence.Entity");
        this.getJpaProject().synchronizeContextModel();
        ClassRef2_1Tests.assertEquals((String)"test.AnnotationTestType", (String)classRef.getJavaManagedType().getName());
        ClassRef2_1Tests.assertEquals(ConverterType2_1.class, (Object)classRef.getJavaManagedType().getManagedTypeType());
    }
}

