/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jaxb.core.context.JaxbPersistentAttribute;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.core.context.java.JavaClassMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.java.ELJavaXmlInverseReferenceMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlInverseReferenceAnnotation;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.ELJaxbContextModelTestCase;

public class ELJavaXmlInverseReferenceMappingTests
extends ELJaxbContextModelTestCase {
    public ELJavaXmlInverseReferenceMappingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTypeWithXmlInverseReference() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "org.eclipse.persistence.oxm.annotations.XmlInverseReference"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlInverseReference");
            }
        });
    }

    public void testModifyMappedBy() throws Exception {
        this.createTypeWithXmlInverseReference();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        ELJavaXmlInverseReferenceMapping mapping = (ELJavaXmlInverseReferenceMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlInverseReferenceAnnotation annotation = (XmlInverseReferenceAnnotation)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlInverseReference");
        ELJavaXmlInverseReferenceMappingTests.assertNull((Object)annotation.getMappedBy());
        ELJavaXmlInverseReferenceMappingTests.assertNull((Object)mapping.getMappedBy());
        mapping.setMappedBy("foo");
        ELJavaXmlInverseReferenceMappingTests.assertEquals((String)"foo", (String)annotation.getMappedBy());
        ELJavaXmlInverseReferenceMappingTests.assertEquals((String)"foo", (String)mapping.getMappedBy());
        mapping.setMappedBy(null);
        ELJavaXmlInverseReferenceMappingTests.assertNull((Object)annotation.getMappedBy());
        ELJavaXmlInverseReferenceMappingTests.assertNull((Object)mapping.getMappedBy());
    }

    public void testUpdateMappedBy() throws Exception {
        this.createTypeWithXmlInverseReference();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        JaxbPersistentAttribute persistentAttribute = (JaxbPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0);
        ELJavaXmlInverseReferenceMapping mapping = (ELJavaXmlInverseReferenceMapping)persistentAttribute.getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        XmlInverseReferenceAnnotation annotation = (XmlInverseReferenceAnnotation)resourceAttribute.getAnnotation("org.eclipse.persistence.oxm.annotations.XmlInverseReference");
        ELJavaXmlInverseReferenceMappingTests.assertNull((Object)annotation.getMappedBy());
        ELJavaXmlInverseReferenceMappingTests.assertNull((Object)mapping.getMappedBy());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlInverseReferenceMappingTests.this.addMemberValuePair((MarkerAnnotation)declaration.getAnnotationNamed("org.eclipse.persistence.oxm.annotations.XmlInverseReference"), "mappedBy", "foo");
            }
        });
        ELJavaXmlInverseReferenceMappingTests.assertEquals((String)"foo", (String)annotation.getMappedBy());
        ELJavaXmlInverseReferenceMappingTests.assertEquals((String)"foo", (String)mapping.getMappedBy());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                NormalAnnotation annotation = (NormalAnnotation)declaration.getAnnotationNamed("org.eclipse.persistence.oxm.annotations.XmlInverseReference");
                ELJavaXmlInverseReferenceMappingTests.this.values(annotation).remove(0);
            }
        });
        ELJavaXmlInverseReferenceMappingTests.assertNull((Object)annotation.getMappedBy());
        ELJavaXmlInverseReferenceMappingTests.assertNull((Object)mapping.getMappedBy());
    }
}

