/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SubIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jaxb.core.context.java.JavaClass;
import org.eclipse.jpt.jaxb.core.context.java.JavaClassMapping;
import org.eclipse.jpt.jaxb.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.jaxb.eclipselink.core.context.ELXmlJoinNode;
import org.eclipse.jpt.jaxb.eclipselink.core.internal.context.java.ELJavaXmlJoinNodesMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.java.XmlJoinNodeAnnotation;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.ELJaxbContextModelTestCase;

public class ELJavaXmlJoinNodesMappingTests
extends ELJaxbContextModelTestCase {
    public ELJavaXmlJoinNodesMappingTests(String name) {
        super(name);
    }

    @Override
    protected String getPlatformID() {
        return "eclipselink_2_2";
    }

    private ICompilationUnit createTypeWithXmlJoinNodes() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.xml.bind.annotation.XmlType", "org.eclipse.persistence.oxm.annotations.XmlJoinNodes"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@XmlType");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@XmlJoinNodes");
            }
        });
    }

    protected NormalAnnotation newXmlJoinNodeAnnotation(AST ast, String xmlPath, String referencedXmlPath) {
        NormalAnnotation annotation = this.newNormalAnnotation(ast, "org.eclipse.persistence.oxm.annotations.XmlJoinNode");
        this.addMemberValuePair(annotation, "xmlPath", xmlPath);
        this.addMemberValuePair(annotation, "referencedXmlPath", referencedXmlPath);
        return annotation;
    }

    protected void addXmlJoinNode(ModifiedDeclaration declaration, int index, String xmlPath, String referencedXmlPath) {
        NormalAnnotation annotation = this.newXmlJoinNodeAnnotation(declaration.getAst(), xmlPath, referencedXmlPath);
        this.addArrayElement(declaration, "org.eclipse.persistence.oxm.annotations.XmlJoinNodes", index, "value", (Expression)annotation);
    }

    protected void moveXmlJoinNode(ModifiedDeclaration declaration, int targetIndex, int sourceIndex) {
        this.moveArrayElement((NormalAnnotation)declaration.getAnnotationNamed("org.eclipse.persistence.oxm.annotations.XmlJoinNodes"), "value", targetIndex, sourceIndex);
    }

    protected void removeXmlJoinNode(ModifiedDeclaration declaration, int index) {
        this.removeArrayElement((NormalAnnotation)declaration.getAnnotationNamed("org.eclipse.persistence.oxm.annotations.XmlJoinNodes"), "value", index);
    }

    public void testUpdateXmlJoinNodes() throws Exception {
        this.createTypeWithXmlJoinNodes();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        ELJavaXmlJoinNodesMapping mapping = (ELJavaXmlJoinNodesMapping)((JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ListIterable xmlJoinNodes = mapping.getXmlJoinNodes();
        ELJavaXmlJoinNodesMappingTests.assertTrue((boolean)IterableTools.isEmpty((Iterable)xmlJoinNodes));
        ELJavaXmlJoinNodesMappingTests.assertEquals((int)0, (int)mapping.getXmlJoinNodesSize());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourceAttribute);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlJoinNodesMappingTests.this.addXmlJoinNode(declaration, 0, "foo", "@foo");
                ELJavaXmlJoinNodesMappingTests.this.addXmlJoinNode(declaration, 1, "bar", "@bar");
            }
        });
        xmlJoinNodes = mapping.getXmlJoinNodes();
        ELJavaXmlJoinNodesMappingTests.assertFalse((boolean)IterableTools.isEmpty((Iterable)xmlJoinNodes));
        ELJavaXmlJoinNodesMappingTests.assertEquals((int)2, (int)mapping.getXmlJoinNodesSize());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"foo", (String)((ELXmlJoinNode)IterableTools.get((Iterable)xmlJoinNodes, (int)0)).getXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"@foo", (String)((ELXmlJoinNode)IterableTools.get((Iterable)xmlJoinNodes, (int)0)).getReferencedXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"bar", (String)((ELXmlJoinNode)IterableTools.get((Iterable)xmlJoinNodes, (int)1)).getXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"@bar", (String)((ELXmlJoinNode)IterableTools.get((Iterable)xmlJoinNodes, (int)1)).getReferencedXmlPath());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlJoinNodesMappingTests.this.moveXmlJoinNode(declaration, 0, 1);
            }
        });
        xmlJoinNodes = mapping.getXmlJoinNodes();
        ELJavaXmlJoinNodesMappingTests.assertFalse((boolean)IterableTools.isEmpty((Iterable)xmlJoinNodes));
        ELJavaXmlJoinNodesMappingTests.assertEquals((int)2, (int)mapping.getXmlJoinNodesSize());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"bar", (String)((ELXmlJoinNode)IterableTools.get((Iterable)xmlJoinNodes, (int)0)).getXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"@bar", (String)((ELXmlJoinNode)IterableTools.get((Iterable)xmlJoinNodes, (int)0)).getReferencedXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"foo", (String)((ELXmlJoinNode)IterableTools.get((Iterable)xmlJoinNodes, (int)1)).getXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"@foo", (String)((ELXmlJoinNode)IterableTools.get((Iterable)xmlJoinNodes, (int)1)).getReferencedXmlPath());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                ELJavaXmlJoinNodesMappingTests.this.removeXmlJoinNode(declaration, 1);
                ELJavaXmlJoinNodesMappingTests.this.removeXmlJoinNode(declaration, 0);
            }
        });
        xmlJoinNodes = mapping.getXmlJoinNodes();
        ELJavaXmlJoinNodesMappingTests.assertTrue((boolean)IterableTools.isEmpty((Iterable)xmlJoinNodes));
        ELJavaXmlJoinNodesMappingTests.assertEquals((int)0, (int)mapping.getXmlJoinNodesSize());
    }

    public void testModifyXmlJoinNodes() throws Exception {
        this.createTypeWithXmlJoinNodes();
        JavaClass jaxbClass = (JavaClass)IterableTools.get((Iterable)this.getContextRoot().getJavaTypes(), (int)0);
        JavaClassMapping classMapping = jaxbClass.getMapping();
        ELJavaXmlJoinNodesMapping mapping = (ELJavaXmlJoinNodesMapping)((JavaPersistentAttribute)IterableTools.get((Iterable)classMapping.getAttributes(), (int)0)).getMapping();
        JavaResourceAttribute resourceAttribute = mapping.getPersistentAttribute().getJavaResourceAttribute();
        ELJavaXmlJoinNodesMappingTests.assertEquals((int)0, (int)resourceAttribute.getAnnotationsSize("org.eclipse.persistence.oxm.annotations.XmlJoinNode"));
        ELJavaXmlJoinNodesMappingTests.assertEquals((int)0, (int)mapping.getXmlJoinNodesSize());
        ELXmlJoinNode joinNode = mapping.addXmlJoinNode(0);
        joinNode.setXmlPath("foo");
        joinNode.setReferencedXmlPath("@foo");
        joinNode = mapping.addXmlJoinNode(1);
        joinNode.setXmlPath("baz");
        joinNode.setReferencedXmlPath("@baz");
        joinNode = mapping.addXmlJoinNode(1);
        joinNode.setXmlPath("bar");
        joinNode.setReferencedXmlPath("@bar");
        SubIterableWrapper xmlJoinNodeAnnotations = new SubIterableWrapper((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlJoinNode"));
        ELJavaXmlJoinNodesMappingTests.assertEquals((int)3, (int)IterableTools.size((Iterable)xmlJoinNodeAnnotations));
        ELJavaXmlJoinNodesMappingTests.assertEquals((int)3, (int)mapping.getXmlJoinNodesSize());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"foo", (String)((XmlJoinNodeAnnotation)IterableTools.get((Iterable)xmlJoinNodeAnnotations, (int)0)).getXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"@foo", (String)((XmlJoinNodeAnnotation)IterableTools.get((Iterable)xmlJoinNodeAnnotations, (int)0)).getReferencedXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"bar", (String)((XmlJoinNodeAnnotation)IterableTools.get((Iterable)xmlJoinNodeAnnotations, (int)1)).getXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"@bar", (String)((XmlJoinNodeAnnotation)IterableTools.get((Iterable)xmlJoinNodeAnnotations, (int)1)).getReferencedXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"baz", (String)((XmlJoinNodeAnnotation)IterableTools.get((Iterable)xmlJoinNodeAnnotations, (int)2)).getXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"@baz", (String)((XmlJoinNodeAnnotation)IterableTools.get((Iterable)xmlJoinNodeAnnotations, (int)2)).getReferencedXmlPath());
        mapping.moveXmlJoinNode(1, 2);
        xmlJoinNodeAnnotations = new SubIterableWrapper((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlJoinNode"));
        ELJavaXmlJoinNodesMappingTests.assertEquals((int)3, (int)IterableTools.size((Iterable)xmlJoinNodeAnnotations));
        ELJavaXmlJoinNodesMappingTests.assertEquals((int)3, (int)mapping.getXmlJoinNodesSize());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"foo", (String)((XmlJoinNodeAnnotation)IterableTools.get((Iterable)xmlJoinNodeAnnotations, (int)0)).getXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"@foo", (String)((XmlJoinNodeAnnotation)IterableTools.get((Iterable)xmlJoinNodeAnnotations, (int)0)).getReferencedXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"baz", (String)((XmlJoinNodeAnnotation)IterableTools.get((Iterable)xmlJoinNodeAnnotations, (int)1)).getXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"@baz", (String)((XmlJoinNodeAnnotation)IterableTools.get((Iterable)xmlJoinNodeAnnotations, (int)1)).getReferencedXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"bar", (String)((XmlJoinNodeAnnotation)IterableTools.get((Iterable)xmlJoinNodeAnnotations, (int)2)).getXmlPath());
        ELJavaXmlJoinNodesMappingTests.assertEquals((String)"@bar", (String)((XmlJoinNodeAnnotation)IterableTools.get((Iterable)xmlJoinNodeAnnotations, (int)2)).getReferencedXmlPath());
        mapping.removeXmlJoinNode(2);
        mapping.removeXmlJoinNode(0);
        mapping.removeXmlJoinNode(0);
        xmlJoinNodeAnnotations = new SubIterableWrapper((Iterable)resourceAttribute.getAnnotations("org.eclipse.persistence.oxm.annotations.XmlJoinNode"));
        ELJavaXmlJoinNodesMappingTests.assertEquals((int)0, (int)IterableTools.size((Iterable)xmlJoinNodeAnnotations));
        ELJavaXmlJoinNodesMappingTests.assertEquals((int)0, (int)mapping.getXmlJoinNodesSize());
    }
}

