/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.oxm;

import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.jaxb.core.context.java.JavaEnumMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.context.ELJaxbContextRoot;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmFile;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmXmlBindings;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmXmlEnum;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EXmlBindings;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EXmlEnum;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.oxm.OxmContextModelTestCase;

public class OxmXmlEnumTests
extends OxmContextModelTestCase {
    public OxmXmlEnumTests(String name) {
        super(name);
    }

    protected void addOxmFile(String fileName, String packageName, String typeName) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(CR);
        sb.append("<xml-bindings").append(CR);
        sb.append("    version=\"2.4\"").append(CR);
        sb.append("    xmlns=\"http://www.eclipse.org/eclipselink/xsds/persistence/oxm\"").append(CR);
        sb.append("    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"").append(CR);
        sb.append("    xsi:schemaLocation=\"http://www.eclipse.org/eclipselink/xsds/persistence/oxm http://www.eclipse.org/eclipselink/xsds/eclipselink_oxm_2_4.xsd\"").append(CR);
        sb.append("    package-name=\"").append(packageName).append("\">").append(CR);
        sb.append("    <xml-enums>").append(CR);
        sb.append("        <xml-enum java-enum=\"").append(typeName).append("\"/>").append(CR);
        sb.append("    </xml-enums>").append(CR);
        sb.append("</xml-bindings>").append(CR);
        this.addOxmFile(fileName, sb);
    }

    public void testUpdateName() throws Exception {
        this.addOxmFile("oxm.xml", "test.oxm", "Foo");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test.oxm");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        OxmXmlEnum xmlEnum = xmlBindings.getXmlEnum(0);
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        EXmlEnum eXmlEnum = (EXmlEnum)eXmlBindings.getXmlEnums().get(0);
        OxmXmlEnumTests.assertEquals((String)"Foo", (String)eXmlEnum.getJavaEnum());
        OxmXmlEnumTests.assertEquals((String)"Foo", (String)xmlEnum.getSpecifiedJavaEnum());
        OxmXmlEnumTests.assertEquals((String)"test.oxm.Foo", (String)xmlEnum.getTypeName().getFullyQualifiedName());
        OxmXmlEnumTests.assertEquals((String)"Foo", (String)xmlEnum.getTypeName().getSimpleName());
        eXmlEnum.setJavaEnum("test.oxm2.Bar");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "java-enum=\"test.oxm2.Bar\"", true);
        OxmXmlEnumTests.assertEquals((String)"test.oxm2.Bar", (String)eXmlEnum.getJavaEnum());
        OxmXmlEnumTests.assertEquals((String)"test.oxm2.Bar", (String)xmlEnum.getSpecifiedJavaEnum());
        OxmXmlEnumTests.assertEquals((String)"test.oxm2.Bar", (String)xmlEnum.getTypeName().getFullyQualifiedName());
        OxmXmlEnumTests.assertEquals((String)"Bar", (String)xmlEnum.getTypeName().getSimpleName());
        eXmlEnum.setJavaEnum("test.oxm2.Foo$Bar");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "java-enum=\"test.oxm2.Foo$Bar\"", true);
        OxmXmlEnumTests.assertEquals((String)"test.oxm2.Foo$Bar", (String)eXmlEnum.getJavaEnum());
        OxmXmlEnumTests.assertEquals((String)"test.oxm2.Foo$Bar", (String)xmlEnum.getSpecifiedJavaEnum());
        OxmXmlEnumTests.assertEquals((String)"test.oxm2.Foo$Bar", (String)xmlEnum.getTypeName().getFullyQualifiedName());
        OxmXmlEnumTests.assertEquals((String)"Foo$Bar", (String)xmlEnum.getTypeName().getTypeQualifiedName());
        OxmXmlEnumTests.assertEquals((String)"Bar", (String)xmlEnum.getTypeName().getSimpleName());
        eXmlEnum.setJavaEnum("int");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "java-enum=\"int\"", true);
        OxmXmlEnumTests.assertEquals((String)"int", (String)eXmlEnum.getJavaEnum());
        OxmXmlEnumTests.assertEquals((String)"int", (String)xmlEnum.getSpecifiedJavaEnum());
        OxmXmlEnumTests.assertEquals((String)"int", (String)xmlEnum.getTypeName().getFullyQualifiedName());
        OxmXmlEnumTests.assertEquals((String)"int", (String)xmlEnum.getTypeName().getSimpleName());
        eXmlEnum.setJavaEnum("String");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "java-enum=\"String\"", true);
        OxmXmlEnumTests.assertEquals((String)"String", (String)eXmlEnum.getJavaEnum());
        OxmXmlEnumTests.assertEquals((String)"String", (String)xmlEnum.getSpecifiedJavaEnum());
        OxmXmlEnumTests.assertEquals((String)"java.lang.String", (String)xmlEnum.getTypeName().getFullyQualifiedName());
        OxmXmlEnumTests.assertEquals((String)"String", (String)xmlEnum.getTypeName().getSimpleName());
        eXmlBindings.setPackageName("test.oxm2");
        eXmlEnum.setJavaEnum("Foo");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "java-enum=\"Foo\"", true);
        OxmXmlEnumTests.assertEquals((String)"Foo", (String)eXmlEnum.getJavaEnum());
        OxmXmlEnumTests.assertEquals((String)"Foo", (String)xmlEnum.getSpecifiedJavaEnum());
        OxmXmlEnumTests.assertEquals((String)"test.oxm2.Foo", (String)xmlEnum.getTypeName().getFullyQualifiedName());
        OxmXmlEnumTests.assertEquals((String)"Foo", (String)xmlEnum.getTypeName().getSimpleName());
    }

    public void testModifyName() throws Exception {
        this.addOxmFile("oxm.xml", "test.oxm", "Foo");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test.oxm");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        OxmXmlEnum xmlEnum = xmlBindings.getXmlEnum(0);
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        EXmlEnum eXmlEnum = (EXmlEnum)eXmlBindings.getXmlEnums().get(0);
        OxmXmlEnumTests.assertEquals((String)"Foo", (String)eXmlEnum.getJavaEnum());
        OxmXmlEnumTests.assertEquals((String)"Foo", (String)xmlEnum.getSpecifiedJavaEnum());
        OxmXmlEnumTests.assertEquals((String)"test.oxm.Foo", (String)xmlEnum.getTypeName().getFullyQualifiedName());
        OxmXmlEnumTests.assertEquals((String)"Foo", (String)xmlEnum.getTypeName().getSimpleName());
        xmlEnum.setSpecifiedJavaEnum("test.oxm2.Bar");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "java-enum=\"test.oxm2.Bar\"", true);
        OxmXmlEnumTests.assertEquals((String)"test.oxm2.Bar", (String)eXmlEnum.getJavaEnum());
        OxmXmlEnumTests.assertEquals((String)"test.oxm2.Bar", (String)xmlEnum.getSpecifiedJavaEnum());
        OxmXmlEnumTests.assertEquals((String)"test.oxm2.Bar", (String)xmlEnum.getTypeName().getFullyQualifiedName());
        OxmXmlEnumTests.assertEquals((String)"Bar", (String)xmlEnum.getTypeName().getSimpleName());
        xmlEnum.setSpecifiedJavaEnum("int");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "java-enum=\"int\"", true);
        OxmXmlEnumTests.assertEquals((String)"int", (String)eXmlEnum.getJavaEnum());
        OxmXmlEnumTests.assertEquals((String)"int", (String)xmlEnum.getSpecifiedJavaEnum());
        OxmXmlEnumTests.assertEquals((String)"int", (String)xmlEnum.getTypeName().getFullyQualifiedName());
        OxmXmlEnumTests.assertEquals((String)"int", (String)xmlEnum.getTypeName().getSimpleName());
        eXmlEnum.setJavaEnum("String");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "java-enum=\"String\"", true);
        OxmXmlEnumTests.assertEquals((String)"String", (String)eXmlEnum.getJavaEnum());
        OxmXmlEnumTests.assertEquals((String)"String", (String)xmlEnum.getSpecifiedJavaEnum());
        OxmXmlEnumTests.assertEquals((String)"java.lang.String", (String)xmlEnum.getTypeName().getFullyQualifiedName());
        OxmXmlEnumTests.assertEquals((String)"String", (String)xmlEnum.getTypeName().getSimpleName());
        xmlBindings.setSpecifiedPackageName("test.oxm2");
        xmlEnum.setSpecifiedJavaEnum("Foo");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "java-enum=\"Foo\"", true);
        OxmXmlEnumTests.assertEquals((String)"Foo", (String)eXmlEnum.getJavaEnum());
        OxmXmlEnumTests.assertEquals((String)"Foo", (String)xmlEnum.getSpecifiedJavaEnum());
        OxmXmlEnumTests.assertEquals((String)"test.oxm2.Foo", (String)xmlEnum.getTypeName().getFullyQualifiedName());
        OxmXmlEnumTests.assertEquals((String)"Foo", (String)xmlEnum.getTypeName().getSimpleName());
    }

    public void testUpdateValue() throws Exception {
        this.createEnumWithXmlType();
        this.addOxmFile("oxm.xml", "test", "AnnotationTestType");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        OxmXmlEnum xmlEnum = xmlBindings.getXmlEnum(0);
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        EXmlEnum eXmlEnum = (EXmlEnum)eXmlBindings.getXmlEnums().get(0);
        JavaEnumMapping javaEnumMapping = xmlEnum.getJavaType().getMapping();
        OxmXmlEnumTests.assertNull((Object)eXmlEnum.getValue());
        OxmXmlEnumTests.assertEquals((String)"java.lang.String", (String)xmlEnum.getValue());
        OxmXmlEnumTests.assertEquals((String)"java.lang.String", (String)xmlEnum.getDefaultValue());
        OxmXmlEnumTests.assertNull((Object)xmlEnum.getSpecifiedValue());
        javaEnumMapping.setSpecifiedValue("java.util.Date");
        OxmXmlEnumTests.assertNull((Object)eXmlEnum.getValue());
        OxmXmlEnumTests.assertEquals((String)"java.util.Date", (String)xmlEnum.getValue());
        OxmXmlEnumTests.assertEquals((String)"java.util.Date", (String)xmlEnum.getDefaultValue());
        OxmXmlEnumTests.assertNull((Object)xmlEnum.getSpecifiedValue());
        xmlBindings.setXmlMappingMetadataComplete(true);
        oxmResource.save();
        OxmXmlEnumTests.assertNull((Object)eXmlEnum.getValue());
        OxmXmlEnumTests.assertEquals((String)"java.lang.String", (String)xmlEnum.getValue());
        OxmXmlEnumTests.assertEquals((String)"java.lang.String", (String)xmlEnum.getDefaultValue());
        OxmXmlEnumTests.assertNull((Object)xmlEnum.getSpecifiedValue());
        javaEnumMapping.setSpecifiedValue(null);
        xmlBindings.setXmlMappingMetadataComplete(false);
        eXmlEnum.setValue("java.lang.Integer");
        oxmResource.save();
        OxmXmlEnumTests.assertEquals((String)"java.lang.Integer", (String)eXmlEnum.getValue());
        OxmXmlEnumTests.assertEquals((String)"java.lang.Integer", (String)xmlEnum.getValue());
        OxmXmlEnumTests.assertEquals((String)"java.lang.String", (String)xmlEnum.getDefaultValue());
        OxmXmlEnumTests.assertEquals((String)"java.lang.Integer", (String)xmlEnum.getSpecifiedValue());
        eXmlEnum.setValue(null);
        oxmResource.save();
        OxmXmlEnumTests.assertNull((Object)eXmlEnum.getValue());
        OxmXmlEnumTests.assertEquals((String)"java.lang.String", (String)xmlEnum.getValue());
        OxmXmlEnumTests.assertEquals((String)"java.lang.String", (String)xmlEnum.getDefaultValue());
        OxmXmlEnumTests.assertNull((Object)xmlEnum.getSpecifiedValue());
    }

    public void testModifyValue() throws Exception {
        this.createEnumWithXmlType();
        this.addOxmFile("oxm.xml", "test", "AnnotationTestType");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        OxmXmlEnum xmlEnum = xmlBindings.getXmlEnum(0);
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        EXmlEnum eXmlEnum = (EXmlEnum)eXmlBindings.getXmlEnums().get(0);
        OxmXmlEnumTests.assertNull((Object)eXmlEnum.getValue());
        OxmXmlEnumTests.assertNull((Object)xmlEnum.getSpecifiedValue());
        xmlEnum.setSpecifiedValue("java.util.Date");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "value=\"java.util.Date\"", true);
        OxmXmlEnumTests.assertEquals((String)"java.util.Date", (String)eXmlEnum.getValue());
        OxmXmlEnumTests.assertEquals((String)"java.util.Date", (String)xmlEnum.getSpecifiedValue());
        xmlEnum.setSpecifiedValue("java.lang.Integer");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "value=\"java.lang.Integer\"", true);
        OxmXmlEnumTests.assertEquals((String)"java.lang.Integer", (String)eXmlEnum.getValue());
        OxmXmlEnumTests.assertEquals((String)"java.lang.Integer", (String)xmlEnum.getSpecifiedValue());
        xmlEnum.setSpecifiedValue(null);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "value", false);
        OxmXmlEnumTests.assertNull((Object)eXmlEnum.getValue());
        OxmXmlEnumTests.assertNull((Object)xmlEnum.getSpecifiedValue());
    }
}

