/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.oxm;

import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.jaxb.eclipselink.core.context.ELJaxbContextRoot;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmFile;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmXmlSeeAlso;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EJavaType;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EXmlBindings;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EXmlSeeAlso;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.oxm.OxmContextModelTestCase;

public class OxmXmlSeeAlsoTests
extends OxmContextModelTestCase {
    public OxmXmlSeeAlsoTests(String name) {
        super(name);
    }

    protected void addOxmFile() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(CR);
        sb.append("<xml-bindings").append(CR);
        sb.append("    version=\"2.4\"").append(CR);
        sb.append("    xmlns=\"http://www.eclipse.org/eclipselink/xsds/persistence/oxm\"").append(CR);
        sb.append("    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"").append(CR);
        sb.append("    xsi:schemaLocation=\"http://www.eclipse.org/eclipselink/xsds/persistence/oxm http://www.eclipse.org/eclipselink/xsds/eclipselink_oxm_2_4.xsd\"").append(CR);
        sb.append("    package-name=\"").append("test").append("\">").append(CR);
        sb.append("    <java-types>").append(CR);
        sb.append("        <java-type name=\"").append("AnnotationTestType").append("\">").append(CR);
        sb.append("            <xml-see-also></xml-see-also>").append(CR);
        sb.append("        </java-type>").append(CR);
        sb.append("    </java-types>").append(CR);
        sb.append("</xml-bindings>").append(CR);
        this.addOxmFile("oxm.xml", sb);
    }

    public void testUpdateClasses() throws Exception {
        this.addOxmFile();
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test");
        OxmXmlSeeAlso xmlSeeAlso = oxmFile.getXmlBindings().getJavaType(0).getSpecifiedXmlSeeAlso();
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        EXmlSeeAlso eXmlSeeAlso = ((EJavaType)eXmlBindings.getJavaTypes().get(0)).getXmlSeeAlso();
        OxmXmlSeeAlsoTests.assertNotNull((Object)eXmlSeeAlso);
        OxmXmlSeeAlsoTests.assertNotNull((Object)xmlSeeAlso);
        OxmXmlSeeAlsoTests.assertTrue((boolean)StringTools.isBlank((String)eXmlSeeAlso.getClasses()));
        OxmXmlSeeAlsoTests.assertTrue((boolean)IterableTools.isEmpty((Iterable)eXmlSeeAlso.getClassesList()));
        OxmXmlSeeAlsoTests.assertTrue((boolean)IterableTools.isEmpty((Iterable)xmlSeeAlso.getClasses()));
        eXmlSeeAlso.setClasses("foo");
        oxmResource.save();
        OxmXmlSeeAlsoTests.assertEquals((String)"foo", (String)eXmlSeeAlso.getClasses());
        OxmXmlSeeAlsoTests.assertEquals((int)1, (int)IterableTools.size((Iterable)eXmlSeeAlso.getClassesList()));
        OxmXmlSeeAlsoTests.assertEquals((String)"foo", (String)((String)IterableTools.get((Iterable)eXmlSeeAlso.getClassesList(), (int)0)));
        OxmXmlSeeAlsoTests.assertEquals((int)1, (int)IterableTools.size((Iterable)xmlSeeAlso.getClasses()));
        OxmXmlSeeAlsoTests.assertEquals((String)"foo", (String)((String)IterableTools.get((Iterable)xmlSeeAlso.getClasses(), (int)0)));
        eXmlSeeAlso.setClasses("bar baz");
        oxmResource.save();
        OxmXmlSeeAlsoTests.assertEquals((String)"bar baz", (String)eXmlSeeAlso.getClasses());
        OxmXmlSeeAlsoTests.assertEquals((int)2, (int)IterableTools.size((Iterable)eXmlSeeAlso.getClassesList()));
        OxmXmlSeeAlsoTests.assertEquals((String)"bar", (String)((String)IterableTools.get((Iterable)eXmlSeeAlso.getClassesList(), (int)0)));
        OxmXmlSeeAlsoTests.assertEquals((String)"baz", (String)((String)IterableTools.get((Iterable)eXmlSeeAlso.getClassesList(), (int)1)));
        OxmXmlSeeAlsoTests.assertEquals((int)2, (int)IterableTools.size((Iterable)xmlSeeAlso.getClasses()));
        OxmXmlSeeAlsoTests.assertEquals((String)"bar", (String)((String)IterableTools.get((Iterable)xmlSeeAlso.getClasses(), (int)0)));
        OxmXmlSeeAlsoTests.assertEquals((String)"baz", (String)((String)IterableTools.get((Iterable)xmlSeeAlso.getClasses(), (int)1)));
        eXmlSeeAlso.setClasses(null);
        oxmResource.save();
        OxmXmlSeeAlsoTests.assertTrue((boolean)StringTools.isBlank((String)eXmlSeeAlso.getClasses()));
        OxmXmlSeeAlsoTests.assertEquals((int)0, (int)IterableTools.size((Iterable)eXmlSeeAlso.getClassesList()));
    }

    public void testModifyClasses() throws Exception {
        this.addOxmFile();
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test");
        OxmXmlSeeAlso xmlSeeAlso = oxmFile.getXmlBindings().getJavaType(0).getSpecifiedXmlSeeAlso();
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        EXmlSeeAlso eXmlSeeAlso = ((EJavaType)eXmlBindings.getJavaTypes().get(0)).getXmlSeeAlso();
        OxmXmlSeeAlsoTests.assertNotNull((Object)eXmlSeeAlso);
        OxmXmlSeeAlsoTests.assertNotNull((Object)xmlSeeAlso);
        OxmXmlSeeAlsoTests.assertTrue((boolean)StringTools.isBlank((String)eXmlSeeAlso.getClasses()));
        OxmXmlSeeAlsoTests.assertTrue((boolean)IterableTools.isEmpty((Iterable)eXmlSeeAlso.getClassesList()));
        OxmXmlSeeAlsoTests.assertTrue((boolean)IterableTools.isEmpty((Iterable)xmlSeeAlso.getClasses()));
        xmlSeeAlso.addClass(0, "foo");
        oxmResource.save();
        OxmXmlSeeAlsoTests.assertEquals((String)"foo", (String)eXmlSeeAlso.getClasses());
        OxmXmlSeeAlsoTests.assertEquals((int)1, (int)IterableTools.size((Iterable)eXmlSeeAlso.getClassesList()));
        OxmXmlSeeAlsoTests.assertEquals((String)"foo", (String)((String)IterableTools.get((Iterable)eXmlSeeAlso.getClassesList(), (int)0)));
        OxmXmlSeeAlsoTests.assertEquals((int)1, (int)IterableTools.size((Iterable)xmlSeeAlso.getClasses()));
        OxmXmlSeeAlsoTests.assertEquals((String)"foo", (String)((String)IterableTools.get((Iterable)xmlSeeAlso.getClasses(), (int)0)));
        xmlSeeAlso.addClass(0, "bar");
        oxmResource.save();
        OxmXmlSeeAlsoTests.assertEquals((String)"bar foo", (String)eXmlSeeAlso.getClasses());
        OxmXmlSeeAlsoTests.assertEquals((int)2, (int)IterableTools.size((Iterable)eXmlSeeAlso.getClassesList()));
        OxmXmlSeeAlsoTests.assertEquals((String)"bar", (String)((String)IterableTools.get((Iterable)eXmlSeeAlso.getClassesList(), (int)0)));
        OxmXmlSeeAlsoTests.assertEquals((String)"foo", (String)((String)IterableTools.get((Iterable)eXmlSeeAlso.getClassesList(), (int)1)));
        OxmXmlSeeAlsoTests.assertEquals((int)2, (int)IterableTools.size((Iterable)xmlSeeAlso.getClasses()));
        OxmXmlSeeAlsoTests.assertEquals((String)"bar", (String)((String)IterableTools.get((Iterable)xmlSeeAlso.getClasses(), (int)0)));
        OxmXmlSeeAlsoTests.assertEquals((String)"foo", (String)((String)IterableTools.get((Iterable)xmlSeeAlso.getClasses(), (int)1)));
        xmlSeeAlso.moveClass(0, 1);
        oxmResource.save();
        OxmXmlSeeAlsoTests.assertEquals((String)"foo bar", (String)eXmlSeeAlso.getClasses());
        OxmXmlSeeAlsoTests.assertEquals((int)2, (int)IterableTools.size((Iterable)eXmlSeeAlso.getClassesList()));
        OxmXmlSeeAlsoTests.assertEquals((String)"foo", (String)((String)IterableTools.get((Iterable)eXmlSeeAlso.getClassesList(), (int)0)));
        OxmXmlSeeAlsoTests.assertEquals((String)"bar", (String)((String)IterableTools.get((Iterable)eXmlSeeAlso.getClassesList(), (int)1)));
        OxmXmlSeeAlsoTests.assertEquals((int)2, (int)IterableTools.size((Iterable)xmlSeeAlso.getClasses()));
        OxmXmlSeeAlsoTests.assertEquals((String)"foo", (String)((String)IterableTools.get((Iterable)xmlSeeAlso.getClasses(), (int)0)));
        OxmXmlSeeAlsoTests.assertEquals((String)"bar", (String)((String)IterableTools.get((Iterable)xmlSeeAlso.getClasses(), (int)1)));
        xmlSeeAlso.removeClass(0);
        oxmResource.save();
        OxmXmlSeeAlsoTests.assertEquals((String)"bar", (String)eXmlSeeAlso.getClasses());
        OxmXmlSeeAlsoTests.assertEquals((int)1, (int)IterableTools.size((Iterable)eXmlSeeAlso.getClassesList()));
        OxmXmlSeeAlsoTests.assertEquals((String)"bar", (String)((String)IterableTools.get((Iterable)eXmlSeeAlso.getClassesList(), (int)0)));
        OxmXmlSeeAlsoTests.assertEquals((int)1, (int)IterableTools.size((Iterable)xmlSeeAlso.getClasses()));
        OxmXmlSeeAlsoTests.assertEquals((String)"bar", (String)((String)IterableTools.get((Iterable)xmlSeeAlso.getClasses(), (int)0)));
        xmlSeeAlso.removeClass(0);
        oxmResource.save();
        OxmXmlSeeAlsoTests.assertTrue((boolean)StringTools.isBlank((String)eXmlSeeAlso.getClasses()));
        OxmXmlSeeAlsoTests.assertTrue((boolean)IterableTools.isEmpty((Iterable)eXmlSeeAlso.getClassesList()));
        OxmXmlSeeAlsoTests.assertTrue((boolean)IterableTools.isEmpty((Iterable)xmlSeeAlso.getClasses()));
    }
}

