/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jst.j2ee.internal.web.operations.NewListenerClassDataModelProvider;
import org.eclipse.jst.servlet.ui.internal.wizard.IWebWizardConstants;
import org.eclipse.jst.servlet.ui.internal.wizard.ServletDataModelSyncHelper;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class AddListenerWizardPage
extends DataModelWizardPage {
    private static final Image IMG_INTERFACE = JavaPluginImages.get((String)"org.eclipse.jdt.ui.int_obj.gif");
    protected ServletDataModelSyncHelper synchHelper2;
    private Button changeSessionID;
    private Button asyncListener;
    private Label changeSessionIDIconLabel;
    private Label changeSessionIDInterfaceLabel;
    private Label asyncListenerIconLabel;
    private Label asyncListenerInterfaceLabel;

    public AddListenerWizardPage(IDataModel model, String pageName) {
        super(model, pageName);
        this.setDescription(IWebWizardConstants.ADD_LISTENER_WIZARD_PAGE_DESC);
        this.setTitle(IWebWizardConstants.ADD_LISTENER_WIZARD_PAGE_TITLE);
        this.synchHelper2 = this.initializeSynchHelper(model);
    }

    public ServletDataModelSyncHelper initializeSynchHelper(IDataModel dm) {
        return new ServletDataModelSyncHelper(dm);
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridData data = new GridData(1808);
        data.widthHint = 300;
        composite.setLayoutData((Object)data);
        this.createServletContextEvents(composite);
        this.createHttpSessionEvents(composite);
        this.createServletRequestEvents(composite);
        this.createSelectAllGroup(composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"NewJavaClassDataModel.INTERFACES"};
    }

    protected void enter() {
        super.enter();
        this.synchHelper2.synchUIWithModel("NewJavaClassDataModel.INTERFACES", 1);
    }

    private void createServletContextEvents(Composite parent) {
        Group group = this.createGroup(parent, IWebWizardConstants.ADD_LISTENER_WIZARD_SERVLET_CONTEXT_EVENTS);
        this.createEventListenerRow((Composite)group, IWebWizardConstants.ADD_LISTENER_WIZARD_LIFECYCLE_L, "javax.servlet.ServletContextListener", "NewJavaClassDataModel.INTERFACES");
        this.createEventListenerRow((Composite)group, IWebWizardConstants.ADD_LISTENER_WIZARD_CHANGES_TO_ATTRIBUTES_C, "javax.servlet.ServletContextAttributeListener", "NewJavaClassDataModel.INTERFACES");
    }

    private void createHttpSessionEvents(Composite parent) {
        Group group = this.createGroup(parent, IWebWizardConstants.ADD_LISTENER_WIZARD_HTTP_SESSION_EVENTS);
        this.createEventListenerRow((Composite)group, IWebWizardConstants.ADD_LISTENER_WIZARD_LIFECYCLE_I, "javax.servlet.http.HttpSessionListener", "NewJavaClassDataModel.INTERFACES");
        this.createEventListenerRow((Composite)group, IWebWizardConstants.ADD_LISTENER_WIZARD_CHANGES_TO_ATTRIBUTES_H, "javax.servlet.http.HttpSessionAttributeListener", "NewJavaClassDataModel.INTERFACES");
        this.createEventListenerRow((Composite)group, IWebWizardConstants.ADD_LISTENER_WIZARD_SESSION_MIGRATION, "javax.servlet.http.HttpSessionActivationListener", "NewJavaClassDataModel.INTERFACES");
        this.createEventListenerRow((Composite)group, IWebWizardConstants.ADD_LISTENER_WIZARD_OBJECT_BINDING, "javax.servlet.http.HttpSessionBindingListener", "NewJavaClassDataModel.INTERFACES");
        this.createEventListenerRow((Composite)group, IWebWizardConstants.ADD_LISTENER_WIZARD_OBJECT_SESSION_ID, "javax.servlet.http.HttpSessionIdListener", "NewJavaClassDataModel.INTERFACES");
    }

    private void createServletRequestEvents(Composite parent) {
        Group group = this.createGroup(parent, IWebWizardConstants.ADD_LISTENER_WIZARD_SERVLET_REQUEST_EVENTS);
        this.createEventListenerRow((Composite)group, IWebWizardConstants.ADD_LISTENER_WIZARD_LIFECYCLE_Y, "javax.servlet.ServletRequestListener", "NewJavaClassDataModel.INTERFACES");
        this.createEventListenerRow((Composite)group, IWebWizardConstants.ADD_LISTENER_WIZARD_CHANGES_TO_ATTRIBUTES_G, "javax.servlet.ServletRequestAttributeListener", "NewJavaClassDataModel.INTERFACES");
        this.createEventListenerRow((Composite)group, IWebWizardConstants.ADD_LISTENER_WIZARD_ASYNC_EVENTS, "javax.servlet.AsyncListener", "NewJavaClassDataModel.INTERFACES");
    }

    private Group createGroup(Composite parent, String text) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setText(text);
        return group;
    }

    private void createEventListenerRow(Composite parent, String event, String listener, String property) {
        if (listener.equals("javax.servlet.http.HttpSessionIdListener")) {
            this.changeSessionID = this.createCheckbox(parent, event, listener, property);
            this.changeSessionIDIconLabel = this.createInterfaceIcon(parent);
            this.changeSessionIDInterfaceLabel = this.createInterfaceLabel(parent, listener);
        } else if (listener.equals("javax.servlet.AsyncListener")) {
            this.asyncListener = this.createCheckbox(parent, event, listener, property);
            this.asyncListenerIconLabel = this.createInterfaceIcon(parent);
            this.asyncListenerInterfaceLabel = this.createInterfaceLabel(parent, listener);
        } else {
            this.createCheckbox(parent, event, listener, property);
            this.createInterfaceIcon(parent);
            this.createInterfaceLabel(parent, listener);
        }
    }

    private Button createCheckbox(Composite parent, String text, String value, String property) {
        Button button = new Button(parent, 32);
        button.setText(text);
        button.setLayoutData((Object)new GridData(4, 4, false, true));
        this.synchHelper2.synchCheckbox(button, value, property, null);
        return button;
    }

    private Label createInterfaceIcon(Composite parent) {
        GridData data = new GridData();
        data.horizontalIndent = 50;
        Label label = new Label(parent, 131072);
        label.setImage(IMG_INTERFACE);
        label.setLayoutData((Object)data);
        return label;
    }

    private Label createInterfaceLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        return label;
    }

    private void createSelectAllGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Button selectAll = new Button(composite, 8);
        selectAll.setText(IWebWizardConstants.SELECT_ALL_BUTTON);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddListenerWizardPage.this.handleSelectAll();
            }
        });
        Button clear = new Button(composite, 8);
        clear.setText(IWebWizardConstants.CLEAR_BUTTON);
        clear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddListenerWizardPage.this.handleSelectNone();
            }
        });
    }

    private void handleSelectAll() {
        ArrayList<String> interfaces = (ArrayList<String>)this.model.getProperty("NewJavaClassDataModel.INTERFACES");
        if (interfaces == null) {
            interfaces = new ArrayList<String>();
            this.model.setProperty("NewJavaClassDataModel.INTERFACES", interfaces);
        }
        String[] stringArray = NewListenerClassDataModelProvider.LISTENER_INTERFACES;
        int n = NewListenerClassDataModelProvider.LISTENER_INTERFACES.length;
        int n2 = 0;
        while (n2 < n) {
            String iface = stringArray[n2];
            if (!interfaces.contains(iface)) {
                interfaces.add(iface);
            }
            ++n2;
        }
        this.synchHelper2.synchUIWithModel("NewJavaClassDataModel.INTERFACES", 1);
        this.model.notifyPropertyChange("NewJavaClassDataModel.INTERFACES", 1);
    }

    private void handleSelectNone() {
        ArrayList interfaces = (ArrayList)this.model.getProperty("NewJavaClassDataModel.INTERFACES");
        if (interfaces == null) {
            interfaces = new ArrayList();
            this.model.setProperty("NewJavaClassDataModel.INTERFACES", interfaces);
        }
        interfaces.removeAll(Arrays.asList(NewListenerClassDataModelProvider.LISTENER_INTERFACES));
        this.synchHelper2.synchUIWithModel("NewJavaClassDataModel.INTERFACES", 1);
        this.model.notifyPropertyChange("NewJavaClassDataModel.INTERFACES", 1);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        String javaEEVersion = this.model.getStringProperty("NewServletClassDataModel.JAVA_EE_VERSION");
        if ("3.1".equals(javaEEVersion)) {
            this.setServlet31ListenersVisible(true);
        } else {
            this.setServlet31ListenersVisible(false);
        }
    }

    private void setServlet31ListenersVisible(boolean visible) {
        List interfaces;
        this.changeSessionID.setVisible(visible);
        this.changeSessionIDIconLabel.setVisible(visible);
        this.changeSessionIDInterfaceLabel.setVisible(visible);
        this.asyncListener.setVisible(visible);
        this.asyncListenerIconLabel.setVisible(visible);
        this.asyncListenerInterfaceLabel.setVisible(visible);
        if (!visible && (interfaces = (List)this.model.getProperty("NewJavaClassDataModel.INTERFACES")) != null) {
            interfaces.remove("javax.servlet.http.HttpSessionIdListener");
            interfaces.remove("javax.servlet.AsyncListener");
            this.synchHelper2.synchUIWithModel("NewJavaClassDataModel.INTERFACES", 1);
            this.model.notifyPropertyChange("NewJavaClassDataModel.INTERFACES", 1);
        }
    }
}

