/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsil.actions;

import java.io.OutputStream;
import javax.wsdl.Definition;
import org.eclipse.wst.ws.internal.explorer.platform.actions.ImportToFileSystemAction;
import org.eclipse.wst.ws.internal.explorer.platform.actions.WSDLFileNameHelper;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.ListElement;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.ListManager;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Tool;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.util.Uddi4jHelper;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilUddiServiceElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilWsdlServiceElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.perspective.ListUDDIServicesTool;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.perspective.ListWSDLServicesTool;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.perspective.WSILPerspective;
import org.uddi4j.client.UDDIProxy;

public class ImportWSDLToFileSystemAction
extends ImportToFileSystemAction {
    private Definition def_;
    private String wsdlFileName_;
    private NodeManager nodeManager_;

    public ImportWSDLToFileSystemAction(Controller controller) {
        super(controller);
        this.nodeManager_ = controller.getWSILPerspective().getNodeManager();
    }

    public static final String getActionLink(int nodeId, int toolId, int viewId, int viewToolId) {
        return ImportToFileSystemAction.getActionLink(nodeId, toolId, viewId, viewToolId, "wsil/actions/ImportWSDLToFileSystemActionJSP.jsp");
    }

    public boolean write(OutputStream os) {
        if (this.def_ != null) {
            return this.writeWSDLDefinition(os, this.def_);
        }
        return false;
    }

    public String getDefaultFileName() {
        return this.wsdlFileName_;
    }

    private boolean getWSDLFromURL() {
        int nodeID = Integer.parseInt((String)this.propertyTable_.get("nodeId"));
        int viewID = Integer.parseInt((String)this.propertyTable_.get("viewId"));
        Node selectedNode = this.nodeManager_.getNode(nodeID);
        WsilElement wsilElement = (WsilElement)selectedNode.getTreeElement();
        ListManager wsilServices = wsilElement.getAllWSDLServices();
        ListElement le = wsilServices.getElementWithViewId(viewID);
        WsilWsdlServiceElement service = (WsilWsdlServiceElement)((Object)le.getObject());
        String wsdlURL = service.getWSDLServiceURL();
        this.wsdlFileName_ = WSDLFileNameHelper.getWSDLFileName(wsdlURL);
        try {
            this.def_ = new Uddi4jHelper().getWSDLDefinition(wsdlURL);
        }
        catch (Exception e) {
            WSILPerspective wsilPerspective = this.controller_.getWSILPerspective();
            wsilPerspective.getMessageQueue().addMessage(e.getMessage());
            return false;
        }
        return true;
    }

    private boolean getWSDLFromUDDIRegistry() {
        int nodeID = Integer.parseInt((String)this.propertyTable_.get("nodeId"));
        int viewID = Integer.parseInt((String)this.propertyTable_.get("viewId"));
        Node selectedNode = this.nodeManager_.getNode(nodeID);
        WsilElement wsilElement = (WsilElement)selectedNode.getTreeElement();
        ListManager wsilServices = wsilElement.getAllUDDIServices();
        ListElement le = wsilServices.getElementWithViewId(viewID);
        WsilUddiServiceElement service = (WsilUddiServiceElement)((Object)le.getObject());
        WSILPerspective wsilPerspective = this.controller_.getWSILPerspective();
        this.wsdlFileName_ = String.valueOf(service.getName()) + ".wsdl";
        Uddi4jHelper uddi4jHelper = new Uddi4jHelper();
        try {
            UDDIProxy proxy = null;
            String inquiryURL = service.getUDDIServiceInquiryAPI();
            if (inquiryURL != null) {
                proxy = new UDDIProxy();
                proxy.setInquiryURL(inquiryURL);
            }
            this.def_ = uddi4jHelper.getWSDLDefinition(uddi4jHelper.getWSDL(service.getServiceDefinition(), proxy));
        }
        catch (Exception e) {
            try {
                this.def_ = uddi4jHelper.getWSDLDefinition(service.getUDDIServiceDiscoveryURL());
                return true;
            }
            catch (Exception exception) {
                wsilPerspective.getMessageQueue().addMessage(e.getMessage());
                return false;
            }
        }
        return true;
    }

    public boolean run() {
        int nodeID = Integer.parseInt((String)this.propertyTable_.get("nodeId"));
        Node selectedNode = this.nodeManager_.getNode(nodeID);
        Tool selectedTool = selectedNode.getToolManager().getSelectedTool();
        if (selectedTool instanceof ListWSDLServicesTool) {
            return this.getWSDLFromURL();
        }
        if (selectedTool instanceof ListUDDIServicesTool) {
            return this.getWSDLFromUDDIRegistry();
        }
        return false;
    }

    public final String getStatusContentVar() {
        return this.controller_.getWSILPerspective().getStatusContentVar();
    }

    public final String getStatusContentPage() {
        return this.controller_.getWSILPerspective().getStatusContentPage();
    }
}

