/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.wst.xml.xpath2.api.DynamicContext;
import org.eclipse.wst.xml.xpath2.api.Item;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpGt;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpLt;
import org.eclipse.wst.xml.xpath2.processor.internal.function.MathMinus;
import org.eclipse.wst.xml.xpath2.processor.internal.function.MathPlus;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CalendarType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDateTime;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDayTimeDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSUntypedAtomic;
import org.eclipse.wst.xml.xpath2.processor.internal.types.builtin.BuiltinTypeLibrary;

public class XSTime
extends CalendarType
implements CmpEq,
CmpLt,
CmpGt,
MathMinus,
MathPlus,
Cloneable {
    private static final String XS_TIME = "xs:time";
    private Calendar _calendar;
    private boolean _timezoned;
    private XSDuration _tz;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.wst.xml.xpath2.processor.internal.types.XSTime");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public XSTime(Calendar cal, XSDuration tz) {
        this._calendar = cal;
        this._tz = tz;
        this._timezoned = tz != null;
    }

    public XSTime() {
        this(new GregorianCalendar(TimeZone.getTimeZone("GMT")), null);
    }

    public Object clone() throws CloneNotSupportedException {
        Calendar c = (Calendar)this.calendar().clone();
        XSDuration t = this.tz();
        if (t != null) {
            t = (XSDuration)t.clone();
        }
        return new XSTime(c, t);
    }

    public String type_name() {
        return "time";
    }

    public static CalendarType parse_time(String str) {
        String startdate = "1983-11-29T";
        XSDateTime dt = XSDateTime.parseDateTime(String.valueOf(startdate) + str);
        if (dt == null) {
            return null;
        }
        return new XSTime(dt.calendar(), dt.tz());
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        if (arg.empty()) {
            return ResultBuffer.EMPTY;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        if (!this.isCastable(aat)) {
            throw DynamicError.invalidType();
        }
        CalendarType t = this.castTime(aat);
        if (t == null) {
            throw DynamicError.cant_cast(null);
        }
        return t;
    }

    private boolean isCastable(AnyAtomicType aat) {
        if (aat instanceof XSString || aat instanceof XSUntypedAtomic) {
            return true;
        }
        if (aat instanceof XSDateTime) {
            return true;
        }
        return aat instanceof XSTime;
    }

    private CalendarType castTime(AnyAtomicType aat) {
        if (aat instanceof XSTime) {
            XSTime time = (XSTime)aat;
            return new XSTime(time.calendar(), time.tz());
        }
        if (aat instanceof XSDateTime) {
            XSDateTime dateTime = (XSDateTime)aat;
            return new XSTime(dateTime.calendar(), dateTime.tz());
        }
        return XSTime.parse_time(aat.getStringValue());
    }

    public int hour() {
        return this._calendar.get(11);
    }

    public int minute() {
        return this._calendar.get(12);
    }

    public double second() {
        double s = this._calendar.get(13);
        double ms = this._calendar.get(14);
        return s += (ms /= 1000.0);
    }

    public boolean timezoned() {
        return this._timezoned;
    }

    public String getStringValue() {
        String ret = "";
        Calendar adjustFortimezone = this.calendar();
        ret = String.valueOf(ret) + XSDateTime.pad_int(adjustFortimezone.get(11), 2);
        ret = String.valueOf(ret) + ":";
        ret = String.valueOf(ret) + XSDateTime.pad_int(adjustFortimezone.get(12), 2);
        ret = String.valueOf(ret) + ":";
        int isecond = (int)this.second();
        double sec = this.second();
        ret = sec - (double)isecond == 0.0 ? String.valueOf(ret) + XSDateTime.pad_int(isecond, 2) : (sec < 10.0 ? String.valueOf(ret) + "0" + sec : String.valueOf(ret) + sec);
        if (this.timezoned()) {
            int hrs = this._tz.hours();
            int min = this._tz.minutes();
            double secs = this._tz.seconds();
            if (hrs == 0 && min == 0 && secs == 0.0) {
                ret = String.valueOf(ret) + "Z";
            } else {
                String tZoneStr = "";
                tZoneStr = this._tz.negative() ? String.valueOf(tZoneStr) + "-" : String.valueOf(tZoneStr) + "+";
                tZoneStr = String.valueOf(tZoneStr) + XSDateTime.pad_int(hrs, 2);
                tZoneStr = String.valueOf(tZoneStr) + ":";
                tZoneStr = String.valueOf(tZoneStr) + XSDateTime.pad_int(min, 2);
                ret = String.valueOf(ret) + tZoneStr;
            }
        }
        return ret;
    }

    public String string_type() {
        return XS_TIME;
    }

    public Calendar calendar() {
        return this._calendar;
    }

    public XSDuration tz() {
        return this._tz;
    }

    public double value() {
        return (double)this.calendar().getTimeInMillis() / 1000.0;
    }

    public boolean eq(AnyType arg, DynamicContext dynamicContext) throws DynamicError {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.xpath2.processor.internal.types.XSTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XSTime val = (XSTime)NumericType.get_single_type(arg, (Class)clazz);
        Calendar thiscal = this.normalizeCalendar(this.calendar(), this.tz());
        Calendar thatcal = this.normalizeCalendar(val.calendar(), val.tz());
        return thiscal.equals(thatcal);
    }

    public boolean lt(AnyType arg, DynamicContext context) throws DynamicError {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.xpath2.processor.internal.types.XSTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XSTime val = (XSTime)NumericType.get_single_type(arg, (Class)clazz);
        Calendar thiscal = this.normalizeCalendar(this.calendar(), this.tz());
        Calendar thatcal = this.normalizeCalendar(val.calendar(), val.tz());
        return thiscal.before(thatcal);
    }

    public boolean gt(AnyType arg, DynamicContext context) throws DynamicError {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.xpath2.processor.internal.types.XSTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XSTime val = (XSTime)NumericType.get_single_type(arg, (Class)clazz);
        Calendar thiscal = this.normalizeCalendar(this.calendar(), this.tz());
        Calendar thatcal = this.normalizeCalendar(val.calendar(), val.tz());
        return thiscal.after(thatcal);
    }

    public ResultSequence minus(ResultSequence arg) throws DynamicError {
        Item at;
        if (arg.size() != 1) {
            DynamicError.throw_type_error();
        }
        if (!((at = arg.first()) instanceof XSTime) && !(at instanceof XSDayTimeDuration)) {
            throw DynamicError.throw_type_error();
        }
        if (at instanceof XSTime) {
            return this.minusXSTimeDuration(at);
        }
        if (at instanceof XSDayTimeDuration) {
            return this.minusXSDayTimeDuration(at);
        }
        return null;
    }

    private ResultSequence minusXSDayTimeDuration(Item at) {
        XSDuration val = (XSDuration)at;
        XSTime res = null;
        try {
            res = (XSTime)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        XMLGregorianCalendar xmlCal = _datatypeFactory.newXMLGregorianCalendar((GregorianCalendar)this.calendar());
        Duration dtduration = _datatypeFactory.newDuration(val.getStringValue());
        xmlCal.add(dtduration.negate());
        res = new XSTime(xmlCal.toGregorianCalendar(), res.tz());
        return ResultSequenceFactory.create_new(res);
    }

    private ResultSequence minusXSTimeDuration(Item at) {
        XSTime val = (XSTime)at;
        Duration dtduration = null;
        Calendar thisCal = this.normalizeCalendar(this.calendar(), this.tz());
        Calendar thatCal = this.normalizeCalendar(val.calendar(), val.tz());
        long duration = thisCal.getTimeInMillis() - thatCal.getTimeInMillis();
        dtduration = _datatypeFactory.newDuration(duration);
        return ResultSequenceFactory.create_new(XSDayTimeDuration.parseDTDuration(dtduration.toString()));
    }

    public ResultSequence plus(ResultSequence arg) throws DynamicError {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.xml.xpath2.processor.internal.types.XSDayTimeDuration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        XSDuration val = (XSDuration)NumericType.get_single_type(arg, (Class)clazz);
        try {
            double ms = val.time_value() * 1000.0;
            XSTime res = (XSTime)this.clone();
            res.calendar().add(14, (int)ms);
            return ResultSequenceFactory.create_new(res);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    public TypeDefinition getTypeDefinition() {
        return BuiltinTypeLibrary.XS_TIME;
    }

    public Object getNativeValue() {
        return this._calendar.clone();
    }
}

