/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.tests.internal.stack;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import org.eclipse.jpt.common.utility.internal.queue.ArrayQueue;
import org.eclipse.jpt.common.utility.internal.queue.QueueTools;
import org.eclipse.jpt.common.utility.internal.stack.ArrayStack;
import org.eclipse.jpt.common.utility.internal.stack.LinkedStack;
import org.eclipse.jpt.common.utility.internal.stack.StackTools;
import org.eclipse.jpt.common.utility.internal.stack.SynchronizedStack;
import org.eclipse.jpt.common.utility.queue.Queue;
import org.eclipse.jpt.common.utility.stack.Stack;
import org.eclipse.jpt.common.utility.tests.internal.MultiThreadedTestCase;
import org.eclipse.jpt.common.utility.tests.internal.deque.DequeToolsTests;
import org.eclipse.jpt.common.utility.tests.internal.stack.StackTests;

public class SynchronizedStackTests
extends StackTests {
    private volatile SynchronizedStack<String> ss;
    volatile boolean timeoutOccurred;
    volatile long startTime;
    volatile long endTime;
    volatile Object poppedObject;
    boolean commandExecuted;
    static final String ITEM_1 = new String();
    static final String ITEM_2 = new String();

    public SynchronizedStackTests(String name) {
        super(name);
    }

    @Override
    Stack<String> buildStack() {
        return StackTools.synchronizedStack();
    }

    @Override
    public void testClone() {
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.ss = StackTools.synchronizedStack();
        this.timeoutOccurred = false;
        this.startTime = 0L;
        this.endTime = 0L;
        this.poppedObject = null;
    }

    public void testConstructorStack() throws Exception {
        ArrayStack innerStack = StackTools.arrayStack();
        SynchronizedStack stack = StackTools.synchronizedStack((Stack)innerStack);
        SynchronizedStackTests.assertNotNull((Object)stack);
        SynchronizedStackTests.assertSame((Object)stack, (Object)stack.getMutex());
    }

    public void testConstructorStack_NPE() throws Exception {
        boolean exCaught = false;
        try {
            SynchronizedStack stack = StackTools.synchronizedStack(null);
            SynchronizedStackTests.fail((String)("bogus stack: " + stack));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        SynchronizedStackTests.assertTrue((boolean)exCaught);
    }

    public void testConstructorStackObject() throws Exception {
        String mutex = "mutex";
        ArrayStack innerStack = StackTools.arrayStack();
        SynchronizedStack stack = StackTools.synchronizedStack((Stack)innerStack, (Object)mutex);
        SynchronizedStackTests.assertNotNull((Object)stack);
        SynchronizedStackTests.assertSame((Object)mutex, (Object)stack.getMutex());
    }

    public void testConstructorStackObject_NPE1() throws Exception {
        String mutex = "mutex";
        boolean exCaught = false;
        try {
            SynchronizedStack stack = StackTools.synchronizedStack(null, (Object)mutex);
            SynchronizedStackTests.fail((String)("bogus stack: " + stack));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        SynchronizedStackTests.assertTrue((boolean)exCaught);
    }

    public void testConstructorStackObject_NPE2() throws Exception {
        ArrayStack innerStack = StackTools.arrayStack();
        boolean exCaught = false;
        try {
            SynchronizedStack stack = StackTools.synchronizedStack((Stack)innerStack, null);
            SynchronizedStackTests.fail((String)("bogus stack: " + stack));
        }
        catch (NullPointerException nullPointerException) {
            exCaught = true;
        }
        SynchronizedStackTests.assertTrue((boolean)exCaught);
    }

    public void testConcurrentPop() throws Exception {
        this.verifyConcurrentPop(new SlowLinkedStack<String>(), "second");
        this.verifyConcurrentPop(new SlowSynchronizedStack<String>(), "first");
    }

    private void verifyConcurrentPop(SlowStack<String> slowStack, String expected) throws Exception {
        slowStack.push("first");
        slowStack.push("second");
        Thread thread = this.buildThread(this.buildRunnablePop(slowStack));
        thread.start();
        Thread.sleep(TWO_TICKS);
        SynchronizedStackTests.assertEquals((String)expected, (String)((String)slowStack.pop()));
        thread.join();
        SynchronizedStackTests.assertTrue((boolean)slowStack.isEmpty());
    }

    private Runnable buildRunnablePop(final SlowStack<String> slowStack) {
        return new Runnable(){

            @Override
            public void run() {
                slowStack.slowPop();
            }
        };
    }

    public void testConcurrentPush() throws Exception {
        this.verifyConcurrentPush(new SlowLinkedStack<String>(), "first", "second");
        this.verifyConcurrentPush(new SlowSynchronizedStack<String>(), "second", "first");
    }

    private void verifyConcurrentPush(SlowStack<String> slowStack, String first, String second) throws Exception {
        Thread thread = this.buildThread(this.buildRunnablePush(slowStack, "first"));
        thread.start();
        Thread.sleep(TWO_TICKS);
        slowStack.push("second");
        thread.join();
        SynchronizedStackTests.assertEquals((String)first, (String)((String)slowStack.pop()));
        SynchronizedStackTests.assertEquals((String)second, (String)((String)slowStack.pop()));
        SynchronizedStackTests.assertTrue((boolean)slowStack.isEmpty());
    }

    private Runnable buildRunnablePush(final SlowStack<String> slowStack, final String element) {
        return new Runnable(){

            @Override
            public void run() {
                slowStack.slowPush(element);
            }
        };
    }

    public void testConcurrentIsEmpty() throws Exception {
        this.verifyConcurrentIsEmpty(new SlowLinkedStack<String>(), true);
        this.verifyConcurrentIsEmpty(new SlowSynchronizedStack<String>(), false);
    }

    private void verifyConcurrentIsEmpty(SlowStack<String> slowStack, boolean empty) throws Exception {
        Thread thread = this.buildThread(this.buildRunnablePush(slowStack, "first"));
        thread.start();
        Thread.sleep(TWO_TICKS);
        SynchronizedStackTests.assertEquals((boolean)empty, (boolean)slowStack.isEmpty());
        thread.join();
        SynchronizedStackTests.assertEquals((String)"first", (String)((String)slowStack.pop()));
        SynchronizedStackTests.assertTrue((boolean)slowStack.isEmpty());
    }

    public void testWaitUntilEmpty() throws Exception {
        this.verifyWaitUntilEmpty(-1L);
        SynchronizedStackTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedStackTests.assertSame((Object)ITEM_1, (Object)this.poppedObject);
        SynchronizedStackTests.assertTrue((boolean)this.ss.isEmpty());
        SynchronizedStackTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitUntilEmpty2() throws Exception {
        this.verifyWaitUntilEmpty(0L);
        SynchronizedStackTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedStackTests.assertSame((Object)ITEM_1, (Object)this.poppedObject);
        SynchronizedStackTests.assertTrue((boolean)this.ss.isEmpty());
        SynchronizedStackTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitUntilEmptyTimeout() throws Exception {
        this.verifyWaitUntilEmpty(TICK);
        SynchronizedStackTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedStackTests.assertSame((Object)ITEM_1, (Object)this.poppedObject);
        SynchronizedStackTests.assertTrue((boolean)this.ss.isEmpty());
        SynchronizedStackTests.assertTrue((this.calculateElapsedTime() < THREE_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitUntilEmpty(long timeout) throws Exception {
        this.ss.push((Object)ITEM_1);
        Runnable r1 = this.buildRunnable(this.buildPopCommand(), this.ss, TWO_TICKS);
        Runnable r2 = this.buildRunnable(this.buildWaitUntilEmptyCommand(timeout), this.ss, 0L);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    private Command buildWaitUntilEmptyCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedStack<String> synchronizedStack) throws InterruptedException {
                SynchronizedStackTests.this.startTime = System.currentTimeMillis();
                SynchronizedStackTests.this.timeoutOccurred = this.timeoutOccurred(synchronizedStack);
                SynchronizedStackTests.this.endTime = System.currentTimeMillis();
            }

            private boolean timeoutOccurred(SynchronizedStack<String> synchronizedStack) throws InterruptedException {
                if (timeout < 0L) {
                    synchronizedStack.waitUntilEmpty();
                    return false;
                }
                return !synchronizedStack.waitUntilEmpty(timeout);
            }
        };
    }

    public void testWaitUntilNotEmpty() throws Exception {
        this.verifyWaitUntilNotEmpty(-1L);
        SynchronizedStackTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedStackTests.assertFalse((boolean)this.ss.isEmpty());
        SynchronizedStackTests.assertSame((Object)ITEM_1, (Object)this.ss.peek());
        SynchronizedStackTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitUntilNotEmpty2() throws Exception {
        this.verifyWaitUntilNotEmpty(0L);
        SynchronizedStackTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedStackTests.assertFalse((boolean)this.ss.isEmpty());
        SynchronizedStackTests.assertSame((Object)ITEM_1, (Object)this.ss.peek());
        SynchronizedStackTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitUntilNotEmptyTimeout() throws Exception {
        this.verifyWaitUntilNotEmpty(TICK);
        SynchronizedStackTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedStackTests.assertFalse((boolean)this.ss.isEmpty());
        SynchronizedStackTests.assertSame((Object)ITEM_1, (Object)this.ss.peek());
        SynchronizedStackTests.assertTrue((this.calculateElapsedTime() < THREE_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitUntilNotEmpty(long timeout) throws Exception {
        Runnable r1 = this.buildRunnable(this.buildPushCommand(), this.ss, TWO_TICKS);
        Runnable r2 = this.buildRunnable(this.buildWaitUntilNotEmptyCommand(timeout), this.ss, 0L);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    private Command buildWaitUntilNotEmptyCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedStack<String> synchronizedStack) throws InterruptedException {
                SynchronizedStackTests.this.startTime = System.currentTimeMillis();
                SynchronizedStackTests.this.timeoutOccurred = this.timeoutOccurred(synchronizedStack);
                SynchronizedStackTests.this.endTime = System.currentTimeMillis();
            }

            private boolean timeoutOccurred(SynchronizedStack<String> synchronizedStack) throws InterruptedException {
                if (timeout < 0L) {
                    synchronizedStack.waitUntilNotEmpty();
                    return false;
                }
                return !synchronizedStack.waitUntilNotEmpty(timeout);
            }
        };
    }

    public void testWaitToPop() throws Exception {
        this.verifyWaitToPop(-1L);
        SynchronizedStackTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedStackTests.assertSame((Object)ITEM_1, (Object)this.poppedObject);
        SynchronizedStackTests.assertTrue((boolean)this.ss.isEmpty());
        SynchronizedStackTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitToPop2() throws Exception {
        this.verifyWaitToPop(0L);
        SynchronizedStackTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedStackTests.assertSame((Object)ITEM_1, (Object)this.poppedObject);
        SynchronizedStackTests.assertTrue((boolean)this.ss.isEmpty());
        SynchronizedStackTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitToPopTimeout() throws Exception {
        this.verifyWaitToPop(TICK);
        SynchronizedStackTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedStackTests.assertNull((Object)this.poppedObject);
        SynchronizedStackTests.assertSame((Object)ITEM_1, (Object)this.ss.peek());
        SynchronizedStackTests.assertTrue((this.calculateElapsedTime() < THREE_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitToPop(long timeout) throws Exception {
        Runnable r1 = this.buildRunnable(this.buildPushCommand(), this.ss, TWO_TICKS);
        Runnable r2 = this.buildRunnable(this.buildWaitToPopCommand(timeout), this.ss, 0L);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    private Command buildWaitToPopCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedStack<String> synchronizedStack) throws InterruptedException {
                SynchronizedStackTests.this.startTime = System.currentTimeMillis();
                this.waitToPop(synchronizedStack);
                SynchronizedStackTests.this.endTime = System.currentTimeMillis();
            }

            private void waitToPop(SynchronizedStack<String> synchronizedStack) throws InterruptedException {
                if (timeout < 0L) {
                    SynchronizedStackTests.this.poppedObject = synchronizedStack.waitToPop();
                    return;
                }
                try {
                    SynchronizedStackTests.this.poppedObject = synchronizedStack.waitToPop(timeout);
                }
                catch (EmptyStackException emptyStackException) {
                    SynchronizedStackTests.this.timeoutOccurred = true;
                }
            }
        };
    }

    public void testWaitToPush() throws Exception {
        this.verifyWaitToPush(-1L);
        SynchronizedStackTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedStackTests.assertSame((Object)ITEM_1, (Object)this.poppedObject);
        SynchronizedStackTests.assertFalse((boolean)this.ss.isEmpty());
        SynchronizedStackTests.assertSame((Object)ITEM_2, (Object)this.ss.peek());
        SynchronizedStackTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitToPush2() throws Exception {
        this.verifyWaitToPush(0L);
        SynchronizedStackTests.assertFalse((boolean)this.timeoutOccurred);
        SynchronizedStackTests.assertSame((Object)ITEM_1, (Object)this.poppedObject);
        SynchronizedStackTests.assertFalse((boolean)this.ss.isEmpty());
        SynchronizedStackTests.assertSame((Object)ITEM_2, (Object)this.ss.peek());
        SynchronizedStackTests.assertTrue((this.calculateElapsedTime() > TICK ? 1 : 0) != 0);
    }

    public void testWaitToPushTimeout() throws Exception {
        this.verifyWaitToPush(TICK);
        SynchronizedStackTests.assertTrue((boolean)this.timeoutOccurred);
        SynchronizedStackTests.assertSame((Object)ITEM_1, (Object)this.poppedObject);
        SynchronizedStackTests.assertTrue((boolean)this.ss.isEmpty());
        SynchronizedStackTests.assertTrue((this.calculateElapsedTime() < THREE_TICKS ? 1 : 0) != 0);
    }

    private void verifyWaitToPush(long timeout) throws Exception {
        this.ss.push((Object)ITEM_1);
        Runnable r1 = this.buildRunnable(this.buildPopCommand(), this.ss, TWO_TICKS);
        Runnable r2 = this.buildRunnable(this.buildWaitToPushCommand(timeout), this.ss, 0L);
        Thread t1 = this.buildThread(r1);
        Thread t2 = this.buildThread(r2);
        t1.start();
        t2.start();
        t1.join();
        t2.join();
    }

    private Command buildWaitToPushCommand(final long timeout) {
        return new Command(){

            @Override
            public void execute(SynchronizedStack<String> synchronizedStack) throws InterruptedException {
                SynchronizedStackTests.this.startTime = System.currentTimeMillis();
                SynchronizedStackTests.this.timeoutOccurred = this.timeoutOccurred(synchronizedStack);
                SynchronizedStackTests.this.endTime = System.currentTimeMillis();
            }

            private boolean timeoutOccurred(SynchronizedStack<String> synchronizedStack) throws InterruptedException {
                if (timeout < 0L) {
                    synchronizedStack.waitToPush((Object)ITEM_2);
                    return false;
                }
                return !synchronizedStack.waitToPush((Object)ITEM_2, timeout);
            }
        };
    }

    private Command buildPushCommand() {
        return new Command(){

            @Override
            public void execute(SynchronizedStack<String> synchronizedStack) {
                synchronizedStack.push((Object)ITEM_1);
            }
        };
    }

    private Command buildPopCommand() {
        return new Command(){

            @Override
            public void execute(SynchronizedStack<String> synchronizedStack) {
                SynchronizedStackTests.this.poppedObject = synchronizedStack.pop();
            }
        };
    }

    private Runnable buildRunnable(final Command command, final SynchronizedStack<String> synchronizedStack, final long sleep) {
        return new MultiThreadedTestCase.TestRunnable(this){

            @Override
            protected void run_() throws Throwable {
                if (sleep != 0L) {
                    Thread.sleep(sleep);
                }
                command.execute((SynchronizedStack<String>)synchronizedStack);
            }
        };
    }

    long calculateElapsedTime() {
        return this.endTime - this.startTime;
    }

    public void testExecute() throws Exception {
        org.eclipse.jpt.common.utility.command.Command command = new org.eclipse.jpt.common.utility.command.Command(){

            public void execute() {
                SynchronizedStackTests.this.commandExecuted = true;
            }
        };
        this.commandExecuted = false;
        this.ss.execute(command);
        SynchronizedStackTests.assertTrue((boolean)this.commandExecuted);
    }

    public void testPushAllIterable() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        list.add("two");
        list.add("three");
        this.ss.pushAll(list);
        SynchronizedStackTests.assertEquals((String)"three", (String)((String)this.ss.pop()));
        SynchronizedStackTests.assertEquals((String)"two", (String)((String)this.ss.pop()));
        SynchronizedStackTests.assertEquals((String)"one", (String)((String)this.ss.pop()));
        SynchronizedStackTests.assertTrue((boolean)this.ss.isEmpty());
    }

    public void testPushAllIterable_empty() throws Exception {
        ArrayList list = new ArrayList();
        this.ss.pushAll(list);
        SynchronizedStackTests.assertTrue((boolean)this.ss.isEmpty());
    }

    public void testPushAllObjectArray() throws Exception {
        this.ss.pushAll((Object[])new String[]{"one", "two", "three"});
        SynchronizedStackTests.assertEquals((String)"three", (String)((String)this.ss.pop()));
        SynchronizedStackTests.assertEquals((String)"two", (String)((String)this.ss.pop()));
        SynchronizedStackTests.assertEquals((String)"one", (String)((String)this.ss.pop()));
        SynchronizedStackTests.assertTrue((boolean)this.ss.isEmpty());
    }

    public void testPushAllObjectArray_empty() throws Exception {
        this.ss.pushAll((Object[])new String[0]);
        SynchronizedStackTests.assertTrue((boolean)this.ss.isEmpty());
    }

    public void testPushAllStack() throws Exception {
        ArrayStack s2 = StackTools.arrayStack();
        s2.push((Object)"one");
        s2.push((Object)"two");
        s2.push((Object)"three");
        this.ss.pushAll((Stack)s2);
        SynchronizedStackTests.assertEquals((String)"one", (String)((String)this.ss.pop()));
        SynchronizedStackTests.assertEquals((String)"two", (String)((String)this.ss.pop()));
        SynchronizedStackTests.assertEquals((String)"three", (String)((String)this.ss.pop()));
        SynchronizedStackTests.assertTrue((boolean)this.ss.isEmpty());
    }

    public void testPushAllStack_empty() throws Exception {
        ArrayStack s2 = StackTools.arrayStack();
        this.ss.pushAll((Stack)s2);
        SynchronizedStackTests.assertTrue((boolean)this.ss.isEmpty());
    }

    public void testPushAllQueue() throws Exception {
        ArrayQueue queue = QueueTools.arrayQueue();
        queue.enqueue((Object)"one");
        queue.enqueue((Object)"two");
        queue.enqueue((Object)"three");
        this.ss.pushAll((Queue)queue);
        SynchronizedStackTests.assertEquals((String)"three", (String)((String)this.ss.pop()));
        SynchronizedStackTests.assertEquals((String)"two", (String)((String)this.ss.pop()));
        SynchronizedStackTests.assertEquals((String)"one", (String)((String)this.ss.pop()));
        SynchronizedStackTests.assertTrue((boolean)this.ss.isEmpty());
    }

    public void testPushAllQueue_empty() throws Exception {
        ArrayQueue queue = QueueTools.arrayQueue();
        this.ss.pushAll((Queue)queue);
        SynchronizedStackTests.assertTrue((boolean)this.ss.isEmpty());
    }

    public void testPopAll() throws Exception {
        this.ss.push((Object)"one");
        this.ss.push((Object)"two");
        this.ss.push((Object)"three");
        ArrayList list = this.ss.popAll();
        SynchronizedStackTests.assertTrue((boolean)this.ss.isEmpty());
        SynchronizedStackTests.assertEquals((String)"three", (String)((String)list.get(0)));
        SynchronizedStackTests.assertEquals((String)"two", (String)((String)list.get(1)));
        SynchronizedStackTests.assertEquals((String)"one", (String)((String)list.get(2)));
    }

    public void testPopAll_empty() throws Exception {
        ArrayList list = this.ss.popAll();
        SynchronizedStackTests.assertTrue((boolean)this.ss.isEmpty());
        SynchronizedStackTests.assertTrue((boolean)list.isEmpty());
    }

    public void testPopAllToCollection() throws Exception {
        this.ss.push((Object)"one");
        this.ss.push((Object)"two");
        this.ss.push((Object)"three");
        ArrayList list = new ArrayList();
        SynchronizedStackTests.assertTrue((boolean)this.ss.popAllTo(list));
        SynchronizedStackTests.assertTrue((boolean)this.ss.isEmpty());
        SynchronizedStackTests.assertEquals((String)"three", (String)((String)list.get(0)));
        SynchronizedStackTests.assertEquals((String)"two", (String)((String)list.get(1)));
        SynchronizedStackTests.assertEquals((String)"one", (String)((String)list.get(2)));
    }

    public void testPopAllToCollection_empty() throws Exception {
        ArrayList list = new ArrayList();
        SynchronizedStackTests.assertFalse((boolean)this.ss.popAllTo(list));
        SynchronizedStackTests.assertTrue((boolean)this.ss.isEmpty());
        SynchronizedStackTests.assertTrue((boolean)list.isEmpty());
    }

    public void testPopAllToListInt() throws Exception {
        this.ss.push((Object)"one");
        this.ss.push((Object)"two");
        this.ss.push((Object)"three");
        ArrayList<String> list = new ArrayList<String>();
        list.add("aaa");
        list.add("bbb");
        list.add("ccc");
        SynchronizedStackTests.assertTrue((boolean)this.ss.popAllTo(list, 2));
        SynchronizedStackTests.assertEquals((String)"aaa", (String)((String)list.get(0)));
        SynchronizedStackTests.assertEquals((String)"bbb", (String)((String)list.get(1)));
        SynchronizedStackTests.assertEquals((String)"three", (String)((String)list.get(2)));
        SynchronizedStackTests.assertEquals((String)"two", (String)((String)list.get(3)));
        SynchronizedStackTests.assertEquals((String)"one", (String)((String)list.get(4)));
        SynchronizedStackTests.assertEquals((String)"ccc", (String)((String)list.get(5)));
    }

    public void testPopAllToListInt_end() throws Exception {
        this.ss.push((Object)"one");
        this.ss.push((Object)"two");
        this.ss.push((Object)"three");
        ArrayList<String> list = new ArrayList<String>();
        list.add("aaa");
        list.add("bbb");
        list.add("ccc");
        SynchronizedStackTests.assertTrue((boolean)this.ss.popAllTo(list, 3));
        SynchronizedStackTests.assertEquals((String)"aaa", (String)((String)list.get(0)));
        SynchronizedStackTests.assertEquals((String)"bbb", (String)((String)list.get(1)));
        SynchronizedStackTests.assertEquals((String)"ccc", (String)((String)list.get(2)));
        SynchronizedStackTests.assertEquals((String)"three", (String)((String)list.get(3)));
        SynchronizedStackTests.assertEquals((String)"two", (String)((String)list.get(4)));
        SynchronizedStackTests.assertEquals((String)"one", (String)((String)list.get(5)));
    }

    public void testPopAllToListInt_empty() throws Exception {
        ArrayList<String> list = new ArrayList<String>();
        list.add("aaa");
        list.add("bbb");
        list.add("ccc");
        SynchronizedStackTests.assertFalse((boolean)this.ss.popAllTo(list, 2));
        SynchronizedStackTests.assertEquals((String)"aaa", (String)((String)list.get(0)));
        SynchronizedStackTests.assertEquals((String)"bbb", (String)((String)list.get(1)));
        SynchronizedStackTests.assertEquals((String)"ccc", (String)((String)list.get(2)));
    }

    public void testPopAllToStack() throws Exception {
        this.ss.push((Object)"one");
        this.ss.push((Object)"two");
        this.ss.push((Object)"three");
        ArrayStack s2 = StackTools.arrayStack();
        SynchronizedStackTests.assertTrue((boolean)this.ss.popAllTo((Stack)s2));
        SynchronizedStackTests.assertTrue((boolean)this.ss.isEmpty());
        SynchronizedStackTests.assertEquals((String)"one", (String)((String)s2.pop()));
        SynchronizedStackTests.assertEquals((String)"two", (String)((String)s2.pop()));
        SynchronizedStackTests.assertEquals((String)"three", (String)((String)s2.pop()));
        SynchronizedStackTests.assertTrue((boolean)s2.isEmpty());
    }

    public void testPopAllToStack_empty() throws Exception {
        ArrayStack s2 = StackTools.arrayStack();
        SynchronizedStackTests.assertFalse((boolean)this.ss.popAllTo((Stack)s2));
        SynchronizedStackTests.assertTrue((boolean)this.ss.isEmpty());
        SynchronizedStackTests.assertTrue((boolean)s2.isEmpty());
    }

    public void testPopAllToQueue() throws Exception {
        this.ss.push((Object)"one");
        this.ss.push((Object)"two");
        this.ss.push((Object)"three");
        ArrayQueue queue = QueueTools.arrayQueue();
        SynchronizedStackTests.assertTrue((boolean)this.ss.popAllTo((Queue)queue));
        SynchronizedStackTests.assertTrue((boolean)this.ss.isEmpty());
        SynchronizedStackTests.assertEquals((String)"three", (String)((String)queue.dequeue()));
        SynchronizedStackTests.assertEquals((String)"two", (String)((String)queue.dequeue()));
        SynchronizedStackTests.assertEquals((String)"one", (String)((String)queue.dequeue()));
        SynchronizedStackTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testPopAllToQueue_empty() throws Exception {
        ArrayQueue queue = QueueTools.arrayQueue();
        SynchronizedStackTests.assertFalse((boolean)this.ss.popAllTo((Queue)queue));
        SynchronizedStackTests.assertTrue((boolean)this.ss.isEmpty());
        SynchronizedStackTests.assertTrue((boolean)queue.isEmpty());
    }

    public void testPopAllToMapTransformer() {
        this.ss.push((Object)"one");
        this.ss.push((Object)"two");
        this.ss.push((Object)"zero");
        HashMap map = new HashMap();
        SynchronizedStackTests.assertTrue((boolean)this.ss.popAllTo(map, DequeToolsTests.FIRST_LETTER_TRANSFORMER));
        SynchronizedStackTests.assertEquals((String)"one", (String)((String)map.get("o")));
        SynchronizedStackTests.assertEquals((String)"two", (String)((String)map.get("t")));
        SynchronizedStackTests.assertEquals((String)"zero", (String)((String)map.get("z")));
    }

    public void testPopAllToMapTransformer_empty() {
        HashMap map = new HashMap();
        SynchronizedStackTests.assertFalse((boolean)this.ss.popAllTo(map, DequeToolsTests.FIRST_LETTER_TRANSFORMER));
        SynchronizedStackTests.assertTrue((boolean)map.isEmpty());
    }

    public void testPopAllToMapTransformerTransformer() {
        this.ss.push((Object)"one");
        this.ss.push((Object)"two");
        this.ss.push((Object)"zero");
        HashMap map = new HashMap();
        SynchronizedStackTests.assertTrue((boolean)this.ss.popAllTo(map, DequeToolsTests.FIRST_LETTER_TRANSFORMER, DequeToolsTests.EMPHASIZER));
        SynchronizedStackTests.assertEquals((String)"*one*", (String)((String)map.get("o")));
        SynchronizedStackTests.assertEquals((String)"*two*", (String)((String)map.get("t")));
        SynchronizedStackTests.assertEquals((String)"*zero*", (String)((String)map.get("z")));
    }

    public void testPopAllToMapTransformerTransformer_empty() {
        HashMap map = new HashMap();
        SynchronizedStackTests.assertFalse((boolean)this.ss.popAllTo(map, DequeToolsTests.FIRST_LETTER_TRANSFORMER, DequeToolsTests.EMPHASIZER));
        SynchronizedStackTests.assertTrue((boolean)map.isEmpty());
    }

    private static interface Command {
        public void execute(SynchronizedStack<String> var1) throws InterruptedException;
    }

    private class SlowLinkedStack<E>
    extends LinkedStack<E>
    implements SlowStack<E> {
        private static final long serialVersionUID = 1L;

        SlowLinkedStack() {
        }

        @Override
        public Object slowPop() {
            try {
                Thread.sleep(5L * TICK);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            return this.pop();
        }

        @Override
        public void slowPush(E element) {
            try {
                Thread.sleep(5L * TICK);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            this.push(element);
        }
    }

    private static interface SlowStack<E>
    extends Stack<E> {
        public Object slowPop();

        public void slowPush(E var1);
    }

    private class SlowSynchronizedStack<E>
    extends SynchronizedStack<E>
    implements SlowStack<E> {
        private static final long serialVersionUID = 1L;

        SlowSynchronizedStack() {
            super((Stack)StackTools.linkedStack());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object slowPop() {
            Object object = this.getMutex();
            synchronized (object) {
                try {
                    Thread.sleep(5L * TICK);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                return this.pop();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void slowPush(E element) {
            Object object = this.getMutex();
            synchronized (object) {
                try {
                    Thread.sleep(5L * TICK);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                this.push(element);
            }
        }
    }
}

