/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.internal.debug.ui;

import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XMLProcessingInstructionSniffer
extends DefaultHandler {
    private Map<String, List<Map<String, String>>> processingInstructions = new TreeMap<String, List<Map<String, String>>>();
    Pattern PSEUDO_ATTRIBUTES_REGEX = Pattern.compile("\\s*(\\w+)\\s*=\\s*['\"]([^'\"]+)['\"]\\s*");

    void addInstruction(String key, Map<String, String> attributes) {
        List<Map<String, String>> list = this.processingInstructions.get(key);
        if (list == null) {
            list = new LinkedList<Map<String, String>>();
            this.processingInstructions.put(key, list);
        }
        list.add(attributes);
    }

    public List<Map<String, String>> getProcessingInstructions(String key) {
        return this.processingInstructions.get(key);
    }

    private Map<String, String> parsePseudoAttributes(String pseudoAttributes) {
        TreeMap<String, String> attrs = new TreeMap<String, String>();
        Matcher matcher = this.PSEUDO_ATTRIBUTES_REGEX.matcher(pseudoAttributes);
        while (matcher.find()) {
            String value = matcher.group(2);
            attrs.put(matcher.group(1), value);
        }
        return attrs;
    }

    private final SAXParser createParser(SAXParserFactory parserFactory) throws ParserConfigurationException, SAXException, SAXNotRecognizedException, SAXNotSupportedException {
        SAXParser parser = parserFactory.newSAXParser();
        XMLReader reader = parser.getXMLReader();
        try {
            reader.setFeature("http://xml.org/sax/features/validation", false);
            reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {}
        return parser;
    }

    public boolean parseContents(InputSource contents) throws IOException, ParserConfigurationException, SAXException {
        try {
            SAXParser parser = this.createParser(SAXParserFactory.newInstance());
            contents.setSystemId("/");
            parser.parse(contents, (DefaultHandler)this);
        }
        catch (StopParsingException stopParsingException) {}
        return true;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return new InputSource(new StringReader(""));
    }

    @Override
    public final void startElement(String uri, String elementName, String qualifiedName, Attributes attributes) throws SAXException {
        throw new StopParsingException();
    }

    public final void startEntity(String name) {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.addInstruction(target, this.parsePseudoAttributes(data));
    }

    private class StopParsingException
    extends SAXException {
        private static final long serialVersionUID = 1L;

        public StopParsingException() {
            super((String)null);
        }
    }
}

