/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.design.editparts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FocusEvent;
import org.eclipse.draw2d.FocusListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.KeyEvent;
import org.eclipse.draw2d.KeyListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xsd.ui.internal.adt.actions.SetInputToGraphView;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.BaseEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.editor.Messages;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IModel;
import org.eclipse.wst.xsd.ui.internal.design.figures.CenteredIconFigure;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;

public class ADTFloatingToolbarEditPart
extends BaseEditPart {
    protected IModel model;
    protected boolean isDrilledDown;
    protected ADTToolbarButton backToSchema;

    public ADTFloatingToolbarEditPart(IModel model) {
        this.model = model;
    }

    protected IFigure createFigure() {
        Figure figure = new Figure();
        ToolbarLayout tb = new ToolbarLayout(true);
        tb.setStretchMinorAxis(false);
        tb.setSpacing(3);
        figure.setLayoutManager((LayoutManager)tb);
        this.backToSchema = new ADTToolbarButton(XSDEditorPlugin.getPlugin().getIcon("elcl16/schemaview_co.gif"));
        this.backToSchema.setToolTipText(Messages._UI_HOVER_BACK_TO_SCHEMA);
        this.backToSchema.setBackgroundColor(ColorConstants.white);
        this.backToSchema.setFocusTraversable(true);
        figure.add((IFigure)this.backToSchema);
        figure.setBounds(new Rectangle(0, 0, 24, 24));
        this.addToToolbar((IFigure)figure);
        return figure;
    }

    protected void addToToolbar(IFigure figure) {
    }

    public void setIsDrilledDown(boolean isDrilledDown) {
        this.isDrilledDown = isDrilledDown;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        this.backToSchema.isEnabled = this.isDrilledDown;
        this.backToSchema.image = this.isDrilledDown ? XSDEditorPlugin.getPlugin().getIcon("elcl16/schemaview_co.gif") : XSDEditorPlugin.getPlugin().getIcon("dlcl16/schemaview_co.gif");
        this.backToSchema.refresh();
    }

    protected void doAction(MouseEvent me) {
        IEditorPart editorPart = this.getActionEditorPart();
        if (this.backToSchema.getBounds().contains(me.getLocation())) {
            SetInputToGraphView action = new SetInputToGraphView((IWorkbenchPart)editorPart, this.model);
            action.run();
        }
    }

    protected void doAction(KeyEvent ke) {
        IEditorPart editorPart = this.getActionEditorPart();
        SetInputToGraphView action = new SetInputToGraphView((IWorkbenchPart)editorPart, this.model);
        action.run();
    }

    private IEditorPart getActionEditorPart() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        IEditorPart editorPart = workbenchWindow.getActivePage().getActiveEditor();
        return editorPart;
    }

    protected class ADTToolbarButton
    extends CenteredIconFigure {
        protected MouseListener mouseListener;
        protected KeyListener keyListener;
        protected FocusListener focusListener;
        public boolean isEnabled;

        public ADTToolbarButton(Image img) {
            this.image = img;
            this.mouseListener = new MouseListener.Stub(this){
                final /* synthetic */ ADTToolbarButton this$1;
                {
                    this.this$1 = aDTToolbarButton;
                }

                public void mousePressed(MouseEvent me) {
                    if (this.this$1.isEnabled) {
                        this.this$1.addFeedback();
                    }
                }

                public void mouseReleased(MouseEvent me) {
                    if (this.this$1.isEnabled) {
                        this.this$1.removeFeedback();
                        ADTToolbarButton.access$0(this.this$1).doAction(me);
                    }
                }
            };
            this.addMouseListener(this.mouseListener);
            this.addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(this){
                final /* synthetic */ ADTToolbarButton this$1;
                {
                    this.this$1 = aDTToolbarButton;
                }

                public void mouseExited(MouseEvent me) {
                    this.this$1.removeFeedback();
                }
            });
            this.keyListener = new KeyListener.Stub(this){
                final /* synthetic */ ADTToolbarButton this$1;
                {
                    this.this$1 = aDTToolbarButton;
                }

                public void keyPressed(KeyEvent ke) {
                    boolean isValidKey = ke.keycode == 32;
                    boolean bl = isValidKey = isValidKey || ke.character == '\r' || ke.character == '\n';
                    if (this.this$1.isEnabled && isValidKey) {
                        this.this$1.addFeedback();
                    }
                }

                public void keyReleased(KeyEvent ke) {
                    boolean isValidKey = ke.keycode == 32;
                    boolean bl = isValidKey = isValidKey || ke.character == '\r' || ke.character == '\n';
                    if (this.this$1.isEnabled && isValidKey) {
                        this.this$1.removeFeedback();
                        ADTToolbarButton.access$0(this.this$1).doAction(ke);
                    }
                }
            };
            this.addKeyListener(this.keyListener);
            this.focusListener = new FocusListener(this){
                final /* synthetic */ ADTToolbarButton this$1;
                {
                    this.this$1 = aDTToolbarButton;
                }

                public void focusGained(FocusEvent fe) {
                    this.this$1.setMode(2);
                    this.this$1.refresh();
                }

                public void focusLost(FocusEvent fe) {
                    this.this$1.setMode(0);
                    this.this$1.refresh();
                }
            };
            this.addFocusListener(this.focusListener);
        }

        public void addFeedback() {
            this.setMode(1);
            this.refresh();
        }

        public void removeFeedback() {
            this.setMode(0);
            this.refresh();
        }

        public Rectangle getBounds() {
            Rectangle r = super.getBounds();
            org.eclipse.swt.graphics.Rectangle rect = this.image.getBounds();
            return new Rectangle(r.x, r.y, rect.width + 8, rect.height + 8);
        }

        public Dimension getPreferredSize(int hint, int hint2) {
            org.eclipse.swt.graphics.Rectangle rect = this.image.getBounds();
            return new Dimension(rect.width + 8, rect.height + 8);
        }

        static /* synthetic */ ADTFloatingToolbarEditPart access$0(ADTToolbarButton aDTToolbarButton) {
            return aDTToolbarButton.ADTFloatingToolbarEditPart.this;
        }
    }
}

