/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.tests.model;

import junit.framework.Test;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.tests.model.ModifyingResourceTests;

public class LocalElementTests
extends ModifyingResourceTests {
    public LocalElementTests(String name) {
        super(name);
    }

    public static Test suite() {
        return LocalElementTests.buildModelTestSuite(LocalElementTests.class);
    }

    @Override
    public void setUpSuite() throws Exception {
        this.createJavaProject("P");
    }

    @Override
    public void tearDownSuite() throws Exception {
        this.deleteProject("P");
    }

    public void testAnonymousType1() throws CoreException {
        try {
            this.createFile("/P/X.js", "public class X {\n  void foo() {\n    run(new X() {\n    });\n  }\n  void run(X x) {\n  }\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("/P/X.js");
            this.assertElementDescendants("Unexpected compilation unit contents", "X.java\n  class X\n    void foo()\n      class <anonymous #1>\n    void run(X)", (IJavaScriptElement)cu);
        }
        finally {
            this.deleteFile("/P/X.js");
        }
    }

    public void testAnonymousType2() throws CoreException {
        try {
            this.createFile("/P/X.js", "public class X {\n  public class Y {\n  }\n  void foo() {\n    run(new X() {\n    });\n    run(new Y() {\n    });\n  }\n  void run(X x) {\n  }\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("/P/X.js");
            this.assertElementDescendants("Unexpected compilation unit contents", "X.java\n  class X\n    class Y\n    void foo()\n      class <anonymous #1>\n      class <anonymous #2>\n    void run(X)", (IJavaScriptElement)cu);
        }
        finally {
            this.deleteFile("/P/X.js");
        }
    }

    public void testAnonymousType3() throws CoreException {
        try {
            this.createFile("/P/X.js", "public class X {\n  void foo() {\n    run(new X() {\n      void bar() {\n        run(new X() {\n        });\n      }\n    });\n  }\n  void run(X x) {\n  }\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("/P/X.js");
            this.assertElementDescendants("Unexpected compilation unit contents", "X.java\n  class X\n    void foo()\n      class <anonymous #1>\n        void bar()\n          class <anonymous #1>\n    void run(X)", (IJavaScriptElement)cu);
        }
        finally {
            this.deleteFile("/P/X.js");
        }
    }

    public void testAnonymousType4() throws CoreException {
        try {
            this.createFile("/P/X.js", "public class X {\n  {\n      field = new Vector() {\n      };\n  }\n  Object field = new Object() {\n  };\n  void foo() {\n    run(new X() {\n    });\n  }\n  void run(X x) {\n  }\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("/P/X.js");
            this.assertElementDescendants("Unexpected compilation unit contents", "X.java\n  class X\n    <initializer #1>\n      class <anonymous #1>\n    Object field\n      class <anonymous #1>\n    void foo()\n      class <anonymous #1>\n    void run(X)", (IJavaScriptElement)cu);
        }
        finally {
            this.deleteFile("/P/X.js");
        }
    }

    public void testAnonymousType5() throws CoreException {
        try {
            this.createFile("/P/X.js", "public class X {\n  X(Object o) {\n  }\n}\nclass Y extends X {\n  Y() {\n    super(new Object() {});\n  }\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("/P/X.js");
            this.assertElementDescendants("Unexpected compilation unit contents", "X.java\n  class X\n    X(Object)\n  class Y\n    Y()\n      class <anonymous #1>", (IJavaScriptElement)cu);
        }
        finally {
            this.deleteFile("/P/X.js");
        }
    }

    public void testAnonymousType6() throws CoreException {
        try {
            this.createJavaProject("P15", new String[]{""}, new String[]{"JCL15_LIB"}, "", "1.5");
            this.createFile("/P15/En.js", "public enum En {\n  CONST() {};\n}");
            IType type = this.getCompilationUnit("/P15/En.js").getType("En").getField("CONST").getType("", 1);
            LocalElementTests.assertTrue((String)"Should be a local type", (boolean)type.isLocal());
        }
        finally {
            this.deleteProject("P15");
        }
    }

    public void testAnonymousType7() throws CoreException {
        try {
            this.createFile("/P/X.js", "public class X {\n\tclass Y {\n\t}\n\t{\n\t\tnew Y() {\n\t\t\tclass Z {\n\t\t\t}\n\t\t\t{\n\t\t\t\tnew Y() {\n\t\t\t\t};\n\t\t\t}\n\t\t};\n\t}\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("/P/X.js");
            this.assertElementDescendants("Unexpected compilation unit contents", "X.java\n  class X\n    class Y\n    <initializer #1>\n      class <anonymous #1>\n        class Z\n        <initializer #1>\n          class <anonymous #1>", (IJavaScriptElement)cu);
        }
        finally {
            this.deleteFile("/P/X.js");
        }
    }

    public void testGetSuperclassName() throws CoreException {
        try {
            this.createFile("/P/X.js", "public class X {\n  void foo() {\n    run(new X() {\n    });\n  }\n  void run(X x) {\n  }\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("/P/X.js");
            IType type = cu.getType("X").getFunction("foo", new String[0]).getType("", 1);
            LocalElementTests.assertEquals((String)"Unexpected superclass name", (String)"X", (String)type.getSuperclassName());
        }
        finally {
            this.deleteFile("/P/X.js");
        }
    }

    public void testGetType() {
        IJavaScriptUnit cu = this.getCompilationUnit("P/X.js");
        IType topLevelType = cu.getType("X");
        IJavaScriptElement[] types = new IJavaScriptElement[]{topLevelType.getInitializer(1).getType("", 1), topLevelType.getInitializer(1).getType("Y", 1), topLevelType.getField("f").getType("", 1), topLevelType.getFunction("foo", new String[]{"I", "QString;"}).getType("", 1), topLevelType.getFunction("foo", new String[]{"I", "QString;"}).getType("Z", 1)};
        this.assertElementsEqual("Unexpected types", "<anonymous #1> [in <initializer #1> [in X [in X.java [in <default> [in <project root> [in P]]]]]]\nY [in <initializer #1> [in X [in X.java [in <default> [in <project root> [in P]]]]]]\n<anonymous #1> [in f [in X [in X.java [in <default> [in <project root> [in P]]]]]]\n<anonymous #1> [in foo(int, String) [in X [in X.java [in <default> [in <project root> [in P]]]]]]\nZ [in foo(int, String) [in X [in X.java [in <default> [in <project root> [in P]]]]]]", types);
    }

    public void testLocalType1() throws CoreException {
        try {
            this.createFile("/P/X.js", "public class X {\n  void foo() {\n    class Y {\n    }\n  }\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("/P/X.js");
            this.assertElementDescendants("Unexpected compilation unit contents", "X.java\n  class X\n    void foo()\n      class Y", (IJavaScriptElement)cu);
        }
        finally {
            this.deleteFile("/P/X.js");
        }
    }

    public void testLocalType2() throws CoreException {
        try {
            this.createFile("/P/X.js", "public class X {\n  void foo() {\n    class Y {\n    }\n    class Z {\n    }\n  }\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("/P/X.js");
            this.assertElementDescendants("Unexpected compilation unit contents", "X.java\n  class X\n    void foo()\n      class Y\n      class Z", (IJavaScriptElement)cu);
        }
        finally {
            this.deleteFile("/P/X.js");
        }
    }

    public void testLocalType3() throws CoreException {
        try {
            this.createFile("/P/X.js", "public class X {\n  void foo() {\n    class Y {\n      void bar() {\n        class Z {\n        }\n      }\n    }\n  }\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("/P/X.js");
            this.assertElementDescendants("Unexpected compilation unit contents", "X.java\n  class X\n    void foo()\n      class Y\n        void bar()\n          class Z", (IJavaScriptElement)cu);
        }
        finally {
            this.deleteFile("/P/X.js");
        }
    }

    public void testLocalType4() throws CoreException {
        try {
            this.createFile("/P/X.js", "public class X {\n  {\n      class Y {\n      }\n  }\n  void foo() {\n    class Z {\n    }\n  }\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("/P/X.js");
            this.assertElementDescendants("Unexpected compilation unit contents", "X.java\n  class X\n    <initializer #1>\n      class Y\n    void foo()\n      class Z", (IJavaScriptElement)cu);
        }
        finally {
            this.deleteFile("/P/X.js");
        }
    }

    public void testLocalType5() throws CoreException {
        try {
            this.createFile("/P/X.js", "public class X {\n  void foo() {\n    class Z {\n    }\n    Z\n  }\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("/P/X.js");
            this.assertElementDescendants("Unexpected compilation unit contents", "X.java\n  class X\n    void foo()\n      class Z", (IJavaScriptElement)cu);
        }
        finally {
            this.deleteFile("/P/X.js");
        }
    }

    public void _testLocalType6() throws CoreException {
        try {
            this.createFile("/P/X.js", "public class X {\n  void foo() {\n    class Y {\n      {\n        class Z {\n        }\n      }\n    }\n  }\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("/P/X.js");
            this.assertElementDescendants("Unexpected compilation unit contents", "X.java\n  class X\n    void foo()\n      class Y\n        <initializer #1>\n          class Z", (IJavaScriptElement)cu);
        }
        finally {
            this.deleteFile("/P/X.js");
        }
    }

    public void _testLocalType7() throws CoreException {
        try {
            this.createFile("/P/X.js", "public class X {\n  void foo() {\n    class Y {\n      {\n        class Z {\n        }\n      }\n      String s = null;\n    }\n  }\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("/P/X.js");
            this.assertElementDescendants("Unexpected compilation unit contents", "X.java\n  class X\n    void foo()\n      class Y\n        <initializer #1>\n          class Z\n        String s", (IJavaScriptElement)cu);
        }
        finally {
            this.deleteFile("/P/X.js");
        }
    }

    public void _testLocalType8() throws CoreException {
        try {
            this.createFile("/P/X.js", "public class X {\n  void foo() {\n    class Y {\n      String s = null;\n      {\n        class Z {\n        }\n      }\n    }\n  }\n}");
            IJavaScriptUnit cu = this.getCompilationUnit("/P/X.js");
            this.assertElementDescendants("Unexpected compilation unit contents", "X.java\n  class X\n    void foo()\n      class Y\n        String s\n        <initializer #1>\n          class Z", (IJavaScriptElement)cu);
        }
        finally {
            this.deleteFile("/P/X.js");
        }
    }
}

