/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.tests.cache;

import java.io.File;
import junit.framework.TestCase;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.tests.util.FileUtil;
import org.eclipse.wst.xml.core.tests.util.ProjectUnzipUtility;

public class GlobalCMDocumentCacheTest
extends TestCase {
    private static final String ZIP_FILE_NAME = "CMDocumentCacheTestProject.zip";
    private static final String PROJECT_NAME = "CMDocumentCacheTestProject";

    protected void setUp() throws Exception {
        super.setUp();
        Location platformLocation = Platform.getInstanceLocation();
        ProjectUnzipUtility unzipUtil = new ProjectUnzipUtility();
        File zipFile = FileUtil.makeFileFor("projecttestfiles", ZIP_FILE_NAME, "projecttestfiles");
        unzipUtil.unzipAndImport(zipFile, platformLocation.getURL().getFile());
        unzipUtil.initJavaProject(PROJECT_NAME);
    }

    public void testGlobalCMDocumentCacheEnabled() {
        this.setGlobalCacheEnabled(true);
        CMDocument globalCMDocumentCacheTest_1 = this.getCMDocumentFromXMLFile("CMDocumentCacheTestProject/GlobalCMDocumentCacheTest1.xml");
        CMDocument globalCMDocumentCacheTest_2 = this.getCMDocumentFromXMLFile("CMDocumentCacheTestProject/GlobalCMDocumentCacheTest2.xml");
        GlobalCMDocumentCacheTest.assertEquals((Object)globalCMDocumentCacheTest_1, (Object)globalCMDocumentCacheTest_2);
        CMDocument localCMDocument_1 = this.getCMDocumentFromXMLFile("CMDocumentCacheTestProject/document1.xml");
        CMDocument localCMDocument_2 = this.getCMDocumentFromXMLFile("CMDocumentCacheTestProject/document2.xml");
        GlobalCMDocumentCacheTest.assertNotSame((Object)localCMDocument_1, (Object)localCMDocument_2);
    }

    public void testGlobalCMDocumentCacheDisabled() {
        this.setGlobalCacheEnabled(false);
        CMDocument globalCMDocumentCacheTest_1 = this.getCMDocumentFromXMLFile("CMDocumentCacheTestProject/GlobalCMDocumentCacheTest1.xml");
        CMDocument globalCMDocumentCacheTest_2 = this.getCMDocumentFromXMLFile("CMDocumentCacheTestProject/GlobalCMDocumentCacheTest2.xml");
        GlobalCMDocumentCacheTest.assertNotSame((Object)globalCMDocumentCacheTest_1, (Object)globalCMDocumentCacheTest_2);
        CMDocument localCMDocument_1 = this.getCMDocumentFromXMLFile("CMDocumentCacheTestProject/document1.xml");
        CMDocument localCMDocument_2 = this.getCMDocumentFromXMLFile("CMDocumentCacheTestProject/document2.xml");
        GlobalCMDocumentCacheTest.assertNotSame((Object)localCMDocument_1, (Object)localCMDocument_2);
    }

    /*
     * Exception decompiling
     */
    private CMDocument getCMDocumentFromXMLFile(String documentPath) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 140->143)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setGlobalCacheEnabled(boolean value) {
        Preferences pluginPreferences = XMLCorePlugin.getDefault().getPluginPreferences();
        pluginPreferences.setDefault("cmDocumentGlobalCacheEnabled", value);
    }
}

