/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.orm;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.orm.XmlEntity;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConversionValue;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.EclipseLinkOrmBasicMapping;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.orm.EclipseLinkOrmObjectTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.EclipseLinkOrmFactory;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlBasic;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlConversionValue;
import org.eclipse.jpt.jpa.eclipselink.core.resource.orm.XmlObjectTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkOrmObjectTypeConverterTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithBasicMapping() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Basic", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.ObjectTypeConverter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Basic").append(CR);
                sb.append("    @Convert(name=\"foo\")").append(CR);
                sb.append("    @ObjectTypeConverter");
            }
        });
    }

    public EclipseLinkOrmObjectTypeConverterTests(String name) {
        super(name);
    }

    public void testUpdateDataType() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        EclipseLinkOrmBasicMapping ormBasicMapping = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmObjectTypeConverter ormConverter = ormBasicMapping.getConverterContainer().addObjectTypeConverter("objectTypeConverter", 0);
        XmlObjectTypeConverter converterResource = (XmlObjectTypeConverter)((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getObjectTypeConverters().get(0);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getDataType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getDataType());
        converterResource.setDataType("myConvert");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getDataType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"myConvert", (String)converterResource.getDataType());
        converterResource.setDataType(null);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getDataType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getDataType());
    }

    public void testModifyDataType() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        EclipseLinkOrmBasicMapping ormBasicMapping = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmObjectTypeConverter ormConverter = ormBasicMapping.getConverterContainer().addObjectTypeConverter("objectTypeConverter", 0);
        XmlObjectTypeConverter converterResource = (XmlObjectTypeConverter)((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getObjectTypeConverters().get(0);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getDataType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getDataType());
        ormConverter.setDataType("foo");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)ormConverter.getDataType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)converterResource.getDataType());
        ormConverter.setDataType(null);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getDataType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getDataType());
    }

    public void testUpdateObjectType() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        EclipseLinkOrmBasicMapping ormBasicMapping = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmObjectTypeConverter ormConverter = ormBasicMapping.getConverterContainer().addObjectTypeConverter("objectTypeConverter", 0);
        XmlObjectTypeConverter converterResource = (XmlObjectTypeConverter)((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getObjectTypeConverters().get(0);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getObjectType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getObjectType());
        converterResource.setObjectType("myConvert");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getObjectType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"myConvert", (String)converterResource.getObjectType());
        converterResource.setObjectType(null);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getObjectType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getObjectType());
    }

    public void testModifyObjectType() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        EclipseLinkOrmBasicMapping ormBasicMapping = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmObjectTypeConverter ormConverter = ormBasicMapping.getConverterContainer().addObjectTypeConverter("objectTypeConverter", 0);
        XmlObjectTypeConverter converterResource = (XmlObjectTypeConverter)((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getObjectTypeConverters().get(0);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getObjectType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getObjectType());
        ormConverter.setObjectType("foo");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)ormConverter.getObjectType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)converterResource.getObjectType());
        ormConverter.setObjectType(null);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getObjectType());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getObjectType());
    }

    public void testUpdateName() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        EclipseLinkOrmBasicMapping ormBasicMapping = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmObjectTypeConverter ormConverter = ormBasicMapping.getConverterContainer().addObjectTypeConverter("objectTypeConverter", 0);
        XmlObjectTypeConverter converterResource = (XmlObjectTypeConverter)((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getObjectTypeConverters().get(0);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"objectTypeConverter", (String)ormConverter.getName());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"objectTypeConverter", (String)converterResource.getName());
        converterResource.setName("myConvert");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getName());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"myConvert", (String)converterResource.getName());
        converterResource.setName(null);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getName());
    }

    public void testModifyName() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        EclipseLinkOrmBasicMapping ormBasicMapping = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmObjectTypeConverter ormConverter = ormBasicMapping.getConverterContainer().addObjectTypeConverter("objectTypeConverter", 0);
        XmlObjectTypeConverter converterResource = (XmlObjectTypeConverter)((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getObjectTypeConverters().get(0);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"objectTypeConverter", (String)ormConverter.getName());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"objectTypeConverter", (String)converterResource.getName());
        ormConverter.setName("foo");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)ormConverter.getName());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)converterResource.getName());
        ormConverter.setName(null);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getName());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getName());
    }

    public void testUpdateDefaultObjectValue() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        EclipseLinkOrmBasicMapping ormBasicMapping = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmObjectTypeConverter ormConverter = ormBasicMapping.getConverterContainer().addObjectTypeConverter("objectTypeConverter", 0);
        XmlObjectTypeConverter converterResource = (XmlObjectTypeConverter)((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getObjectTypeConverters().get(0);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getDefaultObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getDefaultObjectValue());
        converterResource.setDefaultObjectValue("myConvert");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"myConvert", (String)ormConverter.getDefaultObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"myConvert", (String)converterResource.getDefaultObjectValue());
        converterResource.setDefaultObjectValue(null);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getDefaultObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getDefaultObjectValue());
    }

    public void testModifyDefaultObjectValue() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        EclipseLinkOrmBasicMapping ormBasicMapping = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmObjectTypeConverter ormConverter = ormBasicMapping.getConverterContainer().addObjectTypeConverter("objectTypeConverter", 0);
        XmlObjectTypeConverter converterResource = (XmlObjectTypeConverter)((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getObjectTypeConverters().get(0);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getDefaultObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getDefaultObjectValue());
        ormConverter.setDefaultObjectValue("foo");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)ormConverter.getDefaultObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)converterResource.getDefaultObjectValue());
        ormConverter.setDefaultObjectValue(null);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)ormConverter.getDefaultObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals(null, (String)converterResource.getDefaultObjectValue());
    }

    public void testUpdateConversionValues() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        EclipseLinkOrmBasicMapping ormBasicMapping = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmObjectTypeConverter ormConverter = ormBasicMapping.getConverterContainer().addObjectTypeConverter("objectTypeConverter", 0);
        XmlObjectTypeConverter converterResource = (XmlObjectTypeConverter)((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getObjectTypeConverters().get(0);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)0, (int)ormConverter.getConversionValuesSize());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)0, (int)converterResource.getConversionValues().size());
        XmlConversionValue resourceConversionValue = EclipseLinkOrmFactory.eINSTANCE.createXmlConversionValue();
        converterResource.getConversionValues().add((Object)resourceConversionValue);
        resourceConversionValue.setDataValue("foo");
        resourceConversionValue.setObjectValue("bar");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)1, (int)ormConverter.getConversionValuesSize());
        ListIterator contextConversionValues = ormConverter.getConversionValues().iterator();
        EclipseLinkConversionValue contextConversionValue = (EclipseLinkConversionValue)contextConversionValues.next();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)contextConversionValue.getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)contextConversionValue.getObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)1, (int)converterResource.getConversionValues().size());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getObjectValue());
        XmlConversionValue xmlConversionValue2 = EclipseLinkOrmFactory.eINSTANCE.createXmlConversionValue();
        converterResource.getConversionValues().add(0, (Object)xmlConversionValue2);
        xmlConversionValue2.setDataValue("foo2");
        xmlConversionValue2.setObjectValue("bar2");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)2, (int)ormConverter.getConversionValuesSize());
        contextConversionValues = ormConverter.getConversionValues().iterator();
        contextConversionValue = (EclipseLinkConversionValue)contextConversionValues.next();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo2", (String)contextConversionValue.getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar2", (String)contextConversionValue.getObjectValue());
        contextConversionValue = (EclipseLinkConversionValue)contextConversionValues.next();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)contextConversionValue.getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)contextConversionValue.getObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)2, (int)converterResource.getConversionValues().size());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo2", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar2", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)((XmlConversionValue)converterResource.getConversionValues().get(1)).getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)((XmlConversionValue)converterResource.getConversionValues().get(1)).getObjectValue());
        converterResource.getConversionValues().move(0, 1);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)2, (int)ormConverter.getConversionValuesSize());
        contextConversionValues = ormConverter.getConversionValues().iterator();
        contextConversionValue = (EclipseLinkConversionValue)contextConversionValues.next();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)contextConversionValue.getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)contextConversionValue.getObjectValue());
        contextConversionValue = (EclipseLinkConversionValue)contextConversionValues.next();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo2", (String)contextConversionValue.getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar2", (String)contextConversionValue.getObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)2, (int)converterResource.getConversionValues().size());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo2", (String)((XmlConversionValue)converterResource.getConversionValues().get(1)).getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar2", (String)((XmlConversionValue)converterResource.getConversionValues().get(1)).getObjectValue());
        converterResource.getConversionValues().remove(0);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)1, (int)ormConverter.getConversionValuesSize());
        contextConversionValues = ormConverter.getConversionValues().iterator();
        contextConversionValue = (EclipseLinkConversionValue)contextConversionValues.next();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo2", (String)contextConversionValue.getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar2", (String)contextConversionValue.getObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)1, (int)converterResource.getConversionValues().size());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo2", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar2", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getObjectValue());
        converterResource.getConversionValues().clear();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)0, (int)ormConverter.getConversionValuesSize());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)0, (int)converterResource.getConversionValues().size());
    }

    public void testModifyConversionValues() throws Exception {
        this.createTestEntityWithBasicMapping();
        OrmPersistentType ormPersistentType = this.getEntityMappings().addPersistentType("entity", "test.AnnotationTestType");
        OrmSpecifiedPersistentAttribute ormPersistentAttribute = ormPersistentType.addAttributeToXml(ormPersistentType.getAttributeNamed("id"), "basic");
        EclipseLinkOrmBasicMapping ormBasicMapping = (EclipseLinkOrmBasicMapping)ormPersistentAttribute.getMapping();
        EclipseLinkOrmObjectTypeConverter ormConverter = ormBasicMapping.getConverterContainer().addObjectTypeConverter("objectTypeConverter", 0);
        XmlObjectTypeConverter converterResource = (XmlObjectTypeConverter)((XmlBasic)((XmlEntity)this.getXmlEntityMappings().getEntities().get(0)).getAttributes().getBasics().get(0)).getObjectTypeConverters().get(0);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)0, (int)ormConverter.getConversionValuesSize());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)0, (int)converterResource.getConversionValues().size());
        EclipseLinkConversionValue contextConversionValue = ormConverter.addConversionValue();
        contextConversionValue.setDataValue("foo");
        contextConversionValue.setObjectValue("bar");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)1, (int)ormConverter.getConversionValuesSize());
        ListIterator contextConversionValues = ormConverter.getConversionValues().iterator();
        contextConversionValue = (EclipseLinkConversionValue)contextConversionValues.next();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)contextConversionValue.getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)contextConversionValue.getObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)1, (int)converterResource.getConversionValues().size());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getObjectValue());
        EclipseLinkConversionValue contextConversionValue2 = ormConverter.addConversionValue(0);
        contextConversionValue2.setDataValue("foo2");
        contextConversionValue2.setObjectValue("bar2");
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)2, (int)ormConverter.getConversionValuesSize());
        contextConversionValues = ormConverter.getConversionValues().iterator();
        contextConversionValue = (EclipseLinkConversionValue)contextConversionValues.next();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo2", (String)contextConversionValue.getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar2", (String)contextConversionValue.getObjectValue());
        contextConversionValue = (EclipseLinkConversionValue)contextConversionValues.next();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)contextConversionValue.getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)contextConversionValue.getObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)2, (int)converterResource.getConversionValues().size());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo2", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar2", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)((XmlConversionValue)converterResource.getConversionValues().get(1)).getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)((XmlConversionValue)converterResource.getConversionValues().get(1)).getObjectValue());
        ormConverter.moveConversionValue(0, 1);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)2, (int)ormConverter.getConversionValuesSize());
        contextConversionValues = ormConverter.getConversionValues().iterator();
        contextConversionValue = (EclipseLinkConversionValue)contextConversionValues.next();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)contextConversionValue.getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)contextConversionValue.getObjectValue());
        contextConversionValue = (EclipseLinkConversionValue)contextConversionValues.next();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo2", (String)contextConversionValue.getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar2", (String)contextConversionValue.getObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)2, (int)converterResource.getConversionValues().size());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo2", (String)((XmlConversionValue)converterResource.getConversionValues().get(1)).getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar2", (String)((XmlConversionValue)converterResource.getConversionValues().get(1)).getObjectValue());
        ormConverter.removeConversionValue(0);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)1, (int)ormConverter.getConversionValuesSize());
        contextConversionValues = ormConverter.getConversionValues().iterator();
        contextConversionValue = (EclipseLinkConversionValue)contextConversionValues.next();
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo2", (String)contextConversionValue.getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar2", (String)contextConversionValue.getObjectValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)1, (int)converterResource.getConversionValues().size());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"foo2", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getDataValue());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((String)"bar2", (String)((XmlConversionValue)converterResource.getConversionValues().get(0)).getObjectValue());
        ormConverter.removeConversionValue(0);
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)0, (int)ormConverter.getConversionValuesSize());
        EclipseLinkOrmObjectTypeConverterTests.assertEquals((int)0, (int)converterResource.getConversionValues().size());
    }
}

