/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ChangeTrackingAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ChangeTrackingType;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.resource.java.EclipseLinkJavaResourceModelTestCase;

public class ChangeTrackingTests
extends EclipseLinkJavaResourceModelTestCase {
    public ChangeTrackingTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestChangeTracking() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.ChangeTracking", "org.eclipse.persistence.annotations.ChangeTrackingType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@ChangeTracking");
            }
        });
    }

    private ICompilationUnit createTestChangeTrackingWithValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"org.eclipse.persistence.annotations.ChangeTracking", "org.eclipse.persistence.annotations.ChangeTrackingType"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@ChangeTracking(ChangeTrackingType.DEFERRED)");
            }
        });
    }

    public void testChangeTracking() throws Exception {
        ICompilationUnit cu = this.createTestChangeTracking();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        ChangeTrackingAnnotation existenceChecking = (ChangeTrackingAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        ChangeTrackingTests.assertNotNull((Object)existenceChecking);
    }

    public void testGetValue() throws Exception {
        ICompilationUnit cu = this.createTestChangeTrackingWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        ChangeTrackingAnnotation existenceChecking = (ChangeTrackingAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        ChangeTrackingTests.assertEquals((Object)ChangeTrackingType.DEFERRED, (Object)existenceChecking.getValue());
    }

    public void testSetValue() throws Exception {
        ICompilationUnit cu = this.createTestChangeTrackingWithValue();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        ChangeTrackingAnnotation existenceChecking = (ChangeTrackingAnnotation)resourceType.getAnnotation("org.eclipse.persistence.annotations.ChangeTracking");
        ChangeTrackingTests.assertEquals((Object)ChangeTrackingType.DEFERRED, (Object)existenceChecking.getValue());
        existenceChecking.setValue(ChangeTrackingType.ATTRIBUTE);
        ChangeTrackingTests.assertEquals((Object)ChangeTrackingType.ATTRIBUTE, (Object)existenceChecking.getValue());
        this.assertSourceContains("@ChangeTracking(ATTRIBUTE)", cu);
        existenceChecking.setValue(null);
        ChangeTrackingTests.assertNull((Object)existenceChecking.getValue());
        this.assertSourceDoesNotContain("(ATTRIBUTE)", cu);
        this.assertSourceContains("@ChangeTracking", cu);
        this.assertSourceDoesNotContain("@ChangeTracking(", cu);
    }
}

