/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.OneToManyAnnotation2_0;
import org.eclipse.jpt.jpa.core.resource.java.FetchType;
import org.eclipse.jpt.jpa.core.resource.java.OneToManyAnnotation;
import org.eclipse.jpt.jpa.core.tests.internal.jpa2.resource.java.JavaResourceModel2_0TestCase;

public class OneToMany2_0AnnotationTests
extends JavaResourceModel2_0TestCase {
    public OneToMany2_0AnnotationTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestOneToMany() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.OneToMany"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany");
            }
        });
    }

    private ICompilationUnit createTestOneToManyWithFetch() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.OneToMany", "javax.persistence.FetchType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany(fetch = FetchType.EAGER)");
            }
        });
    }

    private ICompilationUnit createTestOneToManyWithTargetEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.OneToMany"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany(targetEntity = AnnotationTestType.class)");
            }
        });
    }

    private ICompilationUnit createTestOneToManyWithMappedBy() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.OneToMany"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany(mappedBy = \"foo\")");
            }
        });
    }

    private ICompilationUnit createTestOneToManyWithCascade() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.OneToMany", "javax.persistence.CascadeType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany(cascade = CascadeType.ALL)");
            }
        });
    }

    private ICompilationUnit createTestOneToManyWithMultipleCascade() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.OneToMany", "javax.persistence.CascadeType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany(cascade = {CascadeType.MERGE, CascadeType.REMOVE})");
            }
        });
    }

    private ICompilationUnit createTestOneToManyWithDuplicateCascade() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.OneToMany", "javax.persistence.CascadeType"});
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@OneToMany(cascade = {CascadeType.MERGE, CascadeType.MERGE})");
            }
        });
    }

    public void testOneToMany() throws Exception {
        ICompilationUnit cu = this.createTestOneToMany();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        OneToMany2_0AnnotationTests.assertNotNull((Object)oneToMany);
    }

    public void testGetFetch() throws Exception {
        ICompilationUnit cu = this.createTestOneToManyWithFetch();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        OneToMany2_0AnnotationTests.assertEquals((Object)FetchType.EAGER, (Object)oneToMany.getFetch());
    }

    public void testSetFetch() throws Exception {
        ICompilationUnit cu = this.createTestOneToManyWithFetch();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        OneToMany2_0AnnotationTests.assertEquals((Object)FetchType.EAGER, (Object)oneToMany.getFetch());
        oneToMany.setFetch(FetchType.LAZY);
        OneToMany2_0AnnotationTests.assertEquals((Object)FetchType.LAZY, (Object)oneToMany.getFetch());
        this.assertSourceContains("@OneToMany(fetch = LAZY)", cu);
    }

    public void testSetFetchNull() throws Exception {
        ICompilationUnit cu = this.createTestOneToManyWithFetch();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        OneToMany2_0AnnotationTests.assertEquals((Object)FetchType.EAGER, (Object)oneToMany.getFetch());
        oneToMany.setFetch(null);
        OneToMany2_0AnnotationTests.assertNull((Object)oneToMany.getFetch());
        this.assertSourceContains("@OneToMany", cu);
        this.assertSourceDoesNotContain("fetch", cu);
    }

    public void testGetTargetEntity() throws Exception {
        ICompilationUnit cu = this.createTestOneToManyWithTargetEntity();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        OneToMany2_0AnnotationTests.assertEquals((String)"AnnotationTestType", (String)oneToMany.getTargetEntity());
    }

    public void testSetTargetEntity() throws Exception {
        ICompilationUnit cu = this.createTestOneToManyWithTargetEntity();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        OneToMany2_0AnnotationTests.assertEquals((String)"AnnotationTestType", (String)oneToMany.getTargetEntity());
        oneToMany.setTargetEntity("Foo");
        this.assertSourceContains("@OneToMany(targetEntity = Foo.class)", cu);
    }

    public void testSetTargetEntityNull() throws Exception {
        ICompilationUnit cu = this.createTestOneToManyWithTargetEntity();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        OneToMany2_0AnnotationTests.assertEquals((String)"AnnotationTestType", (String)oneToMany.getTargetEntity());
        oneToMany.setTargetEntity(null);
        this.assertSourceContains("@OneToMany", cu);
        this.assertSourceDoesNotContain("targetEntity", cu);
    }

    public void testGetFullyQualifiedTargetEntity() throws Exception {
        ICompilationUnit cu = this.createTestOneToManyWithTargetEntity();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        OneToMany2_0AnnotationTests.assertEquals((String)"test.AnnotationTestType", (String)oneToMany.getFullyQualifiedTargetEntityClassName());
        oneToMany.setTargetEntity("Foo");
        this.assertSourceContains("@OneToMany(targetEntity = Foo.class)", cu);
        OneToMany2_0AnnotationTests.assertEquals((String)"Foo", (String)oneToMany.getTargetEntity());
        OneToMany2_0AnnotationTests.assertEquals((String)"Foo", (String)oneToMany.getFullyQualifiedTargetEntityClassName());
    }

    public void testGetMappedBy() throws Exception {
        ICompilationUnit cu = this.createTestOneToManyWithMappedBy();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        OneToMany2_0AnnotationTests.assertEquals((String)"foo", (String)oneToMany.getMappedBy());
    }

    public void testGetMappedByNull() throws Exception {
        ICompilationUnit cu = this.createTestOneToMany();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        OneToMany2_0AnnotationTests.assertEquals(null, (String)oneToMany.getMappedBy());
    }

    public void testSetMappedBy() throws Exception {
        ICompilationUnit cu = this.createTestOneToMany();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        OneToMany2_0AnnotationTests.assertNull((Object)oneToMany.getMappedBy());
        oneToMany.setMappedBy("bar");
        OneToMany2_0AnnotationTests.assertEquals((String)"bar", (String)oneToMany.getMappedBy());
        this.assertSourceContains("@OneToMany(mappedBy = \"bar\")", cu);
    }

    public void testSetMappedByNull() throws Exception {
        ICompilationUnit cu = this.createTestOneToManyWithMappedBy();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        OneToMany2_0AnnotationTests.assertEquals((String)"foo", (String)oneToMany.getMappedBy());
        oneToMany.setMappedBy(null);
        OneToMany2_0AnnotationTests.assertNull((Object)oneToMany.getMappedBy());
        this.assertSourceContains("@OneToMany", cu);
        this.assertSourceDoesNotContain("mappedBy", cu);
    }

    public void testSetCascadeAll() throws Exception {
        ICompilationUnit cu = this.createTestOneToMany();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        OneToMany2_0AnnotationTests.assertFalse((boolean)oneToMany.isCascadeAll());
        oneToMany.setCascadeAll(true);
        this.assertSourceContains("@OneToMany(cascade = ALL)", cu);
        OneToMany2_0AnnotationTests.assertTrue((boolean)oneToMany.isCascadeAll());
    }

    public void testSetCascadeMerge() throws Exception {
        ICompilationUnit cu = this.createTestOneToMany();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        OneToMany2_0AnnotationTests.assertFalse((boolean)oneToMany.isCascadeMerge());
        oneToMany.setCascadeMerge(true);
        this.assertSourceContains("@OneToMany(cascade = MERGE)", cu);
        OneToMany2_0AnnotationTests.assertTrue((boolean)oneToMany.isCascadeMerge());
    }

    public void testSetCascadePersist() throws Exception {
        ICompilationUnit cu = this.createTestOneToMany();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        OneToMany2_0AnnotationTests.assertFalse((boolean)oneToMany.isCascadePersist());
        oneToMany.setCascadePersist(true);
        this.assertSourceContains("@OneToMany(cascade = PERSIST)", cu);
        OneToMany2_0AnnotationTests.assertTrue((boolean)oneToMany.isCascadePersist());
    }

    public void testSetCascadeRemove() throws Exception {
        ICompilationUnit cu = this.createTestOneToMany();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        OneToMany2_0AnnotationTests.assertFalse((boolean)oneToMany.isCascadeRemove());
        oneToMany.setCascadeRemove(true);
        this.assertSourceContains("@OneToMany(cascade = REMOVE)", cu);
        OneToMany2_0AnnotationTests.assertTrue((boolean)oneToMany.isCascadeRemove());
    }

    public void testSetCascadeRefresh() throws Exception {
        ICompilationUnit cu = this.createTestOneToMany();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        OneToMany2_0AnnotationTests.assertFalse((boolean)oneToMany.isCascadeRefresh());
        oneToMany.setCascadeRefresh(true);
        this.assertSourceContains("@OneToMany(cascade = REFRESH)", cu);
        OneToMany2_0AnnotationTests.assertTrue((boolean)oneToMany.isCascadeRefresh());
    }

    public void testSetCascadeDetach() throws Exception {
        ICompilationUnit cu = this.createTestOneToMany();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToManyAnnotation2_0 oneToMany = (OneToManyAnnotation2_0)resourceField.getAnnotation("javax.persistence.OneToMany");
        OneToMany2_0AnnotationTests.assertFalse((boolean)oneToMany.isCascadeDetach());
        oneToMany.setCascadeDetach(true);
        this.assertSourceContains("@OneToMany(cascade = DETACH)", cu);
        OneToMany2_0AnnotationTests.assertTrue((boolean)oneToMany.isCascadeDetach());
    }

    public void testCascadeMoreThanOnce() throws Exception {
        ICompilationUnit cu = this.createTestOneToManyWithCascade();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        OneToMany2_0AnnotationTests.assertTrue((boolean)oneToMany.isCascadeAll());
        oneToMany.setCascadeAll(true);
        OneToMany2_0AnnotationTests.assertTrue((boolean)oneToMany.isCascadeAll());
        this.assertSourceContains("@OneToMany(cascade = CascadeType.ALL)", cu);
        oneToMany.setCascadeAll(false);
        OneToMany2_0AnnotationTests.assertFalse((boolean)oneToMany.isCascadeAll());
        this.assertSourceDoesNotContain("cascade", cu);
        oneToMany.setCascadeAll(false);
        OneToMany2_0AnnotationTests.assertFalse((boolean)oneToMany.isCascadeAll());
        this.assertSourceDoesNotContain("cascade", cu);
    }

    public void testDuplicateCascade() throws Exception {
        ICompilationUnit cu = this.createTestOneToManyWithDuplicateCascade();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        OneToMany2_0AnnotationTests.assertTrue((boolean)oneToMany.isCascadeMerge());
        oneToMany.setCascadeMerge(false);
        OneToMany2_0AnnotationTests.assertTrue((boolean)oneToMany.isCascadeMerge());
        oneToMany.setCascadeMerge(false);
        OneToMany2_0AnnotationTests.assertFalse((boolean)oneToMany.isCascadeMerge());
        this.assertSourceDoesNotContain("cascade", cu);
    }

    public void testMultipleCascade() throws Exception {
        ICompilationUnit cu = this.createTestOneToManyWithMultipleCascade();
        JavaResourceType resourceType = this.buildJavaResourceType(cu);
        JavaResourceField resourceField = (JavaResourceField)IterableTools.get((Iterable)resourceType.getFields(), (int)0);
        OneToManyAnnotation oneToMany = (OneToManyAnnotation)resourceField.getAnnotation("javax.persistence.OneToMany");
        OneToMany2_0AnnotationTests.assertTrue((boolean)oneToMany.isCascadeMerge());
        OneToMany2_0AnnotationTests.assertTrue((boolean)oneToMany.isCascadeRemove());
        oneToMany.setCascadeMerge(false);
        this.assertSourceContains("@OneToMany(cascade = REMOVE)", cu);
        oneToMany.setCascadeRemove(false);
        this.assertSourceDoesNotContain("cascade", cu);
    }
}

