/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.test;

import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.xs.XSModel;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.xml.xpath2.api.CollationProvider;
import org.eclipse.wst.xml.xpath2.api.Function;
import org.eclipse.wst.xml.xpath2.api.StaticContext;
import org.eclipse.wst.xml.xpath2.api.StaticVariableResolver;
import org.eclipse.wst.xml.xpath2.api.typesystem.ItemType;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeModel;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.Engine;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.StaticError;
import org.eclipse.wst.xml.xpath2.processor.XPathParserException;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDecimal;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDouble;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSFloat;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSInteger;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.eclipse.wst.xml.xpath2.processor.test.AbstractPsychoPathTest;
import org.osgi.framework.Bundle;
import org.xml.sax.InputSource;

public class TestBugs
extends AbstractPsychoPathTest {
    private static final String URN_X_ECLIPSE_XPATH20_FUNKY_COLLATOR = "urn:x-eclipse:xpath20:funky-collator";
    private Bundle bundle;

    protected void setUp() throws Exception {
        super.setUp();
        this.bundle = Platform.getBundle((String)"org.eclipse.wst.xml.xpath2.processor.tests");
    }

    public void testNulVarNamespacePrefix() throws Exception {
        String xpath = "for $a in //* return $a";
        new Engine().parseExpression(xpath, new StaticContext(){

            public boolean isXPath1Compatible() {
                return false;
            }

            public StaticVariableResolver getInScopeVariables() {
                return null;
            }

            public TypeDefinition getInitialContextType() {
                return null;
            }

            public Map getFunctionLibraries() {
                return null;
            }

            public CollationProvider getCollationProvider() {
                return null;
            }

            public URI getBaseUri() {
                return null;
            }

            public ItemType getDocumentType(URI documentUri) {
                return null;
            }

            public NamespaceContext getNamespaceContext() {
                return new NamespaceContext(){

                    public String getNamespaceURI(String arg0) {
                        if (arg0 == null) {
                            throw new IllegalArgumentException("#fail");
                        }
                        return "";
                    }

                    public String getPrefix(String arg0) {
                        if (arg0 == null) {
                            throw new IllegalArgumentException("#fail");
                        }
                        return "";
                    }

                    public Iterator getPrefixes(String arg0) {
                        if (arg0 == null) {
                            throw new IllegalArgumentException("#fail");
                        }
                        return Collections.emptyList().iterator();
                    }
                };
            }

            public String getDefaultNamespace() {
                return "";
            }

            public String getDefaultFunctionNamespace() {
                return null;
            }

            public TypeModel getTypeModel() {
                return null;
            }

            public Function resolveFunction(QName name, int arity) {
                return null;
            }

            public TypeDefinition getCollectionType(String collectionName) {
                return null;
            }

            public TypeDefinition getDefaultCollectionType() {
                return null;
            }
        });
    }

    public void testNamesInUnicode() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug388504.xml");
        this.loadDOMDocument(fileURL);
        this.setupDynamicContext(null);
        this.compileXPath("count(//Schl\u00fcssel)");
        ResultSequence rs = this.evaluate(this.domDoc);
        String actual = rs.first().getStringValue();
        TestBugs.assertEquals((String)"1", (String)actual);
    }

    public void testNamesWhichAreKeywords() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug311480.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "(/element/eq eq 'eq') or //child::xs:*";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testStringLengthWithElementArg() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug273719.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "string-length(x) > 2";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testBug273795Arity2() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug273795.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "substring(x, 3) = 'happy'";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testBug273795Arity3() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug273795.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "substring(x, 3, 4) = 'happ'";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testStringFunctionBug274471() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug274471.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "x/string() = 'unhappy'";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testStringLengthFunctionBug274471() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug274471.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "x/string-length() = 7";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"false", (String)actual);
    }

    public void testNormalizeSpaceFunctionBug274471() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug274471.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "x/normalize-space() = 'unhappy'";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testAnyUriEqualityBug() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug274471.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "xs:anyURI('abc') eq xs:anyURI('abc')";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testBaseUriBug() throws Exception {
        this.loadDOMDocument(new URL("http://resolved-locally/xml/note.xml"));
        this.setupDynamicContext(null);
        String xpath = "base-uri(note) eq xs:anyURI('http://resolved-locally/xml/note.xml')";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testDocumentUriBug() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dbf.newDocumentBuilder();
        InputSource inputSource = this.getTestSource("http://resolved-locally/xml/note.xml");
        this.domDoc = docBuilder.parse(inputSource);
        this.setupDynamicContext(null);
        String xpath = "document-uri(/) eq xs:anyURI('http://resolved-locally/xml/note.xml')";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = "false";
        if (result != null) {
            actual = result.getStringValue();
        }
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testBooleanTypeBug() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug273719.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "xs:boolean('1') eq xs:boolean('true')";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testDateConstructorBug() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug274792.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "xs:date(x) eq xs:date('2009-01-01')";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testIntegerDataTypeBug() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug274805.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "xs:integer(x) gt 100";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testLongDataType() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "xs:long('9223372036854775807') gt 0";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testIntDataType() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "xs:int('2147483647') gt 0";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testSchemaAwarenessForAttributes() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug276134.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/bug276134.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "person/@dob eq xs:date('2006-12-10')";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testSchemaAwarenessForElements() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug276134_2.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/bug276134_2.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "person/dob eq xs:date('2006-12-10')";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testNilled() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bugNilled.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/bugNilled.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        TestBugs.assertTrue((boolean)this.evaluateBoolean("empty( nilled( / ) )"));
        TestBugs.assertTrue((boolean)this.evaluateBoolean("empty( nilled( /root/@attr1 ) )"));
        TestBugs.assertTrue((boolean)this.evaluateBoolean("empty( nilled( /root/element1/text() ) )"));
        TestBugs.assertFalse((boolean)this.evaluateBoolean("nilled(/root/element1)"));
        TestBugs.assertTrue((boolean)this.evaluateBoolean("nilled(/root/element2)"));
        TestBugs.assertFalse((boolean)this.evaluateBoolean("nilled(/root/element3)"));
        TestBugs.assertFalse((boolean)this.evaluateBoolean("nilled(/root/element4)"));
    }

    private boolean evaluateBoolean(String xpath) throws Exception {
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        return result.value();
    }

    public void testXSNonPositiveInteger() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "xs:nonPositiveInteger('0') eq 0";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXSNegativeInteger() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "xs:negativeInteger('-1') eq -1";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXSShort() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "xs:short('-32768') eq -32768";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXSNonNegativeInteger() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "xs:nonNegativeInteger('0') eq 0";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXSUnsignedLong() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "xs:unsignedLong('0') eq 0";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXSPositiveInteger() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "xs:positiveInteger('1') eq 1";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXSByte() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "xs:byte('-128') eq -128";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXSUnsignedInt() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "xs:unsignedInt('4294967295') eq xs:unsignedInt('4294967295')";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXSUnsignedShort() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "xs:unsignedShort('65535') eq 65535";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXSYearMonthDurationMultiply() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "xs:yearMonthDuration('P2Y11M') * 2.3";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSDuration result = (XSDuration)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"P6Y9M", (String)actual);
    }

    public void testXSYearMonthDurationDivide1() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "xs:yearMonthDuration('P2Y11M') div 1.5";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSDuration result = (XSDuration)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"P1Y11M", (String)actual);
    }

    public void testXSYearMonthDurationDivide2() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "xs:yearMonthDuration('P3Y4M') div xs:yearMonthDuration('-P1Y4M')";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSDecimal result = (XSDecimal)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"-2.5", (String)actual);
    }

    public void testXSDayTimeDurationMultiply() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "xs:dayTimeDuration('PT2H10M') * 2.1";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSDuration result = (XSDuration)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"PT4H33M", (String)actual);
    }

    public void testXSDayTimeDurationDivide() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "xs:dayTimeDuration('P1DT2H30M10.5S') div 1.5";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSDuration result = (XSDuration)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"PT17H40M7S", (String)actual);
    }

    public void testNegativeZeroDouble() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "-(xs:double('0'))";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSDouble result = (XSDouble)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"-0", (String)actual);
    }

    public void testNegativeZeroFloat() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "-(xs:float('0'))";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSFloat result = (XSFloat)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"-0", (String)actual);
    }

    public void testXSUnsignedByte() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "xs:unsignedByte('255') eq 255";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXSBase64Binary() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "xs:base64Binary('cmxjZ3R4c3JidnllcmVuZG91aWpsbXV5Z2NhamxpcmJkaWFhbmFob2VsYXVwZmJ1Z2dmanl2eHlzYmhheXFtZXR0anV2dG1q') eq xs:base64Binary('cmxjZ3R4c3JidnllcmVuZG91aWpsbXV5Z2NhamxpcmJkaWFhbmFob2VsYXVwZmJ1Z2dmanl2eHlzYmhheXFtZXR0anV2dG1q')";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXSHexBinary() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "xs:hexBinary('767479716c6a647663') eq xs:hexBinary('767479716c6a647663')";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testElementTypedValue() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/elementTypedValueBug.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/elementTypedValueBug.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "Example/Transportation/mode eq 'air'";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testBug286061_quoted_string_literals_no_normalize() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "'\"\"'";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        String resultValue = rs.first().getStringValue();
        TestBugs.assertEquals((String)"\"\"", (String)resultValue);
    }

    public void testBug286061_quoted_string_literals() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "concat(  'Don''t try this' ,  \" at \"\"home\"\",\"  ,  ' she said'  )";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        String resultValue = rs.first().getStringValue();
        TestBugs.assertEquals((String)"Don't try this at \"home\", she said", (String)resultValue);
    }

    public void testNumericFunctionOnEmptySequence() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = null;
        ResultSequence rs = null;
        xpath = "fn:abs(())";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        TestBugs.assertEquals((int)0, (int)rs.size());
        xpath = "fn:ceiling(())";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        TestBugs.assertEquals((int)0, (int)rs.size());
        xpath = "fn:floor(())";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        TestBugs.assertEquals((int)0, (int)rs.size());
        xpath = "fn:round(())";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        TestBugs.assertEquals((int)0, (int)rs.size());
        xpath = "fn:round-half-to-even(())";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        TestBugs.assertEquals((int)0, (int)rs.size());
        xpath = "fn:round-half-to-even((),1)";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        TestBugs.assertEquals((int)0, (int)rs.size());
    }

    public void testSequenceAggregationOnEmpty() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = null;
        ResultSequence rs = null;
        xpath = "fn:sum((1,2,3,() ))";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        XSDecimal val = (XSDecimal)rs.first();
        TestBugs.assertEquals((String)"6", (String)val.string_value());
    }

    public void testBug280555_collations() throws Exception {
        this.setupDynamicContext(null);
        this.setCollationProvider(this.createLengthCollatorProvider());
        this.compileXPath(" 'abc' < 'de' ");
        XSBoolean bval = (XSBoolean)this.evaluate(this.domDoc).first();
        TestBugs.assertTrue((String)"'abc' < 'de' for normal collations", (boolean)bval.value());
        this.setDefaultCollation(URN_X_ECLIPSE_XPATH20_FUNKY_COLLATOR);
        XSBoolean bval2 = (XSBoolean)this.evaluate(this.domDoc).first();
        TestBugs.assertFalse((String)"'abc' < 'de' should be false for the strange collations", (boolean)bval2.value());
    }

    public void testXPathDefaultNamespace() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/xpathDefNamespaceTest.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        this.addXPathDefaultNamespace("http://xyz");
        String xpath = "X/message = 'hello'";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXPathInstanceOf1() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/elementTypedValueBug.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/elementTypedValueBug.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "Example/Transportation/mode instance of element()";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testNestedABCs() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/nested-abc.xml");
        this.loadDOMDocument(fileURL);
        this.setupDynamicContext(null);
        String xpath = "a/b[2 > 1]/c[3 < 4]";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        TestBugs.assertEquals((int)9, (int)rs.size());
    }

    public void testXPathInstanceOf2() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/elementTypedValueBug.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/elementTypedValueBug.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "Example/Transportation/mode instance of element(mode)";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXPathInstanceOf3() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/elementTypedValueBug.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/elementTypedValueBug.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "Example/Transportation/mode instance of element(mode, modeType)";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXPathInstanceOf4() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/elementTypedValueBug.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/elementTypedValueBug.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "Example/Transportation/mode instance of element(mode, abc)";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"false", (String)actual);
    }

    public void testXPathInstanceOf5() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "Example/x instance of element(x, x_Type)*";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXPathInstanceOf5_2() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "(/Example/x, /Example) instance of element(x, x_Type)+";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        TestBugs.assertEquals((boolean)false, (boolean)result.value());
    }

    public void testXPathInstanceOf5_3() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "(/Example/x, /Example/x) instance of element(x, x_Type)";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        TestBugs.assertFalse((boolean)result.value());
    }

    public void testXPathInstanceOf5_4() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "(/Example/x, /Example/x) instance of element(x, x_Type)+";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        TestBugs.assertTrue((boolean)result.value());
    }

    public void testXPathInstanceOf5_5() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        this.assertXPathTrue("/Example/x instance of x_Type+", this.domDoc);
        this.assertXPathTrue("/Example/x instance of element(x, x_Type)+", this.domDoc);
        this.assertXPathTrue("not (/Example/x instance of element(z, x_Type)+)", this.domDoc);
        this.assertXPathTrue("/Example/x[2]/@mesg instance of mesg_Type", this.domDoc);
        this.assertXPathTrue("/Example/x[2]/@mesg instance of attribute(mesg, mesg_Type)", this.domDoc);
        this.assertXPathTrue("not (/Example/x[2]/@mesg instance of attribute(cesc, mesg_Type))", this.domDoc);
    }

    public void testXPathInstanceOf6() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "Example/x instance of element(*, x_Type)*";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXPathInstanceOf7() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "Example/x instance of element(x, x_Type)+";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXPathNotInstanceOf() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "/Example/x[1] instance of element(*, x_Type) and not (/Example/x[1] instance of element(*, y_Type))";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXPathInstanceNonExistantElement() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/elementTypedValueBug.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/elementTypedValueBug.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "Example/Transportation/mode instance of element(x)";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"false", (String)actual);
    }

    public void testFnNumber_Evaluation1() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/fnNumberBug.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/fnNumberBug.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "number(Example/x) ge 18";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testFnNumber_Evaluation2() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "number(xs:unsignedByte('20')) ge 18";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testAttrNode_Test1() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "Example/x[1]/@mesg instance of attribute()";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testAttrNode_Test2() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "Example/x[1]/@mesg instance of attribute(xx)";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"false", (String)actual);
    }

    public void testAttrNode_Test3() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "Example/x[1]/@mesg instance of attribute(*, mesg_Type)";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testAttrNode_Test4() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "Example/x[1]/@mesg instance of attribute(*, abc)";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"false", (String)actual);
    }

    public void testAttrNode_Test5() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "Example/x[1]/@mesg instance of attribute(mesg, mesg_Type)";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testAttrNode_Test6() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "Example/x[1]/@mesg instance of attribute(mesg, abc)";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"false", (String)actual);
    }

    public void testAttrNode_Test7() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "Example/x/@mesg instance of attribute(mesg, mesg_Type)*";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testFnNameContextUndefined() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/attrNodeTest.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "Example/*[1]/name() eq 'x'";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testXSNormalizedString() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "xs:normalizedString('abcs\t') eq xs:normalizedString('abcs')";
        this.compileXPath(xpath);
        boolean testSuccess = false;
        try {
            this.evaluate(this.domDoc);
        }
        catch (DynamicError dynamicError) {
            testSuccess = true;
        }
        TestBugs.assertTrue((boolean)testSuccess);
    }

    public void testParseElementKeywordsAsNodes() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "/element/attribute";
        this.compileXPath(xpath);
    }

    public void testTypedValueEnhancement_primitiveTypes() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug318313.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/bug318313.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "X gt 99";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testFunctionAtomization() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug318313.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/bug318313.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "abs(X)";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSInteger result = (XSInteger)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"100", (String)actual);
    }

    public void testFunctionAtomization2() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug318313.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/bug318313.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "fn:round-half-to-even(X,1)";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSDecimal result = (XSDecimal)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"100", (String)actual);
    }

    public void testTypedValueEnhancement_Bug323900_1() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug323900_1.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/bug323900_1.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "data(X) instance of xs:integer+";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testTypedValueEnhancement_Bug323900_2() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug323900_2.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/bug323900_2.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "data(X) instance of xs:integer+";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"false", (String)actual);
    }

    public void testTypedValueEnhancement_Bug323900_3() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug323900_2.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/bug323900_2.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "data(X)";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        TestBugs.assertTrue((boolean)(rs.get(0) instanceof XSInteger));
        TestBugs.assertEquals((Object)BigInteger.ONE, (Object)((XSInteger)rs.get(0)).int_value());
        TestBugs.assertTrue((boolean)(rs.get(1) instanceof XSInteger));
        TestBugs.assertEquals((Object)BigInteger.valueOf(2L), (Object)((XSInteger)rs.get(1)).int_value());
        TestBugs.assertTrue((boolean)(rs.get(2) instanceof XSString));
        TestBugs.assertEquals((String)"3.3", (String)((XSString)rs.get(2)).getStringValue());
    }

    public void testTypedValueEnhancement_Bug323900_4() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug323900_3.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/bug323900_3.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "data(X)";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSString result = (XSString)rs.get(0);
        TestBugs.assertEquals((String)"3.3", (String)result.getStringValue());
    }

    public void testTypedValueEnhancement_Bug323900_5() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug323900_4.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/bug323900_3.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "data(X)";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSInteger result = (XSInteger)rs.get(0);
        TestBugs.assertEquals((String)"10", (String)result.getStringValue());
    }

    public void testTypedValueEnhancement_BugUsingSeqIntoVariable_1() throws Exception {
        this.setupDynamicContext(null);
        ResultSequence rs = ResultSequenceFactory.create_new();
        this.setVariable("value", rs);
        String xpath = "deep-equal($value,())";
        this.compileXPath(xpath);
        ResultSequence rsRes = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rsRes.get(0);
        TestBugs.assertEquals((String)"true", (String)result.getStringValue());
    }

    public void testTypedValueEnhancement_BugUsingSeqIntoVariable_2() throws Exception {
        this.setupDynamicContext(null);
        ResultSequence rs = ResultSequenceFactory.create_new();
        rs.add((AnyType)new XSInteger(BigInteger.valueOf(2L)));
        rs.add((AnyType)new XSInteger(BigInteger.valueOf(4L)));
        rs.add((AnyType)new XSInteger(BigInteger.valueOf(6L)));
        this.setVariable("value", rs);
        String xpath = "$value instance of xs:integer+";
        this.compileXPath(xpath);
        ResultSequence rsRes = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rsRes.get(0);
        TestBugs.assertEquals((String)"true", (String)result.getStringValue());
        xpath = "deep-equal($value, (2, 4, 6))";
        this.compileXPath(xpath);
        rsRes = this.evaluate(this.domDoc);
        result = (XSBoolean)rsRes.get(0);
        TestBugs.assertEquals((String)"true", (String)result.getStringValue());
    }

    public void testTypedValueEnhancement_BugUsingSeqIntoVariable_3() throws Exception {
        this.setupDynamicContext(null);
        ResultSequence rs = ResultSequenceFactory.create_new();
        rs.add((AnyType)new XSInteger(BigInteger.valueOf(2L)));
        rs.add((AnyType)new XSInteger(BigInteger.valueOf(4L)));
        rs.add((AnyType)new XSInteger(BigInteger.valueOf(6L)));
        this.setVariable("value", rs);
        String xpath = "count(data($value)) = 3";
        this.compileXPath(xpath);
        ResultSequence rsRes = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rsRes.get(0);
        TestBugs.assertEquals((String)"true", (String)result.getStringValue());
    }

    public void testXSToken() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "xs:token('abcs  abcde') eq xs:token('abcs  abcde')";
        this.compileXPath(xpath);
        boolean testSuccess = false;
        try {
            this.evaluate(this.domDoc);
        }
        catch (DynamicError dynamicError) {
            testSuccess = true;
        }
        TestBugs.assertTrue((boolean)testSuccess);
    }

    public void testBug334842() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = "xs:Name('x:abc') eq xs:Name('x:abc')";
        this.compileXPath(xpath);
        ResultSequence rsRes = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rsRes.get(0);
        TestBugs.assertEquals((String)"true", (String)result.getStringValue());
        xpath = "xs:NCName('x:abc') eq xs:NCName('x:abc')";
        this.compileXPath(xpath);
        try {
            rsRes = this.evaluate(this.domDoc);
            TestBugs.assertTrue((boolean)false);
        }
        catch (DynamicError dynamicError) {
            TestBugs.assertTrue((boolean)true);
        }
        xpath = "xs:NCName('abc') eq xs:NCName('abc')";
        this.compileXPath(xpath);
        rsRes = this.evaluate(this.domDoc);
        result = (XSBoolean)rsRes.get(0);
        TestBugs.assertEquals((String)"true", (String)result.getStringValue());
        xpath = "xs:ID('x:abc') eq xs:ID('x:abc')";
        this.compileXPath(xpath);
        try {
            rsRes = this.evaluate(this.domDoc);
            TestBugs.assertTrue((boolean)false);
        }
        catch (DynamicError dynamicError) {
            TestBugs.assertTrue((boolean)true);
        }
        xpath = "xs:ID('abc') eq xs:ID('abc')";
        this.compileXPath(xpath);
        rsRes = this.evaluate(this.domDoc);
        result = (XSBoolean)rsRes.get(0);
        TestBugs.assertEquals((String)"true", (String)result.getStringValue());
    }

    public void testDefNamespaceOnbuiltInTypes() throws Exception {
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        this.addXPathDefaultNamespace("http://www.w3.org/2001/XMLSchema");
        this.setVariable("value", (AnyType)new XSString("2.5"));
        String xpath = "$value castable as double";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        XSBoolean result = (XSBoolean)rs.first();
        String actual = result.getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testExprParsingBeginnigWithRootNode_bug338494() throws Exception {
        boolean useNew = this.useNewApi;
        try {
            String xpath;
            block16: {
                block15: {
                    block14: {
                        block13: {
                            this.useNewApi = false;
                            this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
                            URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
                            this.loadDOMDocument(fileURL);
                            XSModel schema = this.getGrammar();
                            this.setupDynamicContext(schema);
                            xpath = "/x";
                            try {
                                this.compileXPath(xpath, true);
                                TestBugs.assertTrue((boolean)false);
                            }
                            catch (XPathParserException ex) {
                                if (!"Expression starts with / or //".equals(ex.getMessage())) break block13;
                                TestBugs.assertTrue((boolean)true);
                            }
                        }
                        xpath = "//x";
                        try {
                            this.compileXPath(xpath, true);
                            TestBugs.assertTrue((boolean)false);
                        }
                        catch (XPathParserException ex) {
                            if (!"Expression starts with / or //".equals(ex.getMessage())) break block14;
                            TestBugs.assertTrue((boolean)true);
                        }
                    }
                    xpath = "/";
                    try {
                        this.compileXPath(xpath, true);
                        TestBugs.assertTrue((boolean)false);
                    }
                    catch (XPathParserException ex) {
                        if (!"Expression starts with / or //".equals(ex.getMessage())) break block15;
                        TestBugs.assertTrue((boolean)true);
                    }
                }
                xpath = "x/y[/a]";
                try {
                    this.compileXPath(xpath, true);
                    TestBugs.assertTrue((boolean)false);
                }
                catch (XPathParserException ex) {
                    if (!"Expression starts with / or //".equals(ex.getMessage())) break block16;
                    TestBugs.assertTrue((boolean)true);
                }
            }
            xpath = ".//x";
            try {
                this.compileXPath(xpath, true);
                TestBugs.assertTrue((boolean)true);
            }
            catch (XPathParserException xPathParserException) {
                TestBugs.assertTrue((boolean)false);
            }
        }
        finally {
            this.useNewApi = useNew;
        }
    }

    public void testExprParsingBeginnigWithRootNode_new_API_bug338494() throws Exception {
        this.useNewApi = true;
        this.bundle = Platform.getBundle((String)"org.w3c.xqts.testsuite");
        URL fileURL = this.bundle.getEntry("/TestSources/emptydoc.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        this.compileXPath("x/y//z");
        TestBugs.assertFalse((String)"Not navigating to root", (boolean)this.newXPath.isRootPathUsed());
        this.compileXPath("/a");
        TestBugs.assertTrue((String)"/a means a at root, so root path should be true", (boolean)this.newXPath.isRootPathUsed());
        this.compileXPath("//x");
        TestBugs.assertTrue((String)"//x means x anywhere under root, so root path should be true", (boolean)this.newXPath.isRootPathUsed());
        this.compileXPath("/");
        TestBugs.assertTrue((String)"/ is root, so root path should be true", (boolean)this.newXPath.isRootPathUsed());
        this.compileXPath("x/y[/a]");
        TestBugs.assertTrue((String)"a predicate refers to root, so root path should be true", (boolean)this.newXPath.isRootPathUsed());
        this.compileXPath(".//x");
        TestBugs.assertFalse((String)".//x is just relative, so root path should be false", (boolean)this.newXPath.isRootPathUsed());
    }

    public void testExpression_variables_API() throws Exception {
        this.useNewApi = true;
        this.setupDynamicContext(null);
        this.setVariable("x", ResultSequenceFactory.create_new());
        String xpath = "count(subsequence($x/parent::*, 2)) eq (for $y in (1) return $y+1)";
        this.compileXPath(xpath);
        TestBugs.assertTrue((boolean)this.newXPath.getFreeVariables().contains(new QName("x")));
        TestBugs.assertFalse((boolean)this.newXPath.getFreeVariables().contains(new QName("y")));
    }

    public void testExpression_functions_API() throws Exception {
        this.useNewApi = true;
        this.setupDynamicContext(null);
        String xpath = "count(subsequence(parent::*, 2)) eq (for $y in (1) return $y+1)";
        this.compileXPath(xpath);
        QName fnCount = new QName("http://www.w3.org/2005/xpath-functions", "count");
        TestBugs.assertTrue((boolean)this.newXPath.getResolvedFunctions().contains(fnCount));
        QName fnSubsequence = new QName("http://www.w3.org/2005/xpath-functions", "subsequence");
        TestBugs.assertTrue((boolean)this.newXPath.getResolvedFunctions().contains(fnSubsequence));
        TestBugs.assertEquals((int)2, (int)this.newXPath.getResolvedFunctions().size());
    }

    public void testNamespaceAxis() {
        this.setupDynamicContext(null);
        String xpath = "count(namespace::*)";
        try {
            this.compileXPath(xpath);
            TestBugs.fail((String)"This should have failed since we don't support the namespace axis");
        }
        catch (StaticError se) {
            TestBugs.assertEquals((String)"XPST0010", (String)se.code());
        }
    }

    public void testExpression_axis_API() throws Exception {
        this.useNewApi = true;
        this.setupDynamicContext(null);
        String xpath = "count(subsequence(./parent::*, 2)) + count(ancestor-or-self::*)";
        this.compileXPath(xpath);
        TestBugs.assertTrue((boolean)this.newXPath.getAxes().contains("parent"));
        TestBugs.assertTrue((boolean)this.newXPath.getAxes().contains("ancestor-or-self"));
        TestBugs.assertEquals((int)2, (int)this.newXPath.getAxes().size());
        xpath = "(child::*, descendant::*, attribute::*, self::*, descendant-or-self::*, following-sibling::*,  following::*, parent::*,ancestor::*, preceding-sibling::*, preceding::*, ancestor-or-self::*)";
        this.compileXPath(xpath);
        TestBugs.assertEquals(new TreeSet<Object>(Arrays.asList("child", "descendant", "attribute", "self", "descendant-or-self", "following-sibling", "following", "parent", "ancestor", "preceding-sibling", "preceding", "ancestor-or-self")), (Object)this.newXPath.getAxes());
    }

    public void testBug338999_Fnsubsequence() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug338999.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/bug338999.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "count(subsequence(X/*, 2)) eq 2";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        String actual = ((XSBoolean)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
        xpath = "subsequence(X/*, 2) instance of element(*, xs:integer)+";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        actual = ((XSBoolean)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
        xpath = "deep-equal(subsequence((1,2,3,4), 2), (2,3,4))";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        actual = ((XSBoolean)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
        xpath = "deep-equal(subsequence(('a', 1, 1.5), 2, 2), (1, 1.5))";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        actual = ((XSBoolean)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
        xpath = "deep-equal(subsequence(('a', 1, 1.5, 'b'), -2, 3), ())";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        actual = ((XSBoolean)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    public void testFnIndexOf_onQName() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug338999.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/bug338999.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "fn:index-of( for $e in X/* return fn:node-name($e), fn:node-name(X/b) )";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        TestBugs.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
        String actual = ((XSInteger)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"2", (String)actual);
    }

    public void testFnIndexOf_onQName2() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug338999.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/bug338999.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "fn:index-of( for $e in X/* return fn:node-name($e), fn:QName('','b') )";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        TestBugs.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
        String actual = ((XSInteger)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"2", (String)actual);
    }

    public void testNumberAggregationWithNill() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bugNilled.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/bugNilled.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = null;
        ResultSequence rs = null;
        String actual = null;
        xpath = "fn:count(( /root/element1, /root/element2, /root/element3 ))";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        TestBugs.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
        actual = ((XSDecimal)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"3", (String)actual);
        xpath = "fn:sum(( /root/element1, /root/element2, /root/element3 ))";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        TestBugs.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
        actual = ((XSDecimal)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"43", (String)actual);
        xpath = "fn:sum(( /root/element1, /root/element2, /root/element3 ), 100)";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        TestBugs.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
        actual = ((XSDecimal)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"143", (String)actual);
        xpath = "fn:avg(( /root/element1, /root/element2, /root/element3, 1 ))";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        TestBugs.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
        actual = ((XSDecimal)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"11", (String)actual);
        xpath = "fn:max(( /root/element1, /root/element2, /root/element3 ))";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        TestBugs.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
        actual = ((XSDecimal)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"42", (String)actual);
        xpath = "fn:min(( /root/element1, /root/element2, /root/element3 ))";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        TestBugs.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
        actual = ((XSDecimal)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"1", (String)actual);
    }

    public void testNumberAggregationWithNill2() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bugNilledNoSchema.xml");
        this.loadDOMDocument(fileURL);
        XSModel schema = this.getGrammar();
        this.setupDynamicContext(schema);
        String xpath = null;
        ResultSequence rs = null;
        String actual = null;
        xpath = "fn:count(( /root/element1, /root/element2, /root/element3 ))";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        TestBugs.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
        actual = ((XSDecimal)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"3", (String)actual);
        xpath = "fn:sum(( /root/element1, /root/element2, /root/element3 ))";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        TestBugs.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
        actual = ((NumericType)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"43", (String)actual);
        xpath = "fn:sum(( /root/element1, /root/element2, /root/element3 ), 100)";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        TestBugs.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
        actual = ((NumericType)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"143", (String)actual);
        xpath = "fn:avg(( /root/element1, /root/element2, /root/element3, 1 ))";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        TestBugs.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
        actual = ((NumericType)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"11", (String)actual);
        xpath = "fn:max(( /root/element1, /root/element2, /root/element3 ))";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        TestBugs.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
        actual = ((NumericType)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"42", (String)actual);
        xpath = "fn:min(( /root/element1, /root/element2, /root/element3 ))";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        TestBugs.assertTrue((rs.size() > 0 ? 1 : 0) != 0);
        actual = ((NumericType)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"1", (String)actual);
    }

    public void testBug339025_distinctValuesOnNodeSequence() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug339025.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/bug339025.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "count(//a) = count(distinct-values(//a))";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        String actual = ((XSBoolean)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
        xpath = "count(X/a) = count(distinct-values(X/a))";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        actual = ((XSBoolean)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
        xpath = "count(//b) = count(distinct-values(//b))";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        actual = ((XSBoolean)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"false", (String)actual);
    }

    public void testBug341862_TypedBooleanNode() throws Exception {
        URL fileURL = this.bundle.getEntry("/bugTestFiles/bug341862.xml");
        URL schemaURL = this.bundle.getEntry("/bugTestFiles/bug341862.xsd");
        this.loadDOMDocument(fileURL, schemaURL);
        XSModel schema = this.getGrammar(schemaURL);
        this.setupDynamicContext(schema);
        String xpath = "/X/a[1] = true()";
        this.compileXPath(xpath);
        ResultSequence rs = this.evaluate(this.domDoc);
        String actual = ((XSBoolean)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
        xpath = "/X/a[1]/@att = true()";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        actual = ((XSBoolean)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
        xpath = "/X/a[2] = true()";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        actual = ((XSBoolean)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
        xpath = "/X/a[2]/@att = true()";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        actual = ((XSBoolean)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
        xpath = "/X/a[3] = false()";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        actual = ((XSBoolean)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
        xpath = "/X/a[3]/@att = false()";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        actual = ((XSBoolean)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
        xpath = "/X/a[4] = false()";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        actual = ((XSBoolean)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
        xpath = "/X/a[4]/@att = false()";
        this.compileXPath(xpath);
        rs = this.evaluate(this.domDoc);
        actual = ((XSBoolean)rs.first()).getStringValue();
        TestBugs.assertEquals((String)"true", (String)actual);
    }

    private CollationProvider createLengthCollatorProvider() {
        final CollationProvider oldProvider = this.getStaticContext().getCollationProvider();
        return new CollationProvider(){

            public Comparator getCollation(String name) {
                if (name.equals(TestBugs.URN_X_ECLIPSE_XPATH20_FUNKY_COLLATOR)) {
                    return new Comparator(){

                        public int compare(Object o1, Object o2) {
                            return ((String)o1).length() - ((String)o2).length();
                        }
                    };
                }
                return oldProvider.getCollation(name);
            }

            public String getDefaultCollation() {
                return oldProvider.getDefaultCollation();
            }
        };
    }
}

