/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.jpt.jaxb.core.tests.internal.JaxbCoreMiscTests;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbCoreContextModelTests;
import org.eclipse.jpt.jaxb.core.tests.internal.resource.JaxbCoreResourceModelTests;
import org.eclipse.jpt.jaxb.core.tests.internal.utility.JaxbCoreUtilityTests;

public class JaxbCoreTests {
    public static Test suite() {
        TestSuite suite = new TestSuite(JaxbCoreTests.class.getPackage().getName());
        suite.addTest(JaxbCoreResourceModelTests.suite());
        suite.addTest(JaxbCoreContextModelTests.suite());
        suite.addTest(JaxbCoreUtilityTests.suite());
        suite.addTest(JaxbCoreMiscTests.suite());
        return suite;
    }

    public static boolean requiredJarsExists() {
        return JaxbCoreTests.jaxbJarPropertyExists() && JaxbCoreTests.jaxbJarFileExists();
    }

    public static boolean jaxbJarPropertyExists() {
        return JaxbCoreTests.getSystemProperty("org.eclipse.jpt.jaxb.jar") != null;
    }

    public static boolean jaxbJarFileExists() {
        return new File(JaxbCoreTests.getSystemProperty("org.eclipse.jpt.jaxb.jar")).exists();
    }

    public static String buildMissingJarErrorMessage() {
        if (!JaxbCoreTests.jaxbJarPropertyExists()) {
            return JaxbCoreTests.errorMissingProperty("org.eclipse.jpt.jaxb.jar");
        }
        return JaxbCoreTests.errorJarFileDoesNotExist(JaxbCoreTests.getSystemProperty("org.eclipse.jpt.jaxb.jar"));
    }

    private static String errorMissingProperty(String propertyName) {
        return "missing Java system property: \"" + propertyName + "\"";
    }

    private static String errorJarFileDoesNotExist(String propertyValue) {
        return "JAR file doesn't exist: \"" + propertyValue + "\"";
    }

    private static String getSystemProperty(String propertyName) {
        return System.getProperty(propertyName);
    }

    private JaxbCoreTests() {
        throw new UnsupportedOperationException();
    }
}

