/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.tests.internal.context.java;

import java.util.ListIterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.ModifiedDeclaration;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jaxb.core.context.JaxbPackage;
import org.eclipse.jpt.jaxb.core.context.JaxbPackageInfo;
import org.eclipse.jpt.jaxb.core.context.XmlAccessType;
import org.eclipse.jpt.jaxb.core.context.XmlNs;
import org.eclipse.jpt.jaxb.core.context.java.JavaXmlSchema;
import org.eclipse.jpt.jaxb.core.resource.java.XmlNsAnnotation;
import org.eclipse.jpt.jaxb.core.resource.java.XmlNsForm;
import org.eclipse.jpt.jaxb.core.resource.java.XmlSchemaAnnotation;
import org.eclipse.jpt.jaxb.core.tests.internal.context.JaxbContextModelTestCase;

public class GenericJavaXmlSchemaTests
extends JaxbContextModelTestCase {
    public GenericJavaXmlSchemaTests(String name) {
        super(name);
    }

    private ICompilationUnit createPackageInfoWithXmlSchema() throws CoreException {
        return this.createTestPackageInfo("@XmlSchema", new String[]{"javax.xml.bind.annotation.XmlSchema"});
    }

    private ICompilationUnit createPackageInfoWithAccessorType() throws CoreException {
        return this.createTestPackageInfo("@XmlAccessorType(value = XmlAccessType.PROPERTY)", new String[]{"javax.xml.bind.annotation.XmlAccessType", "javax.xml.bind.annotation.XmlAccessorType"});
    }

    public void testModifyNamespace() throws Exception {
        this.createPackageInfoWithXmlSchema();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaXmlSchema contextXmlSchema = contextPackageInfo.getXmlSchema();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        GenericJavaXmlSchemaTests.assertEquals((String)"", (String)contextXmlSchema.getNamespace());
        GenericJavaXmlSchemaTests.assertNull((Object)contextXmlSchema.getSpecifiedNamespace());
        contextXmlSchema.setSpecifiedNamespace("foo");
        XmlSchemaAnnotation schemaAnnotation = (XmlSchemaAnnotation)resourcePackage.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        GenericJavaXmlSchemaTests.assertEquals((String)"foo", (String)schemaAnnotation.getNamespace());
        GenericJavaXmlSchemaTests.assertEquals((String)"foo", (String)contextXmlSchema.getNamespace());
        GenericJavaXmlSchemaTests.assertEquals((String)"foo", (String)contextXmlSchema.getSpecifiedNamespace());
        contextPackageInfo.setSpecifiedAccessType(XmlAccessType.FIELD);
        contextXmlSchema.setSpecifiedNamespace(null);
        schemaAnnotation = (XmlSchemaAnnotation)resourcePackage.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        GenericJavaXmlSchemaTests.assertNull((Object)schemaAnnotation.getNamespace());
        GenericJavaXmlSchemaTests.assertEquals((String)"", (String)contextXmlSchema.getNamespace());
        GenericJavaXmlSchemaTests.assertNull((Object)contextXmlSchema.getSpecifiedNamespace());
        contextXmlSchema.setSpecifiedNamespace("foo");
        schemaAnnotation = (XmlSchemaAnnotation)resourcePackage.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        GenericJavaXmlSchemaTests.assertEquals((String)"foo", (String)schemaAnnotation.getNamespace());
        GenericJavaXmlSchemaTests.assertEquals((String)"foo", (String)contextXmlSchema.getSpecifiedNamespace());
        GenericJavaXmlSchemaTests.assertEquals((String)"foo", (String)contextXmlSchema.getNamespace());
    }

    public void testUpdateNamespace() throws Exception {
        this.createPackageInfoWithXmlSchema();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaXmlSchema contextXmlSchema = contextPackageInfo.getXmlSchema();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        GenericJavaXmlSchemaTests.assertEquals((String)"", (String)contextXmlSchema.getNamespace());
        GenericJavaXmlSchemaTests.assertNull((Object)contextXmlSchema.getSpecifiedNamespace());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourcePackage);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSchemaTests.this.addXmlSchemaMemberValuePair(declaration, "namespace", "foo");
            }
        });
        GenericJavaXmlSchemaTests.assertEquals((String)"foo", (String)contextXmlSchema.getNamespace());
        GenericJavaXmlSchemaTests.assertEquals((String)"foo", (String)contextXmlSchema.getSpecifiedNamespace());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSchemaTests.this.removeXmlSchemaAnnotation(declaration);
            }
        });
        contextXmlSchema = contextPackageInfo.getXmlSchema();
        GenericJavaXmlSchemaTests.assertEquals((String)"", (String)contextXmlSchema.getNamespace());
        GenericJavaXmlSchemaTests.assertNull((Object)contextXmlSchema.getSpecifiedNamespace());
    }

    public void testModifyLocation() throws Exception {
        this.createPackageInfoWithXmlSchema();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaXmlSchema contextXmlSchema = contextPackageInfo.getXmlSchema();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        GenericJavaXmlSchemaTests.assertNull((Object)contextXmlSchema.getLocation());
        contextXmlSchema.setLocation("foo");
        XmlSchemaAnnotation schemaAnnotation = (XmlSchemaAnnotation)resourcePackage.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        GenericJavaXmlSchemaTests.assertEquals((String)"foo", (String)schemaAnnotation.getLocation());
        GenericJavaXmlSchemaTests.assertEquals((String)"foo", (String)contextXmlSchema.getLocation());
        contextPackageInfo.setSpecifiedAccessType(XmlAccessType.FIELD);
        contextXmlSchema.setLocation(null);
        schemaAnnotation = (XmlSchemaAnnotation)resourcePackage.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        GenericJavaXmlSchemaTests.assertNull((Object)schemaAnnotation.getLocation());
        GenericJavaXmlSchemaTests.assertNull((Object)contextXmlSchema.getLocation());
        contextXmlSchema.setLocation("foo");
        schemaAnnotation = (XmlSchemaAnnotation)resourcePackage.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        GenericJavaXmlSchemaTests.assertEquals((String)"foo", (String)schemaAnnotation.getLocation());
        GenericJavaXmlSchemaTests.assertEquals((String)"foo", (String)contextXmlSchema.getLocation());
    }

    public void testUpdateLocation() throws Exception {
        this.createPackageInfoWithXmlSchema();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaXmlSchema contextXmlSchema = contextPackageInfo.getXmlSchema();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        GenericJavaXmlSchemaTests.assertNull((Object)contextXmlSchema.getLocation());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourcePackage);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSchemaTests.this.addXmlSchemaMemberValuePair(declaration, "location", "foo");
            }
        });
        GenericJavaXmlSchemaTests.assertEquals((String)"foo", (String)contextXmlSchema.getLocation());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSchemaTests.this.removeXmlSchemaAnnotation(declaration);
            }
        });
        contextXmlSchema = contextPackageInfo.getXmlSchema();
        GenericJavaXmlSchemaTests.assertNull((Object)contextXmlSchema.getLocation());
    }

    public void testModifyAttributeFormDefault() throws Exception {
        this.createPackageInfoWithXmlSchema();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaXmlSchema contextXmlSchema = contextPackageInfo.getXmlSchema();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        GenericJavaXmlSchemaTests.assertNull((Object)contextXmlSchema.getSpecifiedAttributeFormDefault());
        GenericJavaXmlSchemaTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.context.XmlNsForm.UNSET, (Object)contextXmlSchema.getAttributeFormDefault());
        contextXmlSchema.setSpecifiedAttributeFormDefault(org.eclipse.jpt.jaxb.core.context.XmlNsForm.QUALIFIED);
        XmlSchemaAnnotation schemaAnnotation = (XmlSchemaAnnotation)resourcePackage.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        GenericJavaXmlSchemaTests.assertEquals((Object)XmlNsForm.QUALIFIED, (Object)schemaAnnotation.getAttributeFormDefault());
        GenericJavaXmlSchemaTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.context.XmlNsForm.QUALIFIED, (Object)contextXmlSchema.getAttributeFormDefault());
        contextXmlSchema.setSpecifiedAttributeFormDefault(org.eclipse.jpt.jaxb.core.context.XmlNsForm.UNQUALIFIED);
        GenericJavaXmlSchemaTests.assertEquals((Object)XmlNsForm.UNQUALIFIED, (Object)schemaAnnotation.getAttributeFormDefault());
        GenericJavaXmlSchemaTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.context.XmlNsForm.UNQUALIFIED, (Object)contextXmlSchema.getAttributeFormDefault());
        contextPackageInfo.setSpecifiedAccessType(XmlAccessType.FIELD);
        contextXmlSchema.setSpecifiedAttributeFormDefault(null);
        schemaAnnotation = (XmlSchemaAnnotation)resourcePackage.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        GenericJavaXmlSchemaTests.assertNull((Object)schemaAnnotation.getAttributeFormDefault());
        GenericJavaXmlSchemaTests.assertNull((Object)contextXmlSchema.getSpecifiedAttributeFormDefault());
        contextXmlSchema.setSpecifiedAttributeFormDefault(org.eclipse.jpt.jaxb.core.context.XmlNsForm.QUALIFIED);
        schemaAnnotation = (XmlSchemaAnnotation)resourcePackage.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        GenericJavaXmlSchemaTests.assertEquals((Object)XmlNsForm.QUALIFIED, (Object)schemaAnnotation.getAttributeFormDefault());
        GenericJavaXmlSchemaTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.context.XmlNsForm.QUALIFIED, (Object)contextXmlSchema.getAttributeFormDefault());
    }

    public void testUpdateAttributeFormDefault() throws Exception {
        this.createPackageInfoWithXmlSchema();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaXmlSchema contextXmlSchema = contextPackageInfo.getXmlSchema();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        GenericJavaXmlSchemaTests.assertNull((Object)contextXmlSchema.getSpecifiedAttributeFormDefault());
        GenericJavaXmlSchemaTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.context.XmlNsForm.UNSET, (Object)contextXmlSchema.getAttributeFormDefault());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourcePackage);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSchemaTests.this.addXmlSchemaEnumMemberValuePair(declaration, "attributeFormDefault", "javax.xml.bind.annotation.XmlNsForm.QUALIFIED");
            }
        });
        GenericJavaXmlSchemaTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.context.XmlNsForm.QUALIFIED, (Object)contextXmlSchema.getSpecifiedAttributeFormDefault());
        GenericJavaXmlSchemaTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.context.XmlNsForm.QUALIFIED, (Object)contextXmlSchema.getAttributeFormDefault());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSchemaTests.this.setXmlSchemaEnumMemberValuePair(declaration, "attributeFormDefault", "javax.xml.bind.annotation.XmlNsForm.UNQUALIFIED");
            }
        });
        GenericJavaXmlSchemaTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.context.XmlNsForm.UNQUALIFIED, (Object)contextXmlSchema.getSpecifiedAttributeFormDefault());
        GenericJavaXmlSchemaTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.context.XmlNsForm.UNQUALIFIED, (Object)contextXmlSchema.getAttributeFormDefault());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSchemaTests.this.removeXmlSchemaAnnotation(declaration);
            }
        });
        contextXmlSchema = contextPackageInfo.getXmlSchema();
        GenericJavaXmlSchemaTests.assertNull((Object)contextXmlSchema.getSpecifiedAttributeFormDefault());
        GenericJavaXmlSchemaTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.context.XmlNsForm.UNSET, (Object)contextXmlSchema.getAttributeFormDefault());
    }

    public void testModifyElementFormDefault() throws Exception {
        this.createPackageInfoWithXmlSchema();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaXmlSchema contextXmlSchema = contextPackageInfo.getXmlSchema();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        GenericJavaXmlSchemaTests.assertNull((Object)contextXmlSchema.getSpecifiedElementFormDefault());
        GenericJavaXmlSchemaTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.context.XmlNsForm.UNSET, (Object)contextXmlSchema.getElementFormDefault());
        contextXmlSchema.setSpecifiedElementFormDefault(org.eclipse.jpt.jaxb.core.context.XmlNsForm.QUALIFIED);
        XmlSchemaAnnotation schemaAnnotation = (XmlSchemaAnnotation)resourcePackage.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        GenericJavaXmlSchemaTests.assertEquals((Object)XmlNsForm.QUALIFIED, (Object)schemaAnnotation.getElementFormDefault());
        GenericJavaXmlSchemaTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.context.XmlNsForm.QUALIFIED, (Object)contextXmlSchema.getElementFormDefault());
        contextXmlSchema.setSpecifiedElementFormDefault(org.eclipse.jpt.jaxb.core.context.XmlNsForm.UNQUALIFIED);
        GenericJavaXmlSchemaTests.assertEquals((Object)XmlNsForm.UNQUALIFIED, (Object)schemaAnnotation.getElementFormDefault());
        GenericJavaXmlSchemaTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.context.XmlNsForm.UNQUALIFIED, (Object)contextXmlSchema.getElementFormDefault());
        contextPackageInfo.setSpecifiedAccessType(XmlAccessType.FIELD);
        contextXmlSchema.setSpecifiedElementFormDefault(null);
        schemaAnnotation = (XmlSchemaAnnotation)resourcePackage.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        GenericJavaXmlSchemaTests.assertNull((Object)schemaAnnotation.getElementFormDefault());
        GenericJavaXmlSchemaTests.assertNull((Object)contextXmlSchema.getSpecifiedElementFormDefault());
        contextXmlSchema.setSpecifiedElementFormDefault(org.eclipse.jpt.jaxb.core.context.XmlNsForm.QUALIFIED);
        schemaAnnotation = (XmlSchemaAnnotation)resourcePackage.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        GenericJavaXmlSchemaTests.assertEquals((Object)XmlNsForm.QUALIFIED, (Object)schemaAnnotation.getElementFormDefault());
        GenericJavaXmlSchemaTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.context.XmlNsForm.QUALIFIED, (Object)contextXmlSchema.getElementFormDefault());
    }

    public void testUpdateElementFormDefault() throws Exception {
        this.createPackageInfoWithXmlSchema();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaXmlSchema contextXmlSchema = contextPackageInfo.getXmlSchema();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        GenericJavaXmlSchemaTests.assertNull((Object)contextXmlSchema.getSpecifiedElementFormDefault());
        GenericJavaXmlSchemaTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.context.XmlNsForm.UNSET, (Object)contextXmlSchema.getElementFormDefault());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourcePackage);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSchemaTests.this.addXmlSchemaEnumMemberValuePair(declaration, "elementFormDefault", "javax.xml.bind.annotation.XmlNsForm.QUALIFIED");
            }
        });
        GenericJavaXmlSchemaTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.context.XmlNsForm.QUALIFIED, (Object)contextXmlSchema.getSpecifiedElementFormDefault());
        GenericJavaXmlSchemaTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.context.XmlNsForm.QUALIFIED, (Object)contextXmlSchema.getElementFormDefault());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSchemaTests.this.setXmlSchemaEnumMemberValuePair(declaration, "elementFormDefault", "javax.xml.bind.annotation.XmlNsForm.UNQUALIFIED");
            }
        });
        GenericJavaXmlSchemaTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.context.XmlNsForm.UNQUALIFIED, (Object)contextXmlSchema.getSpecifiedElementFormDefault());
        GenericJavaXmlSchemaTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.context.XmlNsForm.UNQUALIFIED, (Object)contextXmlSchema.getElementFormDefault());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSchemaTests.this.removeXmlSchemaAnnotation(declaration);
            }
        });
        contextXmlSchema = contextPackageInfo.getXmlSchema();
        GenericJavaXmlSchemaTests.assertNull((Object)contextXmlSchema.getSpecifiedElementFormDefault());
        GenericJavaXmlSchemaTests.assertEquals((Object)org.eclipse.jpt.jaxb.core.context.XmlNsForm.UNSET, (Object)contextXmlSchema.getElementFormDefault());
    }

    public void testGetXmlNsPrefixes() throws Exception {
        this.createPackageInfoWithXmlSchema();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaXmlSchema contextXmlSchema = contextPackageInfo.getXmlSchema();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        ListIterable xmlNsPrefixes = contextXmlSchema.getXmlNsPrefixes();
        GenericJavaXmlSchemaTests.assertFalse((boolean)xmlNsPrefixes.iterator().hasNext());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourcePackage);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSchemaTests.this.addXmlNs(declaration, 0, "bar", "barPrefix");
                GenericJavaXmlSchemaTests.this.addXmlNs(declaration, 1, "foo", "fooPrefix");
            }
        });
        xmlNsPrefixes = contextXmlSchema.getXmlNsPrefixes();
        ListIterator xmlNsPrefixesIterator = xmlNsPrefixes.iterator();
        GenericJavaXmlSchemaTests.assertTrue((boolean)xmlNsPrefixesIterator.hasNext());
        XmlNs xmlNsPref = (XmlNs)xmlNsPrefixesIterator.next();
        GenericJavaXmlSchemaTests.assertEquals((String)"bar", (String)xmlNsPref.getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"barPrefix", (String)xmlNsPref.getPrefix());
        xmlNsPref = (XmlNs)xmlNsPrefixesIterator.next();
        GenericJavaXmlSchemaTests.assertEquals((String)"foo", (String)xmlNsPref.getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"fooPrefix", (String)xmlNsPref.getPrefix());
        GenericJavaXmlSchemaTests.assertFalse((boolean)xmlNsPrefixesIterator.hasNext());
    }

    protected void addXmlNs(ModifiedDeclaration declaration, int index, String namespaceURI, String prefix) {
        NormalAnnotation arrayElement = this.newXmlNsAnnotation(declaration.getAst(), namespaceURI, prefix);
        this.addArrayElement(declaration, "javax.xml.bind.annotation.XmlSchema", index, "xmlns", (Expression)arrayElement);
    }

    protected NormalAnnotation newXmlNsAnnotation(AST ast, String namespaceURI, String prefix) {
        NormalAnnotation annotation = this.newNormalAnnotation(ast, "javax.xml.bind.annotation.XmlNs");
        this.addMemberValuePair(annotation, "namespaceURI", namespaceURI);
        this.addMemberValuePair(annotation, "prefix", prefix);
        return annotation;
    }

    public void testGetXmlNsPrexiesSize() throws Exception {
        this.createPackageInfoWithXmlSchema();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaXmlSchema contextXmlSchema = contextPackageInfo.getXmlSchema();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        GenericJavaXmlSchemaTests.assertEquals((int)0, (int)contextXmlSchema.getXmlNsPrefixesSize());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourcePackage);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSchemaTests.this.addXmlNs(declaration, 0, "bar", "barPrefix");
                GenericJavaXmlSchemaTests.this.addXmlNs(declaration, 1, "foo", "fooPrefix");
            }
        });
        GenericJavaXmlSchemaTests.assertEquals((int)2, (int)contextXmlSchema.getXmlNsPrefixesSize());
    }

    public void testAddXmlNsPrefix() throws Exception {
        this.createPackageInfoWithAccessorType();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaXmlSchema contextXmlSchema = contextPackageInfo.getXmlSchema();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        XmlNs xmlNsPrefix = contextXmlSchema.addXmlNsPrefix(0);
        xmlNsPrefix.setNamespaceURI("bar");
        xmlNsPrefix.setPrefix("barPrefix");
        xmlNsPrefix = contextXmlSchema.addXmlNsPrefix(0);
        xmlNsPrefix.setNamespaceURI("foo");
        xmlNsPrefix.setPrefix("fooPrefix");
        xmlNsPrefix = contextXmlSchema.addXmlNsPrefix(0);
        xmlNsPrefix.setNamespaceURI("baz");
        xmlNsPrefix.setPrefix("bazPrefix");
        XmlSchemaAnnotation schemaAnnotation = (XmlSchemaAnnotation)resourcePackage.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        ListIterator xmlNsPrefixes = schemaAnnotation.getXmlns().iterator();
        XmlNsAnnotation xmlNsAnnotation = (XmlNsAnnotation)xmlNsPrefixes.next();
        GenericJavaXmlSchemaTests.assertEquals((String)"baz", (String)xmlNsAnnotation.getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"bazPrefix", (String)xmlNsAnnotation.getPrefix());
        xmlNsAnnotation = (XmlNsAnnotation)xmlNsPrefixes.next();
        GenericJavaXmlSchemaTests.assertEquals((String)"foo", (String)xmlNsAnnotation.getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"fooPrefix", (String)xmlNsAnnotation.getPrefix());
        xmlNsAnnotation = (XmlNsAnnotation)xmlNsPrefixes.next();
        GenericJavaXmlSchemaTests.assertEquals((String)"bar", (String)xmlNsAnnotation.getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"barPrefix", (String)xmlNsAnnotation.getPrefix());
        GenericJavaXmlSchemaTests.assertFalse((boolean)xmlNsPrefixes.hasNext());
    }

    public void testAddXmlNsPrefix2() throws Exception {
        this.createPackageInfoWithXmlSchema();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaXmlSchema contextXmlSchema = contextPackageInfo.getXmlSchema();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        XmlNs xmlNsPrefix = contextXmlSchema.addXmlNsPrefix(0);
        xmlNsPrefix.setNamespaceURI("bar");
        xmlNsPrefix.setPrefix("barPrefix");
        xmlNsPrefix = contextXmlSchema.addXmlNsPrefix(1);
        xmlNsPrefix.setNamespaceURI("foo");
        xmlNsPrefix.setPrefix("fooPrefix");
        xmlNsPrefix = contextXmlSchema.addXmlNsPrefix(0);
        xmlNsPrefix.setNamespaceURI("baz");
        xmlNsPrefix.setPrefix("bazPrefix");
        XmlSchemaAnnotation schemaAnnotation = (XmlSchemaAnnotation)resourcePackage.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        ListIterator xmlNsPrefixes = schemaAnnotation.getXmlns().iterator();
        XmlNsAnnotation xmlNsAnnotation = (XmlNsAnnotation)xmlNsPrefixes.next();
        GenericJavaXmlSchemaTests.assertEquals((String)"baz", (String)xmlNsAnnotation.getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"bazPrefix", (String)xmlNsAnnotation.getPrefix());
        xmlNsAnnotation = (XmlNsAnnotation)xmlNsPrefixes.next();
        GenericJavaXmlSchemaTests.assertEquals((String)"bar", (String)xmlNsAnnotation.getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"barPrefix", (String)xmlNsAnnotation.getPrefix());
        xmlNsAnnotation = (XmlNsAnnotation)xmlNsPrefixes.next();
        GenericJavaXmlSchemaTests.assertEquals((String)"foo", (String)xmlNsAnnotation.getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"fooPrefix", (String)xmlNsAnnotation.getPrefix());
        GenericJavaXmlSchemaTests.assertFalse((boolean)xmlNsPrefixes.hasNext());
    }

    public void testRemoveXmlNsPrefix() throws Exception {
        this.createPackageInfoWithXmlSchema();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaXmlSchema contextXmlSchema = contextPackageInfo.getXmlSchema();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        contextXmlSchema.addXmlNsPrefix(0).setNamespaceURI("bar");
        contextXmlSchema.addXmlNsPrefix(1).setNamespaceURI("foo");
        contextXmlSchema.addXmlNsPrefix(2).setNamespaceURI("baz");
        XmlSchemaAnnotation schemaAnnotation = (XmlSchemaAnnotation)resourcePackage.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        GenericJavaXmlSchemaTests.assertEquals((int)3, (int)schemaAnnotation.getXmlnsSize());
        contextXmlSchema.removeXmlNsPrefix(1);
        ListIterator xmlNsPrefixes = schemaAnnotation.getXmlns().iterator();
        GenericJavaXmlSchemaTests.assertEquals((String)"bar", (String)((XmlNsAnnotation)xmlNsPrefixes.next()).getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"baz", (String)((XmlNsAnnotation)xmlNsPrefixes.next()).getNamespaceURI());
        GenericJavaXmlSchemaTests.assertFalse((boolean)xmlNsPrefixes.hasNext());
        contextXmlSchema.removeXmlNsPrefix(1);
        xmlNsPrefixes = schemaAnnotation.getXmlns().iterator();
        GenericJavaXmlSchemaTests.assertEquals((String)"bar", (String)((XmlNsAnnotation)xmlNsPrefixes.next()).getNamespaceURI());
        GenericJavaXmlSchemaTests.assertFalse((boolean)xmlNsPrefixes.hasNext());
        contextXmlSchema.removeXmlNsPrefix(0);
        xmlNsPrefixes = schemaAnnotation.getXmlns().iterator();
        GenericJavaXmlSchemaTests.assertFalse((boolean)xmlNsPrefixes.hasNext());
    }

    public void testMoveXmlNsPrefix() throws Exception {
        this.createPackageInfoWithXmlSchema();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaXmlSchema contextXmlSchema = contextPackageInfo.getXmlSchema();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        contextXmlSchema.addXmlNsPrefix(0).setNamespaceURI("bar");
        contextXmlSchema.addXmlNsPrefix(1).setNamespaceURI("foo");
        contextXmlSchema.addXmlNsPrefix(2).setNamespaceURI("baz");
        XmlSchemaAnnotation schemaAnnotation = (XmlSchemaAnnotation)resourcePackage.getAnnotation("javax.xml.bind.annotation.XmlSchema");
        GenericJavaXmlSchemaTests.assertEquals((int)3, (int)schemaAnnotation.getXmlnsSize());
        contextXmlSchema.moveXmlNsPrefix(2, 0);
        ListIterator xmlNsPrefixes = contextXmlSchema.getXmlNsPrefixes().iterator();
        GenericJavaXmlSchemaTests.assertEquals((String)"foo", (String)((XmlNs)xmlNsPrefixes.next()).getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"baz", (String)((XmlNs)xmlNsPrefixes.next()).getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"bar", (String)((XmlNs)xmlNsPrefixes.next()).getNamespaceURI());
        GenericJavaXmlSchemaTests.assertFalse((boolean)xmlNsPrefixes.hasNext());
        ListIterator xmlNsAnnotations = schemaAnnotation.getXmlns().iterator();
        GenericJavaXmlSchemaTests.assertEquals((String)"foo", (String)((XmlNsAnnotation)xmlNsAnnotations.next()).getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"baz", (String)((XmlNsAnnotation)xmlNsAnnotations.next()).getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"bar", (String)((XmlNsAnnotation)xmlNsAnnotations.next()).getNamespaceURI());
        contextXmlSchema.moveXmlNsPrefix(0, 1);
        xmlNsPrefixes = contextXmlSchema.getXmlNsPrefixes().iterator();
        GenericJavaXmlSchemaTests.assertEquals((String)"baz", (String)((XmlNs)xmlNsPrefixes.next()).getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"foo", (String)((XmlNs)xmlNsPrefixes.next()).getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"bar", (String)((XmlNs)xmlNsPrefixes.next()).getNamespaceURI());
        GenericJavaXmlSchemaTests.assertFalse((boolean)xmlNsPrefixes.hasNext());
        xmlNsAnnotations = schemaAnnotation.getXmlns().iterator();
        GenericJavaXmlSchemaTests.assertEquals((String)"baz", (String)((XmlNsAnnotation)xmlNsAnnotations.next()).getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"foo", (String)((XmlNsAnnotation)xmlNsAnnotations.next()).getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"bar", (String)((XmlNsAnnotation)xmlNsAnnotations.next()).getNamespaceURI());
    }

    public void testSyncXmlNsPrefixes() throws Exception {
        this.createPackageInfoWithXmlSchema();
        JaxbPackageInfo contextPackageInfo = ((JaxbPackage)IterableTools.get((Iterable)this.getContextRoot().getPackages(), (int)0)).getPackageInfo();
        JavaXmlSchema contextXmlSchema = contextPackageInfo.getXmlSchema();
        JavaResourcePackage resourcePackage = contextPackageInfo.getResourcePackage();
        ListIterable xmlNsPrefixes = contextXmlSchema.getXmlNsPrefixes();
        GenericJavaXmlSchemaTests.assertFalse((boolean)xmlNsPrefixes.iterator().hasNext());
        AnnotatedElement annotatedElement = this.annotatedElement((JavaResourceAnnotatedElement)resourcePackage);
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSchemaTests.this.addXmlNs(declaration, 0, "bar", "barPrefix");
                GenericJavaXmlSchemaTests.this.addXmlNs(declaration, 1, "foo", "fooPrefix");
                GenericJavaXmlSchemaTests.this.addXmlNs(declaration, 2, "baz", "bazPrefix");
            }
        });
        xmlNsPrefixes = contextXmlSchema.getXmlNsPrefixes();
        ListIterator xmlNsPrefixesIterator = xmlNsPrefixes.iterator();
        GenericJavaXmlSchemaTests.assertTrue((boolean)xmlNsPrefixesIterator.hasNext());
        XmlNs xmlNsPref = (XmlNs)xmlNsPrefixesIterator.next();
        GenericJavaXmlSchemaTests.assertEquals((String)"bar", (String)xmlNsPref.getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"barPrefix", (String)xmlNsPref.getPrefix());
        xmlNsPref = (XmlNs)xmlNsPrefixesIterator.next();
        GenericJavaXmlSchemaTests.assertEquals((String)"foo", (String)xmlNsPref.getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"fooPrefix", (String)xmlNsPref.getPrefix());
        xmlNsPref = (XmlNs)xmlNsPrefixesIterator.next();
        GenericJavaXmlSchemaTests.assertEquals((String)"baz", (String)xmlNsPref.getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"bazPrefix", (String)xmlNsPref.getPrefix());
        GenericJavaXmlSchemaTests.assertFalse((boolean)xmlNsPrefixesIterator.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSchemaTests.this.moveXmlNsPrefix(declaration, 2, 0);
            }
        });
        xmlNsPrefixesIterator = xmlNsPrefixes.iterator();
        GenericJavaXmlSchemaTests.assertTrue((boolean)xmlNsPrefixesIterator.hasNext());
        xmlNsPref = (XmlNs)xmlNsPrefixesIterator.next();
        GenericJavaXmlSchemaTests.assertEquals((String)"foo", (String)xmlNsPref.getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"fooPrefix", (String)xmlNsPref.getPrefix());
        xmlNsPref = (XmlNs)xmlNsPrefixesIterator.next();
        GenericJavaXmlSchemaTests.assertEquals((String)"baz", (String)xmlNsPref.getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"bazPrefix", (String)xmlNsPref.getPrefix());
        xmlNsPref = (XmlNs)xmlNsPrefixesIterator.next();
        GenericJavaXmlSchemaTests.assertEquals((String)"bar", (String)xmlNsPref.getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"barPrefix", (String)xmlNsPref.getPrefix());
        GenericJavaXmlSchemaTests.assertFalse((boolean)xmlNsPrefixesIterator.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSchemaTests.this.moveXmlNsPrefix(declaration, 0, 1);
            }
        });
        xmlNsPrefixesIterator = xmlNsPrefixes.iterator();
        GenericJavaXmlSchemaTests.assertTrue((boolean)xmlNsPrefixesIterator.hasNext());
        xmlNsPref = (XmlNs)xmlNsPrefixesIterator.next();
        GenericJavaXmlSchemaTests.assertEquals((String)"baz", (String)xmlNsPref.getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"bazPrefix", (String)xmlNsPref.getPrefix());
        xmlNsPref = (XmlNs)xmlNsPrefixesIterator.next();
        GenericJavaXmlSchemaTests.assertEquals((String)"foo", (String)xmlNsPref.getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"fooPrefix", (String)xmlNsPref.getPrefix());
        xmlNsPref = (XmlNs)xmlNsPrefixesIterator.next();
        GenericJavaXmlSchemaTests.assertEquals((String)"bar", (String)xmlNsPref.getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"barPrefix", (String)xmlNsPref.getPrefix());
        GenericJavaXmlSchemaTests.assertFalse((boolean)xmlNsPrefixesIterator.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSchemaTests.this.removeXmlNsPrefix(declaration, 1);
            }
        });
        xmlNsPrefixesIterator = xmlNsPrefixes.iterator();
        GenericJavaXmlSchemaTests.assertTrue((boolean)xmlNsPrefixesIterator.hasNext());
        xmlNsPref = (XmlNs)xmlNsPrefixesIterator.next();
        GenericJavaXmlSchemaTests.assertEquals((String)"baz", (String)xmlNsPref.getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"bazPrefix", (String)xmlNsPref.getPrefix());
        xmlNsPref = (XmlNs)xmlNsPrefixesIterator.next();
        GenericJavaXmlSchemaTests.assertEquals((String)"bar", (String)xmlNsPref.getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"barPrefix", (String)xmlNsPref.getPrefix());
        GenericJavaXmlSchemaTests.assertFalse((boolean)xmlNsPrefixesIterator.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSchemaTests.this.removeXmlNsPrefix(declaration, 1);
            }
        });
        xmlNsPrefixesIterator = xmlNsPrefixes.iterator();
        GenericJavaXmlSchemaTests.assertTrue((boolean)xmlNsPrefixesIterator.hasNext());
        xmlNsPref = (XmlNs)xmlNsPrefixesIterator.next();
        GenericJavaXmlSchemaTests.assertEquals((String)"baz", (String)xmlNsPref.getNamespaceURI());
        GenericJavaXmlSchemaTests.assertEquals((String)"bazPrefix", (String)xmlNsPref.getPrefix());
        GenericJavaXmlSchemaTests.assertFalse((boolean)xmlNsPrefixesIterator.hasNext());
        annotatedElement.edit(new AnnotatedElement.Editor(){

            public void edit(ModifiedDeclaration declaration) {
                GenericJavaXmlSchemaTests.this.removeXmlNsPrefix(declaration, 0);
            }
        });
        xmlNsPrefixesIterator = xmlNsPrefixes.iterator();
        GenericJavaXmlSchemaTests.assertFalse((boolean)xmlNsPrefixesIterator.hasNext());
    }

    protected void addXmlSchemaEnumMemberValuePair(ModifiedDeclaration declaration, String elementName, String value) {
        this.addEnumMemberValuePair((MarkerAnnotation)this.getXmlSchemaAnnotation(declaration), elementName, value);
    }

    protected void setXmlSchemaEnumMemberValuePair(ModifiedDeclaration declaration, String elementName, String enumValue) {
        this.setEnumMemberValuePair((NormalAnnotation)this.getXmlSchemaAnnotation(declaration), elementName, enumValue);
    }

    protected void addXmlSchemaMemberValuePair(ModifiedDeclaration declaration, String name, String value) {
        this.addMemberValuePair((MarkerAnnotation)this.getXmlSchemaAnnotation(declaration), name, value);
    }

    protected void removeXmlSchemaAnnotation(ModifiedDeclaration declaration) {
        this.addMarkerAnnotation(declaration.getDeclaration(), "javax.xml.bind.annotation.XmlAccessorOrder");
        this.removeAnnotation(declaration, "javax.xml.bind.annotation.XmlSchema");
    }

    protected Annotation getXmlSchemaAnnotation(ModifiedDeclaration declaration) {
        return declaration.getAnnotationNamed("javax.xml.bind.annotation.XmlSchema");
    }

    protected void moveXmlNsPrefix(ModifiedDeclaration declaration, int targetIndex, int sourceIndex) {
        this.moveArrayElement((NormalAnnotation)this.getXmlSchemaAnnotation(declaration), "xmlns", targetIndex, sourceIndex);
    }

    protected void removeXmlNsPrefix(ModifiedDeclaration declaration, int index) {
        this.removeArrayElement((NormalAnnotation)this.getXmlSchemaAnnotation(declaration), "xmlns", index);
    }
}

