/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.oxm;

import java.beans.Introspector;
import org.eclipse.jpt.common.core.resource.xml.JptXmlResource;
import org.eclipse.jpt.jaxb.core.context.XmlAccessOrder;
import org.eclipse.jpt.jaxb.core.context.XmlAccessType;
import org.eclipse.jpt.jaxb.core.context.java.JavaClassMapping;
import org.eclipse.jpt.jaxb.eclipselink.core.context.ELJaxbContextRoot;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmFile;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmJavaType;
import org.eclipse.jpt.jaxb.eclipselink.core.context.oxm.OxmXmlBindings;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EJavaType;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EXmlAccessOrder;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EXmlAccessType;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EXmlBindings;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.EXmlType;
import org.eclipse.jpt.jaxb.eclipselink.core.resource.oxm.OxmFactory;
import org.eclipse.jpt.jaxb.eclipselink.core.tests.internal.context.oxm.OxmContextModelTestCase;

public class OxmJavaTypeTests
extends OxmContextModelTestCase {
    public OxmJavaTypeTests(String name) {
        super(name);
    }

    protected void addOxmFile(String fileName, String packageName, String typeName) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(CR);
        sb.append("<xml-bindings").append(CR);
        sb.append("    version=\"2.4\"").append(CR);
        sb.append("    xmlns=\"http://www.eclipse.org/eclipselink/xsds/persistence/oxm\"").append(CR);
        sb.append("    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"").append(CR);
        sb.append("    xsi:schemaLocation=\"http://www.eclipse.org/eclipselink/xsds/persistence/oxm http://www.eclipse.org/eclipselink/xsds/eclipselink_oxm_2_4.xsd\"").append(CR);
        sb.append("    package-name=\"").append(packageName).append("\">").append(CR);
        sb.append("    <java-types>").append(CR);
        sb.append("        <java-type name=\"").append(typeName).append("\"/>").append(CR);
        sb.append("    </java-types>").append(CR);
        sb.append("</xml-bindings>").append(CR);
        this.addOxmFile(fileName, sb);
    }

    public void testUpdateName() throws Exception {
        this.addOxmFile("oxm.xml", "test.oxm", "Foo");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test.oxm");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        OxmJavaType javaType = xmlBindings.getJavaType(0);
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        EJavaType eJavaType = (EJavaType)eXmlBindings.getJavaTypes().get(0);
        OxmJavaTypeTests.assertEquals((String)"Foo", (String)eJavaType.getName());
        OxmJavaTypeTests.assertEquals((String)"Foo", (String)javaType.getSpecifiedName());
        OxmJavaTypeTests.assertEquals((String)"test.oxm.Foo", (String)javaType.getTypeName().getFullyQualifiedName());
        OxmJavaTypeTests.assertEquals((String)"Foo", (String)javaType.getTypeName().getSimpleName());
        eJavaType.setName("test.oxm2.Bar");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "name=\"test.oxm2.Bar\"", true);
        OxmJavaTypeTests.assertEquals((String)"test.oxm2.Bar", (String)eJavaType.getName());
        OxmJavaTypeTests.assertEquals((String)"test.oxm2.Bar", (String)javaType.getSpecifiedName());
        OxmJavaTypeTests.assertEquals((String)"test.oxm2.Bar", (String)javaType.getTypeName().getFullyQualifiedName());
        OxmJavaTypeTests.assertEquals((String)"Bar", (String)javaType.getTypeName().getSimpleName());
        eJavaType.setName("test.oxm2.Foo$Bar");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "name=\"test.oxm2.Foo$Bar\"", true);
        OxmJavaTypeTests.assertEquals((String)"test.oxm2.Foo$Bar", (String)eJavaType.getName());
        OxmJavaTypeTests.assertEquals((String)"test.oxm2.Foo$Bar", (String)javaType.getSpecifiedName());
        OxmJavaTypeTests.assertEquals((String)"test.oxm2.Foo$Bar", (String)javaType.getTypeName().getFullyQualifiedName());
        OxmJavaTypeTests.assertEquals((String)"Foo$Bar", (String)javaType.getTypeName().getTypeQualifiedName());
        OxmJavaTypeTests.assertEquals((String)"Bar", (String)javaType.getTypeName().getSimpleName());
        eJavaType.setName("int");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "name=\"int\"", true);
        OxmJavaTypeTests.assertEquals((String)"int", (String)eJavaType.getName());
        OxmJavaTypeTests.assertEquals((String)"int", (String)javaType.getSpecifiedName());
        OxmJavaTypeTests.assertEquals((String)"int", (String)javaType.getTypeName().getFullyQualifiedName());
        OxmJavaTypeTests.assertEquals((String)"int", (String)javaType.getTypeName().getSimpleName());
        eJavaType.setName("String");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "name=\"String\"", true);
        OxmJavaTypeTests.assertEquals((String)"String", (String)eJavaType.getName());
        OxmJavaTypeTests.assertEquals((String)"String", (String)javaType.getSpecifiedName());
        OxmJavaTypeTests.assertEquals((String)"java.lang.String", (String)javaType.getTypeName().getFullyQualifiedName());
        OxmJavaTypeTests.assertEquals((String)"String", (String)javaType.getTypeName().getSimpleName());
        eXmlBindings.setPackageName("test.oxm2");
        eJavaType.setName("Foo");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "name=\"Foo\"", true);
        OxmJavaTypeTests.assertEquals((String)"Foo", (String)eJavaType.getName());
        OxmJavaTypeTests.assertEquals((String)"Foo", (String)javaType.getSpecifiedName());
        OxmJavaTypeTests.assertEquals((String)"test.oxm2.Foo", (String)javaType.getTypeName().getFullyQualifiedName());
        OxmJavaTypeTests.assertEquals((String)"Foo", (String)javaType.getTypeName().getSimpleName());
    }

    public void testModifyName() throws Exception {
        this.addOxmFile("oxm.xml", "test.oxm", "Foo");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test.oxm");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        OxmJavaType javaType = xmlBindings.getJavaType(0);
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        EJavaType eJavaType = (EJavaType)eXmlBindings.getJavaTypes().get(0);
        OxmJavaTypeTests.assertEquals((String)"Foo", (String)eJavaType.getName());
        OxmJavaTypeTests.assertEquals((String)"Foo", (String)javaType.getSpecifiedName());
        OxmJavaTypeTests.assertEquals((String)"test.oxm.Foo", (String)javaType.getTypeName().getFullyQualifiedName());
        OxmJavaTypeTests.assertEquals((String)"Foo", (String)javaType.getTypeName().getSimpleName());
        javaType.setSpecifiedName("test.oxm2.Bar");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "name=\"test.oxm2.Bar\"", true);
        OxmJavaTypeTests.assertEquals((String)"test.oxm2.Bar", (String)eJavaType.getName());
        OxmJavaTypeTests.assertEquals((String)"test.oxm2.Bar", (String)javaType.getSpecifiedName());
        OxmJavaTypeTests.assertEquals((String)"test.oxm2.Bar", (String)javaType.getTypeName().getFullyQualifiedName());
        OxmJavaTypeTests.assertEquals((String)"Bar", (String)javaType.getTypeName().getSimpleName());
        javaType.setSpecifiedName("int");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "name=\"int\"", true);
        OxmJavaTypeTests.assertEquals((String)"int", (String)eJavaType.getName());
        OxmJavaTypeTests.assertEquals((String)"int", (String)javaType.getSpecifiedName());
        OxmJavaTypeTests.assertEquals((String)"int", (String)javaType.getTypeName().getFullyQualifiedName());
        OxmJavaTypeTests.assertEquals((String)"int", (String)javaType.getTypeName().getSimpleName());
        eJavaType.setName("String");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "name=\"String\"", true);
        OxmJavaTypeTests.assertEquals((String)"String", (String)eJavaType.getName());
        OxmJavaTypeTests.assertEquals((String)"String", (String)javaType.getSpecifiedName());
        OxmJavaTypeTests.assertEquals((String)"java.lang.String", (String)javaType.getTypeName().getFullyQualifiedName());
        OxmJavaTypeTests.assertEquals((String)"String", (String)javaType.getTypeName().getSimpleName());
        xmlBindings.setSpecifiedPackageName("test.oxm2");
        javaType.setSpecifiedName("Foo");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "name=\"Foo\"", true);
        OxmJavaTypeTests.assertEquals((String)"Foo", (String)eJavaType.getName());
        OxmJavaTypeTests.assertEquals((String)"Foo", (String)javaType.getSpecifiedName());
        OxmJavaTypeTests.assertEquals((String)"test.oxm2.Foo", (String)javaType.getTypeName().getFullyQualifiedName());
        OxmJavaTypeTests.assertEquals((String)"Foo", (String)javaType.getTypeName().getSimpleName());
    }

    public void testUpdateSuperTypeName() throws Exception {
        this.createClassWithXmlType();
        this.addOxmFile("oxm.xml", "test", "AnnotationTestType");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        OxmJavaType javaType = xmlBindings.getJavaType(0);
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        EJavaType eJavaType = (EJavaType)eXmlBindings.getJavaTypes().get(0);
        OxmJavaTypeTests.assertNull((Object)eJavaType.getSuperType());
        OxmJavaTypeTests.assertEquals((String)"java.lang.Object", (String)javaType.getSuperTypeName());
        OxmJavaTypeTests.assertEquals((String)"java.lang.Object", (String)javaType.getDefaultSuperTypeName());
        OxmJavaTypeTests.assertNull((Object)javaType.getSpecifiedSuperTypeName());
        eJavaType.setSuperType("foo");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "super-type=\"foo\"", true);
        OxmJavaTypeTests.assertEquals((String)"foo", (String)eJavaType.getSuperType());
        OxmJavaTypeTests.assertEquals((String)"foo", (String)javaType.getSuperTypeName());
        OxmJavaTypeTests.assertEquals((String)"java.lang.Object", (String)javaType.getDefaultSuperTypeName());
        OxmJavaTypeTests.assertEquals((String)"foo", (String)javaType.getSpecifiedSuperTypeName());
        eJavaType.setSuperType(null);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "super-type", false);
        OxmJavaTypeTests.assertNull((Object)eJavaType.getSuperType());
        OxmJavaTypeTests.assertEquals((String)"java.lang.Object", (String)javaType.getSuperTypeName());
        OxmJavaTypeTests.assertEquals((String)"java.lang.Object", (String)javaType.getDefaultSuperTypeName());
        OxmJavaTypeTests.assertNull((Object)javaType.getSpecifiedSuperTypeName());
    }

    public void testModifySuperTypeName() throws Exception {
        this.createClassWithXmlType();
        this.addOxmFile("oxm.xml", "test", "AnnotationTestType");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        OxmJavaType javaType = xmlBindings.getJavaType(0);
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        EJavaType eJavaType = (EJavaType)eXmlBindings.getJavaTypes().get(0);
        OxmJavaTypeTests.assertNull((Object)eJavaType.getSuperType());
        OxmJavaTypeTests.assertEquals((String)"java.lang.Object", (String)javaType.getSuperTypeName());
        OxmJavaTypeTests.assertEquals((String)"java.lang.Object", (String)javaType.getDefaultSuperTypeName());
        OxmJavaTypeTests.assertNull((Object)javaType.getSpecifiedSuperTypeName());
        javaType.setSpecifiedSuperTypeName("foo");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "super-type=\"foo\"", true);
        OxmJavaTypeTests.assertEquals((String)"foo", (String)eJavaType.getSuperType());
        OxmJavaTypeTests.assertEquals((String)"foo", (String)javaType.getSuperTypeName());
        OxmJavaTypeTests.assertEquals((String)"java.lang.Object", (String)javaType.getDefaultSuperTypeName());
        OxmJavaTypeTests.assertEquals((String)"foo", (String)javaType.getSpecifiedSuperTypeName());
        javaType.setSpecifiedSuperTypeName(null);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "super-type", false);
        OxmJavaTypeTests.assertNull((Object)eJavaType.getSuperType());
        OxmJavaTypeTests.assertEquals((String)"java.lang.Object", (String)javaType.getSuperTypeName());
        OxmJavaTypeTests.assertEquals((String)"java.lang.Object", (String)javaType.getDefaultSuperTypeName());
        OxmJavaTypeTests.assertNull((Object)javaType.getSpecifiedSuperTypeName());
    }

    public void testUpdateSuperclass() throws Exception {
        this.createClassWithXmlType();
        this.addOxmFile("oxm.xml", "test", "Foo");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        OxmJavaType javaType = xmlBindings.getJavaType(0);
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        EJavaType eJavaType = (EJavaType)eXmlBindings.getJavaTypes().get(0);
        OxmJavaTypeTests.assertNull((Object)eJavaType.getSuperType());
        OxmJavaTypeTests.assertNull((Object)javaType.getSuperclass());
        eJavaType.setSuperType("test.AnnotationTestType");
        oxmResource.save();
        OxmJavaTypeTests.assertNotNull((Object)eJavaType.getSuperType());
        OxmJavaTypeTests.assertNotNull((Object)javaType.getSuperclass());
        eJavaType.setSuperType(null);
        oxmResource.save();
        OxmJavaTypeTests.assertNull((Object)eJavaType.getSuperType());
        OxmJavaTypeTests.assertNull((Object)javaType.getSuperclass());
    }

    public void testUpdateXmlAccessOrder() throws Exception {
        this.createClassWithXmlType();
        this.addOxmFile("oxm.xml", "test", "AnnotationTestType");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        OxmJavaType oxmJavaType = xmlBindings.getJavaType(0);
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        EJavaType eJavaType = (EJavaType)eXmlBindings.getJavaTypes().get(0);
        OxmJavaType oxmSuperclass = xmlBindings.addJavaType(1);
        oxmSuperclass.setSpecifiedName("test.Superclass");
        oxmJavaType.setSpecifiedSuperTypeName("test.Superclass");
        oxmResource.save();
        JavaClassMapping javaClassMapping = oxmJavaType.getJavaType().getMapping();
        OxmJavaTypeTests.assertNull((Object)eJavaType.getXmlAccessorOrder());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)oxmJavaType.getAccessOrder());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)oxmJavaType.getDefaultAccessOrder());
        OxmJavaTypeTests.assertNull((Object)oxmJavaType.getSpecifiedAccessOrder());
        javaClassMapping.setSpecifiedAccessOrder(XmlAccessOrder.ALPHABETICAL);
        OxmJavaTypeTests.assertNull((Object)eJavaType.getXmlAccessorOrder());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessOrder.ALPHABETICAL, (Object)oxmJavaType.getAccessOrder());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessOrder.ALPHABETICAL, (Object)oxmJavaType.getDefaultAccessOrder());
        OxmJavaTypeTests.assertNull((Object)oxmJavaType.getSpecifiedAccessOrder());
        xmlBindings.setXmlMappingMetadataComplete(true);
        oxmResource.save();
        OxmJavaTypeTests.assertNull((Object)eJavaType.getXmlAccessorOrder());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)oxmJavaType.getAccessOrder());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)oxmJavaType.getDefaultAccessOrder());
        OxmJavaTypeTests.assertNull((Object)oxmJavaType.getSpecifiedAccessOrder());
        javaClassMapping.setSpecifiedAccessOrder(null);
        xmlBindings.setXmlMappingMetadataComplete(false);
        oxmSuperclass.setSpecifiedAccessOrder(XmlAccessOrder.UNDEFINED);
        oxmResource.save();
        OxmJavaTypeTests.assertNull((Object)eJavaType.getXmlAccessorOrder());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)oxmJavaType.getAccessOrder());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)oxmJavaType.getDefaultAccessOrder());
        OxmJavaTypeTests.assertNull((Object)oxmJavaType.getSpecifiedAccessOrder());
        oxmSuperclass.setSpecifiedAccessOrder(null);
        xmlBindings.setSpecifiedAccessOrder(XmlAccessOrder.ALPHABETICAL);
        oxmResource.save();
        OxmJavaTypeTests.assertNull((Object)eJavaType.getXmlAccessorOrder());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessOrder.ALPHABETICAL, (Object)oxmJavaType.getAccessOrder());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessOrder.ALPHABETICAL, (Object)oxmJavaType.getDefaultAccessOrder());
        OxmJavaTypeTests.assertNull((Object)oxmJavaType.getSpecifiedAccessOrder());
        eJavaType.setXmlAccessorOrder(EXmlAccessOrder.UNDEFINED);
        oxmResource.save();
        OxmJavaTypeTests.assertEquals((Object)EXmlAccessOrder.UNDEFINED, (Object)eJavaType.getXmlAccessorOrder());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)oxmJavaType.getAccessOrder());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessOrder.ALPHABETICAL, (Object)oxmJavaType.getDefaultAccessOrder());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)oxmJavaType.getSpecifiedAccessOrder());
        xmlBindings.setSpecifiedAccessOrder(null);
        eJavaType.setXmlAccessorOrder(null);
        oxmResource.save();
        OxmJavaTypeTests.assertNull((Object)eJavaType.getXmlAccessorOrder());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)oxmJavaType.getAccessOrder());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)oxmJavaType.getDefaultAccessOrder());
        OxmJavaTypeTests.assertNull((Object)oxmJavaType.getSpecifiedAccessOrder());
    }

    public void testModifyXmlAccessOrder() throws Exception {
        this.addOxmFile("oxm.xml", "test.oxm", "Foo");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test.oxm");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        OxmJavaType javaType = xmlBindings.getJavaType(0);
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        EJavaType eJavaType = (EJavaType)eXmlBindings.getJavaTypes().get(0);
        OxmJavaTypeTests.assertNull((Object)eJavaType.getXmlAccessorOrder());
        OxmJavaTypeTests.assertNull((Object)javaType.getSpecifiedAccessOrder());
        javaType.setSpecifiedAccessOrder(XmlAccessOrder.ALPHABETICAL);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-accessor-order=\"ALPHABETICAL\"", true);
        OxmJavaTypeTests.assertEquals((Object)EXmlAccessOrder.ALPHABETICAL, (Object)eJavaType.getXmlAccessorOrder());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessOrder.ALPHABETICAL, (Object)javaType.getSpecifiedAccessOrder());
        javaType.setSpecifiedAccessOrder(XmlAccessOrder.UNDEFINED);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-accessor-order=\"UNDEFINED\"", true);
        OxmJavaTypeTests.assertEquals((Object)EXmlAccessOrder.UNDEFINED, (Object)eJavaType.getXmlAccessorOrder());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessOrder.UNDEFINED, (Object)javaType.getSpecifiedAccessOrder());
        javaType.setSpecifiedAccessOrder(null);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-accessor-order", false);
        OxmJavaTypeTests.assertNull((Object)eJavaType.getXmlAccessorOrder());
        OxmJavaTypeTests.assertNull((Object)javaType.getSpecifiedAccessOrder());
    }

    public void testUpdateXmlAccessType() throws Exception {
        this.createClassWithXmlType();
        this.addOxmFile("oxm.xml", "test", "AnnotationTestType");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        OxmJavaType oxmJavaType = xmlBindings.getJavaType(0);
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        EJavaType eJavaType = (EJavaType)eXmlBindings.getJavaTypes().get(0);
        OxmJavaType oxmSuperclass = xmlBindings.addJavaType(1);
        oxmSuperclass.setSpecifiedName("test.Superclass");
        oxmJavaType.setSpecifiedSuperTypeName("test.Superclass");
        oxmResource.save();
        JavaClassMapping javaClassMapping = oxmJavaType.getJavaType().getMapping();
        OxmJavaTypeTests.assertNull((Object)eJavaType.getXmlAccessorType());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)oxmJavaType.getAccessType());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)oxmJavaType.getDefaultAccessType());
        OxmJavaTypeTests.assertNull((Object)oxmJavaType.getSpecifiedAccessType());
        javaClassMapping.setSpecifiedAccessType(XmlAccessType.FIELD);
        OxmJavaTypeTests.assertNull((Object)eJavaType.getXmlAccessorType());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessType.FIELD, (Object)oxmJavaType.getAccessType());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessType.FIELD, (Object)oxmJavaType.getDefaultAccessType());
        OxmJavaTypeTests.assertNull((Object)oxmJavaType.getSpecifiedAccessType());
        xmlBindings.setXmlMappingMetadataComplete(true);
        oxmResource.save();
        OxmJavaTypeTests.assertNull((Object)eJavaType.getXmlAccessorType());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)oxmJavaType.getAccessType());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)oxmJavaType.getDefaultAccessType());
        OxmJavaTypeTests.assertNull((Object)oxmJavaType.getSpecifiedAccessType());
        javaClassMapping.setSpecifiedAccessType(null);
        xmlBindings.setXmlMappingMetadataComplete(false);
        oxmSuperclass.setSpecifiedAccessType(XmlAccessType.PROPERTY);
        oxmResource.save();
        OxmJavaTypeTests.assertNull((Object)eJavaType.getXmlAccessorType());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessType.PROPERTY, (Object)oxmJavaType.getAccessType());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessType.PROPERTY, (Object)oxmJavaType.getDefaultAccessType());
        OxmJavaTypeTests.assertNull((Object)oxmJavaType.getSpecifiedAccessType());
        oxmSuperclass.setSpecifiedAccessType(null);
        xmlBindings.setSpecifiedAccessType(XmlAccessType.FIELD);
        oxmResource.save();
        OxmJavaTypeTests.assertNull((Object)eJavaType.getXmlAccessorType());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessType.FIELD, (Object)oxmJavaType.getAccessType());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessType.FIELD, (Object)oxmJavaType.getDefaultAccessType());
        OxmJavaTypeTests.assertNull((Object)oxmJavaType.getSpecifiedAccessType());
        eJavaType.setXmlAccessorType(EXmlAccessType.NONE);
        oxmResource.save();
        OxmJavaTypeTests.assertEquals((Object)EXmlAccessType.NONE, (Object)eJavaType.getXmlAccessorType());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessType.NONE, (Object)oxmJavaType.getAccessType());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessType.FIELD, (Object)oxmJavaType.getDefaultAccessType());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessType.NONE, (Object)oxmJavaType.getSpecifiedAccessType());
        xmlBindings.setSpecifiedAccessType(null);
        eJavaType.setXmlAccessorType(null);
        oxmResource.save();
        OxmJavaTypeTests.assertNull((Object)eJavaType.getXmlAccessorType());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)oxmJavaType.getAccessType());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessType.PUBLIC_MEMBER, (Object)oxmJavaType.getDefaultAccessType());
        OxmJavaTypeTests.assertNull((Object)oxmJavaType.getSpecifiedAccessType());
    }

    public void testModifyXmlAccessType() throws Exception {
        this.addOxmFile("oxm.xml", "test.oxm", "Foo");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test.oxm");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        OxmJavaType javaType = xmlBindings.getJavaType(0);
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        EJavaType eJavaType = (EJavaType)eXmlBindings.getJavaTypes().get(0);
        OxmJavaTypeTests.assertNull((Object)eJavaType.getXmlAccessorType());
        OxmJavaTypeTests.assertNull((Object)javaType.getSpecifiedAccessType());
        javaType.setSpecifiedAccessType(XmlAccessType.FIELD);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-accessor-type=\"FIELD\"", true);
        OxmJavaTypeTests.assertEquals((Object)EXmlAccessType.FIELD, (Object)eJavaType.getXmlAccessorType());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessType.FIELD, (Object)javaType.getSpecifiedAccessType());
        javaType.setSpecifiedAccessType(XmlAccessType.PROPERTY);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-accessor-type=\"PROPERTY\"", true);
        OxmJavaTypeTests.assertEquals((Object)EXmlAccessType.PROPERTY, (Object)eJavaType.getXmlAccessorType());
        OxmJavaTypeTests.assertEquals((Object)XmlAccessType.PROPERTY, (Object)javaType.getSpecifiedAccessType());
        javaType.setSpecifiedAccessType(null);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-accessor-type", false);
        OxmJavaTypeTests.assertNull((Object)eJavaType.getXmlAccessorType());
        OxmJavaTypeTests.assertNull((Object)javaType.getSpecifiedAccessType());
    }

    public void testUpdateXmlTransient() throws Exception {
        this.createClassWithXmlType();
        this.addOxmFile("oxm.xml", "test", "AnnotationTestType");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        OxmJavaType oxmMapping = xmlBindings.getJavaType(0);
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        EJavaType eJavaType = (EJavaType)eXmlBindings.getJavaTypes().get(0);
        JavaClassMapping javaMapping = oxmMapping.getJavaType().getMapping();
        OxmJavaTypeTests.assertFalse((boolean)javaMapping.isXmlTransient());
        OxmJavaTypeTests.assertFalse((boolean)oxmMapping.isDefaultXmlTransient());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getSpecifiedXmlTransient());
        OxmJavaTypeTests.assertFalse((boolean)oxmMapping.isXmlTransient());
        javaMapping.setXmlTransient(true);
        OxmJavaTypeTests.assertTrue((boolean)javaMapping.isXmlTransient());
        OxmJavaTypeTests.assertTrue((boolean)oxmMapping.isDefaultXmlTransient());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getSpecifiedXmlTransient());
        OxmJavaTypeTests.assertTrue((boolean)oxmMapping.isXmlTransient());
        xmlBindings.setXmlMappingMetadataComplete(true);
        oxmResource.save();
        OxmJavaTypeTests.assertTrue((boolean)javaMapping.isXmlTransient());
        OxmJavaTypeTests.assertFalse((boolean)oxmMapping.isDefaultXmlTransient());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getSpecifiedXmlTransient());
        OxmJavaTypeTests.assertFalse((boolean)oxmMapping.isXmlTransient());
        xmlBindings.setXmlMappingMetadataComplete(false);
        oxmResource.save();
        eJavaType.setXmlTransient(Boolean.FALSE);
        oxmResource.save();
        OxmJavaTypeTests.assertTrue((boolean)javaMapping.isXmlTransient());
        OxmJavaTypeTests.assertTrue((boolean)oxmMapping.isDefaultXmlTransient());
        OxmJavaTypeTests.assertEquals((Object)Boolean.FALSE, (Object)oxmMapping.getSpecifiedXmlTransient());
        OxmJavaTypeTests.assertFalse((boolean)oxmMapping.isXmlTransient());
        eJavaType.setXmlTransient(Boolean.TRUE);
        oxmResource.save();
        OxmJavaTypeTests.assertTrue((boolean)javaMapping.isXmlTransient());
        OxmJavaTypeTests.assertTrue((boolean)oxmMapping.isDefaultXmlTransient());
        OxmJavaTypeTests.assertEquals((Object)Boolean.TRUE, (Object)oxmMapping.getSpecifiedXmlTransient());
        OxmJavaTypeTests.assertTrue((boolean)oxmMapping.isXmlTransient());
        javaMapping.setXmlTransient(false);
        OxmJavaTypeTests.assertFalse((boolean)javaMapping.isXmlTransient());
        OxmJavaTypeTests.assertFalse((boolean)oxmMapping.isDefaultXmlTransient());
        OxmJavaTypeTests.assertEquals((Object)Boolean.TRUE, (Object)oxmMapping.getSpecifiedXmlTransient());
        OxmJavaTypeTests.assertTrue((boolean)oxmMapping.isXmlTransient());
        eJavaType.setXmlTransient(null);
        oxmResource.save();
        OxmJavaTypeTests.assertFalse((boolean)javaMapping.isXmlTransient());
        OxmJavaTypeTests.assertFalse((boolean)oxmMapping.isDefaultXmlTransient());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getSpecifiedXmlTransient());
        OxmJavaTypeTests.assertFalse((boolean)oxmMapping.isXmlTransient());
    }

    public void testModifyXmlTransient() throws Exception {
        this.createClassWithXmlType();
        this.addOxmFile("oxm.xml", "test", "AnnotationTestType");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        OxmJavaType oxmMapping = xmlBindings.getJavaType(0);
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        EJavaType eJavaType = (EJavaType)eXmlBindings.getJavaTypes().get(0);
        OxmJavaTypeTests.assertNull((Object)eJavaType.getXmlTransient());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getSpecifiedXmlTransient());
        OxmJavaTypeTests.assertFalse((boolean)oxmMapping.isXmlTransient());
        oxmMapping.setSpecifiedXmlTransient(Boolean.TRUE);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-transient=\"true\"", true);
        OxmJavaTypeTests.assertEquals((Object)Boolean.TRUE, (Object)eJavaType.getXmlTransient());
        OxmJavaTypeTests.assertEquals((Object)Boolean.TRUE, (Object)oxmMapping.getSpecifiedXmlTransient());
        OxmJavaTypeTests.assertTrue((boolean)oxmMapping.isXmlTransient());
        oxmMapping.setSpecifiedXmlTransient(Boolean.FALSE);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-transient=\"false\"", true);
        OxmJavaTypeTests.assertEquals((Object)Boolean.FALSE, (Object)eJavaType.getXmlTransient());
        OxmJavaTypeTests.assertEquals((Object)Boolean.FALSE, (Object)oxmMapping.getSpecifiedXmlTransient());
        OxmJavaTypeTests.assertFalse((boolean)oxmMapping.isXmlTransient());
        oxmMapping.setSpecifiedXmlTransient(null);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-transient", false);
        OxmJavaTypeTests.assertNull((Object)eJavaType.getXmlTransient());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getSpecifiedXmlTransient());
        OxmJavaTypeTests.assertFalse((boolean)oxmMapping.isXmlTransient());
    }

    public void testUpdateXmlRootElement() throws Exception {
        this.createClassWithXmlType();
        this.addOxmFile("oxm.xml", "test", "AnnotationTestType");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        OxmJavaType oxmMapping = xmlBindings.getJavaType(0);
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        EJavaType eJavaType = (EJavaType)eXmlBindings.getJavaTypes().get(0);
        JavaClassMapping javaMapping = oxmMapping.getJavaType().getMapping();
        OxmJavaTypeTests.assertNull((Object)javaMapping.getXmlRootElement());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getDefaultXmlRootElement());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getSpecifiedXmlRootElement());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getXmlRootElement());
        javaMapping.addXmlRootElement();
        OxmJavaTypeTests.assertNotNull((Object)javaMapping.getXmlRootElement());
        OxmJavaTypeTests.assertNotNull((Object)oxmMapping.getDefaultXmlRootElement());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getSpecifiedXmlRootElement());
        OxmJavaTypeTests.assertNotNull((Object)oxmMapping.getXmlRootElement());
        xmlBindings.setXmlMappingMetadataComplete(true);
        oxmResource.save();
        OxmJavaTypeTests.assertNotNull((Object)javaMapping.getXmlRootElement());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getDefaultXmlRootElement());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getSpecifiedXmlRootElement());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getXmlRootElement());
        xmlBindings.setXmlMappingMetadataComplete(false);
        oxmResource.save();
        eJavaType.setXmlRootElement(OxmFactory.eINSTANCE.createEXmlRootElement());
        oxmResource.save();
        OxmJavaTypeTests.assertNotNull((Object)javaMapping.getXmlRootElement());
        OxmJavaTypeTests.assertNotNull((Object)oxmMapping.getDefaultXmlRootElement());
        OxmJavaTypeTests.assertNotNull((Object)oxmMapping.getSpecifiedXmlRootElement());
        OxmJavaTypeTests.assertNotNull((Object)oxmMapping.getXmlRootElement());
        OxmJavaTypeTests.assertEquals((Object)oxmMapping.getSpecifiedXmlRootElement(), (Object)oxmMapping.getXmlRootElement());
        eJavaType.setXmlRootElement(null);
        oxmResource.save();
        OxmJavaTypeTests.assertNotNull((Object)javaMapping.getXmlRootElement());
        OxmJavaTypeTests.assertNotNull((Object)oxmMapping.getDefaultXmlRootElement());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getSpecifiedXmlRootElement());
        OxmJavaTypeTests.assertNotNull((Object)oxmMapping.getXmlRootElement());
        javaMapping.removeXmlRootElement();
        OxmJavaTypeTests.assertNull((Object)javaMapping.getXmlRootElement());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getDefaultXmlRootElement());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getSpecifiedXmlRootElement());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getXmlRootElement());
    }

    public void testModifyXmlRootElement() throws Exception {
        this.createClassWithXmlType();
        this.addOxmFile("oxm.xml", "test", "AnnotationTestType");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        OxmJavaType oxmMapping = xmlBindings.getJavaType(0);
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        EJavaType eJavaType = (EJavaType)eXmlBindings.getJavaTypes().get(0);
        OxmJavaTypeTests.assertNull((Object)eJavaType.getXmlRootElement());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getSpecifiedXmlRootElement());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getXmlRootElement());
        oxmMapping.addSpecifiedXmlRootElement();
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-root-element", true);
        OxmJavaTypeTests.assertNotNull((Object)eJavaType.getXmlRootElement());
        OxmJavaTypeTests.assertNotNull((Object)oxmMapping.getSpecifiedXmlRootElement());
        OxmJavaTypeTests.assertNotNull((Object)oxmMapping.getXmlRootElement());
        oxmMapping.removeSpecifiedXmlRootElement();
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-root-element", false);
        OxmJavaTypeTests.assertNull((Object)eJavaType.getXmlRootElement());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getSpecifiedXmlRootElement());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getXmlRootElement());
    }

    public void testUpdateXmlSeeAlso() throws Exception {
        this.createClassWithXmlType();
        this.addOxmFile("oxm.xml", "test", "AnnotationTestType");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        OxmJavaType oxmMapping = xmlBindings.getJavaType(0);
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        EJavaType eJavaType = (EJavaType)eXmlBindings.getJavaTypes().get(0);
        JavaClassMapping javaMapping = oxmMapping.getJavaType().getMapping();
        OxmJavaTypeTests.assertNull((Object)javaMapping.getXmlSeeAlso());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getDefaultXmlSeeAlso());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getSpecifiedXmlSeeAlso());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getXmlSeeAlso());
        javaMapping.addXmlSeeAlso();
        OxmJavaTypeTests.assertNotNull((Object)javaMapping.getXmlSeeAlso());
        OxmJavaTypeTests.assertNotNull((Object)oxmMapping.getDefaultXmlSeeAlso());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getSpecifiedXmlSeeAlso());
        OxmJavaTypeTests.assertNotNull((Object)oxmMapping.getXmlSeeAlso());
        xmlBindings.setXmlMappingMetadataComplete(true);
        oxmResource.save();
        OxmJavaTypeTests.assertNotNull((Object)javaMapping.getXmlSeeAlso());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getDefaultXmlSeeAlso());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getSpecifiedXmlSeeAlso());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getXmlSeeAlso());
        xmlBindings.setXmlMappingMetadataComplete(false);
        oxmResource.save();
        eJavaType.setXmlSeeAlso(OxmFactory.eINSTANCE.createEXmlSeeAlso());
        oxmResource.save();
        OxmJavaTypeTests.assertNotNull((Object)javaMapping.getXmlSeeAlso());
        OxmJavaTypeTests.assertNotNull((Object)oxmMapping.getDefaultXmlSeeAlso());
        OxmJavaTypeTests.assertNotNull((Object)oxmMapping.getSpecifiedXmlSeeAlso());
        OxmJavaTypeTests.assertNotNull((Object)oxmMapping.getXmlSeeAlso());
        OxmJavaTypeTests.assertEquals((Object)oxmMapping.getSpecifiedXmlSeeAlso(), (Object)oxmMapping.getXmlSeeAlso());
        eJavaType.setXmlSeeAlso(null);
        oxmResource.save();
        OxmJavaTypeTests.assertNotNull((Object)javaMapping.getXmlSeeAlso());
        OxmJavaTypeTests.assertNotNull((Object)oxmMapping.getDefaultXmlSeeAlso());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getSpecifiedXmlSeeAlso());
        OxmJavaTypeTests.assertNotNull((Object)oxmMapping.getXmlSeeAlso());
        javaMapping.removeXmlSeeAlso();
        OxmJavaTypeTests.assertNull((Object)javaMapping.getXmlSeeAlso());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getDefaultXmlSeeAlso());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getSpecifiedXmlSeeAlso());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getXmlSeeAlso());
    }

    public void testModifyXmlSeeAlso() throws Exception {
        this.createClassWithXmlType();
        this.addOxmFile("oxm.xml", "test", "AnnotationTestType");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        OxmJavaType oxmMapping = xmlBindings.getJavaType(0);
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        EJavaType eJavaType = (EJavaType)eXmlBindings.getJavaTypes().get(0);
        OxmJavaTypeTests.assertNull((Object)eJavaType.getXmlSeeAlso());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getSpecifiedXmlSeeAlso());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getXmlSeeAlso());
        oxmMapping.addSpecifiedXmlSeeAlso();
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-see-also", true);
        OxmJavaTypeTests.assertNotNull((Object)eJavaType.getXmlSeeAlso());
        OxmJavaTypeTests.assertNotNull((Object)oxmMapping.getSpecifiedXmlSeeAlso());
        OxmJavaTypeTests.assertNotNull((Object)oxmMapping.getXmlSeeAlso());
        oxmMapping.removeSpecifiedXmlSeeAlso();
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "xml-see-also", false);
        OxmJavaTypeTests.assertNull((Object)eJavaType.getXmlSeeAlso());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getSpecifiedXmlSeeAlso());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getXmlSeeAlso());
    }

    public void testUpdateQNameName() throws Exception {
        this.createClassWithXmlType();
        this.addOxmFile("oxm.xml", "test", "AnnotationTestType");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        OxmJavaType oxmMapping = xmlBindings.getJavaType(0);
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        EJavaType eJavaType = (EJavaType)eXmlBindings.getJavaTypes().get(0);
        JavaClassMapping javaMapping = oxmMapping.getJavaType().getMapping();
        String defaultName = Introspector.decapitalize("AnnotationTestType");
        OxmJavaTypeTests.assertEquals((String)defaultName, (String)javaMapping.getQName().getName());
        OxmJavaTypeTests.assertEquals((String)defaultName, (String)oxmMapping.getQName().getDefaultName());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getQName().getSpecifiedName());
        OxmJavaTypeTests.assertEquals((String)defaultName, (String)oxmMapping.getQName().getName());
        javaMapping.getQName().setSpecifiedName("foo");
        OxmJavaTypeTests.assertEquals((String)"foo", (String)javaMapping.getQName().getName());
        OxmJavaTypeTests.assertEquals((String)"foo", (String)oxmMapping.getQName().getDefaultName());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getQName().getSpecifiedName());
        OxmJavaTypeTests.assertEquals((String)"foo", (String)oxmMapping.getQName().getName());
        xmlBindings.setXmlMappingMetadataComplete(true);
        oxmResource.save();
        OxmJavaTypeTests.assertEquals((String)"foo", (String)javaMapping.getQName().getName());
        OxmJavaTypeTests.assertEquals((String)defaultName, (String)oxmMapping.getQName().getDefaultName());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getQName().getSpecifiedName());
        OxmJavaTypeTests.assertEquals((String)defaultName, (String)oxmMapping.getQName().getName());
        xmlBindings.setXmlMappingMetadataComplete(false);
        oxmResource.save();
        EXmlType xmlType = OxmFactory.eINSTANCE.createEXmlType();
        eJavaType.setXmlType(xmlType);
        xmlType.setName("foo");
        oxmResource.save();
        OxmJavaTypeTests.assertEquals((String)"foo", (String)javaMapping.getQName().getName());
        OxmJavaTypeTests.assertEquals((String)"foo", (String)oxmMapping.getQName().getDefaultName());
        OxmJavaTypeTests.assertEquals((String)"foo", (String)oxmMapping.getQName().getSpecifiedName());
        OxmJavaTypeTests.assertEquals((String)"foo", (String)oxmMapping.getQName().getName());
        xmlType.setName("bar");
        oxmResource.save();
        OxmJavaTypeTests.assertEquals((String)"foo", (String)javaMapping.getQName().getName());
        OxmJavaTypeTests.assertEquals((String)"foo", (String)oxmMapping.getQName().getDefaultName());
        OxmJavaTypeTests.assertEquals((String)"bar", (String)oxmMapping.getQName().getSpecifiedName());
        OxmJavaTypeTests.assertEquals((String)"bar", (String)oxmMapping.getQName().getName());
        javaMapping.getQName().setSpecifiedName(null);
        OxmJavaTypeTests.assertEquals((String)defaultName, (String)javaMapping.getQName().getName());
        OxmJavaTypeTests.assertEquals((String)defaultName, (String)oxmMapping.getQName().getDefaultName());
        OxmJavaTypeTests.assertEquals((String)"bar", (String)oxmMapping.getQName().getSpecifiedName());
        OxmJavaTypeTests.assertEquals((String)"bar", (String)oxmMapping.getQName().getName());
        xmlType.setName(null);
        oxmResource.save();
        OxmJavaTypeTests.assertEquals((String)defaultName, (String)javaMapping.getQName().getName());
        OxmJavaTypeTests.assertEquals((String)defaultName, (String)oxmMapping.getQName().getDefaultName());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getQName().getSpecifiedName());
        OxmJavaTypeTests.assertEquals((String)defaultName, (String)oxmMapping.getQName().getName());
    }

    public void testModifyQNameName() throws Exception {
        this.createClassWithXmlType();
        this.addOxmFile("oxm.xml", "test", "AnnotationTestType");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        OxmJavaType oxmMapping = xmlBindings.getJavaType(0);
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        EJavaType eJavaType = (EJavaType)eXmlBindings.getJavaTypes().get(0);
        JavaClassMapping javaMapping = oxmMapping.getJavaType().getMapping();
        String defaultName = Introspector.decapitalize("AnnotationTestType");
        OxmJavaTypeTests.assertEquals((String)defaultName, (String)javaMapping.getQName().getName());
        OxmJavaTypeTests.assertEquals((String)defaultName, (String)oxmMapping.getQName().getDefaultName());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getQName().getSpecifiedName());
        OxmJavaTypeTests.assertEquals((String)defaultName, (String)oxmMapping.getQName().getName());
        oxmMapping.getQName().setSpecifiedName("foo");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "<xml-type", true);
        this.assertFileContentsContains("oxm.xml", "name=\"foo\"", true);
        OxmJavaTypeTests.assertNotNull((Object)eJavaType.getXmlType());
        OxmJavaTypeTests.assertEquals((String)"foo", (String)eJavaType.getXmlType().getName());
        OxmJavaTypeTests.assertEquals((String)defaultName, (String)oxmMapping.getQName().getDefaultName());
        OxmJavaTypeTests.assertEquals((String)"foo", (String)oxmMapping.getQName().getSpecifiedName());
        OxmJavaTypeTests.assertEquals((String)"foo", (String)oxmMapping.getQName().getName());
        oxmMapping.getQName().setSpecifiedName("bar");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "<xml-type", true);
        this.assertFileContentsContains("oxm.xml", "name=\"bar\"", true);
        OxmJavaTypeTests.assertNotNull((Object)eJavaType.getXmlType());
        OxmJavaTypeTests.assertEquals((String)"bar", (String)eJavaType.getXmlType().getName());
        OxmJavaTypeTests.assertEquals((String)defaultName, (String)oxmMapping.getQName().getDefaultName());
        OxmJavaTypeTests.assertEquals((String)"bar", (String)oxmMapping.getQName().getSpecifiedName());
        OxmJavaTypeTests.assertEquals((String)"bar", (String)oxmMapping.getQName().getName());
        oxmMapping.getQName().setSpecifiedName(null);
        oxmResource.save();
        OxmJavaTypeTests.assertNull((Object)eJavaType.getXmlType().getName());
        OxmJavaTypeTests.assertEquals((String)defaultName, (String)oxmMapping.getQName().getDefaultName());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getQName().getSpecifiedName());
        OxmJavaTypeTests.assertEquals((String)defaultName, (String)oxmMapping.getQName().getName());
    }

    public void testUpdateQNameNamespace() throws Exception {
        this.createClassWithXmlType();
        this.addOxmFile("oxm.xml", "test", "AnnotationTestType");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        OxmJavaType oxmMapping = xmlBindings.getJavaType(0);
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        EJavaType eJavaType = (EJavaType)eXmlBindings.getJavaTypes().get(0);
        JavaClassMapping javaMapping = oxmMapping.getJavaType().getMapping();
        String defaultNamespace = "";
        OxmJavaTypeTests.assertEquals((String)defaultNamespace, (String)javaMapping.getQName().getNamespace());
        OxmJavaTypeTests.assertEquals((String)defaultNamespace, (String)oxmMapping.getQName().getDefaultNamespace());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getQName().getSpecifiedNamespace());
        OxmJavaTypeTests.assertEquals((String)defaultNamespace, (String)oxmMapping.getQName().getNamespace());
        javaMapping.getQName().setSpecifiedNamespace("foo");
        OxmJavaTypeTests.assertEquals((String)"foo", (String)javaMapping.getQName().getNamespace());
        OxmJavaTypeTests.assertEquals((String)"foo", (String)oxmMapping.getQName().getDefaultNamespace());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getQName().getSpecifiedNamespace());
        OxmJavaTypeTests.assertEquals((String)"foo", (String)oxmMapping.getQName().getNamespace());
        xmlBindings.setXmlMappingMetadataComplete(true);
        oxmResource.save();
        OxmJavaTypeTests.assertEquals((String)"foo", (String)javaMapping.getQName().getNamespace());
        OxmJavaTypeTests.assertEquals((String)defaultNamespace, (String)oxmMapping.getQName().getDefaultNamespace());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getQName().getSpecifiedNamespace());
        OxmJavaTypeTests.assertEquals((String)defaultNamespace, (String)oxmMapping.getQName().getNamespace());
        xmlBindings.setXmlMappingMetadataComplete(false);
        oxmResource.save();
        EXmlType xmlType = OxmFactory.eINSTANCE.createEXmlType();
        eJavaType.setXmlType(xmlType);
        xmlType.setNamespace("foo");
        oxmResource.save();
        OxmJavaTypeTests.assertEquals((String)"foo", (String)javaMapping.getQName().getNamespace());
        OxmJavaTypeTests.assertEquals((String)"foo", (String)oxmMapping.getQName().getDefaultNamespace());
        OxmJavaTypeTests.assertEquals((String)"foo", (String)oxmMapping.getQName().getSpecifiedNamespace());
        OxmJavaTypeTests.assertEquals((String)"foo", (String)oxmMapping.getQName().getNamespace());
        xmlType.setNamespace("bar");
        oxmResource.save();
        OxmJavaTypeTests.assertEquals((String)"foo", (String)javaMapping.getQName().getNamespace());
        OxmJavaTypeTests.assertEquals((String)"foo", (String)oxmMapping.getQName().getDefaultNamespace());
        OxmJavaTypeTests.assertEquals((String)"bar", (String)oxmMapping.getQName().getSpecifiedNamespace());
        OxmJavaTypeTests.assertEquals((String)"bar", (String)oxmMapping.getQName().getNamespace());
        javaMapping.getQName().setSpecifiedNamespace(null);
        OxmJavaTypeTests.assertEquals((String)defaultNamespace, (String)javaMapping.getQName().getNamespace());
        OxmJavaTypeTests.assertEquals((String)defaultNamespace, (String)oxmMapping.getQName().getDefaultNamespace());
        OxmJavaTypeTests.assertEquals((String)"bar", (String)oxmMapping.getQName().getSpecifiedNamespace());
        OxmJavaTypeTests.assertEquals((String)"bar", (String)oxmMapping.getQName().getNamespace());
        xmlType.setNamespace(null);
        oxmResource.save();
        OxmJavaTypeTests.assertEquals((String)defaultNamespace, (String)javaMapping.getQName().getNamespace());
        OxmJavaTypeTests.assertEquals((String)defaultNamespace, (String)oxmMapping.getQName().getDefaultNamespace());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getQName().getSpecifiedNamespace());
        OxmJavaTypeTests.assertEquals((String)defaultNamespace, (String)oxmMapping.getQName().getNamespace());
    }

    public void testModifyQNameNamespace() throws Exception {
        this.createClassWithXmlType();
        this.addOxmFile("oxm.xml", "test", "AnnotationTestType");
        ELJaxbContextRoot root = (ELJaxbContextRoot)this.getJaxbProject().getContextRoot();
        OxmFile oxmFile = root.getOxmFile("test");
        OxmXmlBindings xmlBindings = oxmFile.getXmlBindings();
        OxmJavaType oxmMapping = xmlBindings.getJavaType(0);
        JptXmlResource oxmResource = oxmFile.getOxmResource();
        EXmlBindings eXmlBindings = (EXmlBindings)oxmResource.getRootObject();
        EJavaType eJavaType = (EJavaType)eXmlBindings.getJavaTypes().get(0);
        JavaClassMapping javaMapping = oxmMapping.getJavaType().getMapping();
        String defaultNamespace = "";
        OxmJavaTypeTests.assertEquals((String)defaultNamespace, (String)javaMapping.getQName().getNamespace());
        OxmJavaTypeTests.assertEquals((String)defaultNamespace, (String)oxmMapping.getQName().getDefaultNamespace());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getQName().getSpecifiedNamespace());
        OxmJavaTypeTests.assertEquals((String)defaultNamespace, (String)oxmMapping.getQName().getNamespace());
        oxmMapping.getQName().setSpecifiedNamespace("foo");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "<xml-type", true);
        this.assertFileContentsContains("oxm.xml", "namespace=\"foo\"", true);
        OxmJavaTypeTests.assertNotNull((Object)eJavaType.getXmlType());
        OxmJavaTypeTests.assertEquals((String)"foo", (String)eJavaType.getXmlType().getNamespace());
        OxmJavaTypeTests.assertEquals((String)defaultNamespace, (String)oxmMapping.getQName().getDefaultNamespace());
        OxmJavaTypeTests.assertEquals((String)"foo", (String)oxmMapping.getQName().getSpecifiedNamespace());
        OxmJavaTypeTests.assertEquals((String)"foo", (String)oxmMapping.getQName().getNamespace());
        oxmMapping.getQName().setSpecifiedNamespace("bar");
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "<xml-type", true);
        this.assertFileContentsContains("oxm.xml", "namespace=\"bar\"", true);
        OxmJavaTypeTests.assertNotNull((Object)eJavaType.getXmlType());
        OxmJavaTypeTests.assertEquals((String)"bar", (String)eJavaType.getXmlType().getNamespace());
        OxmJavaTypeTests.assertEquals((String)defaultNamespace, (String)oxmMapping.getQName().getDefaultNamespace());
        OxmJavaTypeTests.assertEquals((String)"bar", (String)oxmMapping.getQName().getSpecifiedNamespace());
        OxmJavaTypeTests.assertEquals((String)"bar", (String)oxmMapping.getQName().getNamespace());
        oxmMapping.getQName().setSpecifiedNamespace(null);
        oxmResource.save();
        this.assertFileContentsContains("oxm.xml", "namespace=", false);
        OxmJavaTypeTests.assertNull((Object)eJavaType.getXmlType().getNamespace());
        OxmJavaTypeTests.assertEquals((String)defaultNamespace, (String)oxmMapping.getQName().getDefaultNamespace());
        OxmJavaTypeTests.assertNull((Object)oxmMapping.getQName().getSpecifiedNamespace());
        OxmJavaTypeTests.assertEquals((String)defaultNamespace, (String)oxmMapping.getQName().getNamespace());
    }
}

