/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.projects.JavaProjectTestHarness;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.InheritanceType;
import org.eclipse.jpt.jpa.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkMultitenantType2_3;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkTenantDiscriminatorColumn2_3;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaEntity;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaMultitenancy2_3;
import org.eclipse.jpt.jpa.eclipselink.core.context.java.EclipseLinkJavaSpecifiedTenantDiscriminatorColumn2_3;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkEntityMappings;
import org.eclipse.jpt.jpa.eclipselink.core.context.orm.EclipseLinkPersistenceUnitDefaults;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.MultitenantAnnotation2_3;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.MultitenantType2_3;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.TenantDiscriminatorColumnAnnotation2_3;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLink2_3ContextModelTestCase;

public class EclipseLink2_3JavaMultitenancyTests
extends EclipseLink2_3ContextModelTestCase {
    protected static final String SUB_TYPE_NAME = "AnnotationTestTypeChild";
    protected static final String FULLY_QUALIFIED_SUB_TYPE_NAME = "test.AnnotationTestTypeChild";

    public EclipseLink2_3JavaMultitenancyTests(String name) {
        super(name);
    }

    private ICompilationUnit createTestEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Id"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }
        });
    }

    private ICompilationUnit createTestEntityWithMultitenant() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Multitenant"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@Multitenant");
            }
        });
    }

    private ICompilationUnit createTestEntityWithTenantDiscriminatorColumn() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Multitenant", "org.eclipse.persistence.annotations.TenantDiscriminatorColumn"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@TenantDiscriminatorColumn(name=\"foo\")");
            }
        });
    }

    private ICompilationUnit createTestEntityWithTenantDiscriminatorColumns() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Multitenant", "org.eclipse.persistence.annotations.TenantDiscriminatorColumn", "org.eclipse.persistence.annotations.TenantDiscriminatorColumns"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@TenantDiscriminatorColumns({@TenantDiscriminatorColumn(name=\"foo\"), @TenantDiscriminatorColumn(name=\"bar\")})");
            }
        });
    }

    private ICompilationUnit createTestMultitenantMappedSuperclass() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.MappedSuperclass", "org.eclipse.persistence.annotations.Multitenant", "org.eclipse.persistence.annotations.TenantDiscriminatorColumn"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@MappedSuperclass").append(CR);
                sb.append("@Multitenant").append(CR);
                sb.append("@TenantDiscriminatorColumn(name=\"MS_TENANT_ID\")").append(CR);
            }
        });
    }

    private ICompilationUnit createTestMultitenantRootEntity() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "javax.persistence.Inheritance", "org.eclipse.persistence.annotations.Multitenant", "org.eclipse.persistence.annotations.TenantDiscriminatorColumn"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity").append(CR);
                sb.append("@Inheritenace").append(CR);
                sb.append("@Multitenant").append(CR);
                sb.append("@TenantDiscriminatorColumn(name=\"ROOT_ENTITY_TENANT_ID\")").append(CR);
            }
        });
    }

    private void createTestSubType() throws Exception {
        JavaProjectTestHarness.SourceWriter sourceWriter = new JavaProjectTestHarness.SourceWriter(){

            public void appendSourceTo(StringBuilder sb) {
                sb.append(CR);
                sb.append("import ");
                sb.append("javax.persistence.Entity");
                sb.append(";");
                sb.append(CR);
                sb.append("@Entity");
                sb.append(CR);
                sb.append("public class ").append(EclipseLink2_3JavaMultitenancyTests.SUB_TYPE_NAME).append(" ");
                sb.append("extends AnnotationTestType ");
                sb.append("{}").append(CR);
            }
        };
        this.javaProjectTestHarness.createCompilationUnit("test", "AnnotationTestTypeChild.java", sourceWriter);
    }

    public EclipseLinkJavaMultitenancy2_3 getJavaMultitenancy() {
        return this.getJavaEntity().getMultitenancy();
    }

    public void testGetTypeNull() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLink2_3JavaMultitenancyTests.assertNull((Object)this.getJavaMultitenancy().getType());
    }

    public void testGetType() throws Exception {
        this.createTestEntityWithMultitenant();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLink2_3JavaMultitenancyTests.assertEquals((Object)EclipseLinkMultitenantType2_3.SINGLE_TABLE, (Object)this.getJavaMultitenancy().getType());
    }

    public void testGetSpecifiedType() throws Exception {
        this.createTestEntityWithMultitenant();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLink2_3JavaMultitenancyTests.assertEquals(null, (Object)this.getJavaMultitenancy().getSpecifiedType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        MultitenantAnnotation2_3 multitenant = (MultitenantAnnotation2_3)resourceType.getAnnotation("org.eclipse.persistence.annotations.Multitenant");
        multitenant.setValue(MultitenantType2_3.SINGLE_TABLE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_3JavaMultitenancyTests.assertEquals((Object)EclipseLinkMultitenantType2_3.SINGLE_TABLE, (Object)this.getJavaMultitenancy().getSpecifiedType());
        multitenant.setValue(MultitenantType2_3.TABLE_PER_TENANT);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_3JavaMultitenancyTests.assertEquals((Object)EclipseLinkMultitenantType2_3.TABLE_PER_TENANT, (Object)this.getJavaMultitenancy().getSpecifiedType());
        multitenant.setValue(MultitenantType2_3.VPD);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_3JavaMultitenancyTests.assertEquals((Object)EclipseLinkMultitenantType2_3.VPD, (Object)this.getJavaMultitenancy().getSpecifiedType());
        multitenant.setValue(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_3JavaMultitenancyTests.assertNull((Object)this.getJavaMultitenancy().getSpecifiedType());
    }

    public void testSetSpecifiedType() throws Exception {
        this.createTestEntityWithMultitenant();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLink2_3JavaMultitenancyTests.assertEquals(null, (Object)this.getJavaMultitenancy().getSpecifiedType());
        this.getJavaMultitenancy().setSpecifiedType(EclipseLinkMultitenantType2_3.SINGLE_TABLE);
        EclipseLink2_3JavaMultitenancyTests.assertEquals((Object)EclipseLinkMultitenantType2_3.SINGLE_TABLE, (Object)this.getJavaMultitenancy().getSpecifiedType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        MultitenantAnnotation2_3 multitenant = (MultitenantAnnotation2_3)resourceType.getAnnotation("org.eclipse.persistence.annotations.Multitenant");
        EclipseLink2_3JavaMultitenancyTests.assertEquals((Object)MultitenantType2_3.SINGLE_TABLE, (Object)multitenant.getValue());
        this.getJavaMultitenancy().setSpecifiedType(EclipseLinkMultitenantType2_3.TABLE_PER_TENANT);
        EclipseLink2_3JavaMultitenancyTests.assertEquals((Object)EclipseLinkMultitenantType2_3.TABLE_PER_TENANT, (Object)this.getJavaMultitenancy().getSpecifiedType());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((Object)MultitenantType2_3.TABLE_PER_TENANT, (Object)multitenant.getValue());
        this.getJavaMultitenancy().setSpecifiedType(EclipseLinkMultitenantType2_3.VPD);
        EclipseLink2_3JavaMultitenancyTests.assertEquals((Object)EclipseLinkMultitenantType2_3.VPD, (Object)this.getJavaMultitenancy().getSpecifiedType());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((Object)MultitenantType2_3.VPD, (Object)multitenant.getValue());
    }

    public void testIsIncludeCriteria() throws Exception {
        this.createTestEntityWithMultitenant();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLink2_3JavaMultitenancyTests.assertEquals((boolean)true, (boolean)this.getJavaMultitenancy().isIncludeCriteria());
        this.getJavaMultitenancy().setSpecifiedIncludeCriteria(Boolean.FALSE);
        EclipseLink2_3JavaMultitenancyTests.assertEquals((boolean)false, (boolean)this.getJavaMultitenancy().isIncludeCriteria());
    }

    public void testGetSpecifiedIncludeCriteria() throws Exception {
        this.createTestEntityWithMultitenant();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLink2_3JavaMultitenancyTests.assertNull((Object)this.getJavaMultitenancy().getSpecifiedIncludeCriteria());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        MultitenantAnnotation2_3 multitenant = (MultitenantAnnotation2_3)resourceType.getAnnotation("org.eclipse.persistence.annotations.Multitenant");
        multitenant.setIncludeCriteria(Boolean.FALSE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_3JavaMultitenancyTests.assertEquals((Object)Boolean.FALSE, (Object)this.getJavaMultitenancy().getSpecifiedIncludeCriteria());
        multitenant.setIncludeCriteria(Boolean.TRUE);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_3JavaMultitenancyTests.assertEquals((Object)Boolean.TRUE, (Object)this.getJavaMultitenancy().getSpecifiedIncludeCriteria());
        multitenant.setIncludeCriteria(null);
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_3JavaMultitenancyTests.assertNull((Object)this.getJavaMultitenancy().getSpecifiedIncludeCriteria());
        multitenant = (MultitenantAnnotation2_3)resourceType.getAnnotation("org.eclipse.persistence.annotations.Multitenant");
        EclipseLink2_3JavaMultitenancyTests.assertNotNull((Object)multitenant);
    }

    public void testSetSpecifiedIncludeCriteria() throws Exception {
        this.createTestEntityWithMultitenant();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLink2_3JavaMultitenancyTests.assertNull((Object)this.getJavaMultitenancy().getSpecifiedIncludeCriteria());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        MultitenantAnnotation2_3 multitenant = (MultitenantAnnotation2_3)resourceType.getAnnotation("org.eclipse.persistence.annotations.Multitenant");
        EclipseLink2_3JavaMultitenancyTests.assertNull((Object)multitenant.getIncludeCriteria());
        this.getJavaMultitenancy().setSpecifiedIncludeCriteria(Boolean.TRUE);
        EclipseLink2_3JavaMultitenancyTests.assertEquals((Object)Boolean.TRUE, (Object)multitenant.getIncludeCriteria());
        this.getJavaMultitenancy().setSpecifiedIncludeCriteria(null);
        multitenant = (MultitenantAnnotation2_3)resourceType.getAnnotation("org.eclipse.persistence.annotations.Multitenant");
        EclipseLink2_3JavaMultitenancyTests.assertNull((Object)multitenant.getIncludeCriteria());
        EclipseLink2_3JavaMultitenancyTests.assertNull((Object)this.getJavaMultitenancy().getSpecifiedIncludeCriteria());
    }

    public void testSpecifiedTenantDiscriminatorColumn() throws Exception {
        this.createTestEntityWithTenantDiscriminatorColumn();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator tenandDiscriminatorColumns = this.getJavaMultitenancy().getSpecifiedTenantDiscriminatorColumns().iterator();
        EclipseLink2_3JavaMultitenancyTests.assertTrue((boolean)tenandDiscriminatorColumns.hasNext());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"foo", (String)((EclipseLinkJavaSpecifiedTenantDiscriminatorColumn2_3)tenandDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertFalse((boolean)tenandDiscriminatorColumns.hasNext());
    }

    public void testSpecifiedTenantDiscriminatorColumnsSize() throws Exception {
        this.createTestEntityWithMultitenant();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaMultitenancy2_3 javaMultitenancy = this.getJavaMultitenancy();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        EclipseLink2_3JavaMultitenancyTests.assertEquals((int)0, (int)javaMultitenancy.getSpecifiedTenantDiscriminatorColumnsSize());
        ((TenantDiscriminatorColumnAnnotation2_3)resourceType.addAnnotation(0, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn")).setName("FOO");
        ((TenantDiscriminatorColumnAnnotation2_3)resourceType.addAnnotation(1, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn")).setName("BAR");
        ((TenantDiscriminatorColumnAnnotation2_3)resourceType.addAnnotation(2, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        EclipseLink2_3JavaMultitenancyTests.assertEquals((int)3, (int)javaMultitenancy.getSpecifiedTenantDiscriminatorColumnsSize());
    }

    public void testSpecifiedTenantDiscriminatorColumns() throws Exception {
        this.createTestEntityWithTenantDiscriminatorColumns();
        this.addXmlClassRef("test.AnnotationTestType");
        ListIterator tenandDiscriminatorColumns = this.getJavaMultitenancy().getSpecifiedTenantDiscriminatorColumns().iterator();
        EclipseLink2_3JavaMultitenancyTests.assertTrue((boolean)tenandDiscriminatorColumns.hasNext());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"foo", (String)((EclipseLinkJavaSpecifiedTenantDiscriminatorColumn2_3)tenandDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"bar", (String)((EclipseLinkJavaSpecifiedTenantDiscriminatorColumn2_3)tenandDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertFalse((boolean)tenandDiscriminatorColumns.hasNext());
    }

    public void testAddSpecifiedTenantDiscriminatorColumn() throws Exception {
        this.createTestEntityWithMultitenant();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaMultitenancy().addSpecifiedTenantDiscriminatorColumn(0).setSpecifiedName("FOO");
        this.getJavaMultitenancy().addSpecifiedTenantDiscriminatorColumn(0).setSpecifiedName("BAR");
        this.getJavaMultitenancy().addSpecifiedTenantDiscriminatorColumn(0).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ListIterator tenantDiscriminatorColumns = resourceType.getAnnotations("org.eclipse.persistence.annotations.TenantDiscriminatorColumn").iterator();
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"BAZ", (String)((TenantDiscriminatorColumnAnnotation2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"BAR", (String)((TenantDiscriminatorColumnAnnotation2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"FOO", (String)((TenantDiscriminatorColumnAnnotation2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertFalse((boolean)tenantDiscriminatorColumns.hasNext());
    }

    public void testAddSpecifiedTenantDiscriminatorColumn2() throws Exception {
        this.createTestEntityWithMultitenant();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaMultitenancy().addSpecifiedTenantDiscriminatorColumn(0).setSpecifiedName("FOO");
        this.getJavaMultitenancy().addSpecifiedTenantDiscriminatorColumn(1).setSpecifiedName("BAR");
        this.getJavaMultitenancy().addSpecifiedTenantDiscriminatorColumn(0).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ListIterator tenantDiscriminatorColumns = resourceType.getAnnotations("org.eclipse.persistence.annotations.TenantDiscriminatorColumn").iterator();
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"BAZ", (String)((TenantDiscriminatorColumnAnnotation2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"FOO", (String)((TenantDiscriminatorColumnAnnotation2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"BAR", (String)((TenantDiscriminatorColumnAnnotation2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertFalse((boolean)tenantDiscriminatorColumns.hasNext());
    }

    public void testRemoveSpecifiedTenantDiscriminatorColumn() throws Exception {
        this.createTestEntityWithMultitenant();
        this.addXmlClassRef("test.AnnotationTestType");
        this.getJavaMultitenancy().addSpecifiedTenantDiscriminatorColumn(0).setSpecifiedName("FOO");
        this.getJavaMultitenancy().addSpecifiedTenantDiscriminatorColumn(1).setSpecifiedName("BAR");
        this.getJavaMultitenancy().addSpecifiedTenantDiscriminatorColumn(2).setSpecifiedName("BAZ");
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        EclipseLink2_3JavaMultitenancyTests.assertEquals((int)3, (int)resourceType.getAnnotationsSize("org.eclipse.persistence.annotations.TenantDiscriminatorColumn"));
        this.getJavaMultitenancy().removeSpecifiedTenantDiscriminatorColumn(1);
        ListIterator tenantDiscriminatorColumnAnnotations = resourceType.getAnnotations("org.eclipse.persistence.annotations.TenantDiscriminatorColumn").iterator();
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"FOO", (String)((TenantDiscriminatorColumnAnnotation2_3)tenantDiscriminatorColumnAnnotations.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"BAZ", (String)((TenantDiscriminatorColumnAnnotation2_3)tenantDiscriminatorColumnAnnotations.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertFalse((boolean)tenantDiscriminatorColumnAnnotations.hasNext());
        ListIterator tenantDiscriminatorColumns = this.getJavaMultitenancy().getSpecifiedTenantDiscriminatorColumns().iterator();
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"FOO", (String)((EclipseLinkJavaSpecifiedTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"BAZ", (String)((EclipseLinkJavaSpecifiedTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertFalse((boolean)tenantDiscriminatorColumns.hasNext());
        this.getJavaMultitenancy().removeSpecifiedTenantDiscriminatorColumn(1);
        tenantDiscriminatorColumnAnnotations = resourceType.getAnnotations("org.eclipse.persistence.annotations.TenantDiscriminatorColumn").iterator();
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"FOO", (String)((TenantDiscriminatorColumnAnnotation2_3)tenantDiscriminatorColumnAnnotations.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertFalse((boolean)tenantDiscriminatorColumnAnnotations.hasNext());
        tenantDiscriminatorColumns = this.getJavaMultitenancy().getSpecifiedTenantDiscriminatorColumns().iterator();
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"FOO", (String)((EclipseLinkJavaSpecifiedTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertFalse((boolean)tenantDiscriminatorColumns.hasNext());
        this.getJavaMultitenancy().removeSpecifiedTenantDiscriminatorColumn(0);
        tenantDiscriminatorColumnAnnotations = resourceType.getAnnotations("org.eclipse.persistence.annotations.TenantDiscriminatorColumn").iterator();
        EclipseLink2_3JavaMultitenancyTests.assertFalse((boolean)tenantDiscriminatorColumnAnnotations.hasNext());
        tenantDiscriminatorColumns = this.getJavaMultitenancy().getSpecifiedTenantDiscriminatorColumns().iterator();
        EclipseLink2_3JavaMultitenancyTests.assertFalse((boolean)tenantDiscriminatorColumns.hasNext());
        EclipseLink2_3JavaMultitenancyTests.assertNull((Object)resourceType.getAnnotation("org.eclipse.persistence.annotations.TenantDiscriminatorColumn"));
    }

    public void testMoveSpecifiedTenantDiscriminatorColumn() throws Exception {
        this.createTestEntityWithMultitenant();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaMultitenancy2_3 javaMultitenancy = this.getJavaMultitenancy();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        javaMultitenancy.addSpecifiedTenantDiscriminatorColumn(0).setSpecifiedName("FOO");
        javaMultitenancy.addSpecifiedTenantDiscriminatorColumn(1).setSpecifiedName("BAR");
        javaMultitenancy.addSpecifiedTenantDiscriminatorColumn(2).setSpecifiedName("BAZ");
        ListIterator javaTenantDiscriminatorColumns = resourceType.getAnnotations("org.eclipse.persistence.annotations.TenantDiscriminatorColumn").iterator();
        EclipseLink2_3JavaMultitenancyTests.assertEquals((int)3, (int)IteratorTools.size((Iterator)javaTenantDiscriminatorColumns));
        javaMultitenancy.moveSpecifiedTenantDiscriminatorColumn(2, 0);
        ListIterator tenantDiscriminatorColumns = javaMultitenancy.getSpecifiedTenantDiscriminatorColumns().iterator();
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"BAR", (String)((EclipseLinkJavaSpecifiedTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getSpecifiedName());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"BAZ", (String)((EclipseLinkJavaSpecifiedTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getSpecifiedName());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"FOO", (String)((EclipseLinkJavaSpecifiedTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getSpecifiedName());
        javaTenantDiscriminatorColumns = resourceType.getAnnotations("org.eclipse.persistence.annotations.TenantDiscriminatorColumn").iterator();
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"BAR", (String)((TenantDiscriminatorColumnAnnotation2_3)javaTenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"BAZ", (String)((TenantDiscriminatorColumnAnnotation2_3)javaTenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"FOO", (String)((TenantDiscriminatorColumnAnnotation2_3)javaTenantDiscriminatorColumns.next()).getName());
        javaMultitenancy.moveSpecifiedTenantDiscriminatorColumn(0, 1);
        tenantDiscriminatorColumns = javaMultitenancy.getSpecifiedTenantDiscriminatorColumns().iterator();
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"BAZ", (String)((EclipseLinkJavaSpecifiedTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getSpecifiedName());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"BAR", (String)((EclipseLinkJavaSpecifiedTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getSpecifiedName());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"FOO", (String)((EclipseLinkJavaSpecifiedTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getSpecifiedName());
        javaTenantDiscriminatorColumns = resourceType.getAnnotations("org.eclipse.persistence.annotations.TenantDiscriminatorColumn").iterator();
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"BAZ", (String)((TenantDiscriminatorColumnAnnotation2_3)javaTenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"BAR", (String)((TenantDiscriminatorColumnAnnotation2_3)javaTenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"FOO", (String)((TenantDiscriminatorColumnAnnotation2_3)javaTenantDiscriminatorColumns.next()).getName());
    }

    public void testUpdateSpecifiedTenantDiscriminatorColumns() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaMultitenancy2_3 javaMultitenancy = this.getJavaMultitenancy();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        ((TenantDiscriminatorColumnAnnotation2_3)resourceType.addAnnotation(0, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn")).setName("FOO");
        ((TenantDiscriminatorColumnAnnotation2_3)resourceType.addAnnotation(1, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn")).setName("BAR");
        ((TenantDiscriminatorColumnAnnotation2_3)resourceType.addAnnotation(2, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn")).setName("BAZ");
        this.getJpaProject().synchronizeContextModel();
        ListIterator tenantDiscriminatorColumns = javaMultitenancy.getSpecifiedTenantDiscriminatorColumns().iterator();
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"FOO", (String)((EclipseLinkJavaSpecifiedTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"BAR", (String)((EclipseLinkJavaSpecifiedTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"BAZ", (String)((EclipseLinkJavaSpecifiedTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertFalse((boolean)tenantDiscriminatorColumns.hasNext());
        resourceType.moveAnnotation(2, 0, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn");
        this.getJpaProject().synchronizeContextModel();
        tenantDiscriminatorColumns = javaMultitenancy.getSpecifiedTenantDiscriminatorColumns().iterator();
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"BAR", (String)((EclipseLinkJavaSpecifiedTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"BAZ", (String)((EclipseLinkJavaSpecifiedTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"FOO", (String)((EclipseLinkJavaSpecifiedTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertFalse((boolean)tenantDiscriminatorColumns.hasNext());
        resourceType.moveAnnotation(0, 1, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn");
        this.getJpaProject().synchronizeContextModel();
        tenantDiscriminatorColumns = javaMultitenancy.getSpecifiedTenantDiscriminatorColumns().iterator();
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"BAZ", (String)((EclipseLinkJavaSpecifiedTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"BAR", (String)((EclipseLinkJavaSpecifiedTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"FOO", (String)((EclipseLinkJavaSpecifiedTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertFalse((boolean)tenantDiscriminatorColumns.hasNext());
        resourceType.removeAnnotation(1, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn");
        this.getJpaProject().synchronizeContextModel();
        tenantDiscriminatorColumns = javaMultitenancy.getSpecifiedTenantDiscriminatorColumns().iterator();
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"BAZ", (String)((EclipseLinkJavaSpecifiedTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"FOO", (String)((EclipseLinkJavaSpecifiedTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertFalse((boolean)tenantDiscriminatorColumns.hasNext());
        resourceType.removeAnnotation(1, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn");
        this.getJpaProject().synchronizeContextModel();
        tenantDiscriminatorColumns = javaMultitenancy.getSpecifiedTenantDiscriminatorColumns().iterator();
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"BAZ", (String)((EclipseLinkJavaSpecifiedTenantDiscriminatorColumn2_3)tenantDiscriminatorColumns.next()).getName());
        EclipseLink2_3JavaMultitenancyTests.assertFalse((boolean)tenantDiscriminatorColumns.hasNext());
        resourceType.removeAnnotation(0, "org.eclipse.persistence.annotations.TenantDiscriminatorColumn");
        this.getJpaProject().synchronizeContextModel();
        tenantDiscriminatorColumns = javaMultitenancy.getSpecifiedTenantDiscriminatorColumns().iterator();
        EclipseLink2_3JavaMultitenancyTests.assertFalse((boolean)tenantDiscriminatorColumns.hasNext());
    }

    public void testTenantDiscriminatorColumnsWithMappedSuperclass() throws Exception {
        this.createTestMultitenantMappedSuperclass();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaMultitenancy2_3 multitenancy = this.getJavaMultitenancy();
        EclipseLink2_3JavaMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"MS_TENANT_ID", (String)((EclipseLinkTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
        multitenancy.setSpecifiedType(EclipseLinkMultitenantType2_3.SINGLE_TABLE);
        EclipseLink2_3JavaMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"TENANT_ID", (String)((EclipseLinkTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
    }

    public void testTenantDiscriminatorColumnsWithInheritance() throws Exception {
        this.createTestMultitenantRootEntity();
        this.createTestSubType();
        this.addXmlClassRef(FULLY_QUALIFIED_SUB_TYPE_NAME);
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkJavaMultitenancy2_3 multitenancy = this.getJavaMultitenancy();
        EclipseLink2_3JavaMultitenancyTests.assertTrue((boolean)multitenancy.isMultitenant());
        EclipseLink2_3JavaMultitenancyTests.assertFalse((boolean)multitenancy.isSpecifiedMultitenant());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"ROOT_ENTITY_TENANT_ID", (String)((EclipseLinkTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
        this.getJavaEntity().getRootEntity().setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        EclipseLink2_3JavaMultitenancyTests.assertTrue((boolean)multitenancy.isMultitenant());
        EclipseLink2_3JavaMultitenancyTests.assertFalse((boolean)multitenancy.isSpecifiedMultitenant());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"ROOT_ENTITY_TENANT_ID", (String)((EclipseLinkTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
        this.getJavaEntity().getRootEntity().setSpecifiedInheritanceStrategy(InheritanceType.TABLE_PER_CLASS);
        EclipseLink2_3JavaMultitenancyTests.assertFalse((boolean)multitenancy.isMultitenant());
        EclipseLink2_3JavaMultitenancyTests.assertFalse((boolean)multitenancy.isSpecifiedMultitenant());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((int)0, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLinkPersistenceUnitDefaults persistenceUnitDefaults = (EclipseLinkPersistenceUnitDefaults)this.getMappingFile().getRoot().getPersistenceUnitMetadata().getPersistenceUnitDefaults();
        persistenceUnitDefaults.addTenantDiscriminatorColumn().setSpecifiedName("PU_TENANT_ID");
        EclipseLink2_3JavaMultitenancyTests.assertFalse((boolean)multitenancy.isMultitenant());
        EclipseLink2_3JavaMultitenancyTests.assertFalse((boolean)multitenancy.isSpecifiedMultitenant());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((int)0, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        multitenancy.setSpecifiedMultitenant(true);
        EclipseLink2_3JavaMultitenancyTests.assertTrue((boolean)multitenancy.isSpecifiedMultitenant());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"PU_TENANT_ID", (String)((EclipseLinkTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
        multitenancy.addSpecifiedTenantDiscriminatorColumn().setSpecifiedName("CHILD_TENANT_ID");
        EclipseLink2_3JavaMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"CHILD_TENANT_ID", (String)((EclipseLinkTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
        this.getJavaEntity().getRootEntity().setSpecifiedInheritanceStrategy(InheritanceType.JOINED);
        EclipseLink2_3JavaMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"CHILD_TENANT_ID", (String)((EclipseLinkTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
    }

    public void testTenantDiscriminatorColumnsWithPersistenceUnitDefaults() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkPersistenceUnitDefaults persistenceUnitDefaults = (EclipseLinkPersistenceUnitDefaults)this.getMappingFile().getRoot().getPersistenceUnitMetadata().getPersistenceUnitDefaults();
        persistenceUnitDefaults.addTenantDiscriminatorColumn().setSpecifiedName("PU_TENANT_ID");
        EclipseLinkJavaMultitenancy2_3 multitenancy = this.getJavaMultitenancy();
        EclipseLink2_3JavaMultitenancyTests.assertFalse((boolean)multitenancy.isMultitenant());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((int)0, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        multitenancy.setSpecifiedType(EclipseLinkMultitenantType2_3.SINGLE_TABLE);
        EclipseLink2_3JavaMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"PU_TENANT_ID", (String)((EclipseLinkTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
        multitenancy.addSpecifiedTenantDiscriminatorColumn().setSpecifiedName("ENTITY_TENANT_ID");
        EclipseLink2_3JavaMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((int)0, (int)multitenancy.getDefaultTenantDiscriminatorColumnsSize());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"ENTITY_TENANT_ID", (String)((EclipseLinkTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
        this.getJavaMultitenancy().setSpecifiedMultitenant(false);
        EclipseLink2_3JavaMultitenancyTests.assertEquals((int)0, (int)multitenancy.getTenantDiscriminatorColumnsSize());
    }

    public void testTenantDiscriminatorColumnsWithEntityMappingsDefaults() throws Exception {
        this.createTestEntity();
        this.addXmlClassRef("test.AnnotationTestType");
        EclipseLinkEntityMappings entityMappings = (EclipseLinkEntityMappings)this.getMappingFile().getRoot();
        entityMappings.addSpecifiedTenantDiscriminatorColumn().setSpecifiedName("EM_TENANT_ID");
        EclipseLinkJavaMultitenancy2_3 multitenancy = this.getJavaMultitenancy();
        EclipseLink2_3JavaMultitenancyTests.assertFalse((boolean)multitenancy.isMultitenant());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((int)0, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        multitenancy.setSpecifiedType(EclipseLinkMultitenantType2_3.SINGLE_TABLE);
        EclipseLink2_3JavaMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"TENANT_ID", (String)((EclipseLinkTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
        OrmPersistentType persistentType = entityMappings.addPersistentType("entity", "test.AnnotationTestType");
        multitenancy = ((EclipseLinkJavaEntity)persistentType.getJavaPersistentType().getMapping()).getMultitenancy();
        EclipseLink2_3JavaMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"EM_TENANT_ID", (String)((EclipseLinkTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
        multitenancy.setSpecifiedType(EclipseLinkMultitenantType2_3.TABLE_PER_TENANT);
        EclipseLink2_3JavaMultitenancyTests.assertEquals((int)0, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        multitenancy.setSpecifiedMultitenant(false);
        EclipseLink2_3JavaMultitenancyTests.assertEquals((int)0, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLinkPersistenceUnitDefaults persistenceUnitDefaults = (EclipseLinkPersistenceUnitDefaults)this.getMappingFile().getRoot().getPersistenceUnitMetadata().getPersistenceUnitDefaults();
        persistenceUnitDefaults.addTenantDiscriminatorColumn().setSpecifiedName("PU_TENANT_ID");
        multitenancy.setSpecifiedType(EclipseLinkMultitenantType2_3.SINGLE_TABLE);
        EclipseLink2_3JavaMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"EM_TENANT_ID", (String)((EclipseLinkTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
        entityMappings.removeManagedType(0);
        multitenancy = this.getJavaMultitenancy();
        EclipseLink2_3JavaMultitenancyTests.assertEquals((int)1, (int)multitenancy.getTenantDiscriminatorColumnsSize());
        EclipseLink2_3JavaMultitenancyTests.assertEquals((String)"PU_TENANT_ID", (String)((EclipseLinkTenantDiscriminatorColumn2_3)multitenancy.getTenantDiscriminatorColumns().iterator().next()).getName());
    }
}

