/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.java;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceField;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.tests.internal.utility.jdt.AnnotationTestCase;
import org.eclipse.jpt.common.utility.internal.iterator.IteratorTools;
import org.eclipse.jpt.jpa.core.context.SpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConversionValue;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkObjectTypeConverter;
import org.eclipse.jpt.jpa.eclipselink.core.internal.context.java.EclipseLinkJavaBasicMapping;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ConversionValueAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.resource.java.ObjectTypeConverterAnnotation;
import org.eclipse.jpt.jpa.eclipselink.core.tests.internal.context.EclipseLinkContextModelTestCase;

public class EclipseLinkJavaObjectTypeConverterTests
extends EclipseLinkContextModelTestCase {
    private ICompilationUnit createTestEntityWithConvertAndObjectTypeConverter() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.ObjectTypeConverter", "org.eclipse.persistence.annotations.ConversionValue"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"foo\")").append(CR);
                sb.append("    @ObjectTypeConverter(name=\"foo\", defaultObjectValue=\"bar\")");
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvertAndDataType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.ObjectTypeConverter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"foo\")").append(CR);
                sb.append("    @ObjectTypeConverter(dataType=Foo.class)");
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvertAndObjectType() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.ObjectTypeConverter"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"foo\")").append(CR);
                sb.append("    @ObjectTypeConverter(objectType=Foo.class)");
            }
        });
    }

    private ICompilationUnit createTestEntityWithConvertAndObjectTypeConverterConversionValue() throws Exception {
        return this.createTestType((AnnotationTestCase.AnnotationWriter)new AnnotationTestCase.DefaultAnnotationWriter(){

            public Iterator<String> imports() {
                return IteratorTools.iterator((Object[])new String[]{"javax.persistence.Entity", "org.eclipse.persistence.annotations.Convert", "org.eclipse.persistence.annotations.ObjectTypeConverter", "org.eclipse.persistence.annotations.ConversionValue"});
            }

            public void appendTypeAnnotationTo(StringBuilder sb) {
                sb.append("@Entity");
            }

            public void appendIdFieldAnnotationTo(StringBuilder sb) {
                sb.append("@Convert(\"foo\")").append(CR);
                sb.append("    @ObjectTypeConverter(name=\"foo\", defaultObjectValue=\"bar\", conversionValues = @ConversionValue(dataValue=\"f\", objectValue=\"female\"))");
            }
        });
    }

    public EclipseLinkJavaObjectTypeConverterTests(String name) {
        super(name);
    }

    public void testGetName() throws Exception {
        this.createTestEntityWithConvertAndObjectTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        JavaSpecifiedPersistentAttribute persistentAttribute = (JavaSpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkJavaBasicMapping basicMapping = (EclipseLinkJavaBasicMapping)persistentAttribute.getMapping();
        EclipseLinkObjectTypeConverter converter = (EclipseLinkObjectTypeConverter)basicMapping.getConverterContainer().getObjectTypeConverters().iterator().next();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"foo", (String)converter.getName());
    }

    public void testSetName() throws Exception {
        this.createTestEntityWithConvertAndObjectTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkJavaBasicMapping basicMapping = (EclipseLinkJavaBasicMapping)persistentAttribute.getMapping();
        EclipseLinkObjectTypeConverter converter = (EclipseLinkObjectTypeConverter)basicMapping.getConverterContainer().getObjectTypeConverters().iterator().next();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"foo", (String)converter.getName());
        converter.setName("bar");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"bar", (String)converter.getName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ObjectTypeConverterAnnotation converterAnnotation = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"bar", (String)converterAnnotation.getName());
        converter.setName(null);
        EclipseLinkJavaObjectTypeConverterTests.assertEquals(null, (String)converter.getName());
        converterAnnotation = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals(null, (String)converterAnnotation.getName());
        converter.setName("bar");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"bar", (String)converter.getName());
        converterAnnotation = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"bar", (String)converterAnnotation.getName());
    }

    public void testGetNameUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithConvertAndObjectTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkJavaBasicMapping basicMapping = (EclipseLinkJavaBasicMapping)persistentAttribute.getMapping();
        EclipseLinkObjectTypeConverter converter = (EclipseLinkObjectTypeConverter)basicMapping.getConverterContainer().getObjectTypeConverters().iterator().next();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"foo", (String)converter.getName());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ObjectTypeConverterAnnotation converterAnnotation = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        converterAnnotation.setName("bar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"bar", (String)converter.getName());
        resourceField.removeAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaObjectTypeConverterTests.assertFalse((boolean)basicMapping.getConverterContainer().getObjectTypeConverters().iterator().hasNext());
        converterAnnotation = (ObjectTypeConverterAnnotation)resourceField.addAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        this.getJpaProject().synchronizeContextModel();
        converter = (EclipseLinkObjectTypeConverter)basicMapping.getConverterContainer().getObjectTypeConverters().iterator().next();
        EclipseLinkJavaObjectTypeConverterTests.assertNotNull((Object)converter);
        converterAnnotation.setName("FOO");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"FOO", (String)converter.getName());
    }

    public void testGetDataType() throws Exception {
        this.createTestEntityWithConvertAndDataType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkJavaBasicMapping basicMapping = (EclipseLinkJavaBasicMapping)persistentAttribute.getMapping();
        EclipseLinkObjectTypeConverter converter = (EclipseLinkObjectTypeConverter)basicMapping.getConverterContainer().getObjectTypeConverters().iterator().next();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Foo", (String)converter.getDataType());
    }

    public void testSetDataType() throws Exception {
        this.createTestEntityWithConvertAndDataType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkJavaBasicMapping basicMapping = (EclipseLinkJavaBasicMapping)persistentAttribute.getMapping();
        EclipseLinkObjectTypeConverter converter = (EclipseLinkObjectTypeConverter)basicMapping.getConverterContainer().getObjectTypeConverters().iterator().next();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Foo", (String)converter.getDataType());
        converter.setDataType("Bar");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Bar", (String)converter.getDataType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ObjectTypeConverterAnnotation converterAnnotation = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Bar", (String)converterAnnotation.getDataType());
        converter.setDataType(null);
        EclipseLinkJavaObjectTypeConverterTests.assertEquals(null, (String)converter.getDataType());
        converterAnnotation = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals(null, (String)converterAnnotation.getDataType());
        converter.setDataType("Bar");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Bar", (String)converter.getDataType());
        converterAnnotation = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Bar", (String)converterAnnotation.getDataType());
    }

    public void testGetDataTypeUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithConvertAndDataType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkJavaBasicMapping basicMapping = (EclipseLinkJavaBasicMapping)persistentAttribute.getMapping();
        EclipseLinkObjectTypeConverter converter = (EclipseLinkObjectTypeConverter)basicMapping.getConverterContainer().getObjectTypeConverters().iterator().next();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Foo", (String)converter.getDataType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ObjectTypeConverterAnnotation converterAnnotation = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        converterAnnotation.setDataType("Bar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Bar", (String)converter.getDataType());
        resourceField.removeAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaObjectTypeConverterTests.assertFalse((boolean)basicMapping.getConverterContainer().getObjectTypeConverters().iterator().hasNext());
        converterAnnotation = (ObjectTypeConverterAnnotation)resourceField.addAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        this.getJpaProject().synchronizeContextModel();
        converter = (EclipseLinkObjectTypeConverter)basicMapping.getConverterContainer().getObjectTypeConverters().iterator().next();
        EclipseLinkJavaObjectTypeConverterTests.assertNotNull((Object)converter);
        converterAnnotation.setDataType("FooBar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"FooBar", (String)converter.getDataType());
    }

    public void testGetObjectType() throws Exception {
        this.createTestEntityWithConvertAndObjectType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkJavaBasicMapping basicMapping = (EclipseLinkJavaBasicMapping)persistentAttribute.getMapping();
        EclipseLinkObjectTypeConverter converter = (EclipseLinkObjectTypeConverter)basicMapping.getConverterContainer().getObjectTypeConverters().iterator().next();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Foo", (String)converter.getObjectType());
    }

    public void testSetObjectType() throws Exception {
        this.createTestEntityWithConvertAndObjectType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkJavaBasicMapping basicMapping = (EclipseLinkJavaBasicMapping)persistentAttribute.getMapping();
        EclipseLinkObjectTypeConverter converter = (EclipseLinkObjectTypeConverter)basicMapping.getConverterContainer().getObjectTypeConverters().iterator().next();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Foo", (String)converter.getObjectType());
        converter.setObjectType("Bar");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Bar", (String)converter.getObjectType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ObjectTypeConverterAnnotation converterAnnotation = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Bar", (String)converterAnnotation.getObjectType());
        converter.setObjectType(null);
        EclipseLinkJavaObjectTypeConverterTests.assertEquals(null, (String)converter.getObjectType());
        converterAnnotation = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals(null, (String)converterAnnotation.getObjectType());
        converter.setObjectType("Bar");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Bar", (String)converter.getObjectType());
        converterAnnotation = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Bar", (String)converterAnnotation.getObjectType());
    }

    public void testGetObjectTypeUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithConvertAndObjectType();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkJavaBasicMapping basicMapping = (EclipseLinkJavaBasicMapping)persistentAttribute.getMapping();
        EclipseLinkObjectTypeConverter converter = (EclipseLinkObjectTypeConverter)basicMapping.getConverterContainer().getObjectTypeConverters().iterator().next();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Foo", (String)converter.getObjectType());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ObjectTypeConverterAnnotation converterAnnotation = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        converterAnnotation.setObjectType("Bar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"Bar", (String)converter.getObjectType());
        resourceField.removeAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaObjectTypeConverterTests.assertFalse((boolean)basicMapping.getConverterContainer().getObjectTypeConverters().iterator().hasNext());
        converterAnnotation = (ObjectTypeConverterAnnotation)resourceField.addAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        this.getJpaProject().synchronizeContextModel();
        converter = (EclipseLinkObjectTypeConverter)basicMapping.getConverterContainer().getObjectTypeConverters().iterator().next();
        EclipseLinkJavaObjectTypeConverterTests.assertNotNull((Object)converter);
        converterAnnotation.setObjectType("FooBar");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"FooBar", (String)converter.getObjectType());
    }

    public void testAddConversionValue() throws Exception {
        this.createTestEntityWithConvertAndObjectTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkJavaBasicMapping basicMapping = (EclipseLinkJavaBasicMapping)persistentAttribute.getMapping();
        EclipseLinkObjectTypeConverter converter = (EclipseLinkObjectTypeConverter)basicMapping.getConverterContainer().getObjectTypeConverters().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ObjectTypeConverterAnnotation converterAnnotation = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkConversionValue conversionValue = converter.addConversionValue(0);
        conversionValue.setDataValue("F");
        conversionValue.setObjectValue("female");
        ListIterator resourceConversionValues = converterAnnotation.getConversionValues().iterator();
        ConversionValueAnnotation resourceConversionValue = (ConversionValueAnnotation)resourceConversionValues.next();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"F", (String)resourceConversionValue.getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"female", (String)resourceConversionValue.getObjectValue());
        EclipseLinkConversionValue conversionValue2 = converter.addConversionValue(0);
        conversionValue2.setDataValue("M");
        conversionValue2.setObjectValue("male");
        resourceConversionValues = converterAnnotation.getConversionValues().iterator();
        resourceConversionValue = (ConversionValueAnnotation)resourceConversionValues.next();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"M", (String)resourceConversionValue.getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"male", (String)resourceConversionValue.getObjectValue());
        resourceConversionValue = (ConversionValueAnnotation)resourceConversionValues.next();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"F", (String)resourceConversionValue.getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"female", (String)resourceConversionValue.getObjectValue());
        EclipseLinkConversionValue conversionValue3 = converter.addConversionValue(1);
        conversionValue3.setDataValue("O");
        conversionValue3.setObjectValue("male");
        resourceConversionValues = converterAnnotation.getConversionValues().iterator();
        resourceConversionValue = (ConversionValueAnnotation)resourceConversionValues.next();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"M", (String)resourceConversionValue.getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"male", (String)resourceConversionValue.getObjectValue());
        resourceConversionValue = (ConversionValueAnnotation)resourceConversionValues.next();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"O", (String)resourceConversionValue.getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"male", (String)resourceConversionValue.getObjectValue());
        resourceConversionValue = (ConversionValueAnnotation)resourceConversionValues.next();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"F", (String)resourceConversionValue.getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"female", (String)resourceConversionValue.getObjectValue());
        ListIterator conversionValues = converter.getConversionValues().iterator();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((Object)conversionValue2, conversionValues.next());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((Object)conversionValue3, conversionValues.next());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((Object)conversionValue, conversionValues.next());
        conversionValues = converter.getConversionValues().iterator();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"M", (String)((EclipseLinkConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"O", (String)((EclipseLinkConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"F", (String)((EclipseLinkConversionValue)conversionValues.next()).getDataValue());
    }

    public void testRemoveConversionValue() throws Exception {
        this.createTestEntityWithConvertAndObjectTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkJavaBasicMapping basicMapping = (EclipseLinkJavaBasicMapping)persistentAttribute.getMapping();
        EclipseLinkObjectTypeConverter converter = (EclipseLinkObjectTypeConverter)basicMapping.getConverterContainer().getObjectTypeConverters().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ObjectTypeConverterAnnotation converterAnnotation = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        converter.addConversionValue(0).setDataValue("F");
        converter.addConversionValue(1).setDataValue("M");
        converter.addConversionValue(2).setDataValue("O");
        ListIterator resourceConversionValues = converterAnnotation.getConversionValues().iterator();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((int)3, (int)IteratorTools.size((Iterator)resourceConversionValues));
        converter.removeConversionValue(0);
        resourceConversionValues = converterAnnotation.getConversionValues().iterator();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((int)2, (int)IteratorTools.size((Iterator)resourceConversionValues));
        resourceConversionValues = converterAnnotation.getConversionValues().iterator();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"M", (String)((ConversionValueAnnotation)resourceConversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"O", (String)((ConversionValueAnnotation)resourceConversionValues.next()).getDataValue());
        converter.removeConversionValue(0);
        resourceConversionValues = converterAnnotation.getConversionValues().iterator();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((int)1, (int)IteratorTools.size((Iterator)resourceConversionValues));
        resourceConversionValues = converterAnnotation.getConversionValues().iterator();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"O", (String)((ConversionValueAnnotation)resourceConversionValues.next()).getDataValue());
        converter.removeConversionValue(0);
        resourceConversionValues = converterAnnotation.getConversionValues().iterator();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((int)0, (int)IteratorTools.size((Iterator)resourceConversionValues));
    }

    public void testMoveConversionValue() throws Exception {
        this.createTestEntityWithConvertAndObjectTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkJavaBasicMapping basicMapping = (EclipseLinkJavaBasicMapping)persistentAttribute.getMapping();
        EclipseLinkObjectTypeConverter converter = (EclipseLinkObjectTypeConverter)basicMapping.getConverterContainer().getObjectTypeConverters().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ObjectTypeConverterAnnotation converterAnnotation = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        converter.addConversionValue(0).setDataValue("F");
        converter.addConversionValue(1).setDataValue("M");
        converter.addConversionValue(2).setDataValue("O");
        ListIterator resourceConversionValues = converterAnnotation.getConversionValues().iterator();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((int)3, (int)IteratorTools.size((Iterator)resourceConversionValues));
        converter.moveConversionValue(2, 0);
        resourceConversionValues = converterAnnotation.getConversionValues().iterator();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((int)3, (int)IteratorTools.size((Iterator)resourceConversionValues));
        resourceConversionValues = converterAnnotation.getConversionValues().iterator();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"M", (String)((ConversionValueAnnotation)resourceConversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"O", (String)((ConversionValueAnnotation)resourceConversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"F", (String)((ConversionValueAnnotation)resourceConversionValues.next()).getDataValue());
        converter.moveConversionValue(0, 1);
        resourceConversionValues = converterAnnotation.getConversionValues().iterator();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((int)3, (int)IteratorTools.size((Iterator)resourceConversionValues));
        resourceConversionValues = converterAnnotation.getConversionValues().iterator();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"O", (String)((ConversionValueAnnotation)resourceConversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"M", (String)((ConversionValueAnnotation)resourceConversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"F", (String)((ConversionValueAnnotation)resourceConversionValues.next()).getDataValue());
    }

    public void testUpdateConversionValues() throws Exception {
        this.createTestEntityWithConvertAndObjectTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkJavaBasicMapping basicMapping = (EclipseLinkJavaBasicMapping)persistentAttribute.getMapping();
        EclipseLinkObjectTypeConverter converter = (EclipseLinkObjectTypeConverter)basicMapping.getConverterContainer().getObjectTypeConverters().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ObjectTypeConverterAnnotation converterAnnotation = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        converterAnnotation.addConversionValue(0).setDataValue("F");
        converterAnnotation.addConversionValue(1).setDataValue("M");
        converterAnnotation.addConversionValue(2).setDataValue("O");
        this.getJpaProject().synchronizeContextModel();
        ListIterator conversionValues = converter.getConversionValues().iterator();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"F", (String)((EclipseLinkConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"M", (String)((EclipseLinkConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"O", (String)((EclipseLinkConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertFalse((boolean)conversionValues.hasNext());
        converterAnnotation.moveConversionValue(2, 0);
        this.getJpaProject().synchronizeContextModel();
        conversionValues = converter.getConversionValues().iterator();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"M", (String)((EclipseLinkConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"O", (String)((EclipseLinkConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"F", (String)((EclipseLinkConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertFalse((boolean)conversionValues.hasNext());
        converterAnnotation.moveConversionValue(0, 1);
        this.getJpaProject().synchronizeContextModel();
        conversionValues = converter.getConversionValues().iterator();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"O", (String)((EclipseLinkConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"M", (String)((EclipseLinkConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"F", (String)((EclipseLinkConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertFalse((boolean)conversionValues.hasNext());
        converterAnnotation.removeConversionValue(1);
        this.getJpaProject().synchronizeContextModel();
        conversionValues = converter.getConversionValues().iterator();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"O", (String)((EclipseLinkConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"F", (String)((EclipseLinkConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertFalse((boolean)conversionValues.hasNext());
        converterAnnotation.removeConversionValue(1);
        this.getJpaProject().synchronizeContextModel();
        conversionValues = converter.getConversionValues().iterator();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"O", (String)((EclipseLinkConversionValue)conversionValues.next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertFalse((boolean)conversionValues.hasNext());
        converterAnnotation.removeConversionValue(0);
        this.getJpaProject().synchronizeContextModel();
        conversionValues = converter.getConversionValues().iterator();
        EclipseLinkJavaObjectTypeConverterTests.assertFalse((boolean)conversionValues.hasNext());
    }

    public void testConversionValuesSize() throws Exception {
        this.createTestEntityWithConvertAndObjectTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkJavaBasicMapping basicMapping = (EclipseLinkJavaBasicMapping)persistentAttribute.getMapping();
        EclipseLinkObjectTypeConverter converter = (EclipseLinkObjectTypeConverter)basicMapping.getConverterContainer().getObjectTypeConverters().iterator().next();
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ObjectTypeConverterAnnotation converterAnnotation = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((int)0, (int)converter.getConversionValuesSize());
        converterAnnotation.addConversionValue(0).setDataValue("F");
        converterAnnotation.addConversionValue(1).setDataValue("M");
        converterAnnotation.addConversionValue(2).setDataValue("O");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((int)3, (int)converter.getConversionValuesSize());
    }

    public void testGetDefaultObjectValue() throws Exception {
        this.createTestEntityWithConvertAndObjectTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkJavaBasicMapping basicMapping = (EclipseLinkJavaBasicMapping)persistentAttribute.getMapping();
        EclipseLinkObjectTypeConverter converter = (EclipseLinkObjectTypeConverter)basicMapping.getConverterContainer().getObjectTypeConverters().iterator().next();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"bar", (String)converter.getDefaultObjectValue());
    }

    public void testSetDefaultObjectValue() throws Exception {
        this.createTestEntityWithConvertAndObjectTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkJavaBasicMapping basicMapping = (EclipseLinkJavaBasicMapping)persistentAttribute.getMapping();
        EclipseLinkObjectTypeConverter converter = (EclipseLinkObjectTypeConverter)basicMapping.getConverterContainer().getObjectTypeConverters().iterator().next();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"bar", (String)converter.getDefaultObjectValue());
        converter.setDefaultObjectValue("baz");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"baz", (String)converter.getDefaultObjectValue());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ObjectTypeConverterAnnotation converterAnnotation = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"baz", (String)converterAnnotation.getDefaultObjectValue());
        converter.setDefaultObjectValue(null);
        EclipseLinkJavaObjectTypeConverterTests.assertEquals(null, (String)converter.getDefaultObjectValue());
        converterAnnotation = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals(null, (String)converterAnnotation.getDefaultObjectValue());
        converter.setDefaultObjectValue("bar");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"bar", (String)converter.getDefaultObjectValue());
        converterAnnotation = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"bar", (String)converterAnnotation.getDefaultObjectValue());
    }

    public void testGetDefaultObjectValueUpdatesFromResourceModelChange() throws Exception {
        this.createTestEntityWithConvertAndObjectTypeConverter();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkJavaBasicMapping basicMapping = (EclipseLinkJavaBasicMapping)persistentAttribute.getMapping();
        EclipseLinkObjectTypeConverter converter = (EclipseLinkObjectTypeConverter)basicMapping.getConverterContainer().getObjectTypeConverters().iterator().next();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"bar", (String)converter.getDefaultObjectValue());
        JavaResourceType resourceType = (JavaResourceType)this.getJpaProject().getJavaResourceType("test.AnnotationTestType", JavaResourceAnnotatedElement.AstNodeType.TYPE);
        JavaResourceField resourceField = (JavaResourceField)resourceType.getFields().iterator().next();
        ObjectTypeConverterAnnotation converterAnnotation = (ObjectTypeConverterAnnotation)resourceField.getAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        converterAnnotation.setDefaultObjectValue("baz");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"baz", (String)converter.getDefaultObjectValue());
        resourceField.removeAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaObjectTypeConverterTests.assertFalse((boolean)basicMapping.getConverterContainer().getObjectTypeConverters().iterator().hasNext());
        converterAnnotation = (ObjectTypeConverterAnnotation)resourceField.addAnnotation(0, "org.eclipse.persistence.annotations.ObjectTypeConverter");
        this.getJpaProject().synchronizeContextModel();
        converter = (EclipseLinkObjectTypeConverter)basicMapping.getConverterContainer().getObjectTypeConverters().iterator().next();
        EclipseLinkJavaObjectTypeConverterTests.assertNotNull((Object)converter);
        converterAnnotation.setDefaultObjectValue("FOO");
        this.getJpaProject().synchronizeContextModel();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"FOO", (String)converter.getDefaultObjectValue());
    }

    public void testInitializeConversionValues() throws Exception {
        this.createTestEntityWithConvertAndObjectTypeConverterConversionValue();
        this.addXmlClassRef("test.AnnotationTestType");
        SpecifiedPersistentAttribute persistentAttribute = (SpecifiedPersistentAttribute)this.getJavaPersistentType().getAttributes().iterator().next();
        EclipseLinkJavaBasicMapping basicMapping = (EclipseLinkJavaBasicMapping)persistentAttribute.getMapping();
        EclipseLinkObjectTypeConverter converter = (EclipseLinkObjectTypeConverter)basicMapping.getConverterContainer().getObjectTypeConverters().iterator().next();
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((int)1, (int)converter.getConversionValuesSize());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"f", (String)((EclipseLinkConversionValue)converter.getConversionValues().iterator().next()).getDataValue());
        EclipseLinkJavaObjectTypeConverterTests.assertEquals((String)"female", (String)((EclipseLinkConversionValue)converter.getConversionValues().iterator().next()).getObjectValue());
    }
}

